/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.util.CHexConver;

public class SensorInfo
implements IHealthSettingToAttr {
    private int flag;
    private final Sensor step;
    private final Sensor heartRate;
    private final Sensor bloodOxygen;
    private final Sensor altitudePressure;

    public SensorInfo(int n) {
        Sensor sensor;
        Sensor sensor2;
        Sensor sensor3;
        Sensor sensor4;
        this.flag = n;
        Sensor sensor5 = sensor4;
        sensor4 = new Sensor(this, 0, 1);
        this.step = sensor5;
        sensor5 = sensor3;
        sensor3 = new Sensor(this, 2, 3);
        this.heartRate = sensor5;
        sensor5 = sensor2;
        sensor2 = new Sensor(this, 4, 5);
        this.bloodOxygen = sensor5;
        sensor5 = sensor;
        sensor = new Sensor(this, 6, 7);
        this.altitudePressure = sensor5;
    }

    public Sensor getStepSensor() {
        return this.step;
    }

    public Sensor getHeartRateSensor() {
        return this.heartRate;
    }

    public Sensor getBloodOxygenSensor() {
        return this.bloodOxygen;
    }

    public Sensor getAltitudePressureSensor() {
        return this.altitudePressure;
    }

    public SensorInfo copy() {
        return new SensorInfo(this.flag);
    }

    public String toString() {
        return "SensorInfo{flag=" + this.flag + ", step=" + this.step + ", heartRate=" + this.heartRate + ", bloodOxygen=" + this.bloodOxygen + ", altitudePressure=" + this.altitudePressure + '}';
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public AttrBean toAttr() {
        AttrBean attrBean;
        AttrBean attrBean2 = attrBean;
        attrBean2();
        attrBean2.setType((byte)this.getType());
        attrBean.setAttrData(CHexConver.shortToBigBytes((short)this.flag));
        return attrBean;
    }

    public class Sensor {
        private final int enablePos;
        private final int recordEnablePos;
        public final /* synthetic */ SensorInfo this$0;

        public Sensor(SensorInfo sensorInfo, int n) {
            int n2 = n + 1;
            this(sensorInfo, n, n2);
        }

        public Sensor(SensorInfo sensorInfo, int n, int n2) {
            this.this$0 = sensorInfo;
            this.enablePos = n;
            this.recordEnablePos = n2;
        }

        public boolean isEnable() {
            return (this.this$0.flag >> this.enablePos & 1) == 1;
        }

        public boolean isRecordEnable() {
            Sensor sensor = this;
            int n = sensor.this$0.flag >> this.recordEnablePos;
            return sensor.isEnable() && (n & 1) == 1;
        }

        public void setEnable(boolean bl) {
            if (bl) {
                this.this$0.flag |= 1 << this.enablePos;
            } else {
                Sensor sensor = this;
                int n = ~(1 << sensor.enablePos);
                sensor.this$0.flag &= n;
            }
        }

        public void setRecordEnable(boolean bl) {
            if (bl) {
                this.this$0.flag |= 1 << this.recordEnablePos;
            } else {
                Sensor sensor = this;
                int n = ~(1 << sensor.recordEnablePos);
                sensor.this$0.flag &= n;
            }
        }

        public String toString() {
            return "Sensor{enablePos=" + this.enablePos + ", recordEnablePos=" + this.recordEnablePos + '}';
        }
    }
}

