/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.parameter;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.util.CHexConver;

public class StartLargeFileTransferParam
extends BaseParameter {
    public byte[] hash;
    public int size;
    public short crc16;

    public StartLargeFileTransferParam(byte[] byArray, int n, short s) {
        this.hash = byArray;
        this.size = n;
        this.crc16 = s;
    }

    public int getSize() {
        return this.size;
    }

    public StartLargeFileTransferParam setSize(int n) {
        this.size = n;
        return this;
    }

    @Override
    public byte[] getParamData() {
        byte[] byArray = new byte[this.hash.length + 6];
        StartLargeFileTransferParam startLargeFileTransferParam = this;
        System.arraycopy(CHexConver.intToBigBytes(startLargeFileTransferParam.size), 0, byArray, 0, 4);
        System.arraycopy(CHexConver.shortToBigBytes(startLargeFileTransferParam.crc16), 0, byArray, 4, 2);
        int n = startLargeFileTransferParam.hash.length;
        System.arraycopy(startLargeFileTransferParam.hash, 0, byArray, 6, n);
        return byArray;
    }

    @Override
    public String toString() {
        return "StartLargeFileTransferParam{, hash='" + CHexConver.byte2HexStr(this.hash) + '\'' + ", size=" + this.size + ", crc16=" + this.crc16 + '}' + "\n" + super.toString();
    }
}

