/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.tool;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.model.command.GetDevConfigureCmd;
import com.jieli.jl_rcsp.model.device.DeviceInfo;
import com.jieli.jl_rcsp.model.device.DeviceStatus;
import com.jieli.jl_rcsp.model.device.VoiceData;
import com.jieli.jl_rcsp.model.response.ADVInfoResponse;
import com.jieli.jl_rcsp.model.response.ExternalFlashMsgResponse;
import com.jieli.jl_rcsp.model.response.GetLowLatencySettingsResponse;
import com.jieli.jl_rcsp.model.response.TargetInfoResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeviceStatusManager {
    private static volatile DeviceStatusManager b;
    private final Map<String, DeviceStatus> a = Collections.synchronizedMap(new HashMap());

    private DeviceStatusManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceStatusManager getInstance() {
        if (b != null) return b;
        Class<DeviceStatusManager> clazz = DeviceStatusManager.class;
        synchronized (DeviceStatusManager.class) {
            if (b != null) return b;
            b = new DeviceStatusManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return b;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ADVInfoResponse a(ADVInfoResponse aDVInfoResponse, ADVInfoResponse aDVInfoResponse2) {
        Object this_ = null;
        if (aDVInfoResponse != null && aDVInfoResponse2 != null) {
            if (aDVInfoResponse2.getVid() >= 0 && aDVInfoResponse2.getVid() != aDVInfoResponse.getVid()) {
                aDVInfoResponse.setVid(aDVInfoResponse2.getVid());
            }
            if (aDVInfoResponse2.getUid() >= 0 && aDVInfoResponse2.getUid() != aDVInfoResponse.getUid()) {
                aDVInfoResponse.setUid(aDVInfoResponse2.getUid());
            }
            if (aDVInfoResponse2.getPid() >= 0 && aDVInfoResponse2.getPid() != aDVInfoResponse.getPid()) {
                aDVInfoResponse.setPid(aDVInfoResponse2.getPid());
            }
            if (aDVInfoResponse2.getDeviceName() != null && !aDVInfoResponse2.getDeviceName().equals(aDVInfoResponse.getDeviceName())) {
                aDVInfoResponse.setDeviceName(aDVInfoResponse2.getDeviceName());
            }
            if (aDVInfoResponse2.getLeftDeviceQuantity() >= 0 && aDVInfoResponse2.getLeftDeviceQuantity() != aDVInfoResponse.getLeftDeviceQuantity()) {
                aDVInfoResponse.setLeftDeviceQuantity(aDVInfoResponse2.getLeftDeviceQuantity());
            }
            if (aDVInfoResponse2.getRightDeviceQuantity() >= 0 && aDVInfoResponse2.getRightDeviceQuantity() != aDVInfoResponse.getRightDeviceQuantity()) {
                aDVInfoResponse.setRightDeviceQuantity(aDVInfoResponse2.getRightDeviceQuantity());
            }
            if (aDVInfoResponse2.getChargingBinQuantity() >= 0 && aDVInfoResponse2.getChargingBinQuantity() != aDVInfoResponse.getChargingBinQuantity()) {
                aDVInfoResponse.setChargingBinQuantity(aDVInfoResponse2.getChargingBinQuantity());
            }
            if (aDVInfoResponse2.isLeftCharging() != aDVInfoResponse.isLeftCharging()) {
                aDVInfoResponse.setLeftCharging(aDVInfoResponse2.isLeftCharging());
            }
            if (aDVInfoResponse2.isRightCharging() != aDVInfoResponse.isRightCharging()) {
                aDVInfoResponse.setRightCharging(aDVInfoResponse2.isRightCharging());
            }
            if (aDVInfoResponse2.isDeviceCharging() != aDVInfoResponse.isDeviceCharging()) {
                aDVInfoResponse.setDeviceCharging(aDVInfoResponse2.isDeviceCharging());
            }
            if (aDVInfoResponse2.getWorkModel() >= 0 && aDVInfoResponse2.getWorkModel() != aDVInfoResponse.getWorkModel()) {
                aDVInfoResponse.setWorkModel(aDVInfoResponse2.getWorkModel());
            }
            if (aDVInfoResponse2.getMicChannel() >= 0 && aDVInfoResponse2.getMicChannel() != aDVInfoResponse.getMicChannel()) {
                aDVInfoResponse.setMicChannel(aDVInfoResponse2.getMicChannel());
            }
            if (aDVInfoResponse2.getKeySettingsList() != null && !aDVInfoResponse2.getKeySettingsList().isEmpty()) {
                aDVInfoResponse.setKeySettingsList(aDVInfoResponse2.getKeySettingsList());
            }
            if (aDVInfoResponse2.getLedSettingsList() == null) return aDVInfoResponse;
            if (aDVInfoResponse2.getLedSettingsList().isEmpty()) return aDVInfoResponse;
            aDVInfoResponse.setLedSettingsList(aDVInfoResponse2.getLedSettingsList());
            return aDVInfoResponse;
        }
        if (aDVInfoResponse != null) {
            return aDVInfoResponse;
        }
        if (aDVInfoResponse2 == null) return this_;
        return aDVInfoResponse2;
    }

    public void release() {
        this.a.clear();
        b = null;
    }

    public GetDevConfigureCmd.Response getDeviceConfigure(BluetoothDevice object) {
        DeviceStatusManager deviceStatusManager = object2;
        Object object2 = null;
        if ((object = deviceStatusManager.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getDeviceConfigure();
        }
        return object2;
    }

    public ExternalFlashMsgResponse getExtFlashMsg(BluetoothDevice object) {
        DeviceStatusManager deviceStatusManager = object2;
        Object object2 = null;
        if ((object = deviceStatusManager.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getExtFlashMSg();
        }
        return object2;
    }

    public boolean isTwsConnected(BluetoothDevice object) {
        boolean bl = false;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null) {
            bl = ((DeviceStatus)object).isTwsConnected();
        }
        return bl;
    }

    public VoiceData getDeviceVoiceConfig(BluetoothDevice object) {
        DeviceStatusManager deviceStatusManager = object2;
        Object object2 = null;
        if ((object = deviceStatusManager.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getVoiceData();
        }
        return object2;
    }

    public int getMaxCommunicationMtu(BluetoothDevice object) {
        int n = 530;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null && ((DeviceStatus)object).getMaxCommunicationMtu() > 0) {
            n = ((DeviceStatus)object).getMaxCommunicationMtu();
        }
        return n;
    }

    public int getMaxReceiveMtu(BluetoothDevice object) {
        int n = 530;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null && ((DeviceStatus)object).getMaxReceiveMtu() > 0) {
            n = ((DeviceStatus)object).getMaxReceiveMtu();
        }
        return n;
    }

    public boolean isEnableLatencyMode(BluetoothDevice object) {
        boolean bl = false;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null) {
            bl = ((DeviceStatus)object).isEnableLatencyMode();
        }
        return bl;
    }

    public GetLowLatencySettingsResponse getLatencySettings(BluetoothDevice object) {
        DeviceStatusManager deviceStatusManager = object2;
        Object object2 = null;
        if ((object = deviceStatusManager.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getLatencySettings();
        }
        return object2;
    }

    public String getDevMD5(BluetoothDevice object) {
        DeviceStatusManager deviceStatusManager = object2;
        Object object2 = null;
        if ((object = deviceStatusManager.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getDevMD5();
        }
        return object2;
    }

    public ADVInfoResponse getAdvInfo(BluetoothDevice bluetoothDevice) {
        ADVInfoResponse aDVInfoResponse = null;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null) {
            aDVInfoResponse = ((DeviceStatus)this).getADVInfo();
        }
        return aDVInfoResponse;
    }

    public int getDeviceConnectStatus(BluetoothDevice bluetoothDevice) {
        int n = 0;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null) {
            n = ((DeviceStatus)this).getStatus();
        }
        return n;
    }

    public boolean isAuthBtDevice(BluetoothDevice bluetoothDevice) {
        boolean bl = false;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null) {
            bl = ((DeviceStatus)this).isAuthDevice();
        }
        return bl;
    }

    public boolean isMandatoryUpgrade(BluetoothDevice bluetoothDevice) {
        boolean bl = false;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null) {
            bl = ((DeviceStatus)this).isMandatoryUpgrade();
        }
        return bl;
    }

    public boolean isEnterLowPowerMode(BluetoothDevice bluetoothDevice) {
        boolean bl = false;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null) {
            bl = ((DeviceStatus)this).isEnterLowPowerMode();
        }
        return bl;
    }

    public boolean isDoubleBackupUpgrade(BluetoothDevice bluetoothDevice) {
        boolean bl = false;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null && (this = ((DeviceStatus)this).getDeviceInfo()) != null) {
            bl = ((TargetInfoResponse)this).isSupportDoubleBackup();
        }
        return bl;
    }

    public DeviceInfo getDeviceInfo(BluetoothDevice bluetoothDevice) {
        DeviceInfo deviceInfo = null;
        if (bluetoothDevice != null && (this = ((DeviceStatusManager)this).getDeviceStatus(bluetoothDevice)) != null) {
            deviceInfo = ((DeviceStatus)this).getDeviceInfo();
        }
        return deviceInfo;
    }

    public void updateDeviceConfigure(BluetoothDevice bluetoothDevice, GetDevConfigureCmd.Response response) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setDeviceConfigure(response);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateExtFlashMsg(BluetoothDevice bluetoothDevice, ExternalFlashMsgResponse externalFlashMsgResponse) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setExtFlashMSg(externalFlashMsgResponse);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceVoiceConfig(BluetoothDevice bluetoothDevice, VoiceData voiceData) {
        boolean bl = false;
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            new DeviceStatus().setVoiceData(voiceData);
            bl = true;
        } else if (voiceData == null || !voiceData.equals(deviceStatus.getVoiceData())) {
            deviceStatus.setVoiceData(voiceData);
            bl = true;
        }
        if (bl) {
            this.updateDeviceStatus(bluetoothDevice, deviceStatus);
        }
    }

    public void updateDeviceMaxCommunicationMtu(BluetoothDevice bluetoothDevice, int n) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setMaxCommunicationMtu(n);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceMaxReceiveMtu(BluetoothDevice bluetoothDevice, int n) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setMaxReceiveMtu(n);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceIsEnableLatencyMode(BluetoothDevice bluetoothDevice, boolean bl) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setEnableLatencyMode(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceLowLatencySettings(BluetoothDevice bluetoothDevice, GetLowLatencySettingsResponse getLowLatencySettingsResponse) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setLatencySettings(getLowLatencySettingsResponse);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceMD5(BluetoothDevice bluetoothDevice, String string) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setDevMD5(string);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceConnectStatus(BluetoothDevice bluetoothDevice, int n) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setStatus(n);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceIsAuth(BluetoothDevice bluetoothDevice, boolean bl) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setAuthDevice(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceIsEnterLowPowerMode(BluetoothDevice bluetoothDevice, boolean bl) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setEnterLowPowerMode(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceTargetInfo(BluetoothDevice bluetoothDevice, TargetInfoResponse targetInfoResponse) {
        this.updateDeviceInfo(bluetoothDevice, DeviceInfo.convertFromTargetInfo(targetInfoResponse));
    }

    public void updateDeviceInfo(BluetoothDevice bluetoothDevice, DeviceInfo deviceInfo) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        boolean bl = deviceInfo != null && deviceInfo.isMandatoryUpgrade();
        DeviceInfo deviceInfo2 = deviceStatus.getDeviceInfo();
        if (deviceInfo2 != null) {
            deviceStatus.setDeviceInfo(DeviceInfo.mergeTargetInfos(deviceInfo2, deviceInfo));
        } else {
            deviceStatus.setDeviceInfo(deviceInfo);
        }
        deviceStatus.setMandatoryUpgrade(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceAdvInfo(BluetoothDevice bluetoothDevice, ADVInfoResponse aDVInfoResponse) {
        if (aDVInfoResponse == null) {
            return;
        }
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            new DeviceStatus().setADVInfo(aDVInfoResponse);
        } else {
            deviceStatus.setADVInfo(this.a(deviceStatus.getADVInfo(), aDVInfoResponse));
        }
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceStatus(BluetoothDevice bluetoothDevice, DeviceStatus deviceStatus) {
        if (bluetoothDevice != null) {
            this.updateDeviceStatus(bluetoothDevice.getAddress(), deviceStatus);
        }
    }

    public void updateDeviceStatus(String string, DeviceStatus deviceStatus) {
        if (BluetoothAdapter.checkBluetoothAddress((String)string) && deviceStatus != null) {
            this.a.put(string, deviceStatus);
        }
    }

    public DeviceStatus removeDeviceStatus(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return null;
        }
        return this.removeDeviceStatus(bluetoothDevice.getAddress());
    }

    public DeviceStatus removeDeviceStatus(String string) {
        DeviceStatus deviceStatus = null;
        if (BluetoothAdapter.checkBluetoothAddress((String)string)) {
            deviceStatus = this.a.remove(string);
        }
        return deviceStatus;
    }

    public DeviceStatus getDeviceStatus(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return null;
        }
        return this.getDeviceStatus(bluetoothDevice.getAddress());
    }

    public DeviceStatus getDeviceStatus(String string) {
        DeviceStatus deviceStatus = null;
        if (BluetoothAdapter.checkBluetoothAddress((String)string)) {
            deviceStatus = this.a.get(string);
        }
        return deviceStatus;
    }
}

