/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.tool;

import android.bluetooth.BluetoothDevice;
import android.graphics.Color;
import com.jieli.jl_rcsp.impl.RcspOpImpl;
import com.jieli.jl_rcsp.model.device.AlarmBean;
import com.jieli.jl_rcsp.model.device.AlarmListInfo;
import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.BatteryInfo;
import com.jieli.jl_rcsp.model.device.ChannelInfo;
import com.jieli.jl_rcsp.model.device.DefaultAlarmBell;
import com.jieli.jl_rcsp.model.device.DevStorageInfo;
import com.jieli.jl_rcsp.model.device.DeviceInfo;
import com.jieli.jl_rcsp.model.device.DynamicLimiterParam;
import com.jieli.jl_rcsp.model.device.EqInfo;
import com.jieli.jl_rcsp.model.device.EqPresetInfo;
import com.jieli.jl_rcsp.model.device.ExpandFunction;
import com.jieli.jl_rcsp.model.device.FmStatusInfo;
import com.jieli.jl_rcsp.model.device.ID3MusicInfo;
import com.jieli.jl_rcsp.model.device.LightControlInfo;
import com.jieli.jl_rcsp.model.device.MusicNameInfo;
import com.jieli.jl_rcsp.model.device.MusicStatusInfo;
import com.jieli.jl_rcsp.model.device.PlayModeInfo;
import com.jieli.jl_rcsp.model.device.ReverberationParam;
import com.jieli.jl_rcsp.model.device.VoiceMode;
import com.jieli.jl_rcsp.model.device.VolumeInfo;
import com.jieli.jl_rcsp.model.device.health.AutomaticPressureDetection;
import com.jieli.jl_rcsp.model.device.health.BloodOxygenMeasurementAlert;
import com.jieli.jl_rcsp.model.device.health.DisconnectReminder;
import com.jieli.jl_rcsp.model.device.health.EmergencyContact;
import com.jieli.jl_rcsp.model.device.health.ExerciseHeartRateReminder;
import com.jieli.jl_rcsp.model.device.health.FallDetection;
import com.jieli.jl_rcsp.model.device.health.HealthSettingInfo;
import com.jieli.jl_rcsp.model.device.health.HeartRateMeasure;
import com.jieli.jl_rcsp.model.device.health.LiftWristDetection;
import com.jieli.jl_rcsp.model.device.health.SedentaryReminder;
import com.jieli.jl_rcsp.model.device.health.SensorInfo;
import com.jieli.jl_rcsp.model.device.health.SleepDetection;
import com.jieli.jl_rcsp.model.device.health.UserInfo;
import com.jieli.jl_rcsp.tool.callback.RcspEventListenerManager;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class RcspDataHandler {
    private static final String c = "rcsp_handler";
    private static final int d = 64;
    private final RcspOpImpl a;
    private final RcspEventListenerManager b;

    public RcspDataHandler(RcspOpImpl rcspOpImpl, RcspEventListenerManager rcspEventListenerManager) {
        this.a = rcspOpImpl;
        this.b = rcspEventListenerManager;
    }

    /*
     * WARNING - void declaration
     */
    private void e(BluetoothDevice bluetoothDevice, List<AttrBean> list) {
        DeviceInfo deviceInfo = this.a.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        block24: for (AttrBean object : list) {
            BatteryInfo batteryInfo;
            Object object2 = object.getAttrData();
            if (object2 == null || ((byte[])object2).length == 0) continue;
            switch (object.getType()) {
                default: {
                    continue block24;
                }
                case 19: {
                    JL_Log.d(c, "-parsePublicData- \u58f0\u5361\u529f\u80fd\u72b6\u6001\u53d8\u5316\uff1a" + CHexConver.byte2HexStr(object2));
                    if (((byte[])object2).length < 8) continue block24;
                    long l = CHexConver.bytesToLong(object2, 0, 8);
                    JL_Log.d(c, "-parsePublicData- \u58f0\u5361\u529f\u80fd\u72b6\u6001\u53d8\u5316 \uff1a mask  ->  " + CHexConver.byte2HexStr(object2, 8));
                    byte[] n = new byte[]{};
                    if (((byte[])object2).length > 8) {
                        int n2 = ((byte[])object2).length - 8;
                        object2 = new byte[n2];
                        System.arraycopy(object2, 8, object2, 0, n2);
                        JL_Log.d(c, "-parsePublicData- \u58f0\u5361\u529f\u80fd\u72b6\u6001\u53d8\u5316 \uff1a values  ->  " + CHexConver.byte2HexStr(object2));
                    } else {
                        object2 = n;
                    }
                    this.b.onSoundCardStatusChange(bluetoothDevice, l, (byte[])object2);
                    continue block24;
                }
                case 18: {
                    EqInfo n = deviceInfo.getSoundCardEqInfo();
                    if (n == null) continue block24;
                    EqInfo eqInfo = n;
                    byte by = object2[0];
                    byte[] byArray = new byte[by];
                    System.arraycopy(object2, 1, byArray, 0, by);
                    eqInfo.setValue(byArray);
                    deviceInfo.setSoundCardEqInfo(eqInfo);
                    this.b.onSoundCardEqChange(bluetoothDevice, n);
                    continue block24;
                }
                case 17: {
                    EqInfo eqInfo;
                    EqInfo n4 = eqInfo;
                    new EqInfo().setDynamic(true);
                    n4.setMode(0);
                    int n = object2[0];
                    Object object3 = new int[n];
                    int n3 = 0;
                    int n5 = 1;
                    while (n3 < n) {
                        object3[n3] = CHexConver.bytesToInt(object2, n5, 2);
                        ++n3;
                        n5 += 2;
                    }
                    n4.setFreqs((int[])object3);
                    deviceInfo.setSoundCardEqInfo(n4);
                    continue block24;
                }
                case 16: {
                    int n = ((byte[])object2).length;
                    object2 = new byte[n];
                    System.arraycopy(object2, 0, object2, 0, n);
                    this.a(bluetoothDevice, (byte[])object2);
                    continue block24;
                }
                case 15: {
                    JL_Log.e(c, "-parsePublicData- phone status change \uff1a" + CHexConver.byte2HexStr(object2));
                    int n = CHexConver.byteToInt(object2[0]);
                    deviceInfo.setPhoneStatus(n);
                    this.b.onPhoneCallStatusChange(bluetoothDevice, n);
                    continue block24;
                }
                case 14: {
                    int n14;
                    ArrayList<VoiceMode> arrayList;
                    int n6 = object2[0];
                    int n7 = 1;
                    if (n6 <= 0 || ((byte[])object2).length < n7 + n6 * 9) continue block24;
                    int n8 = 9;
                    byte[] byArray = new byte[9];
                    ArrayList<VoiceMode> arrayList2 = arrayList;
                    arrayList = new ArrayList<VoiceMode>();
                    for (n14 = 0; n14 < n6; ++n14) {
                        System.arraycopy(object2, n7, byArray, 0, n8);
                        n7 += n8;
                        arrayList2.add(VoiceMode.parse(byArray));
                    }
                    deviceInfo.setVoiceModeList(arrayList2);
                    this.b.onVoiceModeList(bluetoothDevice, arrayList2);
                    continue block24;
                }
                case 13: {
                    if (((byte[])object2).length < 9) continue block24;
                    byte[] byArray = new byte[9];
                    System.arraycopy(object2, 0, byArray, 0, 9);
                    VoiceMode byArray2 = VoiceMode.parse(byArray);
                    deviceInfo.setCurrentVoiceMode(byArray2);
                    this.b.onCurrentVoiceMode(bluetoothDevice, byArray2);
                    continue block24;
                }
                case 12: {
                    JL_Log.d(c, "-parsePublicData- eq preset data-->" + CHexConver.byte2HexStr(object2, ((byte[])object2).length));
                    EqPresetInfo f = this.a(object);
                    deviceInfo.setEqPresetInfo(f);
                    this.b.onEqPresetChange(bluetoothDevice, f);
                    continue block24;
                }
                case 11: {
                    if (((byte[])object2).length < 8) continue block24;
                    int n8 = CHexConver.bytesToInt(object2, 0, 4);
                    int n = CHexConver.bytesToInt(object2, 4, 4);
                    this.b.onHighAndBassChange(bluetoothDevice, n8, n);
                    continue block24;
                }
                case 10: {
                    void by;
                    byte[] lightControlInfo = new byte[]{};
                    boolean bl = object2[0] == 1;
                    if (bl && ((byte[])object2).length > 6) {
                        byte[] n = new byte[6];
                        System.arraycopy(object2, 1, n, 0, 6);
                    }
                    String object6 = CHexConver.hexDataCovetToAddress((byte[])by);
                    this.b.onPeripheralsConnectStatusChange(bluetoothDevice, bl, object6);
                    continue block24;
                }
                case 9: {
                    int n = CHexConver.byteToInt(object2[0]);
                    this.b.onPeripheralsModeChange(bluetoothDevice, n);
                    continue block24;
                }
                case 8: {
                    void var5_27;
                    boolean n = false;
                    if (((byte[])object2).length >= 2 && ((byte[])object2).length < 4) {
                        byte[] byArray = new byte[2];
                        System.arraycopy(object2, 0, byArray, 0, 2);
                        int n9 = CHexConver.bytesToInt(byArray[0], byArray[1]);
                    } else if (((byte[])object2).length >= 4) {
                        byte[] byArray = new byte[4];
                        System.arraycopy(object2, 0, byArray, 0, 4);
                        int n10 = CHexConver.bytesToInt(byArray);
                    }
                    float f = (float)var5_27 / 10.0f;
                    deviceInfo.setFrequency(f);
                    this.b.onFrequencyTx(bluetoothDevice, f);
                    continue block24;
                }
                case 7: {
                    JL_Log.i(c, "-parsePublicData- SYS_INFO_ATTR_LIGHT");
                    int n = CHexConver.byteToInt(object2[0]);
                    int n11 = n & 3;
                    int n12 = (n & 0xC) >>> 2;
                    int n13 = CHexConver.byteToInt(object2[2]);
                    int n3 = CHexConver.byteToInt(object2[3]);
                    int n5 = CHexConver.byteToInt(object2[4]);
                    int n14 = CHexConver.byteToInt(object2[5]);
                    int n15 = CHexConver.byteToInt(object2[6]);
                    int n16 = CHexConver.bytesToInt(object2[7], object2[8]);
                    int n17 = CHexConver.byteToInt(object2[9]);
                    int n18 = CHexConver.byteToInt(object2[10]);
                    LightControlInfo lightControlInfo = new LightControlInfo().setSwitchState(n11).setLightMode(n12).setColor(Color.rgb((int)CHexConver.byteToInt(object2[1]), (int)n13, (int)n3)).setTwinkleMode(n5).setTwinkleFreq(n14).setSceneMode(n15).setHue(n16).setSaturation(n17).setLuminance(n18);
                    deviceInfo.setLightControlInfo(lightControlInfo);
                    this.b.onLightControlInfo(bluetoothDevice, lightControlInfo);
                    continue block24;
                }
                case 6: {
                    int n = CHexConver.byteToInt(object2[0]);
                    deviceInfo.setCurFunction(object2[0]);
                    JL_Log.i(c, "-parsePublicData- onDeviceModeChange >> " + n);
                    this.b.onDeviceModeChange(bluetoothDevice, n);
                    continue block24;
                }
                case 5: {
                    String string;
                    Object var5_32 = null;
                    String string2 = string;
                    try {
                        string = new String((byte[])object2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        string2 = var5_32;
                    }
                    deviceInfo.setPlayFileFormat(string2);
                    this.b.onFileFormatChange(bluetoothDevice, string2);
                    continue block24;
                }
                case 4: {
                    void var5_35;
                    EqInfo eqInfo;
                    if ((object2[0] & 0x80) == 128) {
                        boolean bl = true;
                    } else {
                        boolean bl = false;
                    }
                    int n = CHexConver.byteToInt(object2[0]) & 0x7F;
                    Object object3 = eqInfo;
                    ((EqInfo)object3)();
                    ((EqInfo)object3).setMode(n);
                    eqInfo.setDynamic((boolean)var5_35);
                    if (var5_35 != false) {
                        void var5_39;
                        byte by = object2[1];
                        object2 = new byte[by];
                        System.arraycopy(object2, 2, object2, 0, by);
                        ((EqInfo)object3).setValue((byte[])object2);
                        EqPresetInfo eqPresetInfo = this.a(list);
                        if (eqPresetInfo == null) {
                            EqPresetInfo eqPresetInfo2 = deviceInfo.getEqPresetInfo();
                        }
                        if (var5_39 != null) {
                            ((EqInfo)object3).setFreqs(var5_39.getFreqs());
                        }
                        JL_Log.d(c, "-parsePublicData- eq data freq-->" + var5_39);
                    } else {
                        void var5_42;
                        byte[] byArray = new byte[]{};
                        if (((byte[])object2).length > 10) {
                            byte[] byArray2 = new byte[10];
                            System.arraycopy(object2, 1, byArray2, 0, 10);
                        }
                        ((EqInfo)object3).setValue((byte[])var5_42);
                    }
                    deviceInfo.setEqInfo((EqInfo)object3);
                    this.b.onEqChange(bluetoothDevice, (EqInfo)object3);
                    continue block24;
                }
                case 2: {
                    DevStorageInfo devStorageInfo;
                    DevStorageInfo devStorageInfo2 = devStorageInfo;
                    devStorageInfo2();
                    devStorageInfo.parseData((byte[])object2);
                    deviceInfo.setDevStorageInfo(devStorageInfo);
                    this.b.onDevStorageInfoChange(bluetoothDevice, devStorageInfo2);
                    continue block24;
                }
                case 1: {
                    VolumeInfo volumeInfo;
                    DeviceInfo deviceInfo2 = deviceInfo;
                    int n = deviceInfo2.getMaxVol();
                    boolean bl = deviceInfo2.isSupportVolumeSync();
                    int n19 = CHexConver.byteToInt(object2[0]);
                    deviceInfo.setVolume(n19);
                    Object object3 = volumeInfo;
                    volumeInfo = new VolumeInfo(n, n19, bl);
                    this.b.onVolumeChange(bluetoothDevice, (VolumeInfo)object3);
                    continue block24;
                }
                case 0: 
            }
            int n = CHexConver.byteToInt(object2[0]);
            object2 = batteryInfo;
            batteryInfo = new BatteryInfo(n);
            this.b.onBatteryChange(bluetoothDevice, (BatteryInfo)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void b(BluetoothDevice bluetoothDevice, List<AttrBean> list) {
        if (list == null) {
            return;
        }
        DeviceInfo deviceInfo = this.a.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        ID3MusicInfo iD3MusicInfo = deviceInfo.getiD3MusicInfo();
        if (iD3MusicInfo == null) {
            ID3MusicInfo iD3MusicInfo2;
            iD3MusicInfo = iD3MusicInfo2;
            iD3MusicInfo2 = new ID3MusicInfo();
        }
        boolean bl = false;
        block27: for (AttrBean object : list) {
            String string;
            int n;
            int n2;
            String string2;
            String string3;
            byte[] byArray = object.getAttrData();
            if (byArray == null || byArray.length == 0) continue;
            switch (object.getType()) {
                default: {
                    continue block27;
                }
                case 8: {
                    int bl2;
                    bl = true;
                    boolean n3 = false;
                    if (byArray.length >= 4) {
                        bl2 = CHexConver.bytesToInt(byArray, 0, 4) / 1000;
                    }
                    JL_Log.d(c, "-parseBtData- id3 currentTime: " + bl2);
                    iD3MusicInfo.setCurrentTime(bl2);
                    continue block27;
                }
                case 7: {
                    void var6_12;
                    bl = true;
                    if ((byArray[0] & 1) == 1) {
                        boolean n4 = true;
                    } else {
                        boolean n7 = false;
                    }
                    JL_Log.d(c, "-parseBtData- id3 isPlay: " + (boolean)var6_12);
                    iD3MusicInfo.setPlayStatus((boolean)var6_12);
                    continue block27;
                }
                case 6: {
                    int n3;
                    bl = true;
                    boolean bl2 = false;
                    if (byArray.length >= 2) {
                        n3 = CHexConver.bytesToInt(byArray, 0, 2);
                    }
                    JL_Log.i(c, "-parseBtData- id3 allTime: " + n3);
                    iD3MusicInfo.setTotalTime(n3);
                    continue block27;
                }
                case 5: {
                    String string4;
                    bl = true;
                    Object var6_15 = null;
                    string3 = string4;
                    int n4 = 0;
                    int n5 = byArray.length;
                    try {
                        string4 = new String(byArray, n4, n5, StandardCharsets.UTF_8);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        string3 = var6_15;
                    }
                    JL_Log.d(c, "-parseBtData- id3 genre: " + string3);
                    iD3MusicInfo.setGenre(string3);
                    continue block27;
                }
                case 4: {
                    int n6;
                    bl = true;
                    boolean bl3 = false;
                    if (byArray.length >= 2) {
                        n6 = CHexConver.bytesToInt(byArray, 0, 2);
                    }
                    JL_Log.d(c, "-parseBtData- id3 allNum: " + n6);
                    iD3MusicInfo.setTotal(n6);
                    continue block27;
                }
                case 3: {
                    bl = true;
                    int n7 = CHexConver.byteToInt(byArray[0]);
                    JL_Log.d(c, "-parseBtData- id3 number: " + n7);
                    iD3MusicInfo.setNumber(n7);
                    continue block27;
                }
                case 2: {
                    String string5;
                    bl = true;
                    Object var6_18 = null;
                    string3 = CHexConver.byte2HexStr(byArray);
                    string2 = string5;
                    n2 = 0;
                    n = byArray.length;
                    try {
                        string5 = new String(byArray, n2, n, StandardCharsets.UTF_8);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        string2 = var6_18;
                    }
                    if (string2 != null && byArray.length == 64) {
                        StringBuilder stringBuilder;
                        StringBuilder stringBuilder2 = stringBuilder;
                        String string6 = string2;
                        stringBuilder2();
                        string2 = stringBuilder.append(string6.substring(0, string6.length() - 1)).append("...").toString();
                    }
                    if ("00".equals(string3)) {
                        string2 = "";
                    }
                    iD3MusicInfo.setAlbum(string2);
                    continue block27;
                }
                case 1: {
                    String string7;
                    bl = true;
                    Object var6_21 = null;
                    string3 = CHexConver.byte2HexStr(byArray);
                    string2 = string7;
                    n2 = 0;
                    n = byArray.length;
                    try {
                        string7 = new String(byArray, n2, n, StandardCharsets.UTF_8);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        string2 = var6_21;
                    }
                    if (string2 != null && byArray.length == 64) {
                        StringBuilder stringBuilder;
                        StringBuilder stringBuilder3 = stringBuilder;
                        String string8 = string2;
                        stringBuilder3();
                        string2 = stringBuilder.append(string8.substring(0, string8.length() - 1)).append("...").toString();
                    }
                    if ("00".equals(string3)) {
                        string2 = "";
                    }
                    iD3MusicInfo.setArtist(string2);
                    continue block27;
                }
                case 0: 
            }
            bl = true;
            Object var6_24 = null;
            string3 = CHexConver.byte2HexStr(byArray);
            string2 = string;
            n2 = 0;
            n = byArray.length;
            try {
                string = new String(byArray, n2, n, StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string2 = var6_24;
            }
            if (string2 != null && byArray.length == 64) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder4 = stringBuilder;
                String string9 = string2;
                stringBuilder4();
                string2 = stringBuilder.append(string9.substring(0, string9.length() - 1)).append("...").toString();
            }
            if ("00".equals(string3)) {
                string2 = "";
            }
            iD3MusicInfo.setTitle(string2);
        }
        if (bl) {
            deviceInfo.setiD3MusicInfo(iD3MusicInfo);
            this.b.onID3MusicInfo(bluetoothDevice, iD3MusicInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void d(BluetoothDevice bluetoothDevice, List<AttrBean> object) {
        if (object == null) {
            return;
        }
        DeviceInfo deviceInfo = this.a.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            void var4_17;
            MusicStatusInfo musicStatusInfo;
            int n;
            int n2;
            int n3;
            AttrBean attrBean = (AttrBean)object.next();
            Object object2 = attrBean.getAttrData();
            if (object2 == null || ((byte[])object2).length == 0) continue;
            byte bl = attrBean.getType();
            if (bl != 0) {
                void var4_14;
                MusicNameInfo musicNameInfo;
                block19: {
                    if (bl != 1) {
                        PlayModeInfo playModeInfo;
                        if (bl != 2) continue;
                        int byArray = CHexConver.byteToInt(object2[0]);
                        JL_Log.d(c, "-parseMusicData- music play mode : " + byArray);
                        object2 = playModeInfo;
                        playModeInfo = new PlayModeInfo(byArray);
                        deviceInfo.setPlayModeInfo(playModeInfo);
                        this.b.onPlayModeChange(bluetoothDevice, (PlayModeInfo)object2);
                        continue;
                    }
                    if (((byte[])object2).length <= 3) continue;
                    byte[] n4 = new byte[4];
                    System.arraycopy(object2, 0, n4, 0, 4);
                    int string = 4;
                    n3 = CHexConver.bytesToInt(n4);
                    Object var7_20 = null;
                    if (((byte[])object2).length > 4) {
                        if ((object2[string] & 0xFF) == 1) {
                            boolean bl2 = true;
                        } else {
                            boolean bl3 = false;
                        }
                        n2 = 5;
                        if (((Object)object2).length > 5) {
                            void var4_11;
                            void v1 = var4_11;
                            byte[] byArray = object2;
                            int n5 = byArray.length - n2;
                            String string2 = v1 != false ? "gbk" : "utf-16le";
                            try {
                                String string3 = new String((byte[])object2, n2, n5, string2);
                                break block19;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                unsupportedEncodingException.printStackTrace();
                            }
                        }
                    }
                    Object var4_13 = var7_20;
                }
                DeviceInfo deviceInfo2 = deviceInfo;
                object2 = musicNameInfo;
                musicNameInfo = new MusicNameInfo(n3, (String)var4_14);
                deviceInfo2.setMusicNameInfo(musicNameInfo);
                deviceInfo2.setCluster(object2.getCluster());
                this.b.onMusicNameChange(bluetoothDevice, (MusicNameInfo)object2);
                continue;
            }
            if ((object2[0] & 1) == 1) {
                boolean bl4 = true;
            } else {
                boolean bl5 = false;
            }
            n3 = 0;
            int n6 = 0;
            n2 = 0;
            int n7 = 1;
            if (((byte[])object2).length > 4) {
                n3 = 4;
                byte[] byArray = new byte[4];
                System.arraycopy(object2, n7, byArray, 0, n3);
                int n8 = 5;
                n = CHexConver.bytesToInt(byArray) * 1000;
                if (((byte[])object2).length > 8) {
                    System.arraycopy(object2, n8, byArray, 0, n3);
                    n3 = 9;
                    n6 = CHexConver.bytesToInt(byArray) * 1000;
                    if (((Object)object2).length > 9) {
                        n2 = CHexConver.byteToInt((byte)object2[n3]);
                    }
                }
            } else {
                n = n3;
            }
            DeviceInfo deviceInfo3 = deviceInfo;
            object2 = musicStatusInfo;
            musicStatusInfo = new MusicStatusInfo((boolean)var4_17, n, n6, n2);
            deviceInfo3.setMusicStatusInfo(musicStatusInfo);
            deviceInfo3.setCurrentDevIndex(CHexConver.intToByte(object2.getCurrentDev()));
            this.b.onMusicStatusChange(bluetoothDevice, (MusicStatusInfo)object2);
        }
    }

    private void f(BluetoothDevice bluetoothDevice, List<AttrBean> list) {
        if (list == null) {
            return;
        }
        DeviceInfo deviceInfo = this.a.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        int n = this.b(list);
        block13: for (AttrBean object : list) {
            AlarmListInfo alarmListInfo;
            Object object2;
            block24: {
                ArrayList arrayList;
                int object4;
                Object n6 = object.getAttrData();
                if (n6 == null || ((byte[])n6).length == 0) continue;
                switch (object.getType()) {
                    default: {
                        continue block13;
                    }
                    case 7: {
                        deviceInfo.setAlarmExpandFlag(n6[0]);
                        continue block13;
                    }
                    case 5: {
                        ArrayList arrayList2;
                        JL_Log.i(c, "parse alarm default bell " + CHexConver.byte2HexStr(n6));
                        int n3 = n6[0] & 0xF;
                        object2 = arrayList2;
                        arrayList2 = new ArrayList();
                        object4 = 1;
                        while (object4 < ((byte[])n6).length && object2.size() < n3) {
                            String string;
                            DefaultAlarmBell defaultAlarmBell;
                            int alarmBean = object4 + 1;
                            object4 = n6[object4];
                            int defaultAlarmBell2 = alarmBean + 1;
                            alarmBean = n6[alarmBean];
                            byte[] bl = new byte[alarmBean];
                            System.arraycopy(n6, defaultAlarmBell2, bl, 0, alarmBean);
                            alarmBean = defaultAlarmBell2 + alarmBean;
                            DefaultAlarmBell by6 = defaultAlarmBell;
                            String by5 = string;
                            string = new String(bl);
                            defaultAlarmBell = new DefaultAlarmBell(object4, by5, false);
                            object2.add(by6);
                            object4 = alarmBean;
                        }
                        deviceInfo.setAlarmDefaultBells((List<DefaultAlarmBell>)object2);
                        this.b.onAlarmDefaultBellListChange(bluetoothDevice, (List<DefaultAlarmBell>)object2);
                        continue block13;
                    }
                    case 4: {
                        DeviceInfo deviceInfo2 = deviceInfo;
                        JL_Log.d(c, "parse alarm ver " + CHexConver.byte2HexStr(n6));
                        deviceInfo2.setAlarmVersion(n);
                        if (deviceInfo2.getAlarmListInfo() == null) {
                            ArrayList arrayList3;
                            AlarmListInfo alarmListInfo2;
                            AlarmListInfo n7 = alarmListInfo2;
                            n6 = arrayList3;
                            arrayList3 = new ArrayList();
                            alarmListInfo2 = new AlarmListInfo(n, (List<AlarmBean>)n6);
                            deviceInfo.setAlarmListInfo(n7);
                            continue block13;
                        }
                        deviceInfo.getAlarmListInfo().setVersion(n);
                        continue block13;
                    }
                    case 2: 
                    case 3: {
                        Object object3;
                        int n2 = CHexConver.byteToInt(n6[0]);
                        object2 = null;
                        if (deviceInfo.getAlarmListInfo() != null && (object3 = deviceInfo.getAlarmListInfo().getAlarmBeans()) != null && !object3.isEmpty()) {
                            object3 = object3.iterator();
                            while (object3.hasNext()) {
                                AlarmBean i = (AlarmBean)object3.next();
                                if (n2 != i.getIndex()) continue;
                                object2 = i.copy();
                                break;
                            }
                        }
                        if (object2 == null) {
                            AlarmBean alarmBean;
                            object2 = alarmBean;
                            ((AlarmBean)object2)();
                            alarmBean.setIndex((byte)n2);
                            alarmBean.setName("Alarm");
                            Calendar calendar = Calendar.getInstance();
                            ((AlarmBean)object2).setHour((byte)calendar.get(11));
                            alarmBean.setMin((byte)calendar.get(12));
                        }
                        JL_Log.e("RTCOpImpl", "RTCOpImpl >>>index = " + n2 + " " + object2);
                        if (object.getType() == 3) {
                            this.b.onAlarmStop(bluetoothDevice, (AlarmBean)object2);
                            continue block13;
                        }
                        this.b.onAlarmNotify(bluetoothDevice, (AlarmBean)object2);
                        continue block13;
                    }
                    case 1: 
                }
                int alarmListInfo3 = CHexConver.byteToInt(n6[0]);
                object2 = arrayList;
                arrayList = new ArrayList();
                if (alarmListInfo3 <= 0) break block24;
                object4 = 1;
                for (int i = 0; i < alarmListInfo3 && ((byte[])n6).length - object4 > 5; ++i) {
                    String string;
                    byte by;
                    int byArray;
                    byte by2;
                    String string2;
                    byte by3;
                    byte by4;
                    byte by5;
                    boolean bl;
                    byte by6;
                    block28: {
                        String string3;
                        block27: {
                            String string4;
                            block26: {
                                String by22;
                                block25: {
                                    String string5;
                                    int string42;
                                    by6 = n6[object4++];
                                    bl = CHexConver.byteToInt(n6[object4++]) == 1;
                                    by5 = n6[object4++];
                                    by4 = n6[object4++];
                                    by3 = n6[object4++];
                                    by22 = null;
                                    if ((string42 = CHexConver.byteToInt(n6[object4++])) > ((byte[])n6).length - object4) break;
                                    if (string42 <= 0) break block25;
                                    int n3 = object4;
                                    int n4 = string42;
                                    string2 = string5;
                                    try {
                                        string5 = new String((byte[])n6, object4, string42);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                    object4 = n3 + n4;
                                    break block26;
                                }
                                string2 = by22;
                            }
                            by2 = 0;
                            string3 = "";
                            byArray = 0;
                            by = 0;
                            if (n == 0) {
                                n = deviceInfo.getAlarmVersion();
                            }
                            int n5 = ((byte[])n6).length - object4;
                            if (n != 1 || n5 <= 6) break block27;
                            by2 = n6[object4++];
                            by = n6[object4++];
                            byte[] byArray2 = new byte[4];
                            System.arraycopy(n6, object4, byArray2, 0, 4);
                            byArray = CHexConver.bytesToInt(byArray2);
                            int n7 = object4 + 4;
                            object4 = n7 + 1;
                            n5 = n6[n7] & 0xFF;
                            if (n5 > ((byte[])n6).length - object4) break block27;
                            int n8 = object4;
                            int n9 = n5;
                            string = string4;
                            try {
                                string4 = new String((byte[])n6, object4, n5);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            object4 = n8 + n9;
                            break block28;
                        }
                        string = string3;
                    }
                    object2.add(new AlarmBean().setVersion(n).setIndex(by6).setRepeatMode(by5).setName(string2).setDevIndex(by).setHour(by4).setMin(by3).setBellCluster(byArray).setBellName(string).setBellType(by2).setOpen(bl));
                }
            }
            AlarmListInfo alarmListInfo3 = alarmListInfo;
            alarmListInfo3((List<AlarmBean>)object2);
            alarmListInfo.setVersion(n);
            deviceInfo.setAlarmListInfo(alarmListInfo);
            this.b.onAlarmListChange(bluetoothDevice, alarmListInfo3);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, List<AttrBean> object) {
        if (object == null) {
            return;
        }
        DeviceInfo deviceInfo = this.a.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            AttrBean attrBean = (AttrBean)object.next();
            byte[] byArray = attrBean.getAttrData();
            if (byArray == null || byArray.length == 0 || attrBean.getType() != 0) continue;
            boolean bl = CHexConver.byteToInt(byArray[0]) == 1;
            JL_Log.i(c, "onAuxStatusChange >> " + bl);
            deviceInfo.setAuxPlay(bl);
            this.b.onAuxStatusChange(bluetoothDevice, bl);
        }
    }

    private void c(BluetoothDevice bluetoothDevice, List<AttrBean> object) {
        if (object == null) {
            return;
        }
        DeviceInfo deviceInfo = this.a.getDeviceInfo(bluetoothDevice);
        if (deviceInfo == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            FmStatusInfo fmStatusInfo;
            int n;
            int n2;
            AttrBean attrBean = (AttrBean)object.next();
            Object object2 = attrBean.getAttrData();
            if (object2 == null || ((byte[])object2).length == 0) continue;
            byte by = attrBean.getType();
            if (by) {
                ArrayList<ChannelInfo> arrayList;
                if (!by) continue;
                ArrayList<ChannelInfo> arrayList2 = arrayList;
                arrayList = new ArrayList<ChannelInfo>();
                n2 = 1;
                int n3 = ((byte[])object2).length;
                while (n3 - n2 >= 3) {
                    n = CHexConver.byteToInt(object2[n2]);
                    float f = (float)CHexConver.bytesToInt(object2[++n2], object2[n2 + 1]) / 10.0f;
                    n2 += 2;
                    arrayList2.add(new ChannelInfo(n, f));
                }
                deviceInfo.setChannelInfos(arrayList2);
                this.b.onFmChannelsChange(bluetoothDevice, arrayList2);
                continue;
            }
            by = CHexConver.byteToInt(object2[0]) == 1 ? (byte)1 : 0;
            n2 = 0;
            float f = 0.0f;
            n = 0;
            if (((byte[])object2).length > 1) {
                n2 = CHexConver.byteToInt(object2[1]);
            }
            if (((byte[])object2).length > 3) {
                f = (float)CHexConver.bytesToInt(object2[2], object2[3]) / 10.0f;
            }
            if (((byte[])object2).length > 4) {
                n = CHexConver.byteToInt(object2[4]);
            }
            object2 = fmStatusInfo;
            fmStatusInfo = new FmStatusInfo(by != 0, n2, f, n);
            deviceInfo.setFmStatusInfo(fmStatusInfo);
            this.b.onFmStatusChange(bluetoothDevice, (FmStatusInfo)object2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void a(BluetoothDevice var1_1, byte[] var2_2) {
        block8: {
            JL_Log.d("rcsp_handler", "parseFixedLenData-->" + CHexConver.byte2HexStr(var2_2 /* !! */ ));
            var3_3 = this.a.getDeviceInfo(var1_1);
            if (var3_3 == null) {
                return;
            }
            var4_4 = var3_3.getExpandFunction();
            if (var2_2 /* !! */ .length < 4) break block8;
            var5_5 = CHexConver.bytesToInt(var2_2 /* !! */ , 0, 4);
            if (var4_4 == null) {
                var4_4 = v0;
                new ExpandFunction().setMask(var5_5);
            } else {
                v1 = var4_4;
                v1.setMask(v1.getMask() | var5_5);
            }
            var6_7 = 4;
            if ((var5_5 & 1) != 1) ** GOTO lbl-1000
            var7_9 = 9;
            if (var2_2 /* !! */ .length >= 9) {
                var8_10 = new byte[5];
                System.arraycopy(var2_2 /* !! */ , var6_7, var8_10, 0, 5);
                var4_4.putData(0, var8_10);
                this.b.onExpandFunction(var1_1, 0, var8_10);
                var6_8 = ReverberationParam.parseData(var8_10);
                if (var6_8 != null) {
                    this.b.onReverberation(var1_1, var6_8);
                }
            } else lbl-1000:
            // 2 sources

            {
                var7_9 = var6_7;
            }
            if ((var5_5 & 2) == 2 && var2_2 /* !! */ .length >= var7_9 + 2) {
                var5_6 = new byte[2];
                System.arraycopy(var2_2 /* !! */ , var7_9, var5_6, 0, 2);
                var4_4.putData(1, var5_6);
                this.b.onExpandFunction(var1_1, 1, var5_6);
                v2 = DynamicLimiterParam.parseData(var5_6);
                var2_2 /* !! */  = (byte[])v2;
                if (v2 != null) {
                    this.b.onDynamicLimiter(var1_1, (DynamicLimiterParam)var2_2 /* !! */ );
                }
            }
            var3_3.setExpandFunction(var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private EqPresetInfo a(List<AttrBean> list) {
        void var3_5;
        block2: {
            List<AttrBean> list2 = list;
            list = null;
            for (AttrBean object2 : list2) {
                if (object2.getType() != 12) continue;
                break block2;
            }
            List<AttrBean> list3 = list;
        }
        if (var3_5 == null) {
            return null;
        }
        return this.a((AttrBean)var3_5);
    }

    private EqPresetInfo a(AttrBean object) {
        int n;
        ArrayList<EqInfo> arrayList;
        EqPresetInfo eqPresetInfo;
        EqPresetInfo eqPresetInfo2 = eqPresetInfo;
        eqPresetInfo = new EqPresetInfo();
        byte[] byArray = ((AttrBean)object).getAttrData();
        object = byArray;
        ArrayList<EqInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<EqInfo>();
        int n2 = byArray[0];
        int[] nArray = new int[n2];
        int n3 = 1;
        for (n = 0; n < n2; ++n) {
            nArray[n] = (object[n3] & 0xFF) << 8 | object[n3 + 1] & 0xFF;
            n3 += 2;
        }
        for (n = 0; n < 7; ++n) {
            EqInfo eqInfo;
            byte[] byArray2 = new byte[n2];
            byte by = (byte)(object[n3] & 0x7F);
            System.arraycopy(object, n3 + 1, byArray2, 0, n2);
            EqInfo eqInfo2 = eqInfo;
            eqInfo = new EqInfo(by, byArray2, nArray);
            boolean bl = (object[n3] & 0x80) == 128;
            EqInfo eqInfo3 = eqInfo2;
            eqInfo3.setDynamic(bl);
            arrayList2.add(eqInfo3);
            n3 += n2 + 1;
        }
        Object object2 = eqPresetInfo2;
        eqPresetInfo2.setNumber(n2);
        eqPresetInfo2.setFreqs(nArray);
        ((EqPresetInfo)object2).setEqInfos(arrayList2);
        JL_Log.d(c, "-parseEqPresetInfo- eq--->" + eqPresetInfo2);
        return object2;
    }

    private int b(List<AttrBean> object) {
        Iterator<AttrBean> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (AttrBean)iterator.next();
            if (((AttrBean)object).getType() != 4) continue;
            return ((AttrBean)object).getAttrData()[0] & 7;
        }
        return 0;
    }

    public void parseHealthSetting(BluetoothDevice bluetoothDevice, List<AttrBean> object) {
        Object object2 = this.a.getDeviceInfo();
        if (object2 == null) {
            return;
        }
        HealthSettingInfo healthSettingInfo = ((DeviceInfo)object2).getHealthSettingInfo();
        if (healthSettingInfo == null) {
            HealthSettingInfo healthSettingInfo2;
            healthSettingInfo = healthSettingInfo2;
            healthSettingInfo2 = new HealthSettingInfo();
            ((DeviceInfo)object2).setHealthSettingInfo(healthSettingInfo);
        }
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (AttrBean)object.next();
            byte[] byArray = ((AttrBean)object2).getAttrData();
            healthSettingInfo.setFuncFlag(((AttrBean)object2).getType());
            switch (((AttrBean)object2).getType()) {
                default: {
                    break;
                }
                case 12: {
                    EmergencyContact emergencyContact;
                    object2 = emergencyContact;
                    emergencyContact = new EmergencyContact(byArray);
                    healthSettingInfo.setEmergencyContact((EmergencyContact)object2);
                    break;
                }
                case 11: {
                    BloodOxygenMeasurementAlert bloodOxygenMeasurementAlert;
                    object2 = bloodOxygenMeasurementAlert;
                    bloodOxygenMeasurementAlert = new BloodOxygenMeasurementAlert(byArray);
                    healthSettingInfo.setBloodOxygenMeasurementAlert((BloodOxygenMeasurementAlert)object2);
                    break;
                }
                case 10: {
                    DisconnectReminder disconnectReminder;
                    object2 = disconnectReminder;
                    disconnectReminder = new DisconnectReminder(byArray);
                    healthSettingInfo.setDisconnectReminder((DisconnectReminder)object2);
                    break;
                }
                case 9: {
                    UserInfo userInfo;
                    object2 = userInfo;
                    userInfo = new UserInfo(byArray);
                    healthSettingInfo.setUserInfo((UserInfo)object2);
                    break;
                }
                case 8: {
                    LiftWristDetection liftWristDetection;
                    object2 = liftWristDetection;
                    liftWristDetection = new LiftWristDetection(byArray);
                    healthSettingInfo.setLiftWristDetection((LiftWristDetection)object2);
                    break;
                }
                case 7: {
                    FallDetection fallDetection;
                    object2 = fallDetection;
                    fallDetection = new FallDetection(byArray);
                    healthSettingInfo.setFallDetection((FallDetection)object2);
                    break;
                }
                case 6: {
                    SleepDetection sleepDetection;
                    object2 = sleepDetection;
                    sleepDetection = new SleepDetection(byArray);
                    healthSettingInfo.setSleepDetection((SleepDetection)object2);
                    break;
                }
                case 5: {
                    AutomaticPressureDetection automaticPressureDetection;
                    object2 = automaticPressureDetection;
                    automaticPressureDetection = new AutomaticPressureDetection(byArray);
                    healthSettingInfo.setAutomaticPressureDetection((AutomaticPressureDetection)object2);
                    break;
                }
                case 4: {
                    ExerciseHeartRateReminder exerciseHeartRateReminder;
                    object2 = exerciseHeartRateReminder;
                    exerciseHeartRateReminder = new ExerciseHeartRateReminder(byArray);
                    healthSettingInfo.setExerciseHeartRateReminder((ExerciseHeartRateReminder)object2);
                    break;
                }
                case 3: {
                    HeartRateMeasure heartRateMeasure;
                    object2 = heartRateMeasure;
                    heartRateMeasure = new HeartRateMeasure(byArray);
                    healthSettingInfo.setHeartRateMeasure((HeartRateMeasure)object2);
                    break;
                }
                case 2: {
                    SedentaryReminder sedentaryReminder;
                    object2 = sedentaryReminder;
                    sedentaryReminder = new SedentaryReminder(byArray);
                    healthSettingInfo.setSedentaryReminder((SedentaryReminder)object2);
                    break;
                }
                case 1: {
                    healthSettingInfo.setSensorInfo(new SensorInfo(CHexConver.bytesToInt(byArray, 0, 2)));
                }
            }
            this.b.onHealthSettingChange(bluetoothDevice, healthSettingInfo);
        }
    }

    public void parseAttrMessage(BluetoothDevice bluetoothDevice, byte by, List<AttrBean> list) {
        if (bluetoothDevice != null && list != null) {
            switch (by) {
                default: {
                    break;
                }
                case 4: {
                    this.c(bluetoothDevice, list);
                    break;
                }
                case 3: {
                    this.a(bluetoothDevice, list);
                    break;
                }
                case 2: {
                    this.f(bluetoothDevice, list);
                    break;
                }
                case 1: {
                    this.d(bluetoothDevice, list);
                    break;
                }
                case 0: {
                    this.b(bluetoothDevice, list);
                    break;
                }
                case -1: {
                    this.e(bluetoothDevice, list);
                }
            }
            return;
        }
    }
}

