/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.util;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;

public class HealthDataUtil {
    public static void parseHeartRate(HealthData healthData, ParseResult<Integer> parseResult, ParseResult<Integer> parseResult2, ParseResult<Integer> parseResult3) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 0) {
            return;
        }
        int n = healthData.subMask;
        if ((n & 0xFF) == 255) {
            return;
        }
        int n2 = n;
        n = 0;
        if ((n2 & 1) == 1) {
            if (parseResult != null) {
                parseResult.onResult(healthData.data[n] & 0xFF);
            }
            n = 1;
        }
        if ((healthData.subMask & 2) == 2) {
            if (parseResult2 != null) {
                parseResult2.onResult(healthData.data[n] & 0xFF);
            }
            ++n;
        }
        if ((healthData.subMask & 4) == 4 && parseResult3 != null) {
            parseResult3.onResult(healthData.data[n] & 0xFF);
        }
    }

    public static void parseAirPressure(HealthData healthData, ParseResult<Integer> parseResult, ParseResult<Integer> parseResult2, ParseResult<Integer> parseResult3) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 1) {
            return;
        }
        int n = healthData.subMask;
        if ((n & 0xFF) == 255) {
            return;
        }
        int n2 = n;
        n = 0;
        byte[] byArray = healthData.data;
        if ((n2 & 1) == 1) {
            if (parseResult != null) {
                parseResult.onResult(CHexConver.bytesToInt(byArray[n], byArray[1]));
            }
            n = 2;
        }
        if ((healthData.subMask & 2) == 2) {
            if (parseResult2 != null) {
                parseResult2.onResult(CHexConver.bytesToInt(byArray[n], byArray[n + 1]));
            }
            n += 2;
        }
        if ((healthData.subMask & 4) == 4 && parseResult3 != null) {
            parseResult3.onResult(CHexConver.bytesToInt(byArray[n], byArray[n + 1]));
        }
    }

    public static void parseAltitude(HealthData object, ParseResult<Double> object2, ParseResult<Double> parseResult, ParseResult<Double> parseResult2) {
        if (((HealthData)object).version != 0) {
            return;
        }
        if (((HealthData)object).type != 2) {
            return;
        }
        int n = ((HealthData)object).subMask;
        if ((n & 0xFF) == 255) {
            return;
        }
        int n2 = n;
        n = 0;
        byte[] byArray = ((HealthData)object).data;
        if ((n2 & 1) == 1) {
            if (object2 != null) {
                StringBuilder stringBuilder;
                ParseResult<Double> parseResult3 = object2;
                object2 = stringBuilder;
                ((StringBuilder)object2)();
                parseResult3.onResult(Double.parseDouble(stringBuilder.append(CHexConver.bytesToInt(byArray[n], byArray[1])).append(".").append(CHexConver.bytesToInt(byArray[2], byArray[3])).toString()));
            }
            n = 4;
        }
        if ((((HealthData)object).subMask & 2) == 2) {
            if (parseResult != null) {
                StringBuilder stringBuilder;
                object2 = stringBuilder;
                ((StringBuilder)object2)();
                parseResult.onResult(Double.parseDouble(stringBuilder.append(CHexConver.bytesToInt(byArray[n], byArray[n + 1])).append(".").append(CHexConver.bytesToInt(byArray[n + 2], byArray[n + 3])).toString()));
            }
            n += 4;
        }
        if ((((HealthData)object).subMask & 4) == 4 && parseResult2 != null) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            ((StringBuilder)object)();
            parseResult2.onResult(Double.parseDouble(stringBuilder.append(CHexConver.bytesToInt(byArray[n], byArray[n + 1])).append(".").append(CHexConver.bytesToInt(byArray[n + 2], byArray[n + 3])).toString()));
        }
    }

    public static void parseStep(HealthData healthData, ParseResult<Integer> parseResult, ParseResult<Integer> parseResult2) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 3) {
            return;
        }
        int n = healthData.subMask;
        if ((n & 0xFF) == 255) {
            return;
        }
        int n2 = n;
        n = 0;
        byte[] byArray = healthData.data;
        if ((n2 & 1) == 1) {
            if (parseResult != null) {
                parseResult.onResult(CHexConver.bytesToInt(byArray, n, 4));
            }
            n = 4;
        }
        if ((healthData.subMask & 2) == 2 && parseResult2 != null) {
            parseResult2.onResult(CHexConver.bytesToInt(byArray, n, 4));
        }
    }

    public static void parsePressure(HealthData healthData, ParseResult<Integer> parseResult) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 4) {
            return;
        }
        byte by = healthData.subMask;
        if ((by & 0xFF) == 255) {
            return;
        }
        int n = 0;
        byte[] byArray = healthData.data;
        if ((by & 1) == 1 && parseResult != null) {
            parseResult.onResult(byArray[n] & 0xFF);
        }
    }

    public static void parseBloodOxygen(HealthData healthData, ParseResult<Integer> parseResult) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 5) {
            return;
        }
        byte by = healthData.subMask;
        if ((by & 0xFF) == 255) {
            return;
        }
        int n = 0;
        byte[] byArray = healthData.data;
        if ((by & 1) == 1 && parseResult != null) {
            parseResult.onResult(byArray[n] & 0xFF);
        }
    }

    public static void parseTrainingLoad(HealthData healthData, ParseResult<Integer> parseResult) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 6) {
            return;
        }
        byte by = healthData.subMask;
        if ((by & 0xFF) == 255) {
            return;
        }
        int n = 0;
        byte[] byArray = healthData.data;
        if ((by & 1) == 1 && parseResult != null) {
            parseResult.onResult(byArray[n] & 0xFF);
        }
    }

    public static void parseMaxOxygenUptake(HealthData healthData, ParseResult<Integer> parseResult) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 7) {
            return;
        }
        byte by = healthData.subMask;
        if ((by & 0xFF) == 255) {
            return;
        }
        int n = 0;
        byte[] byArray = healthData.data;
        if ((by & 1) == 1 && parseResult != null) {
            parseResult.onResult(byArray[n] & 0xFF);
        }
    }

    public static void parseSportRecoveryTime(HealthData healthData, ParseResult<Float> parseResult) {
        if (healthData.version != 0) {
            return;
        }
        if (healthData.type != 8) {
            return;
        }
        byte by = healthData.subMask;
        if ((by & 0xFF) == 255) {
            return;
        }
        int n = 0;
        byte[] byArray = healthData.data;
        if ((by & 1) == 1) {
            int n2 = n;
            n = byArray[n] & 0xFF;
            float f = (float)((byArray[n2] & 0xFF) >> 2) + (float)n * 15.0f / 60.0f;
            if (parseResult != null) {
                parseResult.onResult(Float.valueOf(f));
            }
        }
    }

    public static interface ParseResult<T> {
        public void onResult(T var1);
    }
}

