/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.bk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.elinkthings.bleotalibrary.bk.BleBKOtaUtils;
import com.elinkthings.bleotalibrary.bk.OnBleBkOTAListener;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.device.SendDataBean;
import com.pingwang.bluetoothlib.listener.OnCharacteristicListener;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public class BKOtaManager
implements OnCharacteristicListener,
BleDevice.onDisConnectedListener {
    private static final String TAG = BKOtaManager.class.getSimpleName();
    public static final String ERROR_SEND_IMG_STR = "Send img error.";
    private BluetoothGatt mBluetoothGatt;
    private OnBleOTAListener mOnBleOTAListener;
    private HashMap errors;
    public static final int ERROR_COMMUNICATION = 65535;
    public static final int ERROR_SUOTA_NOT_FOUND = 65534;
    public static final int ERROR_READ_FILE = 65533;
    public static final int ERROR_ON_START = 65532;
    public static final int ERROR_LOW_POWER = 65531;
    public static final int ERROR_SEND_IMG = 65530;
    public static final UUID UUID_OTA_SERVICE = UUID.fromString("f000ffc0-0451-4000-b000-000000000000");
    public static final UUID UUID_OTA_READ = UUID.fromString("f000ffc1-0451-4000-b000-000000000000");
    public static final UUID UUID_OTA_WRITE = UUID.fromString("f000ffc2-0451-4000-b000-000000000000");
    private BluetoothGattCharacteristic mOtaWriteData1;
    private BluetoothGattCharacteristic mOtaWriteData2;
    private BleBKOtaUtils fileUtils;
    private boolean mVerifySupport = false;
    private String mFilePath = "";
    private BleDevice mBleDevice;
    private boolean lastBlock = false;
    private int mOldIndex = 0;
    private boolean hasError = false;
    private static final int OTA_SEND_MSG = 2;
    private Handler threadHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    BKOtaManager.this.threadHandler.removeMessages(2);
                    if ((long)BKOtaManager.this.mOldIndex > BKOtaManager.this.fileUtils.getBlocks()) {
                        BKOtaManager.this.onSuccess();
                        return;
                    }
                    BKOtaManager.this.sendBlock(BKOtaManager.this.mOldIndex);
                    ++BKOtaManager.this.mOldIndex;
                    BKOtaManager.this.threadHandler.sendEmptyMessageDelayed(2, 20L);
                }
            }
        }
    };

    private BKOtaManager(Builder builder) {
        this.mBleDevice = builder.mBleDevice;
        if (this.mBleDevice != null) {
            this.mBleDevice.setOnDisConnectedListener((BleDevice.onDisConnectedListener)this);
            this.mBluetoothGatt = this.mBleDevice.getBluetoothGatt();
            if (this.mBluetoothGatt == null) {
                this.mBleDevice.disconnect();
                return;
            }
        }
        this.mFilePath = builder.mFilePath;
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        BluetoothGattService suota = this.mBluetoothGatt.getService(UUID_OTA_SERVICE);
        if (suota != null) {
            this.mOtaWriteData1 = suota.getCharacteristic(UUID_OTA_READ);
            this.mOtaWriteData2 = suota.getCharacteristic(UUID_OTA_WRITE);
            this.mVerifySupport = true;
            if (this.mBleDevice != null) {
                this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
                this.mBleDevice.setNotify(UUID_OTA_SERVICE, new UUID[]{UUID_OTA_READ, UUID_OTA_WRITE});
            }
        } else {
            Log.e((String)TAG, (String)"\u4e0d\u652f\u6301Dialog OTA");
            this.mVerifySupport = false;
        }
        this.initErrorMap();
        this.initFileLoad(this.mFilePath);
        this.getDeviceAndRomVersion();
    }

    private void initErrorMap() {
        this.errors = new HashMap();
        this.errors.put(65530, ERROR_SEND_IMG_STR);
        this.errors.put(65531, "Low power can't upgrade.");
        this.errors.put(65532, "Work can't upgrade.");
        this.errors.put(65533, "Read fileUtils error.");
        this.errors.put(65535, "Communication error.");
        this.errors.put(65534, "The remote device does not support SUOTA.");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isVerifySupport() {
        return this.mVerifySupport;
    }

    public synchronized void startOta() {
        if (!this.mVerifySupport || this.mBleDevice == null || this.mBluetoothGatt == null) {
            this.hasError = false;
            this.onError(65535);
            return;
        }
        this.mOldIndex = 0;
        this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
        this.sendHeadBlock();
        this.lastBlock = false;
    }

    private void initFileLoad(String fileName) {
        try {
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                this.fileUtils = BleBKOtaUtils.getByFileName(fileName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.hasError = false;
            this.onError(65533);
        }
    }

    public long getDeviceVersion() {
        if (this.fileUtils != null) {
            return this.fileUtils.getDeviceVersion();
        }
        return 0L;
    }

    public long getRomVersion() {
        if (this.fileUtils != null) {
            return this.fileUtils.getRomVersion();
        }
        return 0L;
    }

    public void onCharacteristicReadOK(BluetoothGattCharacteristic characteristic) {
    }

    public void onCharacteristicWriteOK(BluetoothGattCharacteristic characteristic) {
        UUID uuid = characteristic.getUuid();
        if (uuid.equals(UUID_OTA_WRITE)) {
            // empty if block
        }
    }

    public void onDescriptorWriteOK(BluetoothGattDescriptor descriptor) {
        UUID uuid = descriptor.getCharacteristic().getUuid();
        if (uuid.equals(UUID_OTA_WRITE)) {
            // empty if block
        }
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
        UUID uuid = characteristic.getUuid();
        if (uuid.equals(UUID_OTA_WRITE)) {
            this.onNotifyData(characteristic);
        } else if (uuid.equals(UUID_OTA_READ)) {
            byte[] value = characteristic.getValue();
            this.onDeviceVersion(value);
        }
    }

    private void onDeviceVersion(byte[] value) {
        long deviceVersion = BleBKOtaUtils.buildUint16(value[1], value[0]);
        long romVersion = BleBKOtaUtils.buildUint16(value[9], value[8]);
        if (this.mOnBleOTAListener instanceof OnBleBkOTAListener) {
            ((OnBleBkOTAListener)this.mOnBleOTAListener).onDeviceVersion(String.valueOf(deviceVersion), String.valueOf(romVersion));
        }
    }

    public final void onNotifyData(BluetoothGattCharacteristic characteristic) {
        byte[] value;
        int index;
        if (!this.lastBlock && (index = (((value = characteristic.getValue())[1] & 0xFF) << 8) + (value[0] & 0xFF)) > 0) {
            this.mOldIndex = index + 1;
            this.threadHandler.removeMessages(2);
            this.sendBlock(index);
            this.threadHandler.sendEmptyMessageDelayed(2, 100L);
        }
    }

    private synchronized void getDeviceAndRomVersion() {
        if (this.mOtaWriteData1 != null) {
            SendDataBean sendDataBean = new SendDataBean(new byte[]{0}, UUID_OTA_READ, 2, UUID_OTA_SERVICE);
            this.mBleDevice.sendData(sendDataBean);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private synchronized void sendBlock(int index) {
        byte[] block = this.fileUtils.getBlock(index);
        float progress = (float)index / (float)this.fileUtils.getBlocks() * 100.0f;
        if (this.mOtaWriteData2 != null) {
            this.mOtaWriteData2.setValue(block);
            int properties = this.mOtaWriteData2.getProperties();
            if ((properties & 4) != 0) {
                this.mOtaWriteData2.setWriteType(1);
            } else {
                this.mOtaWriteData2.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.mOtaWriteData2);
            if (!writeSuccess) {
                this.threadHandler.removeMessages(2);
            }
        }
        this.runOnMainThread(() -> {
            if (this.mOnBleOTAListener != null) {
                this.mOnBleOTAListener.onOtaProgress(progress, 1, 1);
            }
        });
        if ((long)index == this.fileUtils.getBlocks()) {
            this.lastBlock = true;
            this.onSuccess();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private synchronized void sendHeadBlock() {
        byte[] block = this.fileUtils.getHeadBlock();
        if (this.mOtaWriteData1 != null) {
            this.mOtaWriteData1.setValue(block);
            int properties = this.mOtaWriteData2.getProperties();
            if ((properties & 4) != 0) {
                this.mOtaWriteData2.setWriteType(1);
            } else {
                this.mOtaWriteData2.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.mOtaWriteData1);
            this.threadHandler.removeMessages(2);
            if (!writeSuccess) {
                this.onError(65530);
            } else {
                this.threadHandler.sendEmptyMessageDelayed(2, 100L);
            }
        }
    }

    private void onSuccess() {
        this.threadHandler.removeMessages(2);
        this.runOnMainThread(() -> {
            if (this.mOnBleOTAListener != null) {
                this.mOnBleOTAListener.onOtaSuccess();
            }
        });
        if (this.fileUtils != null) {
            this.fileUtils.close();
        }
    }

    private void onError(int errorCode) {
        if (!this.hasError) {
            String error = (String)this.errors.get(errorCode);
            Log.e((String)TAG, (String)("Error: " + errorCode + " " + error));
            this.runOnMainThread(() -> {
                if (this.mOnBleOTAListener != null) {
                    this.mOnBleOTAListener.onOtaFailure(errorCode, error);
                }
            });
            this.hasError = true;
            if (this.fileUtils != null) {
                this.fileUtils.close();
            }
        }
    }

    public void setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
        this.mOnBleOTAListener = onBleOTAListener;
    }

    @SuppressLint(value={"MissingPermission"})
    public void onDisConnected() {
        if (!this.lastBlock) {
            BleLog.i((String)TAG, (String)"onDisConnected:\u8fde\u63a5\u65ad\u5f00");
            this.mBluetoothGatt.close();
            this.hasError = false;
            this.onError(65535);
            this.threadHandler.removeMessages(2);
        }
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.threadHandler.post(runnable);
        }
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private OnBleOTAListener mOnBleOTAListener;
        private String mFilePath = "";

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public BKOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new BKOtaManager(this);
        }
    }
}

