/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.bk;

import android.content.Context;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class BleBKOtaUtils {
    private static final int fileChunkSize = 18;
    private InputStream inputStream;
    private static final int FILE_BUFFER_SIZE = 262144;
    private byte[] mFileBytes;
    private long mDeviceVersion;
    private long mRomVersion;
    private long mBinLen;
    private long nBlocks;
    private Map<Integer, byte[]> mMapBytes = new HashMap<Integer, byte[]>();
    private int bytesAvailable;
    private int chunksPerBlockCount;

    public static BleBKOtaUtils getByFileName(String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        return new BleBKOtaUtils(is);
    }

    private BleBKOtaUtils(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.bytesAvailable = this.inputStream.available();
        this.init();
    }

    public void init() throws IOException {
        this.mFileBytes = new byte[262144];
        this.inputStream.read(this.mFileBytes);
        this.mDeviceVersion = BleBKOtaUtils.buildUint16(this.mFileBytes[5], this.mFileBytes[4]);
        this.mBinLen = BleBKOtaUtils.buildUint16(this.mFileBytes[7], this.mFileBytes[6]);
        this.nBlocks = (short)(this.mBinLen / 4L);
        this.mRomVersion = BleBKOtaUtils.buildUint16(this.mFileBytes[15], this.mFileBytes[14]);
    }

    public int getNumberOfBytes() {
        return this.mFileBytes.length;
    }

    private void initBlocksSuota() {
        int dataSize = 16;
        this.chunksPerBlockCount = (int)Math.ceil((double)this.getNumberOfBytes() / (double)dataSize);
        int i = 0;
        while ((long)i < this.mBinLen) {
            byte[] bytes = new byte[18];
            bytes[0] = (byte)(i & 0xFF);
            bytes[1] = (byte)(i >> 8);
            int index = dataSize * i;
            System.arraycopy(this.mFileBytes, index, bytes, 2, dataSize);
            this.mMapBytes.put(i, bytes);
            ++i;
        }
    }

    public byte[] getHeadBlock() {
        int dataSize = 16;
        byte[] bytes = new byte[dataSize];
        System.arraycopy(this.mFileBytes, 0, bytes, 0, bytes.length);
        return bytes;
    }

    public byte[] getBlock(int index) {
        int dataSize = 16;
        byte[] bytes = new byte[18];
        bytes[0] = (byte)(index & 0xFF);
        bytes[1] = (byte)(index >> 8);
        int startIndex = dataSize * index;
        System.arraycopy(this.mFileBytes, startIndex, bytes, 2, dataSize);
        return bytes;
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public long getDeviceVersion() {
        return this.mDeviceVersion;
    }

    public long getRomVersion() {
        return this.mRomVersion;
    }

    public long getBinLen() {
        return this.mBinLen;
    }

    public long getBlocks() {
        return this.nBlocks;
    }

    public static InputStream get(Context c, int resourceID) {
        InputStream inputStream = c.getResources().openRawResource(resourceID);
        return inputStream;
    }

    public static long buildUint16(byte hi, byte lo) {
        if ((hi & 0x80) == 0) {
            return (long)hi << 8 | (long)lo & 0xFFL;
        }
        long temphi = (long)hi & 0x7FL;
        long returnvalue = temphi << 8 | (long)(lo & 0xFF) | 0x8000L;
        return returnvalue;
    }
}

