/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.dialog;

import android.content.Context;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BleDialogOtaUtils {
    private static final int fileChunkSize = 20;
    private InputStream inputStream;
    private byte crc;
    private byte[] bytes;
    private byte[][][] blocks;
    private int fileBlockSize = 0;
    private int bytesAvailable;
    private int numberOfBlocks = -1;
    private int chunksPerBlockCount;
    private int totalChunkCount;

    public static BleDialogOtaUtils getByFileName(String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        return new BleDialogOtaUtils(is);
    }

    private BleDialogOtaUtils(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.bytesAvailable = this.inputStream.available();
        this.init();
    }

    public void init() throws IOException {
        this.bytes = new byte[this.bytesAvailable + 1];
        this.inputStream.read(this.bytes);
        this.bytes[this.bytesAvailable] = this.crc = this.getCrc();
    }

    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    public int getNumberOfBytes() {
        return this.bytes.length;
    }

    public void setFileBlockSize(int fileBlockSize) {
        this.fileBlockSize = fileBlockSize;
        this.chunksPerBlockCount = (int)Math.ceil((double)fileBlockSize / 20.0);
        this.numberOfBlocks = (int)Math.ceil((double)this.bytes.length / (double)this.fileBlockSize);
        this.initBlocksSuota();
    }

    private void initBlocksSuota() {
        int totalChunkCounter = 0;
        this.blocks = new byte[this.numberOfBlocks][][];
        int byteOffset = 0;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            int blockSize = this.fileBlockSize;
            if (i + 1 == this.numberOfBlocks) {
                blockSize = this.bytes.length % this.fileBlockSize;
            }
            int numberOfChunksInBlock = (int)Math.ceil((double)blockSize / 20.0);
            int chunkNumber = 0;
            this.blocks[i] = new byte[numberOfChunksInBlock][];
            for (int j = 0; j < blockSize; j += 20) {
                int chunkSize = 20;
                if (byteOffset + 20 > this.bytes.length) {
                    chunkSize = this.bytes.length - byteOffset;
                } else if (j + 20 > blockSize) {
                    chunkSize = this.fileBlockSize % 20;
                }
                byte[] chunk = Arrays.copyOfRange(this.bytes, byteOffset, byteOffset + chunkSize);
                this.blocks[i][chunkNumber] = chunk;
                byteOffset += chunkSize;
                ++chunkNumber;
                ++totalChunkCounter;
            }
        }
        this.totalChunkCount = totalChunkCounter;
    }

    public byte[][] getBlock(int index) {
        return this.blocks[index];
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public int getChunksPerBlockCount() {
        return this.chunksPerBlockCount;
    }

    public int getTotalChunkCount() {
        return this.totalChunkCount;
    }

    private byte getCrc() throws IOException {
        byte crc_code = 0;
        for (int i = 0; i < this.bytesAvailable; ++i) {
            Byte byteValue = this.bytes[i];
            int intVal = byteValue.intValue();
            crc_code = (byte)(crc_code ^ intVal);
        }
        return crc_code;
    }

    public static InputStream get(Context c, int resourceID) {
        InputStream inputStream = c.getResources().openRawResource(resourceID);
        return inputStream;
    }
}

