/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.dialog;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.elinkthings.bleotalibrary.dialog.BleDialogOtaUtils;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.listener.OnCharacteristicListener;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public class DialogOtaManager
implements OnCharacteristicListener {
    private static final String TAG = DialogOtaManager.class.getSimpleName();
    public static final String OTA_STEP = "OTA_STEP";
    public static final String OTA_ERROR = "OTA_ERROR";
    public static final String OTA_MEMDEV_VALUE = "OTA_MEMDEV_VALUE";
    public static final String ERROR_SEND_IMG_STR = "Send img error.";
    public static final int IC_TYPE_585 = 1;
    public static final int IC_TYPE_580 = 2;
    public static final int IC_TYPE_531 = 3;
    private BluetoothGatt mBluetoothGatt;
    private OnBleOTAListener mOnBleOTAListener;
    private HashMap errors;
    public static final int ERROR_COMMUNICATION = 65535;
    public static final int ERROR_SUOTA_NOT_FOUND = 65534;
    public static final int ERROR_READ_FILE = 65533;
    public static final int ERROR_ON_START = 65532;
    public static final int ERROR_LOW_POWER = 65531;
    public static final int ERROR_SEND_IMG = 65530;
    public static final UUID UUID_OTA_SERVICE = UUID.fromString("0000fef5-0000-1000-8000-00805f9b34fb");
    public static final UUID UUID_OTA_NOTIFY = UUID.fromString("5f78df94-798c-46f5-990a-b3eb6a065c88");
    public static final UUID OTA_MEM_DEV_UUID = UUID.fromString("8082caa8-41a6-4021-91c6-56f9b954cc34");
    public static final UUID OTA_GPIO_MAP_UUID = UUID.fromString("724249f0-5eC3-4b5f-8804-42345af08651");
    public static final UUID OTA_PATCH_LEN_UUID = UUID.fromString("9d84b9a3-000c-49d8-9183-855b673fda31");
    public static final UUID OTA_PATCH_DATA_UUID = UUID.fromString("457871e8-d516-4ca1-9116-57d0b17b9cb2");
    public static final UUID OTA_SERV_STATUS_UUID = UUID.fromString("5f78df94-798c-46f5-990a-b3eb6a065c88");
    private static final UUID DESCR_TWO = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private BluetoothGattCharacteristic otaMemDevChara;
    private BluetoothGattCharacteristic otaGpioMapChara;
    private BluetoothGattCharacteristic otaPatchLenChara;
    private BluetoothGattCharacteristic otaPatchDataChara;
    private BluetoothGattCharacteristic otaServStatusChara;
    private BleDialogOtaUtils fileUtils;
    private int gpioMapPrereq = 0;
    private boolean mVerifySupport = false;
    private String mFilePath = "";
    private int mIcType = 1;
    private BleDevice mBleDevice;
    private boolean mNotify = false;
    private boolean mStartOta = false;
    private int step;
    private static final int MEMORY_TYPE_EXTERNAL_SPI = 19;
    private static int IMAGE_BANK = 0;
    private static int MISO_GPIO = 5;
    private static int MOSI_GPIO = 6;
    private static int CS_GPIO = 3;
    private static int SCK_GPIO = 0;
    private static final int END_SIGNAL = -33554432;
    private static final int REBOOT_SIGNAL = -50331648;
    private boolean endSignalSent = false;
    private int mSendRebootSignalErr = 0;
    private boolean lastBlock = false;
    private boolean preparedForLastBlock = false;
    private int blockCounter = 0;
    private int chunkCounter = -1;
    private boolean lastBlockSent = false;
    private boolean hasError = false;
    private Handler threadHandler = new Handler(Looper.getMainLooper());

    private DialogOtaManager(Builder builder) {
        this.mBleDevice = builder.mBleDevice;
        if (this.mBleDevice != null) {
            this.mBluetoothGatt = this.mBleDevice.getBluetoothGatt();
            if (this.mBluetoothGatt == null) {
                this.mBleDevice.disconnect();
                return;
            }
        }
        this.mFilePath = builder.mFilePath;
        this.mIcType = builder.mIcType;
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.initErrorMap();
        BluetoothGattService suota = this.mBluetoothGatt.getService(UUID_OTA_SERVICE);
        if (suota != null) {
            this.otaMemDevChara = suota.getCharacteristic(OTA_MEM_DEV_UUID);
            this.otaGpioMapChara = suota.getCharacteristic(OTA_GPIO_MAP_UUID);
            this.otaPatchLenChara = suota.getCharacteristic(OTA_PATCH_LEN_UUID);
            this.otaPatchDataChara = suota.getCharacteristic(OTA_PATCH_DATA_UUID);
            this.otaServStatusChara = suota.getCharacteristic(OTA_SERV_STATUS_UUID);
            this.mVerifySupport = true;
            if (this.mBleDevice != null) {
                this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
                this.mBleDevice.setNotify(UUID_OTA_SERVICE, new UUID[]{UUID_OTA_NOTIFY});
            }
        } else {
            Log.e((String)TAG, (String)"\u4e0d\u652f\u6301Dialog OTA");
            this.mVerifySupport = false;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isVerifySupport() {
        return this.mVerifySupport;
    }

    public void startOta() {
        this.startOta(this.mFilePath, this.mIcType);
    }

    public synchronized void startOta(String fileName, int icType) {
        if (!this.mVerifySupport || this.mBleDevice == null) {
            return;
        }
        this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
        this.setFileName(fileName);
        switch (icType) {
            case 1: {
                this.init585();
                break;
            }
            case 3: {
                this.init531();
                break;
            }
            case 2: {
                this.init580();
            }
        }
        this.mStartOta = true;
        this.setOtaMemDev();
    }

    private void setFileName(String fileName) {
        try {
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                this.fileUtils = BleDialogOtaUtils.getByFileName(fileName);
                this.fileUtils.setFileBlockSize(240);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.onError(65533);
        }
    }

    private void initErrorMap() {
        this.errors = new HashMap();
        this.errors.put(3, "Forced exit of SPOTA service. See Table 1");
        this.errors.put(4, "Patch Data CRC mismatch.");
        this.errors.put(5, "Received patch Length not equal to PATCH_LEN characteristic value.");
        this.errors.put(6, "External Memory Error. Writing to external device failed.");
        this.errors.put(7, "Internal Memory Error. Not enough internal memory space for patch.");
        this.errors.put(8, "Invalid memory device.");
        this.errors.put(9, "Application error.");
        this.errors.put(17, "Invalid image bank");
        this.errors.put(18, "Invalid image header");
        this.errors.put(19, "Invalid image size");
        this.errors.put(20, "Invalid product header");
        this.errors.put(21, "Same Image Error");
        this.errors.put(22, "Failed to read from external memory device");
        this.errors.put(65530, ERROR_SEND_IMG_STR);
        this.errors.put(65531, "Low power can't upgrade.");
        this.errors.put(65532, "Work can't upgrade.");
        this.errors.put(65533, "Read fileUtils error.");
        this.errors.put(65535, "Communication error.");
        this.errors.put(65534, "The remote device does not support SUOTA.");
    }

    @SuppressLint(value={"MissingPermission"})
    public void enableOTANotification() {
        if (this.mBluetoothGatt != null && this.otaServStatusChara != null) {
            this.mBluetoothGatt.setCharacteristicNotification(this.otaServStatusChara, true);
            BluetoothGattDescriptor descriptor = this.otaServStatusChara.getDescriptor(DESCR_TWO);
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            boolean writeSuccess = this.mBluetoothGatt.writeDescriptor(descriptor);
            if (!writeSuccess) {
                this.onError(65530);
            }
        }
    }

    public void onCharacteristicReadOK(BluetoothGattCharacteristic characteristic) {
    }

    public void onCharacteristicWriteOK(BluetoothGattCharacteristic characteristic) {
        this.onWriteDataOk(characteristic);
    }

    public void onDescriptorWriteOK(BluetoothGattDescriptor descriptor) {
        UUID uuid = descriptor.getCharacteristic().getUuid();
        if (uuid.equals(UUID_OTA_NOTIFY)) {
            this.mNotify = true;
            this.setOtaMemDev();
        }
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
        UUID uuid = characteristic.getUuid();
        if (uuid.equals(OTA_SERV_STATUS_UUID)) {
            this.onNotifyData(characteristic);
        }
    }

    public final void onNotifyData(BluetoothGattCharacteristic characteristic) {
        int value = characteristic.getIntValue(17, 0);
        int step = -1;
        int error = -1;
        int memDevValue = -1;
        if (value == 16) {
            step = 3;
        } else if (value == 2) {
            step = 5;
        } else if (value == 3 || value == 1) {
            memDevValue = value;
        } else {
            error = value;
        }
        if (step >= 0 || error >= 0 || memDevValue >= 0) {
            Intent intent = new Intent();
            intent.putExtra(OTA_STEP, step);
            intent.putExtra(OTA_ERROR, error);
            intent.putExtra(OTA_MEMDEV_VALUE, memDevValue);
            this.processStep(intent);
        }
    }

    public void onWriteDataOk(BluetoothGattCharacteristic characteristic) {
        if (characteristic.getUuid().equals(OTA_MEM_DEV_UUID)) {
            this.setStep(3);
        } else if (characteristic.getUuid().equals(OTA_GPIO_MAP_UUID)) {
            this.setStep(4);
        } else if (characteristic.getUuid().equals(OTA_PATCH_LEN_UUID)) {
            this.setStep(5);
        } else if (characteristic.getUuid().equals(OTA_PATCH_DATA_UUID) && this.getChunkCounter() != -1 && !this.isHasError()) {
            this.sendBlock();
        }
    }

    private void setStep(int step) {
        Intent intent = new Intent();
        intent.putExtra(OTA_STEP, step);
        this.processStep(intent);
    }

    private void processStep(Intent intent) {
        int newStep = intent.getIntExtra(OTA_STEP, -1);
        int error = intent.getIntExtra(OTA_ERROR, -1);
        int memDevValue = intent.getIntExtra(OTA_MEMDEV_VALUE, -1);
        if (error != -1) {
            this.onError(error);
        } else if (memDevValue >= 0) {
            this.processMemDevValue(memDevValue);
        }
        if (newStep >= 0) {
            this.step = newStep;
        }
        switch (this.step) {
            case 0: {
                this.step = -1;
                break;
            }
            case 1: {
                this.enableOTANotification();
                break;
            }
            case 2: {
                this.setOtaMemDev();
                break;
            }
            case 3: {
                if (++this.gpioMapPrereq != 2) break;
                this.setOtaGpioMap();
                break;
            }
            case 4: {
                this.setPatchLength();
                break;
            }
            case 5: {
                if (!this.lastBlock) {
                    this.sendBlock();
                    break;
                }
                if (!this.preparedForLastBlock) {
                    this.setPatchLength();
                    break;
                }
                if (!this.lastBlockSent) {
                    this.sendBlock();
                    break;
                }
                if (!this.endSignalSent) {
                    this.sendEndSignal();
                    break;
                }
                if (error != -1) break;
                this.onSuccess();
            }
        }
    }

    private void processMemDevValue(int memDevValue) {
        if (this.step == 2) {
            if (memDevValue == 1) {
                this.goToStep(3);
            } else {
                this.onError(0);
            }
        }
    }

    private void goToStep(int step) {
        Intent i = new Intent();
        i.putExtra(OTA_STEP, step);
        this.processStep(i);
    }

    private void init585() {
        MISO_GPIO = 5;
        MOSI_GPIO = 6;
        CS_GPIO = 3;
        SCK_GPIO = 0;
    }

    private void init531() {
        MISO_GPIO = 3;
        MOSI_GPIO = 0;
        CS_GPIO = 1;
        SCK_GPIO = 4;
    }

    private void init580() {
        MISO_GPIO = 5;
        MOSI_GPIO = 6;
        CS_GPIO = 3;
        SCK_GPIO = 0;
    }

    @SuppressLint(value={"MissingPermission"})
    private void setOtaMemDev() {
        if (this.mStartOta && this.mNotify) {
            int memType = 0x13000000 | IMAGE_BANK;
            if (this.otaMemDevChara != null) {
                this.otaMemDevChara.setValue(memType, 20, 0);
                int properties = this.otaMemDevChara.getProperties();
                if ((properties & 4) != 0) {
                    this.otaMemDevChara.setWriteType(1);
                } else {
                    this.otaMemDevChara.setWriteType(2);
                }
                boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.otaMemDevChara);
                if (!writeSuccess) {
                    BleLog.e((String)"setOtaMemDev");
                    this.onError(65530);
                }
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void setOtaGpioMap() {
        int memInfoData = this.getMemParamsSPI();
        if (this.otaGpioMapChara != null) {
            this.otaGpioMapChara.setValue(memInfoData, 20, 0);
            int properties = this.otaGpioMapChara.getProperties();
            if ((properties & 4) != 0) {
                this.otaGpioMapChara.setWriteType(1);
            } else {
                this.otaGpioMapChara.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.otaGpioMapChara);
            if (!writeSuccess) {
                BleLog.e((String)"setOtaGpioMap");
                this.onError(65530);
            }
        }
    }

    private int getMemParamsSPI() {
        return MISO_GPIO << 24 | MOSI_GPIO << 16 | CS_GPIO << 8 | SCK_GPIO;
    }

    @SuppressLint(value={"MissingPermission"})
    private void sendEndSignal() {
        if (this.otaMemDevChara != null) {
            this.otaMemDevChara.setValue(-33554432, 20, 0);
            int properties = this.otaMemDevChara.getProperties();
            if ((properties & 4) != 0) {
                this.otaMemDevChara.setWriteType(1);
            } else {
                this.otaMemDevChara.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.otaMemDevChara);
            if (!writeSuccess) {
                BleLog.e((String)"sendEndSignal");
                this.onError(65530);
            }
            this.endSignalSent = true;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void reboot() {
        this.runOnMainThread(() -> {
            if (this.otaMemDevChara != null) {
                this.otaMemDevChara.setValue(-50331648, 20, 0);
                boolean b = this.mBluetoothGatt.writeCharacteristic(this.otaMemDevChara);
                ++this.mSendRebootSignalErr;
                if (!b && this.mSendRebootSignalErr < 3) {
                    this.reboot();
                }
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void setPatchLength() {
        int blocksize = this.fileUtils.getFileBlockSize();
        if (this.lastBlock) {
            blocksize = this.fileUtils.getNumberOfBytes() % this.fileUtils.getFileBlockSize();
            this.preparedForLastBlock = true;
        }
        if (this.otaPatchLenChara != null) {
            this.otaPatchLenChara.setValue(blocksize, 18, 0);
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.otaPatchLenChara);
            if (!writeSuccess) {
                BleLog.e((String)"setPatchLength");
                this.onError(65530);
            }
        }
    }

    private int getChunkCounter() {
        return this.chunkCounter;
    }

    @SuppressLint(value={"MissingPermission"})
    private synchronized void sendBlock() {
        float progress = (float)(this.blockCounter + 1) / (float)this.fileUtils.getNumberOfBlocks() * 100.0f;
        if (!this.lastBlockSent) {
            byte[][] block = this.fileUtils.getBlock(this.blockCounter);
            int i = ++this.chunkCounter;
            boolean lastChunk = false;
            if (this.chunkCounter == block.length - 1) {
                this.chunkCounter = -1;
                lastChunk = true;
            }
            byte[] chunk = block[i];
            if (this.otaPatchDataChara != null) {
                this.otaPatchDataChara.setValue(chunk);
                int properties = this.otaPatchDataChara.getProperties();
                if ((properties & 4) != 0) {
                    this.otaPatchDataChara.setWriteType(1);
                } else {
                    this.otaPatchDataChara.setWriteType(2);
                }
                boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.otaPatchDataChara);
                if (!writeSuccess) {
                    this.onError(65530);
                }
            }
            if (lastChunk) {
                if (!this.lastBlock) {
                    ++this.blockCounter;
                } else {
                    this.lastBlockSent = true;
                }
                if (this.blockCounter + 1 == this.fileUtils.getNumberOfBlocks()) {
                    this.lastBlock = true;
                }
            }
        }
        this.runOnMainThread(() -> {
            if (this.mOnBleOTAListener != null) {
                this.mOnBleOTAListener.onOtaProgress(progress, 1, 1);
            }
        });
    }

    private void onSuccess() {
        this.runOnMainThread(() -> {
            if (this.mOnBleOTAListener != null) {
                this.mOnBleOTAListener.onOtaSuccess();
            }
        });
        this.reboot();
        if (this.fileUtils != null) {
            this.fileUtils.close();
        }
    }

    private void onError(int errorCode) {
        if (!this.hasError) {
            String error = (String)this.errors.get(errorCode);
            Log.e((String)TAG, (String)("Error: " + errorCode + " " + error));
            this.runOnMainThread(() -> {
                if (this.mOnBleOTAListener != null) {
                    this.mOnBleOTAListener.onOtaFailure(errorCode, error);
                }
            });
            this.hasError = true;
            if (this.fileUtils != null) {
                this.fileUtils.close();
            }
        }
    }

    private boolean isHasError() {
        return this.hasError;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public void setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
        this.mOnBleOTAListener = onBleOTAListener;
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.threadHandler.post(runnable);
        }
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private OnBleOTAListener mOnBleOTAListener;
        private String mFilePath = "";
        private int mIcType = 1;

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public Builder setIcType(int icType) {
            this.mIcType = icType;
            return this;
        }

        public DialogOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new DialogOtaManager(this);
        }
    }
}

