/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.frk;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.elinkthings.bleotalibrary.base.BaseOtaManager;
import com.elinkthings.bleotalibrary.frk.FRBleCallBack;
import com.elinkthings.bleotalibrary.frk.FrBleOTASDK;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.utils.BleLog;

public class FRKOtaManager
extends BaseOtaManager
implements FRBleCallBack {
    private static final int OTA_TIME_OUT = 1;
    private static final int TIME_OUT_TIME = 20000;
    private static final String TAG = "FRKOtaManager";
    private OnBleOTAListener mOnBleOTAListener;
    private String mFilePath;
    private FrBleOTASDK mFrBleOTASDK;
    private Context mContext;
    private boolean mStartOta = false;
    private boolean mOtaStatus = false;
    private boolean mInitOk = false;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    FRKOtaManager.this.mHandler.removeMessages(1);
                    FRKOtaManager.this.otaFailure("FRKOtaManager: ota time out");
                }
            }
        }
    };

    public FRKOtaManager(Builder builder) {
        this.mContext = builder.mContext;
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.mFilePath = builder.mFilePath;
        BleDevice bleDevice = builder.mBleDevice;
        if (bleDevice == null || bleDevice.getBluetoothGatt() == null) {
            this.otaFailure("bleDevice == null || bleDevice.getBluetoothGatt() == null");
            return;
        }
        BluetoothDevice bluetoothDevice = bleDevice.getBluetoothGatt().getDevice();
        if (bluetoothDevice != null) {
            bleDevice.disconnect(false);
            this.mFrBleOTASDK = new FrBleOTASDK(this.mContext, bluetoothDevice, this);
        }
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    @Override
    public void startOta() {
        BleLog.i((String)("\u5f00\u59cbOTA:mInitOk=" + this.mInitOk));
        this.mStartOta = true;
        if (this.mInitOk && this.mFrBleOTASDK != null && !this.mOtaStatus) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FRKOtaManager.this.mHandler.sendEmptyMessageDelayed(1, 20000L);
                    BleLog.iw((String)"\u5f00\u59cbOTA");
                    try {
                        FRKOtaManager.this.mOtaStatus = true;
                        FRKOtaManager.this.mFrBleOTASDK.FrBleOTAUpate(FRKOtaManager.this.mFilePath);
                    }
                    catch (Exception e) {
                        BleLog.e((String)e.toString());
                        e.printStackTrace();
                        FRKOtaManager.this.otaFailure("load file err");
                    }
                }
            }).start();
        }
    }

    @Override
    public void onBleOtaConnect() {
        BleLog.i((String)TAG, (String)"\u8fde\u63a5\u6210\u529f");
    }

    @Override
    public void onBleOtaDisConnect() {
        BleLog.i((String)TAG, (String)"\u8fde\u63a5\u65ad\u5f00");
        this.otaFailure("disconnect");
    }

    private void otaFailure(String msg) {
        this.mOtaStatus = false;
        this.mHandler.removeMessages(1);
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaFailure(6, msg);
        }
        this.clear();
    }

    @Override
    public void onBleOtaReady() {
        BleLog.i((String)TAG, (String)"notify\u6210\u529f");
        this.mInitOk = true;
        if (this.mStartOta && this.mHandler != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FRKOtaManager.this.startOta();
                }
            }, 1000L);
        }
    }

    @Override
    public void onBleOtaFailure(String msg) {
        this.otaFailure(msg);
    }

    @Override
    public void onBleOtaUUIDError() {
        this.otaFailure("error code:UUIDError");
    }

    @Override
    public void onBleOtaStateChange(int state, int percent) {
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        BleLog.i((String)("\u72b6\u6001:" + state + "  ||  \u8fdb\u5ea6:" + percent));
        if (this.mOnBleOTAListener != null) {
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.mOnBleOTAListener.onOtaProgress(percent, 1, 1);
                    break;
                }
                case 2: {
                    this.mOnBleOTAListener.onOtaSuccess();
                    this.clear();
                }
            }
        }
    }

    @Override
    public void clear() {
        this.mHandler.removeMessages(1);
        this.mInitOk = false;
        this.mStartOta = false;
        this.mOtaStatus = false;
        BleLog.i((String)"clear");
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private Context mContext;
        private OnBleOTAListener mOnBleOTAListener;
        private String mFilePath = "";

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public FRKOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new FRKOtaManager(this);
        }
    }
}

