/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.frk;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.elinkthings.bleotalibrary.frk.FRBleCallBack;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;

public class FrBleOTASDK {
    private static final String TAG = "OtaUpate";
    private final int TIME_OUT = 1;
    private final int SEND_DATA_TIME_OUT = 2;
    private final int SEND_DATA_TIME = 1000;
    private final int RESEND_NUMBER_MAX = 100;
    private static final String UUID_SERVICE_DATA_H = "02f00000-0000-0000-0000-00000000fe00";
    private static final String UUID_SEND_DATA_H = "02f00000-0000-0000-0000-00000000ff01";
    private static final String UUID_RECV_DATA_H = "02f00000-0000-0000-0000-00000000ff02";
    private static final String UUID_DES = "00002902-0000-1000-8000-00805f9b34fb";
    private final BluetoothDevice mDevice;
    private Context mContext;
    private BluetoothGatt mBluetoothGatt;
    private final FRBleCallBack mCallback;
    private BluetoothGattDescriptor mDescriptor;
    private BluetoothGattCharacteristic mGattCharacteristic;
    private int connectState = 0;
    private byte[] recvValue = null;
    private int mRecvData;
    private int mtuSize = 235;
    private int mDelayNum;
    private boolean writeStatus = false;
    private int writePrecent;
    private int mResendNumber;
    private static final int OTA_CMD_NVDS_TYPE = 0;
    private static final int OTA_CMD_GET_STR_BASE = 1;
    private static final int OTA_CMD_PAGE_ERASE = 3;
    private static final int OTA_CMD_CHIP_ERASE = 4;
    private static final int OTA_CMD_WRITE_DATA = 5;
    private static final int OTA_CMD_READ_DATA = 6;
    private static final int OTA_CMD_WRITE_MEM = 7;
    private static final int OTA_CMD_READ_MEM = 8;
    private static final int OTA_CMD_REBOOT = 9;
    private static final int OTA_CMD_NULL = 10;
    byte[] context = new byte[256];
    private Handler mHandler = new Handler(Looper.myLooper()){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                FrBleOTASDK.this.mHandler.removeMessages(1);
                FrBleOTASDK.this.mCallback.onBleOtaReady();
            } else if (msg.what == 2) {
                ++FrBleOTASDK.this.mResendNumber;
                if (FrBleOTASDK.this.mResendNumber > 100) {
                    FrBleOTASDK.this.otaFailure("Handler:\u91cd\u53d1\u5df2\u8fbe\u6700\u5927\u503c:100");
                    return;
                }
                FrBleOTASDK.this.mHandler.removeMessages(2);
                BleLog.iw((String)("\u8d85\u65f6\u91cd\u53d1\u6570\u636e:" + FrBleOTASDK.this.mResendNumber));
                FrBleOTASDK.this.sendCmd(FrBleOTASDK.this.mOldSendData);
                FrBleOTASDK.this.mHandler.sendEmptyMessageDelayed(2, 1000L);
            }
        }
    };
    BluetoothGattCallback mBluetoothGattCallback = new BluetoothGattCallback(){

        @SuppressLint(value={"MissingPermission"})
        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            block6: {
                if (status == 0) {
                    FrBleOTASDK.this.mResendNumber = 0;
                    FrBleOTASDK.this.mBluetoothGatt = gatt;
                    UUID UUID_SERVICE_H = UUID.fromString(FrBleOTASDK.UUID_SERVICE_DATA_H);
                    UUID UUID_SEND_H = UUID.fromString(FrBleOTASDK.UUID_SEND_DATA_H);
                    UUID UUID_RECV_H = UUID.fromString(FrBleOTASDK.UUID_RECV_DATA_H);
                    try {
                        BluetoothGattCharacteristic gattCharacteristic = gatt.getService(UUID_SERVICE_H).getCharacteristic(UUID_SEND_H);
                        String uuidString = gattCharacteristic.getUuid().toString();
                        if (uuidString.equals(FrBleOTASDK.UUID_SEND_DATA_H)) {
                            FrBleOTASDK.this.mGattCharacteristic = gattCharacteristic;
                        }
                        if (!(uuidString = (gattCharacteristic = gatt.getService(UUID_SERVICE_H).getCharacteristic(UUID_RECV_H)).getUuid().toString()).equals(FrBleOTASDK.UUID_RECV_DATA_H)) break block6;
                        FrBleOTASDK.this.mDescriptor = gattCharacteristic.getDescriptor(UUID.fromString(FrBleOTASDK.UUID_DES));
                        if (FrBleOTASDK.this.mDescriptor != null) {
                            FrBleOTASDK.this.mBluetoothGatt.setCharacteristicNotification(gattCharacteristic, true);
                            FrBleOTASDK.this.mDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                            FrBleOTASDK.this.mBluetoothGatt.writeDescriptor(FrBleOTASDK.this.mDescriptor);
                        }
                    }
                    catch (Exception var8) {
                        FrBleOTASDK.this.mCallback.onBleOtaUUIDError();
                    }
                } else {
                    FrBleOTASDK.this.mCallback.onBleOtaUUIDError();
                }
            }
        }

        @SuppressLint(value={"MissingPermission"})
        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            String uuid;
            if (status == 0 && (uuid = descriptor.getUuid().toString()).equalsIgnoreCase(FrBleOTASDK.UUID_DES)) {
                FrBleOTASDK.this.mBluetoothGatt.requestMtu(512);
                FrBleOTASDK.this.mHandler.removeMessages(1);
                FrBleOTASDK.this.mHandler.sendEmptyMessageDelayed(1, 1000L);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (FrBleOTASDK.this.mHandler.hasMessages(2)) {
                FrBleOTASDK.this.mHandler.removeMessages(2);
            }
            FrBleOTASDK.this.recvValue = characteristic.getValue();
            FrBleOTASDK.this.setRecvData(1);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                FrBleOTASDK.this.writeStatus = true;
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            FrBleOTASDK.this.mHandler.removeMessages(1);
            if (0 == status) {
                FrBleOTASDK.this.mtuSize = mtu;
                BleLog.i((String)("BleServiceonMtuChanged success MTU = " + mtu));
            } else {
                FrBleOTASDK.this.mtuSize = 235;
                BleLog.i((String)"onMtuChanged fail ");
            }
            FrBleOTASDK.this.mCallback.onBleOtaReady();
        }

        @SuppressLint(value={"MissingPermission"})
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            BleLog.i((String)("status=" + status + "  newState=" + newState));
            if (newState == 2) {
                FrBleOTASDK.this.mBluetoothGatt.discoverServices();
                FrBleOTASDK.this.mCallback.onBleOtaConnect();
                FrBleOTASDK.this.connectState = 1;
            } else if (newState == 0) {
                FrBleOTASDK.this.mHandler.removeMessages(1);
                if (FrBleOTASDK.this.mBluetoothGatt != null) {
                    FrBleOTASDK.this.mBluetoothGatt.close();
                }
                FrBleOTASDK.this.connectState = 0;
                FrBleOTASDK.this.mCallback.onBleOtaDisConnect();
            }
        }
    };
    private final int[] crc_ta_8 = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    private volatile byte[] mOldSendData;

    @SuppressLint(value={"MissingPermission"})
    public FrBleOTASDK(Context context, BluetoothDevice device, FRBleCallBack callBack) {
        this.mContext = context;
        this.mCallback = callBack;
        this.mDevice = device;
        this.mBluetoothGatt = device.connectGatt(this.mContext, false, this.mBluetoothGattCallback);
    }

    @SuppressLint(value={"MissingPermission"})
    public void FrBleOTAUpate(String filePath) throws FileNotFoundException {
        if (filePath != null) {
            int lastReadCount = 0;
            int send_data_count = 0;
            int fileCRC = 0;
            File file = new File(filePath);
            FileInputStream isfile = new FileInputStream(file);
            long leng = file.length();
            BufferedInputStream input = new BufferedInputStream(isfile);
            try {
                fileCRC = this.getCRC32new(filePath);
                BleLog.i((String)("getCRC32new=" + fileCRC));
            }
            catch (Exception var17) {
                var17.printStackTrace();
                this.otaFailure("CRC32 err:" + var17.toString());
                return;
            }
            this.setRecvData(0);
            int packageSize = this.mtuSize - 3 - 9;
            byte[] inputBuffer = new byte[packageSize];
            this.sendData(1, 0, null, 0);
            while (this.getRecvData() != 1) {
                if (this.checkDisconnect()) {
                    BleLog.e((String)"\u8fde\u63a5\u65ad\u5f00");
                    this.otaFailure("disconnect");
                    return;
                }
                SystemClock.sleep((long)10L);
            }
            int addr = this.bytetoint(this.recvValue);
            this.setRecvData(0);
            this.page_erase(addr, leng);
            try {
                while (true) {
                    int read_count;
                    if ((read_count = input.read(inputBuffer, 0, packageSize)) == -1) {
                        while (this.bytetoint(this.recvValue) != addr - lastReadCount) {
                            if (!this.checkDisconnect()) continue;
                            BleLog.e((String)"\u8fde\u63a5\u65ad\u5f00");
                            this.otaFailure("disconnect");
                            return;
                        }
                        this.send_data_long(9, fileCRC, null, leng);
                        this.mCallback.onBleOtaStateChange(2, 0);
                    }
                    this.sendData(5, addr, inputBuffer, read_count);
                    this.mDelayNum = 0;
                    while (!this.writeStatus) {
                        ++this.mDelayNum;
                        if (this.mDelayNum % 8000 != 0) continue;
                        this.sendData(5, addr, inputBuffer, read_count);
                    }
                    this.writeStatus = false;
                    addr += read_count;
                    lastReadCount = read_count;
                    if (this.writePrecent != (int)((float)(send_data_count += read_count) / (float)leng * 100.0f)) {
                        this.writePrecent = (int)((float)send_data_count / (float)leng * 100.0f);
                        this.mCallback.onBleOtaStateChange(1, this.writePrecent);
                    }
                    while (this.getRecvData() != 1) {
                        if (this.checkDisconnect()) {
                            BleLog.e((String)"\u8fde\u63a5\u65ad\u5f00");
                            this.otaFailure("disconnect");
                            return;
                        }
                        SystemClock.sleep((long)10L);
                    }
                    this.setRecvData(0);
                }
            }
            catch (IOException var18) {
                var18.printStackTrace();
                BleLog.e((String)("OTA\u5f02\u5e38:" + var18.toString()));
            }
        } else {
            this.otaFailure("file==null");
        }
    }

    private void otaFailure(String msg) {
        this.mHandler.removeMessages(2);
        if (this.mCallback != null) {
            this.mCallback.onBleOtaFailure(msg);
        }
    }

    private void setRecvData(int recv_data) {
        this.mRecvData = recv_data;
    }

    private int getRecvData() {
        return this.mRecvData;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean checkDisconnect() {
        return this.connectState == 0;
    }

    private int page_erase(int addr, long length) {
        this.mCallback.onBleOtaStateChange(0, 0);
        long count = length / 4096L;
        if (length % 4096L != 0L) {
            ++count;
        }
        int i = 0;
        while ((long)i < count) {
            this.sendData(3, addr, null, 0);
            this.mDelayNum = 0;
            while (!this.writeStatus) {
                ++this.mDelayNum;
                if (this.mDelayNum % 8000 != 0) continue;
                this.sendData(3, addr, null, 0);
            }
            while (this.getRecvData() != 1) {
                SystemClock.sleep((long)10L);
            }
            this.setRecvData(0);
            addr += 4096;
            ++i;
        }
        this.mCallback.onBleOtaStateChange(0, 100);
        return 0;
    }

    private byte[] cmd_write_op(int opcode, int length, int addr, int datalenth) {
        byte[] cmd = opcode == 3 ? new byte[7] : new byte[9];
        cmd[0] = (byte)(opcode & 0xFF);
        cmd[1] = (byte)(length & 0xFF);
        cmd[2] = (byte)((length & 0xFF) >> 8);
        cmd[3] = (byte)(addr & 0xFF);
        cmd[4] = (byte)((addr & 0xFF00) >> 8);
        cmd[5] = (byte)((addr & 0xFF0000) >> 16);
        cmd[6] = (byte)((addr & 0xFF000000) >> 24);
        if (opcode != 3) {
            cmd[7] = (byte)(datalenth & 0xFF);
            cmd[8] = (byte)((datalenth & 0xFF00) >> 8);
        }
        return cmd;
    }

    public byte[] cmd_operation(int type, int lenth, int addr) {
        byte[] cmd = null;
        if (type == 7 || type == 5) {
            cmd = this.cmd_write_op(type, 9, addr, lenth);
        } else if (type == 1 || type == 0) {
            cmd = this.cmd_write_op(type, 3, 0, 0);
        } else if (type == 3) {
            cmd = this.cmd_write_op(type, 7, addr, 0);
        }
        return cmd;
    }

    private static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean send_data_long(int type, int addr, byte[] buffer, long length) {
        byte[] cmd = new byte[11];
        byte[] result_cmd = null;
        if (type == 9) {
            cmd[0] = (byte)(type & 0xFF);
            cmd[1] = 10;
            cmd[2] = 0;
            cmd[3] = (byte)(length & 0xFFL);
            cmd[4] = (byte)((length & 0xFF00L) >> 8);
            cmd[5] = (byte)((length & 0xFF0000L) >> 16);
            cmd[6] = (byte)((length & 0xFFFFFFFFFF000000L) >> 24);
            cmd[7] = (byte)(addr & 0xFF);
            cmd[8] = (byte)((addr & 0xFF00) >> 8);
            cmd[9] = (byte)((addr & 0xFF0000) >> 16);
            cmd[10] = (byte)((addr & 0xFF000000) >> 24);
            result_cmd = cmd;
        }
        this.mGattCharacteristic.setWriteType(1);
        this.mGattCharacteristic.setValue(result_cmd);
        return this.mBluetoothGatt.writeCharacteristic(this.mGattCharacteristic);
    }

    private boolean sendData(int type, int addr, byte[] buffer, int length) {
        this.mHandler.removeMessages(2);
        while (!this.send_data(type, addr, buffer, length)) {
            ++this.mResendNumber;
            if (this.mResendNumber > 100) {
                this.otaFailure("sendData:\u91cd\u53d1\u5df2\u8fbe\u6700\u5927\u503c:100");
                break;
            }
            BleLog.i((String)("OTA\u53d1\u9001\u6570\u636e\u5931\u8d25,\u91cd\u53d1:" + this.mResendNumber));
            SystemClock.sleep((long)50L);
        }
        this.mHandler.sendEmptyMessageDelayed(2, 1000L);
        return true;
    }

    private boolean send_data(int type, int addr, byte[] buffer, int length) {
        byte[] cmd_write = null;
        byte[] resultCmd = null;
        byte[] cmd = new byte[1];
        cmd_write = this.cmd_operation(type, length, addr);
        if (type == 1 || type == 3 || type == 0) {
            resultCmd = cmd_write;
        } else if (type == 9) {
            cmd[0] = (byte)(type & 0xFF);
            resultCmd = cmd;
        } else {
            resultCmd = FrBleOTASDK.byteMerger(cmd_write, buffer);
        }
        this.mOldSendData = resultCmd;
        return this.sendCmd(resultCmd);
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean sendCmd(byte[] value) {
        this.mGattCharacteristic.setWriteType(1);
        this.mGattCharacteristic.setValue(value);
        return this.mBluetoothGatt.writeCharacteristic(this.mGattCharacteristic);
    }

    public int bytetoint(byte[] data) {
        int addr = data[4] & 0xFF;
        addr |= (data[5] & 0xFF) << 8;
        addr |= (data[6] & 0xFF) << 16;
        return addr |= (data[7] & 0xFF) << 24;
    }

    public int bytetochar(byte[] data) {
        int value = data[4] & 0xFF;
        return value;
    }

    private int Crc32CalByByte(int oldcrc, byte[] ptr, int offset, int len) {
        int crc = oldcrc;
        int i = offset;
        while (len-- != 0) {
            int high = crc / 256;
            crc <<= 8;
            crc ^= this.crc_ta_8[(high ^ ptr[i]) & 0xFF];
            crc &= 0xFFFFFFFF;
            ++i;
        }
        return crc & 0xFFFFFFFF;
    }

    public int getCRC32new(String fp) throws IOException {
        File file = new File(fp);
        FileInputStream isfile = null;
        try {
            isfile = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int read_count = 0;
        BufferedInputStream input = new BufferedInputStream(isfile);
        byte[] inputBuffer = new byte[256];
        int crcInit = 0;
        int couts = 0;
        while ((read_count = input.read(inputBuffer, 0, 256)) != -1) {
            if (couts != 0) {
                crcInit = this.Crc32CalByByte(crcInit, inputBuffer, 0, read_count);
            }
            ++couts;
        }
        return crcInit;
    }
}

