/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.jl;

import android.content.Context;
import com.elinkthings.bleotalibrary.jl.FileBean;
import com.elinkthings.bleotalibrary.jl.JLBgWatchManager;
import com.elinkthings.bleotalibrary.jl.JLOtaManager;
import com.elinkthings.bleotalibrary.jl.JLWatchManager;
import com.elinkthings.bleotalibrary.listener.OnBleFlashListener;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.jieli.jl_fatfs.model.FatFile;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchOpCallback;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.util.ArrayList;

public class JLManager {
    public static final int TYPE_OTA = 1;
    public static final int TYPE_WATCH = 2;
    public static final int TYPE_WATCH_CUSTOMIZE = 3;
    public static final String CUSTOMIZE_OTA_NAME = "watch_ota.ufw";
    private JLOtaManager mJLOtaManager;
    private JLWatchManager mJLWatchManager;
    private JLBgWatchManager mJLBgWatchManager;
    private int mType;

    public JLManager(Builder builder) {
        this.mType = builder.mType;
        if (1 == builder.mType) {
            this.mJLOtaManager = JLOtaManager.newBuilder(builder.mContext).setFilePath(builder.mFilePath).setMtu(builder.mMtu).setOnBleOTAListener(builder.mOnBleOTAListener).build(builder.mBleDevice);
        } else if (3 == builder.mType) {
            this.mJLBgWatchManager = JLBgWatchManager.newBuilder(builder.mContext).setFilePath(builder.mFilePath).setMtu(builder.mMtu).setOnBleFlashListener(builder.mOnBleFlashListener).build(builder.mBleDevice);
        } else {
            this.mJLWatchManager = JLWatchManager.newBuilder(builder.mContext).setFilePath(builder.mFilePath).setMtu(builder.mMtu).setOnBleFlashListener(builder.mOnBleFlashListener).build(builder.mBleDevice);
        }
    }

    public int getType() {
        return this.mType;
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public void startOta() {
        if (this.mJLOtaManager != null) {
            this.mJLOtaManager.startOta();
        }
    }

    public void setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
        if (this.mJLOtaManager != null) {
            this.mJLOtaManager.setOnBleOTAListener(onBleOTAListener);
        }
    }

    public void onBtDeviceConnection(BleDevice bleDevice) {
        if (this.mJLOtaManager != null) {
            BleLog.i((String)"OTA\u56de\u8fde");
            this.mJLOtaManager.onBtDeviceConnection(bleDevice);
        }
    }

    public boolean startFlash() {
        if (this.mJLWatchManager != null) {
            return this.mJLWatchManager.startFlash();
        }
        return false;
    }

    public boolean startCustomizeWatch(String path) {
        if (this.mJLBgWatchManager != null) {
            return this.mJLBgWatchManager.startCustomizeWatch(path);
        }
        return false;
    }

    public boolean getWatchList(OnWatchFileListener<ArrayList<FileBean>> listener) {
        if (this.mJLWatchManager != null) {
            return this.mJLWatchManager.getWatchList(listener);
        }
        return false;
    }

    public boolean setCurrentWatch(String path, final OnWatchFileListener<FileBean> listener) {
        if (this.mJLWatchManager != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return this.mJLWatchManager.setCurrentWatch(path, new OnWatchOpCallback<FatFile>(){

                public void onSuccess(FatFile fatFile) {
                    if (listener != null) {
                        if (fatFile != null) {
                            listener.onSuccess(new FileBean(fatFile));
                        } else {
                            listener.onSuccess(null);
                        }
                    }
                }

                public void onFailed(BaseError baseError) {
                    if (listener != null) {
                        listener.onFailed(baseError.getCode(), baseError.getMessage());
                    }
                }
            });
        }
        return false;
    }

    public boolean deleteWatchFile(String path, OnWatchFileListener<Boolean> listener) {
        if (this.mJLWatchManager != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return this.mJLWatchManager.deleteWatch(path, listener);
        }
        return false;
    }

    public void release() {
        if (this.mJLOtaManager != null) {
            this.mJLOtaManager.release();
            this.mJLOtaManager = null;
        }
        if (this.mJLWatchManager != null) {
            this.mJLWatchManager.release();
            this.mJLWatchManager = null;
        }
        if (this.mJLBgWatchManager != null) {
            this.mJLBgWatchManager.release();
            this.mJLBgWatchManager = null;
        }
    }

    public void setOnDeviceScreenListener(JLBgWatchManager.OnDeviceScreenListener onDeviceScreenListener) {
        if (this.mJLBgWatchManager != null) {
            this.mJLBgWatchManager.setOnDeviceScreenListener(onDeviceScreenListener);
        }
    }

    public static interface OnWatchFileListener<T> {
        public void onSuccess(T var1);

        public void onFailed(int var1, String var2);
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private Context mContext;
        private OnBleOTAListener mOnBleOTAListener;
        private OnBleFlashListener mOnBleFlashListener;
        private String mFilePath = "";
        private int mType;
        private int mMtu = 0;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setOnBleFlashListener(OnBleFlashListener onBleFlashListener) {
            this.mOnBleFlashListener = onBleFlashListener;
            return this;
        }

        public JLManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new JLManager(this);
        }
    }
}

