/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.jl;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.jieli.jl_bt_ota.constant.BluetoothConstant;
import com.jieli.jl_bt_ota.impl.BluetoothOTAManager;
import com.jieli.jl_bt_ota.interfaces.BtEventCallback;
import com.jieli.jl_bt_ota.interfaces.IActionCallback;
import com.jieli.jl_bt_ota.interfaces.IBluetoothCallback;
import com.jieli.jl_bt_ota.interfaces.IUpgradeCallback;
import com.jieli.jl_bt_ota.model.BluetoothOTAConfigure;
import com.jieli.jl_bt_ota.model.base.BaseError;
import com.jieli.jl_bt_ota.model.response.TargetInfoResponse;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.device.SendDataBean;
import com.pingwang.bluetoothlib.listener.OnBleMtuListener;
import com.pingwang.bluetoothlib.listener.OnBleSendResultListener;
import com.pingwang.bluetoothlib.listener.OnCharacteristicListener;
import com.pingwang.bluetoothlib.utils.BleLog;
import com.pingwang.bluetoothlib.utils.BleStrUtils;
import com.pingwang.bluetoothlib.utils.MyBleDeviceUtils;
import java.util.UUID;

class JLOtaManager
extends BluetoothOTAManager
implements OnBleMtuListener,
IUpgradeCallback,
OnCharacteristicListener,
BleDevice.onDisConnectedListener,
OnBleSendResultListener {
    public static final String WATCH_OTA_NAME = "watch_ota.ufw";
    private static final int SEND_INTERVAL = 40;
    private volatile BluetoothGatt mBluetoothGatt;
    private volatile BleDevice mBleDevice;
    private int mMtu = 0;
    private OnBleOTAListener mOnBleOTAListener;
    private boolean mInitOk = false;
    private String mFilePath;
    private boolean mStartOta = false;
    private boolean mNotify = false;
    private boolean mConnectStatus = false;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                JLOtaManager.this.mHandler.removeMessages(1);
                BleLog.i((String)"onDescriptorWrite\u8d85\u65f6");
                if (null != JLOtaManager.this.mBleDevice) {
                    JLOtaManager.this.mNotify = true;
                    JLOtaManager.this.onBtDeviceConnection(JLOtaManager.this.mBleDevice);
                }
            }
        }
    };
    private BtEventCallback mBtEventCallback = new BtEventCallback(){

        public void onConnection(BluetoothDevice bluetoothDevice, int status) {
            if (status == 1) {
                if (JLOtaManager.this.isOTA()) {
                    BleLog.i((String)("\u8fde\u63a5\u6210\u529f,\u5df2\u7ecf\u5728OTA\u72b6\u6001\u4e86,\u4ec0\u4e48\u90fd\u4e0d\u5904\u7406" + JLOtaManager.this.isOTA()));
                } else {
                    JLOtaManager.this.mInitOk = true;
                    BleLog.i((String)("\u8fde\u63a5\u6210\u529f,\u53ef\u4ee5\u8fdb\u884cOTA\u5347\u7ea7:" + JLOtaManager.this.isOTA()));
                    if (JLOtaManager.this.mStartOta) {
                        JLOtaManager.this.startOta();
                    }
                }
            } else {
                if (!JLOtaManager.this.mConnectStatus) {
                    BleLog.i((String)("\u4e0d\u5728\u8fde\u63a5\u72b6\u6001\u7684\u5931\u8d25" + status));
                    return;
                }
                BleLog.i((String)("\u8fde\u63a5\u5931\u8d25:" + status));
                if (JLOtaManager.this.mOnBleOTAListener != null && JLOtaManager.this.mBleDevice != null) {
                    JLOtaManager.this.mOnBleOTAListener.onOtaFailure(6, "error code:" + status);
                }
                JLOtaManager.this.clear();
            }
        }
    };

    public JLOtaManager(Builder builder) {
        super(builder.mContext);
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.mFilePath = builder.mFilePath;
        this.mBleDevice = builder.mBleDevice;
        this.mMtu = builder.mMtu;
        this.onBtDeviceConnection(this.mBleDevice);
    }

    public void onBtDeviceConnection(BleDevice bleDevice) {
        try {
            BleLog.i((String)"onBtDeviceConnection");
            if (bleDevice == null) {
                BleLog.i((String)"bleDevice=null");
                if (this.mOnBleOTAListener != null) {
                    this.mOnBleOTAListener.onOtaFailure(6, "bleDevice=null");
                }
                return;
            }
            this.mConnectStatus = true;
            this.registerBluetoothCallback((IBluetoothCallback)this.mBtEventCallback);
            this.mBleDevice = bleDevice;
            this.mBleDevice.setOnDisConnectedListener((BleDevice.onDisConnectedListener)this);
            this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
            this.mBleDevice.setOnBleSendResultListener((OnBleSendResultListener)this);
            this.mBleDevice.setOnBleMtuListener((OnBleMtuListener)this);
            this.mBluetoothGatt = bleDevice.getBluetoothGatt();
            if (this.mMtu == 0) {
                this.mBleDevice.setMtu(517);
            }
            if (this.mBluetoothGatt == null) {
                BleLog.i((String)"bluetoothGatt=null");
                return;
            }
            if (!this.mNotify) {
                bleDevice.setNotify(BluetoothConstant.UUID_SERVICE, new UUID[]{BluetoothConstant.UUID_NOTIFICATION});
                return;
            }
            this.mInitOk = this.isOTA();
            if (this.mInitOk) {
                if (null != this.getConnectedDevice()) {
                    this.onBtDeviceConnection(this.getConnectedDevice(), 1);
                }
                return;
            }
            this.initBleDeviceInfo();
            BleLog.i((String)"\u901a\u77e5JL SDK\u8fde\u63a5\u6210\u529f");
            if (null != this.getConnectedDevice()) {
                this.onBtDeviceConnection(this.getConnectedDevice(), 1);
            } else {
                BleLog.i((String)"getConnectedDevice()=null");
                if (this.mOnBleOTAListener != null) {
                    this.mOnBleOTAListener.onOtaFailure(6, "BluetoothDevice=null;bluetoothGatt=" + this.mBluetoothGatt);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initBleDeviceInfo() {
        BluetoothOTAConfigure bluetoothOTAConfigure = BluetoothOTAConfigure.createDefault();
        bluetoothOTAConfigure.setPriority(0);
        bluetoothOTAConfigure.setBleIntervalMs(500);
        bluetoothOTAConfigure.setTimeoutMs(10000);
        bluetoothOTAConfigure.setUseAuthDevice(true);
        bluetoothOTAConfigure.setMtu(this.mMtu + 3);
        bluetoothOTAConfigure.setNeedChangeMtu(true);
        bluetoothOTAConfigure.setUseJLServer(true);
        bluetoothOTAConfigure.setFirmwareFilePath(this.mFilePath);
        bluetoothOTAConfigure.setUseReconnect(false);
        this.configure(bluetoothOTAConfigure);
        BleLog.i((String)"\u914d\u7f6eOTA\u53c2\u6570");
        if (this.getConnectedBluetoothGatt() != null) {
            this.onMtuChanged(this.getConnectedBluetoothGatt(), this.mMtu + 3, 0);
            BleLog.i((String)"\u914d\u7f6eSDK MTU");
        }
    }

    private void queryMandatoryUpdate() {
        this.queryMandatoryUpdate((IActionCallback)new IActionCallback<TargetInfoResponse>(){

            public void onSuccess(TargetInfoResponse targetInfoResponse) {
                int versionCode = targetInfoResponse.getVersionCode();
                String versionName = targetInfoResponse.getVersionName();
                String projectCode = targetInfoResponse.getProjectCode();
                BleLog.i((String)("queryMandatoryUpdate:\u8bbe\u5907\u7248\u672c\u53f7:" + versionCode + " \u8bbe\u5907\u7248\u672c\u540d\u79f0:" + versionName + "  \u8bbe\u5907\u4ea7\u54c1ID:" + projectCode + " isOTA()" + JLOtaManager.this.isOTA()));
                if (!JLOtaManager.this.isOTA()) {
                    JLOtaManager.this.startOta();
                }
            }

            public void onError(BaseError baseError) {
                BleLog.i((String)"queryMandatoryUpdate:\u53ef\u4ee5\u4e0d\u7528\u5904\u7406");
            }
        });
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
        if (characteristic.getUuid().toString().equalsIgnoreCase(BluetoothConstant.UUID_NOTIFICATION.toString())) {
            byte[] data = characteristic.getValue();
            BluetoothDevice connectedDevice = this.getConnectedDevice();
            if (connectedDevice != null) {
                this.onReceiveDeviceData(connectedDevice, data);
            } else {
                BleLog.i((String)"getConnectedDevice()==null");
            }
        }
    }

    public void startOta() {
        try {
            if (this.mBleDevice != null && Build.VERSION.SDK_INT >= 21) {
                this.mBleDevice.setConnectPriority(1);
            }
            this.mStartOta = true;
            if (this.mInitOk) {
                this.startOTA(this);
            }
        }
        catch (Exception e) {
            BleLog.e((String)e.toString());
            e.printStackTrace();
        }
    }

    public BluetoothDevice getConnectedDevice() {
        return this.getConnectedBluetoothGatt() != null ? this.mBluetoothGatt.getDevice() : null;
    }

    public BluetoothGatt getConnectedBluetoothGatt() {
        return this.mBluetoothGatt;
    }

    public void connectBluetoothDevice(BluetoothDevice bluetoothDevice) {
        this.mHandler.removeMessages(1);
        BleLog.i((String)("connectBluetoothDevice:" + bluetoothDevice.getAddress()));
        this.mNotify = false;
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onReconnect(bluetoothDevice.getAddress());
        }
    }

    public void disconnectBluetoothDevice(BluetoothDevice bluetoothDevice) {
        BleLog.i((String)("disconnectBluetoothDevice:" + bluetoothDevice.getAddress()));
        this.mNotify = false;
        this.clear();
    }

    public boolean sendDataToDevice(BluetoothDevice bluetoothDevice, byte[] bytes) {
        if (bluetoothDevice == null || bytes == null) {
            return false;
        }
        return this.toSendData(bytes);
    }

    private synchronized boolean toSendData(byte[] bytes) {
        int mtu = this.mMtu;
        int dataLen = bytes.length;
        int blockCount = dataLen / mtu;
        boolean status = true;
        for (int i = 0; i < blockCount; ++i) {
            byte[] mBlockData = new byte[mtu];
            System.arraycopy(bytes, i * mtu, mBlockData, 0, mBlockData.length);
            SendDataBean sendDataBean = new SendDataBean(mBlockData, BluetoothConstant.UUID_WRITE, 2, BluetoothConstant.UUID_SERVICE);
            status = this.sendDataOta(sendDataBean);
        }
        if (0 != dataLen % mtu) {
            byte[] noBlockData = new byte[dataLen % mtu];
            System.arraycopy(bytes, dataLen - dataLen % mtu, noBlockData, 0, noBlockData.length);
            SendDataBean sendDataBean = new SendDataBean(noBlockData, BluetoothConstant.UUID_WRITE, 2, BluetoothConstant.UUID_SERVICE);
            status = this.sendDataOta(sendDataBean);
        }
        return status;
    }

    private boolean sendDataOta(SendDataBean sendDataBean) {
        int time = 40;
        SystemClock.sleep((long)time);
        if (this.mBleDevice == null) {
            return false;
        }
        boolean status = this.mBleDevice.sendDataOta(sendDataBean);
        String sendData = BleStrUtils.byte2HexStrToUpperCase((byte[])sendDataBean.getHex());
        if (!status) {
            SystemClock.sleep((long)(time -= 5));
            if (this.mBleDevice == null) {
                return false;
            }
            BleLog.i((String)("\u53d1\u9001\u6570\u636e\u5931\u8d25,\u91cd\u53d1:" + sendData));
            status = this.mBleDevice.sendDataOta(sendDataBean);
            if (!status) {
                BleLog.i((String)("\u53d1\u9001\u6570\u636e\u5931\u8d25,\u505c\u6b62\u91cd\u53d1:" + sendData));
                return false;
            }
        }
        return true;
    }

    public void release() {
        try {
            this.unregisterBluetoothCallback((IBluetoothCallback)this.mBtEventCallback);
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.mBleDevice != null && Build.VERSION.SDK_INT >= 21) {
                this.mBleDevice.setConnectPriority(0);
            }
            this.clear();
            super.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDisConnected() {
        BluetoothGatt bluetoothGatt;
        BleLog.i((String)"onDisConnected");
        this.mConnectStatus = false;
        if (this.mBleDevice != null && null != (bluetoothGatt = this.mBleDevice.getBluetoothGatt())) {
            MyBleDeviceUtils.refreshDeviceCache((BluetoothGatt)bluetoothGatt);
            if (null != bluetoothGatt.getDevice()) {
                this.onBtDeviceConnection(bluetoothGatt.getDevice(), 2);
            }
        }
        this.clear();
        this.mNotify = false;
    }

    public void onDescriptorWriteOK(BluetoothGattDescriptor descriptor) {
        if (descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(BluetoothConstant.UUID_NOTIFICATION.toString())) {
            BleLog.i((String)"onDescriptorWriteOK");
            this.mNotify = true;
            this.onBtDeviceConnection(this.mBleDevice);
            this.mHandler.removeMessages(1);
        }
    }

    public void onNotifyResult(UUID uuid, boolean result) {
        if (uuid.toString().equalsIgnoreCase(BluetoothConstant.UUID_NOTIFICATION.toString())) {
            BleLog.i((String)("onNotifyResult:" + result));
            if (result) {
                this.mHandler.removeMessages(1);
                this.mHandler.sendEmptyMessageDelayed(1, 5000L);
            } else if (this.mOnBleOTAListener != null && this.mBleDevice != null) {
                this.mOnBleOTAListener.onOtaFailure(6, "Notify:" + result);
            }
        }
    }

    public void OnMtu(int mtu) {
        if (this.getConnectedBluetoothGatt() != null) {
            this.onMtuChanged(this.getConnectedBluetoothGatt(), mtu, 0);
        }
        this.mMtu = mtu - 3;
        BleLog.i((String)("MTU:" + mtu));
    }

    public void onStartOTA() {
        BleLog.i((String)"onStartOTA");
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaProgress(-1.0f, 0, 0);
        }
    }

    public void onNeedReconnect(String addr, boolean isNewReconnectWay) {
        this.mConnectStatus = false;
        this.clear();
        BleLog.i((String)("onNeedReconnect:" + addr + " status:" + isNewReconnectWay));
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onReconnect(addr);
        }
    }

    public void onProgress(int type, float progress) {
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaProgress(progress, type + 1, 2);
        }
    }

    public void onStopOTA() {
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaSuccess();
        }
        this.release();
    }

    public void onCancelOTA() {
        this.mHandler.removeMessages(1);
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaFailure(7, "cancel");
        }
    }

    public void onError(BaseError error) {
        this.mHandler.removeMessages(1);
        int code = error.getCode();
        BleLog.i((String)("onError:" + code + " msg:" + error.getMessage()));
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaFailure(6, error.getMessage());
        }
    }

    public void setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
        this.mOnBleOTAListener = onBleOTAListener;
    }

    public void clear() {
        this.mConnectStatus = false;
        this.mHandler.removeMessages(1);
        this.mBluetoothGatt = null;
        this.mBleDevice = null;
        BleLog.i((String)"clear");
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private Context mContext;
        private OnBleOTAListener mOnBleOTAListener;
        private String mFilePath = "";
        private int mMtu;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public JLOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new JLOtaManager(this);
        }
    }
}

