/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.jl;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.elinkthings.bleotalibrary.jl.FileBean;
import com.elinkthings.bleotalibrary.jl.JLManager;
import com.elinkthings.bleotalibrary.listener.OnBleFlashListener;
import com.jieli.jl_bt_ota.constant.BluetoothConstant;
import com.jieli.jl_fatfs.interfaces.OnFatFileProgressListener;
import com.jieli.jl_fatfs.model.FatFile;
import com.jieli.jl_rcsp.impl.RcspAuth;
import com.jieli.jl_rcsp.impl.WatchOpImpl;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchCallback;
import com.jieli.jl_rcsp.interfaces.watch.OnWatchOpCallback;
import com.jieli.jl_rcsp.model.base.BaseError;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.device.SendDataBean;
import com.pingwang.bluetoothlib.listener.OnBleMtuListener;
import com.pingwang.bluetoothlib.listener.OnCharacteristicListener;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;

class JLWatchManager
extends WatchOpImpl
implements BleDevice.onDisConnectedListener,
OnFatFileProgressListener,
OnBleMtuListener,
OnCharacteristicListener,
RcspAuth.IRcspAuthOp,
RcspAuth.OnRcspAuthListener {
    public static final String WATCH_NAME = "watch009";
    private static final int WATCH_FILE_SIZE = 100;
    private BleDevice mBleDevice;
    private int mMtu = 0;
    private OnBleFlashListener mOnBleFlashListener;
    private boolean mInitOk = false;
    private String mFilePath;
    private boolean mNotify = false;
    private RcspAuth mRcspAuth;
    private boolean mStartStatus = false;
    private volatile String mDeleteWatchPath = "";
    private volatile String mNewWatchPath = "";
    private static Builder mBuilder;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                JLWatchManager.this.mHandler.removeMessages(1);
                BleLog.i((String)"\u6570\u636e\u8d85\u65f6");
                if (JLWatchManager.this.mOnBleFlashListener != null) {
                    JLWatchManager.this.mOnBleFlashListener.onFlashFailure(6, "\u5931\u8d25:\u8d85\u65f6");
                }
            }
        }
    };
    private int mMaxCount = 1;
    private int mCurrentCount = 1;
    private boolean mSendWatchIng = false;

    public JLWatchManager(Builder builder) {
        super(1);
        this.mOnBleFlashListener = builder.mOnBleFlashListener;
        this.mFilePath = builder.mFilePath;
        this.mMtu = builder.mMtu;
        this.onBtDeviceConnection(builder.mBleDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Builder newBuilder(Context context) {
        if (mBuilder != null) return mBuilder;
        Class<Builder> clazz = Builder.class;
        synchronized (Builder.class) {
            if (mBuilder != null) return mBuilder;
            mBuilder = new Builder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mBuilder;
        }
    }

    public void onBtDeviceConnection(BleDevice bleDevice) {
        this.mBleDevice = bleDevice;
        this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
        this.mBleDevice.setOnBleMtuListener((OnBleMtuListener)this);
        if (this.mMtu == 0) {
            this.mBleDevice.setMtu(517);
        }
        if (!this.mNotify) {
            this.mBleDevice.setNotify(BluetoothConstant.UUID_SERVICE, new UUID[]{BluetoothConstant.UUID_NOTIFICATION});
            return;
        }
        BluetoothDevice device = bleDevice.getBluetoothGatt().getDevice();
        this.mRcspAuth = new RcspAuth((RcspAuth.IRcspAuthOp)this, (RcspAuth.OnRcspAuthListener)this);
        if (!JLWatchManager.mBuilder.mAuthOk) {
            this.mRcspAuth.stopAuth(device, false);
            SystemClock.sleep((long)200L);
            boolean b = this.mRcspAuth.startAuth(device);
            BleLog.i((String)("\u8bbe\u5907\u8ba4\u8bc1\u64cd\u4f5c\u7ed3\u679c:" + b));
        } else {
            this.notifyBtDeviceConnection(bleDevice.getBluetoothGatt().getDevice(), 1);
        }
        this.registerOnWatchCallback(new OnWatchCallback(){

            public void onWatchSystemInit(int code) {
                super.onWatchSystemInit(code);
                BleLog.i((String)("onWatchSystemInit:" + code + "  StartStatus:" + JLWatchManager.this.mStartStatus));
                boolean bl = JLWatchManager.this.mInitOk = code == 0;
                if (JLWatchManager.this.mInitOk) {
                    if (JLWatchManager.this.mStartStatus) {
                        JLWatchManager.this.startFlash();
                    }
                } else {
                    JLWatchManager.this.onStop(code);
                }
            }

            public void onWatchSystemException(BluetoothDevice device, int sysStatus) {
                super.onWatchSystemException(device, sysStatus);
                if (sysStatus == 1) {
                    JLWatchManager.this.restoreWatchSystem(new OnFatFileProgressListener(){

                        public void onStart(String s) {
                            BleLog.i((String)"\u7cfb\u7edf\u5f02\u5e38,\u6b63\u5728\u6062\u590d\u4e2d.");
                        }

                        public void onProgress(float v) {
                        }

                        public void onStop(int i) {
                            if (i == 0) {
                                BleLog.i((String)"\u7cfb\u7edf\u5f02\u5e38,\u6062\u590d\u6210\u529f.");
                                if (JLWatchManager.this.mStartStatus) {
                                    JLWatchManager.this.startFlash();
                                } else {
                                    JLWatchManager.this.release();
                                }
                            }
                        }
                    });
                }
            }

            public void onResourceUpdateUnfinished(BluetoothDevice device) {
                super.onResourceUpdateUnfinished(device);
                BleLog.i((String)("onResourceUpdateUnfinished:" + device.getAddress()));
            }
        });
    }

    public boolean sendAuthDataToDevice(BluetoothDevice bluetoothDevice, byte[] bytes) {
        BleLog.i((String)("\u5411\u84dd\u7259\u8bbe\u5907\u53d1\u9001\u8ba4\u8bc1\u6570\u636e:" + Arrays.toString(bytes)));
        return this.sendDataToDevice(bluetoothDevice, bytes);
    }

    public void onInitResult(boolean b) {
    }

    public void onAuthSuccess(BluetoothDevice bluetoothDevice) {
        JLWatchManager.mBuilder.mAuthOk = true;
        this.mRcspAuth.destroy();
        BleLog.i((String)"onAuthSuccess");
        this.mHandler.sendEmptyMessageDelayed(1, 5000L);
        this.notifyBtDeviceConnection(this.getConnectedDevice(), 1);
    }

    public void onAuthFailed(BluetoothDevice bluetoothDevice, int i, String s) {
        this.mRcspAuth.destroy();
        JLWatchManager.mBuilder.mAuthOk = false;
        BleLog.e((String)("onAuthFailed" + s + "   code:" + i));
        this.notifyBtDeviceConnection(this.getConnectedDevice(), 2);
        if (this.mOnBleFlashListener != null) {
            this.mOnBleFlashListener.onFlashFailure(6, "\u5931\u8d25:onAuthFailed=" + s);
        }
    }

    private boolean isValidAuthData(byte[] var1) {
        if (var1 != null && var1.length != 0) {
            return var1.length == 5 && var1[0] == 2 || var1.length == 17 && (var1[0] == 0 || var1[0] == 1);
        }
        return false;
    }

    public void setFilePath(String filePath) {
        this.mFilePath = filePath;
    }

    public boolean startFlash() {
        this.mBleDevice.setConnectPriority(1);
        this.mStartStatus = true;
        if (this.mInitOk) {
            if (this.mSendWatchIng) {
                return true;
            }
            this.mSendWatchIng = true;
            this.mNewWatchPath = this.mFilePath.substring(this.mFilePath.lastIndexOf("/"));
            BleLog.i((String)("\u8868\u76d8\u5b8c\u6574\u8def\u5f84:" + this.mFilePath + "   \u624b\u8868\u8def\u5f84:" + this.mNewWatchPath));
            this.listWatchList((OnWatchOpCallback)new OnWatchOpCallback<ArrayList<FatFile>>(){

                public void onSuccess(ArrayList<FatFile> fatFiles) {
                    for (FatFile fatFile : fatFiles) {
                        if (!fatFile.getName().equalsIgnoreCase(JLWatchManager.WATCH_NAME)) continue;
                        JLWatchManager.this.replaceWatchFile(JLWatchManager.this.mFilePath, JLWatchManager.this);
                        return;
                    }
                    if (fatFiles.size() >= 100) {
                        FatFile fileBean = fatFiles.get(fatFiles.size() - 1);
                        JLWatchManager.this.mDeleteWatchPath = fileBean.getPath();
                    }
                    if (JLWatchManager.this.mNewWatchPath.equalsIgnoreCase(JLWatchManager.this.mDeleteWatchPath)) {
                        JLWatchManager.this.mDeleteWatchPath = "";
                        JLWatchManager.this.mMaxCount = 1;
                        JLWatchManager.this.replaceWatchFile(JLWatchManager.this.mFilePath, JLWatchManager.this);
                    } else {
                        JLWatchManager.this.mMaxCount = 2;
                        JLWatchManager.this.createWatchFile(JLWatchManager.this.mFilePath, false, JLWatchManager.this);
                    }
                }

                public void onFailed(BaseError baseError) {
                }
            });
        }
        return this.mInitOk;
    }

    public boolean deleteWatch(String filePath, final JLManager.OnWatchFileListener<Boolean> listener) {
        if (this.mInitOk) {
            this.deleteWatchFile(filePath, new OnFatFileProgressListener(){

                public void onStart(String s) {
                    if (listener != null) {
                        listener.onSuccess(true);
                    }
                }

                public void onProgress(float v) {
                }

                public void onStop(int i) {
                    if (listener != null) {
                        listener.onSuccess(false);
                    }
                }
            });
        }
        return this.mInitOk;
    }

    public boolean setCurrentWatch(String path, final OnWatchOpCallback<FatFile> listener) {
        if (this.mInitOk) {
            this.setCurrentWatchInfo(path, (OnWatchOpCallback)new OnWatchOpCallback<FatFile>(){

                public void onSuccess(FatFile fatFile) {
                    if (listener != null) {
                        listener.onSuccess((Object)fatFile);
                    }
                }

                public void onFailed(BaseError baseError) {
                    if (listener != null) {
                        listener.onFailed(baseError);
                    }
                }
            });
        }
        return this.mInitOk;
    }

    public boolean getWatchList(final JLManager.OnWatchFileListener<ArrayList<FileBean>> listener) {
        if (this.mInitOk) {
            this.listWatchList((OnWatchOpCallback)new OnWatchOpCallback<ArrayList<FatFile>>(){

                public void onSuccess(ArrayList<FatFile> fatFiles) {
                    if (listener != null) {
                        ArrayList<FileBean> list = new ArrayList<FileBean>();
                        for (FatFile fatFile : fatFiles) {
                            list.add(new FileBean(fatFile));
                        }
                        listener.onSuccess(list);
                    }
                }

                public void onFailed(BaseError baseError) {
                    if (listener != null) {
                        listener.onFailed(baseError.getCode(), baseError.getMessage());
                    }
                }
            });
        }
        return this.mInitOk;
    }

    public void OnMtu(int mtu) {
        this.mMtu = mtu - 3;
        BleLog.i((String)("OnMtu:" + mtu));
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
        byte[] data = characteristic.getValue();
        boolean validAuthData = this.isValidAuthData(data);
        if (validAuthData) {
            if (this.mRcspAuth != null) {
                this.mRcspAuth.handleAuthData(this.mBleDevice.getBluetoothGatt().getDevice(), data);
            }
        } else {
            this.notifyReceiveDeviceData(this.mBleDevice.getBluetoothGatt().getDevice(), data);
        }
    }

    public void onDescriptorWriteOK(BluetoothGattDescriptor descriptor) {
        if (descriptor.getCharacteristic().getUuid().toString().equalsIgnoreCase(BluetoothConstant.UUID_NOTIFICATION.toString())) {
            BleLog.i((String)"onDescriptorWriteOK");
            this.mNotify = true;
            this.onBtDeviceConnection(this.mBleDevice);
        }
    }

    public BluetoothDevice getConnectedDevice() {
        return this.mBleDevice == null ? null : this.mBleDevice.getBluetoothGatt().getDevice();
    }

    public boolean sendDataToDevice(BluetoothDevice bluetoothDevice, byte[] bytes) {
        if (bluetoothDevice == null || bytes == null) {
            return false;
        }
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
        return this.toSendData(bytes);
    }

    private boolean toSendData(byte[] bytes) {
        int time = 0;
        int mtu = this.mMtu;
        int dataLen = bytes.length;
        int blockCount = dataLen / mtu;
        boolean status = true;
        for (int i = 0; i < blockCount; ++i) {
            byte[] mBlockData = new byte[mtu];
            System.arraycopy(bytes, i * mtu, mBlockData, 0, mBlockData.length);
            time += mBlockData.length;
            SystemClock.sleep((long)15L);
            SendDataBean sendDataBean = new SendDataBean(mBlockData, BluetoothConstant.UUID_WRITE, 2, BluetoothConstant.UUID_SERVICE);
            status = this.mBleDevice.sendDataOta(sendDataBean);
            if (status) continue;
            SystemClock.sleep((long)20L);
            status = this.mBleDevice.sendDataOta(sendDataBean);
            if (status) continue;
            SystemClock.sleep((long)20L);
            status = this.mBleDevice.sendDataOta(sendDataBean);
            if (status) continue;
            return false;
        }
        if (0 != dataLen % mtu) {
            SystemClock.sleep((long)20L);
            byte[] noBlockData = new byte[dataLen % mtu];
            System.arraycopy(bytes, dataLen - dataLen % mtu, noBlockData, 0, noBlockData.length);
            SendDataBean sendDataBean = new SendDataBean(noBlockData, BluetoothConstant.UUID_WRITE, 2, BluetoothConstant.UUID_SERVICE);
            status = this.mBleDevice.sendDataOta(sendDataBean);
            if (!status) {
                SystemClock.sleep((long)20L);
                status = this.mBleDevice.sendDataOta(sendDataBean);
                if (!status) {
                    return false;
                }
            }
        }
        return status;
    }

    public void onStart(String s) {
        BleLog.i((String)("onStart:" + s));
        this.mSendWatchIng = true;
        this.mStartStatus = false;
        if (this.mOnBleFlashListener != null) {
            this.mOnBleFlashListener.onFlashProgress(0.0f, this.mCurrentCount, this.mMaxCount);
        }
    }

    public void onProgress(float v) {
        BleLog.i((String)("onProgress:" + v));
        if (this.mOnBleFlashListener != null) {
            this.mOnBleFlashListener.onFlashProgress(v, this.mCurrentCount, this.mMaxCount);
        }
    }

    public void onStop(int result) {
        BleLog.i((String)("onStop:" + result));
        this.mSendWatchIng = false;
        this.mStartStatus = false;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBleDevice.setConnectPriority(0);
        }
        if (result == 0) {
            if (!TextUtils.isEmpty((CharSequence)this.mDeleteWatchPath)) {
                BleLog.i((String)("\u8868\u76d8\u6210\u529f,\u9700\u8981\u5220\u9664:" + this.mDeleteWatchPath));
                this.deleteWatchFile(this.mDeleteWatchPath, new OnFatFileProgressListener(){

                    public void onStart(String s) {
                    }

                    public void onProgress(float v) {
                    }

                    public void onStop(int i) {
                        if (i == 0) {
                            JLWatchManager.this.setCurrentWatchInfo(JLWatchManager.this.mNewWatchPath, (OnWatchOpCallback)new OnWatchOpCallback<FatFile>(){

                                public void onSuccess(FatFile fatFile) {
                                    if (JLWatchManager.this.mOnBleFlashListener != null) {
                                        JLWatchManager.this.mOnBleFlashListener.onFlashSuccess();
                                    }
                                    BleLog.i((String)("\u8bbe\u7f6e\u8868\u76d8\u6210\u529f:" + (fatFile != null ? fatFile.getPath() : JLWatchManager.this.mNewWatchPath)));
                                }

                                public void onFailed(BaseError baseError) {
                                }
                            });
                        }
                    }
                });
                this.mDeleteWatchPath = "";
            } else {
                this.setCurrentWatchInfo(this.mNewWatchPath, (OnWatchOpCallback)new OnWatchOpCallback<FatFile>(){

                    public void onSuccess(FatFile fatFile) {
                        BleLog.i((String)("\u8bbe\u7f6e\u8868\u76d8\u6210\u529f:" + (fatFile != null ? fatFile.getPath() : JLWatchManager.this.mNewWatchPath)));
                        if (JLWatchManager.this.mOnBleFlashListener != null) {
                            JLWatchManager.this.mOnBleFlashListener.onFlashSuccess();
                        }
                    }

                    public void onFailed(BaseError baseError) {
                    }
                });
            }
        } else if (result == 16897) {
            if (this.mOnBleFlashListener != null) {
                this.mOnBleFlashListener.onFlashFailure(8, "\u7a7a\u95f4\u4e0d\u8db3");
            }
        } else if (this.mOnBleFlashListener != null) {
            this.mOnBleFlashListener.onFlashFailure(6, "\u5931\u8d25:" + result);
        }
    }

    public void onDisConnected() {
        this.mSendWatchIng = false;
        JLWatchManager.mBuilder.mAuthOk = false;
        if (this.mBleDevice != null) {
            this.notifyBtDeviceConnection(this.mBleDevice.getBluetoothGatt().getDevice(), 2);
        }
        this.mNotify = false;
        this.mBleDevice = null;
        this.release();
    }

    public void release() {
        super.release();
        if (this.mBleDevice != null) {
            this.mBleDevice.setConnectPriority(0);
        }
        this.mSendWatchIng = false;
        JLWatchManager.mBuilder.mAuthOk = false;
        this.mStartStatus = false;
        if (this.mRcspAuth != null) {
            this.mRcspAuth.destroy();
        }
        BleLog.i((String)"release:\u91ca\u653e\u8d44\u6e90");
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private Context mContext;
        private OnBleFlashListener mOnBleFlashListener;
        private String mFilePath = "";
        private boolean mAuthOk;
        private int mMtu = 0;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setOnBleFlashListener(OnBleFlashListener onBleFlashListener) {
            this.mOnBleFlashListener = onBleFlashListener;
            return this;
        }

        public Builder setFilePath(String filePath) {
            if (!filePath.startsWith("/")) {
                filePath = "/" + filePath;
            }
            this.mFilePath = filePath;
            return this;
        }

        public Builder setMtu(int mtu) {
            this.mMtu = mtu;
            return this;
        }

        public JLWatchManager build(BleDevice bleDevice) {
            if (this.mBleDevice != null && this.mBleDevice != bleDevice) {
                this.mAuthOk = false;
            }
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new JLWatchManager(this);
        }
    }
}

