/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.linkedsemi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class BleLinkedSeMiOtaUtils {
    private static final int fileChunkSize = 513;
    private InputStream inputStream;
    private byte crc;
    private byte[] bytes;
    private byte[][][] blocks;
    private int fileBlockSize = 0;
    private int bytesAvailable;
    private int numberOfBlocks = -1;
    private int chunksPerBlockCount;
    private int totalChunkCount;
    private byte[] summaryBytes = new byte[32];
    private byte[] summaryBytes1 = new byte[18];
    private byte[] summaryBytes2 = new byte[18];

    public static BleLinkedSeMiOtaUtils getByFileName(String filePath) throws IOException {
        FileInputStream is = new FileInputStream(filePath);
        return new BleLinkedSeMiOtaUtils(is);
    }

    private BleLinkedSeMiOtaUtils(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.bytesAvailable = this.inputStream.available();
        this.init();
    }

    public void init() throws IOException {
        this.bytes = new byte[this.bytesAvailable];
        this.inputStream.read(this.bytes);
        this.crc = this.getCrc();
        this.summaryBytes = this.getSummaryBytes();
        this.splitSummaryBytes();
    }

    public int getFileBlockSize() {
        return this.fileBlockSize;
    }

    public int getNumberOfBytes() {
        return this.bytes.length;
    }

    public void setFileBlockSize(int fileBlockSize) {
        this.fileBlockSize = fileBlockSize;
        this.chunksPerBlockCount = (int)Math.ceil((double)fileBlockSize / 513.0);
        this.numberOfBlocks = (int)Math.ceil((double)this.bytes.length / (double)this.fileBlockSize);
        this.initBlocksOta();
    }

    private void initBlocksOta() {
        int totalChunkCounter = 0;
        this.blocks = new byte[this.numberOfBlocks][][];
        int byteOffset = 0;
        for (int i = 0; i < this.numberOfBlocks; ++i) {
            int blockSize = this.fileBlockSize;
            if (i + 1 == this.numberOfBlocks) {
                blockSize = this.bytes.length % this.fileBlockSize == 0 ? this.fileBlockSize : this.bytes.length % this.fileBlockSize;
            }
            int numberOfChunksInBlock = (int)Math.ceil((double)blockSize / 513.0);
            int chunkNumber = 0;
            this.blocks[i] = new byte[numberOfChunksInBlock][];
            for (int j = 0; j < blockSize; j += 513) {
                int chunkSize = 513;
                if (byteOffset + 513 > this.bytes.length) {
                    chunkSize = this.bytes.length - byteOffset;
                } else if (j + 513 > blockSize) {
                    chunkSize = this.fileBlockSize % 513;
                }
                byte[] chunk = Arrays.copyOfRange(this.bytes, byteOffset, byteOffset + chunkSize);
                this.blocks[i][chunkNumber] = chunk;
                byteOffset += chunkSize;
                ++chunkNumber;
                ++totalChunkCounter;
            }
        }
        this.totalChunkCount = totalChunkCounter;
    }

    public byte[][] getBlock(int index) {
        return this.blocks[index];
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public int getChunksPerBlockCount() {
        return this.chunksPerBlockCount;
    }

    public int getTotalChunkCount() {
        return this.totalChunkCount;
    }

    private byte[] getSummaryBytes() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(this.bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getDigestBytes1() {
        return this.summaryBytes1;
    }

    public byte[] getDigestBytes2() {
        return this.summaryBytes2;
    }

    private void splitSummaryBytes() {
        if (this.summaryBytes != null && this.summaryBytes.length >= 32) {
            System.arraycopy(this.summaryBytes, 0, this.summaryBytes1, 2, 16);
            System.arraycopy(this.summaryBytes, 16, this.summaryBytes2, 2, 16);
        }
        this.summaryBytes1[0] = 1;
        this.summaryBytes1[1] = 0;
        this.summaryBytes2[0] = 1;
        this.summaryBytes2[1] = 1;
    }

    private byte getCrc() throws IOException {
        byte crc_code = 0;
        for (int i = 0; i < this.bytesAvailable; ++i) {
            Byte byteValue = this.bytes[i];
            int intVal = byteValue.intValue();
            crc_code = (byte)(crc_code ^ intVal);
        }
        return crc_code;
    }
}

