/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.linkedsemi;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.elinkthings.bleotalibrary.linkedsemi.BleLinkedSeMiOtaUtils;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.listener.OnCharacteristicListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public class LinkedSeMiOtaManager
implements OnCharacteristicListener {
    private static final String TAG = LinkedSeMiOtaManager.class.getSimpleName();
    private BluetoothGatt mBluetoothGatt;
    private OnBleOTAListener mOnBleOTAListener;
    private HashMap errors;
    public static final int ERROR_READ_FILE = 3;
    public static final int ERROR_ON_START = 4;
    public static final int ERROR_LOW_POWER = 5;
    public static final int ERROR_OTA_CRC = 6;
    public static final UUID UUID_OTA_SERVICE = UUID.fromString("00002600-0000-1000-8000-00805f9b34fb");
    public static final UUID UUID_OTA_INDICATE = UUID.fromString("00007000-0000-1000-8000-00805f9b34fb");
    public static final UUID UUID_OTA_WRITE = UUID.fromString("00007001-0000-1000-8000-00805f9b34fb");
    private static final UUID DESCR_TWO = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private BluetoothGattCharacteristic ota7000Chara;
    private BluetoothGattCharacteristic ota7001Chara;
    private BleLinkedSeMiOtaUtils fileUtils;
    private boolean mVerifySupport = false;
    private String mFilePath = "";
    private BleDevice mBleDevice;
    private boolean mIndicate = false;
    private boolean mStartOta = false;
    private int readSuccessFlag = -1;
    private int blockCounter = 0;
    private int chunkCounter = -1;
    private int chunkSentCounter = 0;
    private boolean lastBlockSent = false;
    private boolean lastChunkSent = false;
    private boolean lastBlock = false;
    private boolean hasError = false;
    private Handler threadHandler = new Handler(Looper.getMainLooper());

    private LinkedSeMiOtaManager(Builder builder) {
        this.mBleDevice = builder.mBleDevice;
        if (this.mBleDevice != null) {
            this.mBluetoothGatt = this.mBleDevice.getBluetoothGatt();
            if (this.mBluetoothGatt == null) {
                this.mBleDevice.disconnect();
                return;
            }
        }
        this.mFilePath = builder.mFilePath;
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.initErrorMap();
        BluetoothGattService suota = this.mBluetoothGatt.getService(UUID_OTA_SERVICE);
        if (suota != null) {
            this.ota7000Chara = suota.getCharacteristic(UUID_OTA_INDICATE);
            this.ota7001Chara = suota.getCharacteristic(UUID_OTA_WRITE);
            this.mVerifySupport = true;
            if (this.mBleDevice != null) {
                this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
                this.mBleDevice.setIndication(UUID_OTA_SERVICE, new UUID[]{UUID_OTA_INDICATE});
            }
        } else {
            Log.e((String)TAG, (String)"\u4e0d\u652f\u6301Dialog OTA");
            this.mVerifySupport = false;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void startOta() {
        this.startOta(this.mFilePath);
    }

    public synchronized void startOta(String fileName) {
        if (!this.mVerifySupport || this.mBleDevice == null) {
            return;
        }
        this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
        this.setFileName(fileName);
        this.mStartOta = true;
    }

    private void setFileName(String fileName) {
        try {
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                this.fileUtils = BleLinkedSeMiOtaUtils.getByFileName(fileName);
                this.fileUtils.setFileBlockSize(4096);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.onError(3);
        }
    }

    private void initErrorMap() {
        this.errors = new HashMap();
        this.errors.put(5, "Low power can't upgrade.");
        this.errors.put(4, "Work can't upgrade.");
        this.errors.put(3, "Read fileUtils error.");
        this.errors.put(6, "OTA patch crc error.");
    }

    @SuppressLint(value={"MissingPermission"})
    public void enableOTAIndication() {
        if (this.mBluetoothGatt != null && this.ota7000Chara != null) {
            this.mBluetoothGatt.setCharacteristicNotification(this.ota7000Chara, true);
            BluetoothGattDescriptor descriptor = this.ota7000Chara.getDescriptor(DESCR_TWO);
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
            boolean writeSuccess = this.mBluetoothGatt.writeDescriptor(descriptor);
            if (!writeSuccess) {
                this.onError(4);
            }
        }
    }

    public void onCharacteristicReadOK(BluetoothGattCharacteristic characteristic) {
        byte[] value = characteristic.getValue();
        if (characteristic.getUuid().equals(UUID_OTA_WRITE) && value.length == 27) {
            if (this.lastChunkSent && this.blockCounter < this.fileUtils.getNumberOfBlocks() - 1) {
                this.sendBlockInfo(++this.blockCounter);
                this.lastChunkSent = false;
            } else if (this.lastChunkSent && this.blockCounter == this.fileUtils.getNumberOfBlocks() - 1) {
                this.sendCheckResult();
            } else {
                this.sendBlockDates(this.blockCounter);
            }
        }
    }

    private boolean checkOk(byte[] value) {
        int a = -1;
        for (byte b : value) {
            a = (byte)(a & b);
        }
        return (a & 0xFF) == 255;
    }

    public void onCharacteristicWriteOK(BluetoothGattCharacteristic characteristic) {
        this.onWriteDataOk(characteristic);
    }

    public void onDescriptorWriteOK(BluetoothGattDescriptor descriptor) {
        UUID uuid = descriptor.getCharacteristic().getUuid();
        if (uuid.equals(UUID_OTA_INDICATE)) {
            this.mIndicate = true;
            this.setDigestData();
        }
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
        UUID uuid = characteristic.getUuid();
        byte[] value = characteristic.getValue();
        if (uuid.equals(UUID_OTA_INDICATE) && value.length >= 2 && value[0] == 3) {
            if ((value[1] & 0xFF) == 0) {
                this.sendBlockInfo(this.blockCounter);
            } else {
                this.onError(4);
            }
        }
    }

    public void onWriteDataOk(BluetoothGattCharacteristic characteristic) {
        byte[] value = characteristic.getValue();
        if (characteristic.getUuid().equals(UUID_OTA_INDICATE)) {
            if (value.length >= 2 && value[0] == 1 && value[1] == 0) {
                this.setDigestData1();
            } else if (value.length >= 2 && value[0] == 1 && value[1] == 1) {
                this.setStartOtaInfo();
            } else if (value.length == 3 && value[0] == 4 && (value[1] & value[2]) == 0) {
                this.sendBlockDates(this.blockCounter);
            } else if (value.length >= 2 && value[0] == 6) {
                if ((value[1] & 0xFF) == 0) {
                    this.endOta();
                } else if ((value[1] & 0xFF) != 0) {
                    this.onError(6);
                }
            }
        } else if (characteristic.getUuid().equals(UUID_OTA_WRITE)) {
            this.readBlockState();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void endOta() {
        byte[] bytes = new byte[17];
        bytes[0] = 7;
        bytes[1] = 7;
        int numberOfBytes = (int)this.getFileSize(this.mFilePath);
        bytes[2] = (byte)numberOfBytes;
        bytes[3] = (byte)(numberOfBytes >> 8);
        bytes[4] = (byte)(numberOfBytes >> 16);
        bytes[5] = 0;
        bytes[6] = -128;
        bytes[7] = 5;
        bytes[8] = 24;
        bytes[9] = 0;
        bytes[10] = 64;
        bytes[11] = 3;
        bytes[12] = 24;
        bytes[13] = 0;
        bytes[14] = 64;
        bytes[15] = 3;
        bytes[16] = 24;
        if (this.ota7000Chara != null) {
            this.ota7000Chara.setValue(bytes);
            int properties = this.ota7000Chara.getProperties();
            if ((properties & 4) != 0) {
                this.ota7000Chara.setWriteType(1);
            } else {
                this.ota7000Chara.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.ota7000Chara);
            if (writeSuccess) {
                this.onSuccess();
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void readBlockState() {
        if (this.ota7001Chara != null) {
            boolean readSuccess = this.mBluetoothGatt.readCharacteristic(this.ota7001Chara);
            if (!readSuccess) {
                ++this.readSuccessFlag;
                if (this.readSuccessFlag < 5) {
                    this.readBlockState();
                } else {
                    this.onError(4);
                }
            } else {
                this.readSuccessFlag = -1;
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private synchronized void sendBlockDates(int index) {
        float progress = (float)(this.chunkSentCounter + 1) / (float)this.fileUtils.getTotalChunkCount() * 100.0f;
        if (!this.lastBlockSent) {
            byte[][] block = this.fileUtils.getBlock(index);
            int i = ++this.chunkCounter;
            boolean lastChunk = false;
            if (this.chunkCounter == block.length - 1) {
                this.chunkCounter = -1;
                lastChunk = true;
                this.lastChunkSent = true;
            }
            byte[] chunk = block[i];
            byte[] value = new byte[chunk.length + 1];
            value[0] = (byte)i;
            System.arraycopy(chunk, 0, value, 1, chunk.length);
            if (this.ota7001Chara != null) {
                this.ota7001Chara.setValue(value);
                int properties = this.ota7001Chara.getProperties();
                if ((properties & 4) != 0) {
                    this.ota7001Chara.setWriteType(1);
                } else {
                    this.ota7001Chara.setWriteType(2);
                }
                boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.ota7001Chara);
                if (!writeSuccess) {
                    this.onError(4);
                } else {
                    ++this.chunkSentCounter;
                }
            }
            if (lastChunk) {
                if (this.lastBlock) {
                    this.lastBlockSent = true;
                }
                if (this.blockCounter + 1 == this.fileUtils.getNumberOfBlocks()) {
                    this.lastBlock = true;
                }
            }
        }
        this.runOnMainThread(() -> {
            if (this.mOnBleOTAListener != null) {
                this.mOnBleOTAListener.onOtaProgress(progress, 1, 1);
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void sendBlockInfo(int index) {
        byte[] bytes = new byte[]{4, (byte)index, (byte)(index >> 8)};
        if (this.mStartOta && this.mIndicate && this.ota7000Chara != null) {
            this.ota7000Chara.setValue(bytes);
            int properties = this.ota7000Chara.getProperties();
            if ((properties & 4) != 0) {
                this.ota7000Chara.setWriteType(1);
            } else {
                this.ota7000Chara.setWriteType(2);
            }
            this.mBluetoothGatt.writeCharacteristic(this.ota7000Chara);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void sendCheckResult() {
        byte[] bytes = new byte[]{5};
        if (this.mStartOta && this.mIndicate && this.ota7000Chara != null) {
            this.ota7000Chara.setValue(bytes);
            int properties = this.ota7000Chara.getProperties();
            if ((properties & 4) != 0) {
                this.ota7000Chara.setWriteType(1);
            } else {
                this.ota7000Chara.setWriteType(2);
            }
            this.mBluetoothGatt.writeCharacteristic(this.ota7000Chara);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void setDigestData() {
        if (this.mStartOta && this.mIndicate && this.ota7000Chara != null) {
            this.ota7000Chara.setValue(this.fileUtils.getDigestBytes1());
            int properties = this.ota7000Chara.getProperties();
            if ((properties & 4) != 0) {
                this.ota7000Chara.setWriteType(1);
            } else {
                this.ota7000Chara.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.ota7000Chara);
            if (!writeSuccess) {
                this.onError(4);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void setDigestData1() {
        if (this.mStartOta && this.mIndicate && this.ota7000Chara != null) {
            this.ota7000Chara.setValue(this.fileUtils.getDigestBytes2());
            int properties = this.ota7000Chara.getProperties();
            if ((properties & 4) != 0) {
                this.ota7000Chara.setWriteType(1);
            } else {
                this.ota7000Chara.setWriteType(2);
            }
            boolean writeSuccess = this.mBluetoothGatt.writeCharacteristic(this.ota7000Chara);
            if (!writeSuccess) {
                this.onError(4);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void setStartOtaInfo() {
        byte[] bytes = new byte[13];
        bytes[0] = 2;
        bytes[1] = 0;
        bytes[2] = -128;
        bytes[3] = 5;
        bytes[4] = 24;
        int numberOfBytes = (int)this.getFileSize(this.mFilePath);
        bytes[5] = (byte)numberOfBytes;
        bytes[6] = (byte)(numberOfBytes >> 8);
        bytes[7] = (byte)(numberOfBytes >> 16);
        bytes[8] = (byte)(numberOfBytes >> 24);
        int dataLength = 513;
        bytes[9] = (byte)dataLength;
        bytes[10] = (byte)(dataLength >> 8);
        bytes[11] = (byte)(dataLength >> 16);
        bytes[12] = (byte)(dataLength >> 24);
        if (this.mStartOta && this.mIndicate && this.ota7000Chara != null) {
            this.ota7000Chara.setValue(bytes);
            int properties = this.ota7000Chara.getProperties();
            if ((properties & 4) != 0) {
                this.ota7000Chara.setWriteType(1);
            } else {
                this.ota7000Chara.setWriteType(2);
            }
            this.mBluetoothGatt.writeCharacteristic(this.ota7000Chara);
        }
    }

    private long getFileSize(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.length();
        }
        return 0L;
    }

    private int getChunkCounter() {
        return this.chunkCounter;
    }

    private void onSuccess() {
        this.runOnMainThread(() -> {
            if (this.mOnBleOTAListener != null) {
                this.mOnBleOTAListener.onOtaSuccess();
            }
        });
        if (this.fileUtils != null) {
            this.fileUtils.close();
        }
    }

    private void onError(int errorCode) {
        if (!this.hasError) {
            String error = (String)this.errors.get(errorCode);
            Log.e((String)TAG, (String)("Error: " + errorCode + " " + error));
            this.runOnMainThread(() -> {
                if (this.mOnBleOTAListener != null) {
                    this.mOnBleOTAListener.onOtaFailure(errorCode, error);
                }
            });
            this.hasError = true;
            if (this.fileUtils != null) {
                this.fileUtils.close();
            }
        }
    }

    private boolean isHasError() {
        return this.hasError;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public void setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
        this.mOnBleOTAListener = onBleOTAListener;
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.threadHandler.post(runnable);
        }
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private OnBleOTAListener mOnBleOTAListener;
        private String mFilePath = "";

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public LinkedSeMiOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new LinkedSeMiOtaManager(this);
        }
    }
}

