/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.netstrap;

import android.os.Environment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class NetstrapPacket {
    public static final int PDU_TYPE_CMD_SCAN_REQ = 0;
    public static final int PDU_TYPE_CMD_CONNECT_REQ = 1;
    public static final int PDU_TYPE_CMD_READ_DEVICE_INFO_REQ = 4;
    public static final int PDU_TYPE_CMD_WRITE_DEVICE_INFO_REQ = 5;
    public static final int PDU_TYPE_CMD_BLEWIFI_REQ_WIFI_STATUS = 6;
    public static final int PDU_TYPE_CMD_OTA_VERSION_REQ = 256;
    public static final int PDU_TYPE_CMD_OTA_UPGRADE_REQ = 257;
    public static final int PDU_TYPE_CMD_OTA_RAW_DATA_REQ = 258;
    public static final int PDU_TYPE_CMD_OTA_END_REQ = 259;
    public static final int PDU_TYPE_EVT_SCAN_RSP = 4096;
    public static final int PDU_TYPE_EVT_SCAN_END = 4097;
    public static final int PDU_TYPE_EVT_CONNECT_RSP = 4098;
    public static final int PDU_TYPE_EVT_READ_DEVICE_INFO_RSP = 4101;
    public static final int PDU_TYPE_EVT_WRITE_DEVICE_INFO_RSP = 4102;
    public static final int PDU_TYPE_BLEWIFI_RSP_WIFI_STATUS = 4103;
    public static final int PDU_TYPE_EVT_OTA_VERSION_RSP = 4352;
    public static final int PDU_TYPE_EVT_OTA_UPGRADE_RSP = 4353;
    public static final int PDU_TYPE_EVT_OTA_RAW_DATA_RSP = 4354;
    public static final int PDU_TYPE_EVT_OTA_END_RSP = 4355;
    public static final int PDU_TYPE_VBATT_CAL = 1025;
    public static final int PDU_TYPE_IO_VOL_CAL = 1026;
    public static final int PDU_TYPE_TEMP_CAL = 1027;
    public static final int PDU_TYPE_SET_DEVICE_MODE = 1028;
    public static final int PDU_TYPE_READ_DEVICE_MODE = 1029;
    public static final int PDU_TYPE_VBATT_CAL_RSP = 5121;
    public static final int PDU_TYPE_IO_VOL_CAL_RSP = 5122;
    public static final int PDU_TYPE_TEMP_CAL_RSP = 5123;
    public static final int PDU_TYPE_SET_DEVICE_MODE_RSP = 5124;
    public static final int PDU_TYPE_READ_DEVICE_MODE_RSP = 5125;
    public static final int PDU_TYPE_RESET_REQ = 1537;
    public static final int PDU_TYPE_WRITE_WIFI_MAC_REQ = 1538;
    public static final int PDU_TYPE_READ_WIFI_MAC_REQ = 1539;
    public static final int PDU_TYPE_WRITE_BLE_MAC_REQ = 1540;
    public static final int PDU_TYPE_READ_BLE_MAC_REQ = 1541;
    public static final int PDU_TYPE_SEND_BLE_STR_REQ = 1542;
    public static final int PDU_TYPE_SEND_SINGLE_TONE_REQ = 1543;
    public static final int PDU_TYPE_RESET_RSP = 5633;
    public static final int PDU_TYPE_WRITE_WIFI_MAC_RSP = 5634;
    public static final int PDU_TYPE_READ_WIFI_MAC_RSP = 5635;
    public static final int PDU_TYPE_WRITE_BLE_MAC_RSP = 5636;
    public static final int PDU_TYPE_READ_BLE_MAC_RSP = 5637;
    public static final int PDU_TYPE_SEND_BLE_STR_RSP = 5638;
    public static final int PDU_TYPE_SEND_SINGLE_TONE_RSP = 5639;
    public static final int PDU_TYPE_GOTER_SINGLE_TONE_REQ = 6400;
    public static final int SCAN_TYPE_ACTIVE = 0;
    public static final int SCAN_TYPE_PASSIVE = 1;
    public static final int SCAN_TYPE_MIX = 2;
    public static final int AUTH_MODE_OPEN = 0;
    public static final int AUTH_MODE_WEP = 1;
    public static final int AUTH_MODE_WPA_PSK = 2;
    public static final int AUTH_MODE_WPA2_PSK = 3;
    public static final int AUTH_MODE_WPA_WPA2_PSK = 4;
    public static final int AUTH_MODE_WPA2_ENTERPRISE_PSK = 5;
    public static final int CONNECT_STATUS_SUCCESS = 0;
    public int ApConnectStatus;
    private static ByteBuffer rxBuffer;
    private static int currentLength;
    private int cmdId;
    private int length;
    private boolean showHidden;
    private int scanType;
    private byte[] bssid;
    private String password;
    private int Ap_ConnectStatus;
    private byte devicemode;
    private int maxRxOctet;
    private byte[] rawData;
    private int reason;
    private String ssid;
    private int authMode;
    private int rssi;
    private String ipaddr;
    private String maskaddr;
    private String gatewayaddr;
    private int connectStatus;
    private byte[] deviceId;
    private String manufactureName;
    private int writeStatus;
    private int status;
    private long projectId;
    private long chipId;
    private long fwId;
    private byte[] bleMac = new byte[6];
    private byte[] WiFiMac = new byte[6];
    private String ReadbackStr;

    public String getWiFiMac() {
        return String.format("%02X:%02X:%02X:%02X:%02X:%02X", this.WiFiMac[0], this.WiFiMac[1], this.WiFiMac[2], this.WiFiMac[3], this.WiFiMac[4], this.WiFiMac[5]);
    }

    public String getBleMac() {
        return String.format("%02X:%02X:%02X:%02X:%02X:%02X", this.bleMac[0], this.bleMac[1], this.bleMac[2], this.bleMac[3], this.bleMac[4], this.bleMac[5]);
    }

    public String getReadbackStr() {
        return this.ReadbackStr;
    }

    public int getCmdId() {
        return this.cmdId;
    }

    public byte[] getBssid() {
        return this.bssid;
    }

    public String getSsid() {
        return this.ssid;
    }

    public String getIpaddr() {
        return this.ipaddr;
    }

    public String getMaskddr() {
        return this.maskaddr;
    }

    public String getGateway() {
        return this.gatewayaddr;
    }

    public int getAuthMode() {
        return this.authMode;
    }

    public int getRssi() {
        return this.rssi;
    }

    public int getConnectStatus() {
        return this.connectStatus;
    }

    public int getReason() {
        return this.reason;
    }

    public int getStatus() {
        return this.status;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public long getChipId() {
        return this.chipId;
    }

    public long getFwId() {
        return this.fwId;
    }

    public byte[] getBytes() {
        ByteBuffer buf = null;
        switch (this.cmdId) {
            case 1025: {
                buf = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)4).put(this.rawData);
                break;
            }
            case 1026: {
                buf = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)5).put(this.rawData);
                break;
            }
            case 1027: {
                buf = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)4).put(this.rawData);
                break;
            }
            case 1537: {
                buf = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)0);
                break;
            }
            case 1542: {
                buf = ByteBuffer.allocate(4 + this.rawData.length).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)this.rawData.length).put(this.rawData);
                break;
            }
            case 1543: {
                buf = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)this.rawData.length).put(this.rawData);
                break;
            }
            case 1028: {
                buf = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)1).put(this.devicemode);
                break;
            }
            case 1029: {
                buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)0);
                break;
            }
            case 6: {
                buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)0);
                break;
            }
            case 1538: {
                buf = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)6).put(this.rawData);
                break;
            }
            case 1539: {
                buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)0);
                break;
            }
            case 1540: {
                buf = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)6).put(this.rawData);
                break;
            }
            case 1541: {
                buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)0);
                break;
            }
            case 0: {
                buf = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)2).put((byte)(this.showHidden ? 1 : 0)).put((byte)this.scanType);
                break;
            }
            case 1: {
                int temp_len = this.password.length();
                buf = ByteBuffer.allocate(12 + this.password.length()).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)(8 + this.password.length())).put(this.bssid).put((byte)this.Ap_ConnectStatus).put((byte)this.password.length()).put(this.password.getBytes());
                break;
            }
            case 4: 
            case 256: {
                buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)0);
                break;
            }
            case 5: {
                buf = ByteBuffer.allocate(11 + this.manufactureName.length()).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)(7 + this.manufactureName.length())).put(this.deviceId).put((byte)this.manufactureName.length()).put(this.manufactureName.getBytes());
                break;
            }
            case 257: {
                buf = ByteBuffer.allocate(30).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)26).putShort((short)this.maxRxOctet).put(this.rawData);
                break;
            }
            case 258: {
                buf = ByteBuffer.allocate(4 + this.rawData.length).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)this.rawData.length).put(this.rawData);
                break;
            }
            case 259: {
                buf = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.cmdId).putShort((short)1).put((byte)this.reason);
                break;
            }
        }
        return buf.array();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        switch (this.cmdId) {
            case 0: {
                str.append("[SCAN_REQ]\n").append("showHidden: " + this.showHidden + "\n").append("scanType: " + this.scanType + "\n");
                break;
            }
            case 4096: {
                str.append("[SCAN_RSP]\n").append("ssid: " + this.ssid + "\n").append("bssid: " + NetstrapPacket.getMacAddress(this.bssid) + "\n").append("authMode: " + NetstrapPacket.getAuthModeDescription(this.authMode) + "\n").append("rssi: " + this.rssi + "\n");
                break;
            }
            case 4097: {
                str.append("[SCAN_END]\n");
                break;
            }
            case 1: {
                str.append("[CONNECT_REQ]\n").append("bssid: " + NetstrapPacket.getMacAddress(this.bssid) + "\n").append("password: " + this.password + "\n");
                break;
            }
            case 4098: {
                str.append("[CONNECT_RSP]\n").append("status: " + (this.connectStatus == 0 ? "SUCCESS" : "FAIL") + "\n");
                break;
            }
            case 4: {
                str.append("[READ_DEVICE_REQ]\n");
                break;
            }
            case 4101: {
                str.append("[READ_DEVICE_RSP]\n").append("deviceId: " + NetstrapPacket.getMacAddress(this.deviceId) + "\n").append("manufactureName: " + this.manufactureName + "\n");
                break;
            }
            case 5: {
                str.append("[WRITE_DEVICE_REQ]\n").append("deviceId: " + NetstrapPacket.getMacAddress(this.deviceId) + "\n").append("manufactureName: " + this.manufactureName + "\n");
                break;
            }
            case 4102: {
                str.append("[WRITE_DEVICE_RSP]\n").append("status: " + this.writeStatus + "\n");
                break;
            }
            case 256: {
                str.append("[OTA_VERSION_REQ]\n");
                break;
            }
            case 4352: {
                str.append("[OTA_VERSION_RSP]\n").append("status: " + this.status + "\n").append("projectId: " + String.format("0x%04X", this.projectId) + "\n").append("chipId: " + String.format("0x%04X", this.chipId) + "\n").append("fwId: " + String.format("0x%04X", this.fwId) + "\n");
                break;
            }
            case 257: {
                str.append("[OTA_UPGRADE_REQ]\n").append("maxRxOctet: " + this.maxRxOctet + "\n");
                break;
            }
            case 4353: {
                str.append("[OTA_UPGRADE_RSP]\n").append("status: " + this.status + "\n");
                break;
            }
            case 258: {
                str.append("[OTA_RAW_DATA_REQ]\n").append("rawData.length: " + this.rawData.length + "\n");
                break;
            }
            case 4354: {
                str.append("[OTA_RAW_DATA_RSP]\n");
                break;
            }
            case 259: {
                str.append("[OTA_END_REQ]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 4355: {
                str.append("[OTA_END_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5121: {
                str.append("[VBATT_CAL_END_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5122: {
                str.append("[IO_VOL_CAL_END_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5123: {
                str.append("[TEMP_CAL_END_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5633: {
                str.append("[PDU_TYPE_RESET_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5634: {
                str.append("[PDU_TYPE_WRITE_WIFI_MAC_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5636: {
                str.append("[PDU_TYPE_WRITE_BLE_MAC_RSP]\n").append("reason: " + this.reason + "\n");
                break;
            }
            case 5635: {
                str.append("[PDU_TYPE_READ_WIFI_MAC_RSP]\n").append("Wifi Mac: " + String.format("%02X-%02X-%02X-%02X-%02X-%02X", this.WiFiMac[0], this.WiFiMac[1], this.WiFiMac[2], this.WiFiMac[3], this.WiFiMac[4], this.WiFiMac[5]) + "\n");
                break;
            }
            case 5637: {
                str.append("[PDU_TYPE_READ_BLE_MAC_RSP]\n").append("Ble Mac: " + String.format("%02X-%02X-%02X-%02X-%02X-%02X", this.bleMac[0], this.bleMac[1], this.bleMac[2], this.bleMac[3], this.bleMac[4], this.bleMac[5]) + "\n");
                break;
            }
            case 5638: {
                str.append("[PDU_TYPE_SEND_BLE_STR_RSP]\n").append("status: " + this.reason + "\n");
                break;
            }
            case 5124: {
                str.append("[PDU_TYPE_SET_DEVICE_MODE_RSP]\n").append("status: " + this.reason + "\n");
                break;
            }
            case 5125: {
                str.append("[PDU_TYPE_READ_DEVICE_MODE_RSP]\n").append("Mode: " + this.reason + "\n");
                break;
            }
            case 5639: {
                str.append("[PDU_TYPE_SEND_SINGLE_TONE_RSP]\n").append("status: " + this.reason + "\n");
                break;
            }
        }
        return str.toString();
    }

    public static NetstrapPacket createResetPacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1537;
        return packet;
    }

    public static NetstrapPacket createWriteWiFiMacPacket(byte[] bMac) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1538;
        packet.rawData = bMac;
        return packet;
    }

    public static NetstrapPacket createBleStringPacket(byte[] bInputStr) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1542;
        packet.rawData = bInputStr;
        return packet;
    }

    public static NetstrapPacket createDeviceModePacket(byte iMode) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1028;
        packet.devicemode = iMode;
        return packet;
    }

    public static NetstrapPacket createReadDeviceModePacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1029;
        return packet;
    }

    public static NetstrapPacket createReadWiFiMacPacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1539;
        return packet;
    }

    public static NetstrapPacket createWriteBleMacPacket(byte[] bMac) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1540;
        packet.rawData = bMac;
        return packet;
    }

    public static NetstrapPacket createReadBleMacPacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1541;
        return packet;
    }

    public static NetstrapPacket createReadDeviceWiFiInfoPacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 6;
        return packet;
    }

    public static NetstrapPacket createcalvbattPacket(float fvbatt) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1025;
        packet.rawData = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(fvbatt).array();
        return packet;
    }

    public static NetstrapPacket createcaliovolPacket(byte IOpin, float fiovol) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1026;
        packet.rawData = new byte[5];
        packet.rawData[0] = IOpin;
        byte[] ttemp = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(fiovol).array();
        packet.rawData[1] = ttemp[0];
        packet.rawData[2] = ttemp[1];
        packet.rawData[3] = ttemp[2];
        packet.rawData[4] = ttemp[3];
        return packet;
    }

    public static NetstrapPacket createSingleTonePacket(short nMode, int nFreq) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1543;
        packet.rawData = new byte[6];
        byte[] ttemp1 = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(nMode).array();
        packet.rawData[0] = ttemp1[0];
        packet.rawData[1] = ttemp1[1];
        byte[] ttemp = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(nFreq).array();
        packet.rawData[2] = ttemp[0];
        packet.rawData[3] = ttemp[1];
        packet.rawData[4] = ttemp[2];
        packet.rawData[5] = ttemp[3];
        return packet;
    }

    public static NetstrapPacket createcaltempPacket(float ftemp) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1027;
        packet.rawData = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(ftemp).array();
        return packet;
    }

    public static NetstrapPacket createScanReqPacket(boolean showHidden, int scanType) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 0;
        packet.showHidden = showHidden;
        packet.scanType = scanType;
        return packet;
    }

    public static NetstrapPacket createConnectReqPacket(byte[] bssid, String password, int ConnectStatus) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 1;
        packet.bssid = bssid;
        packet.password = password;
        packet.Ap_ConnectStatus = ConnectStatus;
        return packet;
    }

    public static NetstrapPacket createReadDeviceInfoReqPacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 4;
        return packet;
    }

    public static NetstrapPacket createWriteDeviceInfoReqPacket(byte[] deviceId, String manufactureName) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 5;
        packet.deviceId = deviceId;
        packet.manufactureName = manufactureName;
        return packet;
    }

    public static NetstrapPacket createOtaVersionReqPacket() {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 256;
        return packet;
    }

    public static NetstrapPacket createOtaUpgradeReqPacket(int maxRxOctet, byte[] header) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 257;
        packet.maxRxOctet = maxRxOctet;
        packet.rawData = header;
        return packet;
    }

    public static NetstrapPacket createOtaRawDataReqPacket(byte[] rawData) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 258;
        packet.rawData = rawData;
        return packet;
    }

    public static NetstrapPacket createOtaEndReqPacket(int reason) {
        NetstrapPacket packet = new NetstrapPacket();
        packet.cmdId = 259;
        packet.reason = reason;
        return packet;
    }

    public static synchronized List<NetstrapPacket> decodePacket(byte[] data) {
        short aShort;
        int allPacketLength;
        StringBuilder log = new StringBuilder();
        ArrayList<NetstrapPacket> ls = new ArrayList<NetstrapPacket>();
        if (rxBuffer == null) {
            rxBuffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
        }
        rxBuffer.put(data);
        log.append("in: " + data.length + ", all: " + (currentLength += data.length) + ", ");
        while (currentLength >= (allPacketLength = (aShort = rxBuffer.getShort(2)) + 4)) {
            NetstrapPacket rxPacket = new NetstrapPacket();
            rxPacket.cmdId = rxBuffer.getShort(0);
            switch (rxPacket.cmdId) {
                case 4096: {
                    NetstrapPacket.decodeScanRsp(rxPacket, rxBuffer);
                    break;
                }
                case 4097: {
                    break;
                }
                case 4098: {
                    rxPacket.connectStatus = rxBuffer.get(4);
                    break;
                }
                case 4101: {
                    NetstrapPacket.decodeReadDeviceInfoRsp(rxPacket, rxBuffer);
                    break;
                }
                case 4102: {
                    rxPacket.writeStatus = rxBuffer.get(4);
                    break;
                }
                case 4352: {
                    NetstrapPacket.decodeOtaVersionRsp(rxPacket, rxBuffer);
                    break;
                }
                case 4353: {
                    rxPacket.status = rxBuffer.get(4);
                    break;
                }
                case 5121: {
                    rxPacket.reason = rxBuffer.get(6);
                    break;
                }
                case 5122: {
                    rxPacket.reason = rxBuffer.get(6);
                    break;
                }
                case 5123: {
                    rxPacket.reason = rxBuffer.get(6);
                    break;
                }
                case 5633: {
                    rxPacket.reason = rxBuffer.get(6);
                    break;
                }
                case 5635: {
                    NetstrapPacket.decodeReadwifiMacRsp(rxPacket, rxBuffer);
                    break;
                }
                case 5637: {
                    NetstrapPacket.decodeReadbleMacRsp(rxPacket, rxBuffer);
                    break;
                }
                case 4103: {
                    NetstrapPacket.decodeDeviceWifiStatusRsp(rxPacket, rxBuffer);
                    break;
                }
                case 5638: {
                    rxPacket.reason = rxBuffer.get(4);
                    break;
                }
                case 5124: {
                    rxPacket.reason = rxBuffer.get(4);
                    break;
                }
                case 5125: {
                    rxPacket.reason = rxBuffer.get(4);
                    break;
                }
                case 5639: {
                    rxPacket.reason = rxBuffer.get(4);
                }
            }
            currentLength -= allPacketLength;
            byte[] rxBytes = new byte[1024];
            for (int i = 0; i < currentLength; ++i) {
                rxBytes[i] = rxBuffer.get(allPacketLength + i);
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(1024).order(ByteOrder.LITTLE_ENDIAN);
            newBuffer.put(rxBytes, 0, currentLength);
            rxBuffer = newBuffer;
            ls.add(rxPacket);
        }
        currentLength = 0;
        log.append("rx_pkt: " + ls.size());
        rxBuffer.clear();
        return ls;
    }

    private static void decodeReadwifiMacRsp(NetstrapPacket pkt, ByteBuffer buf) {
        int deviceWifiMacOffset = 4;
        int deviceWiFiMACLen = 6;
        byte[] deviceId = new byte[deviceWiFiMACLen];
        for (int i = 0; i < deviceWiFiMACLen; ++i) {
            deviceId[i] = buf.order(ByteOrder.BIG_ENDIAN).get(deviceWifiMacOffset + i);
        }
        pkt.WiFiMac = deviceId;
    }

    private static void decodeReadbleMacRsp(NetstrapPacket pkt, ByteBuffer buf) {
        int devicebleMacOffset = 4;
        int devicebleMACLen = 6;
        byte[] deviceId = new byte[devicebleMACLen];
        for (int i = 0; i < devicebleMACLen; ++i) {
            deviceId[i] = buf.order(ByteOrder.BIG_ENDIAN).get(devicebleMacOffset + i);
        }
        pkt.bleMac = deviceId;
    }

    private static void decodeDeviceWifiStatusRsp(NetstrapPacket pkt, ByteBuffer buf) {
        int ssidLength = buf.get(5);
        byte[] ssid = new byte[ssidLength];
        for (int i = 0; i < ssidLength; ++i) {
            ssid[i] = buf.get(i + 6);
        }
        pkt.ssid = new String(ssid);
        byte[] bssid = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bssid[i] = buf.get(i + 6 + ssidLength);
        }
        byte[] ip = new byte[12];
        int[] IPaddr = new int[12];
        for (int i = 0; i < 12; ++i) {
            ip[i] = buf.get(i + 12 + ssidLength);
            IPaddr[i] = ip[i] < 0 ? ip[i] + 256 : ip[i];
        }
        pkt.ipaddr = String.format("%d.%d.%d.%d", IPaddr[0], IPaddr[1], IPaddr[2], IPaddr[3]);
        pkt.maskaddr = String.format("%d.%d.%d.%d", IPaddr[4], IPaddr[5], IPaddr[6], IPaddr[7]);
        pkt.gatewayaddr = String.format("%d.%d.%d.%d", IPaddr[8], IPaddr[9], IPaddr[10], IPaddr[11]);
    }

    private static void decodeScanRsp(NetstrapPacket pkt, ByteBuffer buf) {
        try {
            String filename = "output.txt";
            File myFile = new File(Environment.getExternalStorageDirectory(), filename);
            if (!myFile.exists()) {
                myFile.createNewFile();
            }
            FileChannel channel = new FileOutputStream(myFile, true).getChannel();
            buf.flip();
            channel.write(buf);
            channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int ssidLength = buf.get(4);
        byte[] ssid = new byte[ssidLength];
        for (int i = 0; i < ssidLength; ++i) {
            ssid[i] = buf.get(i + 5);
        }
        pkt.ssid = new String(ssid);
        byte[] bssid = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bssid[i] = buf.get(i + 5 + ssidLength);
        }
        pkt.bssid = bssid;
        pkt.authMode = buf.get(11 + ssidLength);
        pkt.rssi = buf.get(12 + ssidLength);
    }

    private static void decodeReadDeviceInfoRsp(NetstrapPacket pkt, ByteBuffer buf) {
        int deviceIdOffset = 4;
        int deviceIdLen = 6;
        int manufactureNameLengthOffset = 10;
        int manufactureNameOffset = 11;
        byte[] deviceId = new byte[deviceIdLen];
        for (int i = 0; i < deviceIdLen; ++i) {
            deviceId[i] = buf.get(deviceIdOffset + i);
        }
        pkt.deviceId = deviceId;
        int manufactureNameLength = buf.get(manufactureNameLengthOffset);
        byte[] manufactureName = new byte[manufactureNameLength];
        for (int i = 0; i < manufactureNameLength; ++i) {
            manufactureName[i] = buf.get(manufactureNameOffset + i);
        }
        pkt.manufactureName = new String(manufactureName);
    }

    private static void decodeOtaVersionRsp(NetstrapPacket pkt, ByteBuffer buf) {
        int statusOffset = 4;
        int projectIdOffset = 5;
        int chipIdOffset = 7;
        int fwIdOffset = 9;
        pkt.status = buf.get(statusOffset);
        pkt.projectId = buf.getInt(projectIdOffset);
        pkt.chipId = buf.getInt(chipIdOffset);
        pkt.fwId = buf.getInt(fwIdOffset);
    }

    public static String getAuthModeDescription(int authMode) {
        String description = "";
        switch (authMode) {
            case 0: {
                description = "OPEN";
                break;
            }
            case 1: {
                description = "WEP";
                break;
            }
            case 2: {
                description = "WPA";
                break;
            }
            case 3: {
                description = "WPA2";
                break;
            }
            case 4: {
                description = "WPA/WPA2";
                break;
            }
            case 5: {
                description = "WPA2-Enterprise";
                break;
            }
        }
        return description;
    }

    public static String getMacAddress(byte[] bssid) {
        return String.format("%02X-%02X-%02X-%02X-%02X-%02X", bssid[0], bssid[1], bssid[2], bssid[3], bssid[4], bssid[5]);
    }

    static void dump(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            System.out.printf("%02X ", buf[i]);
        }
        System.out.println("\n\n");
    }

    public static void main(String[] args) {
        NetstrapPacket otaVerReq = NetstrapPacket.createOtaVersionReqPacket();
        System.out.println(otaVerReq);
        NetstrapPacket.dump(otaVerReq.getBytes());
        List<NetstrapPacket> ls = NetstrapPacket.decodePacket(new byte[]{0, 17, 9, 0, 0, 1, 0, 2, 0, 3, 0});
        for (NetstrapPacket netstrapPacket : ls) {
            System.out.println(netstrapPacket);
        }
        NetstrapPacket otaUpgradeReq = NetstrapPacket.createOtaUpgradeReqPacket(300, new byte[]{1, 2, 3, 4});
        System.out.println(otaUpgradeReq);
        NetstrapPacket.dump(otaUpgradeReq.getBytes());
        ls = NetstrapPacket.decodePacket(new byte[]{1, 17, 1, 0, 0});
        for (NetstrapPacket pkt : ls) {
            System.out.println(pkt);
        }
        NetstrapPacket netstrapPacket = NetstrapPacket.createOtaRawDataReqPacket(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        System.out.println(netstrapPacket);
        NetstrapPacket.dump(netstrapPacket.getBytes());
        NetstrapPacket otaEndReq = NetstrapPacket.createOtaEndReqPacket(0);
        System.out.println(otaEndReq);
        NetstrapPacket.dump(otaEndReq.getBytes());
        ls = NetstrapPacket.decodePacket(new byte[]{2, 17, 1, 0, 0});
        for (NetstrapPacket pkt : ls) {
            System.out.println(pkt);
        }
    }

    static {
        currentLength = 0;
    }
}

