/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.netstrap;

import android.util.Log;
import com.elinkthings.bleotalibrary.netstrap.NetstrapPacket;
import com.elinkthings.bleotalibrary.netstrap.NetstrapState;
import com.elinkthings.bleotalibrary.netstrap.NetstrapTask;
import com.elinkthings.bleotalibrary.netstrap.OPLOtaManager;
import com.elinkthings.bleotalibrary.netstrap.OtaImage;
import com.elinkthings.bleotalibrary.netstrap.OtaService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class NetstrapService
extends Thread {
    private String Tag = this.getName();
    private static final int OTA_MAX_RX_OCTETS = 5;
    private OPLOtaManager bleService;
    private OtaService otaService;
    private boolean isOtaStarted;
    private BlockingQueue<NetstrapTask> taskQueue = new LinkedBlockingDeque<NetstrapTask>();
    private int otaIndex = 0;
    private boolean isOtaPaused;
    int cnt = 0;

    public void setBleService(OPLOtaManager bleService) {
        this.bleService = bleService;
    }

    public OPLOtaManager getBleService() {
        return this.bleService;
    }

    public void setOtaService(OtaService otaService) {
        this.otaService = otaService;
    }

    public boolean isOtaStarted() {
        return this.isOtaStarted;
    }

    public void addTask(NetstrapTask task) {
        try {
            this.taskQueue.put(task);
        }
        catch (InterruptedException e) {
            Log.e((String)NetstrapService.class.getName(), (String)e.getMessage(), (Throwable)e);
        }
    }

    private void otaStart() {
        OtaImage otaImage = this.otaService.getOtaImage();
        if (otaImage != null) {
            byte[] otaHeader = otaImage.getHeader();
            NetstrapPacket pkt = NetstrapPacket.createOtaUpgradeReqPacket(5, otaHeader);
            this.bleService.send(pkt.getBytes());
        }
    }

    public void otaSend() {
        OtaImage otaImage = this.otaService.getOtaImage();
        byte[] rawData = otaImage.getRawData();
        if (rawData != null) {
            this.cnt += rawData.length;
            NetstrapPacket pkt = NetstrapPacket.createOtaRawDataReqPacket(rawData);
            this.bleService.send(pkt.getBytes());
            this.bleService.onOtaProgress((int)(1.0f * (float)this.cnt / (float)otaImage.getSize() * 100.0f));
            this.isOtaStarted = true;
            ++this.otaIndex;
            if (this.otaIndex == 5) {
                this.isOtaPaused = true;
            }
        } else {
            this.isOtaStarted = false;
            this.otaService.resetOtaImage();
            this.otaEnd();
        }
    }

    private void otaEnd() {
        NetstrapPacket pkt = NetstrapPacket.createOtaEndReqPacket(0);
        this.bleService.send(pkt.getBytes());
    }

    private void processRxPacket(NetstrapPacket packet) {
        switch (packet.getCmdId()) {
            case 4352: {
                break;
            }
            case 4353: {
                if (packet.getStatus() != 0) break;
                this.isOtaStarted = true;
                this.isOtaPaused = false;
                this.otaIndex = 0;
                this.otaSend();
                break;
            }
            case 4354: {
                this.otaIndex = 0;
                this.isOtaPaused = false;
                this.otaSend();
                break;
            }
            case 4355: {
                this.bleService.ReqConnBle2BalPriority();
                if (packet.getReason() != 0) {
                    this.isOtaStarted = false;
                    this.bleService.onFail();
                    break;
                }
                this.bleService.onSuccess();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                NetstrapTask task = this.taskQueue.take();
                switch (task.getState()) {
                    case OTA_START: {
                        this.otaStart();
                        break;
                    }
                    case OTA_SEND: {
                        if (this.isOtaPaused) break;
                        this.otaSend();
                        break;
                    }
                    case OTA_END: {
                        break;
                    }
                    case TO_PROCESS_RX_PACKET: {
                        NetstrapPacket packet = (NetstrapPacket)task.getData("netstrapPacket");
                        this.processRxPacket(packet);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Log.e((String)this.getClass().getName(), (String)e.getMessage(), (Throwable)e);
            return;
        }
    }

    public void end() {
        this.addTask(new NetstrapTask(NetstrapState.TO_TERMINATE));
    }
}

