/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.netstrap;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.elinkthings.bleotalibrary.netstrap.NetstrapPacket;
import com.elinkthings.bleotalibrary.netstrap.NetstrapService;
import com.elinkthings.bleotalibrary.netstrap.NetstrapState;
import com.elinkthings.bleotalibrary.netstrap.NetstrapTask;
import com.elinkthings.bleotalibrary.netstrap.OtaImage;
import com.elinkthings.bleotalibrary.netstrap.OtaService;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.listener.OnBleMtuListener;
import com.pingwang.bluetoothlib.listener.OnCharacteristicListener;
import java.io.ByteArrayOutputStream;
import java.util.UUID;

public class OPLOtaManager
implements OnCharacteristicListener {
    private String Tag = this.getClass().getName();
    private BluetoothGatt mBluetoothGatt;
    private byte[] characteristicData;
    private int characteristicCursor;
    private BluetoothGattCharacteristic characteristicTx;
    private BluetoothGattCharacteristic characteristicRx;
    private NetstrapService netstrapService;
    public static final int BLE_MTU_EXTENTED = 243;
    private int mMtu = 23;
    private OnBleOTAListener mOnBleOTAListener;
    private static final UUID SERVICE_UUID = UUID.fromString("0000AAAA-0000-1000-8000-00805F9B34FB");
    private static final UUID CHARACTERISTIC_TX_UUID = UUID.fromString("0000BBB0-0000-1000-8000-00805F9B34FB");
    private static final UUID CHARACTERISTIC_RX_UUID = UUID.fromString("0000BBB1-0000-1000-8000-00805F9B34FB");
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean mVerifySupport = false;
    private BleDevice mBleDevice;
    private OtaService mOtaService;
    private int cnt = 0;

    private OPLOtaManager(Builder builder) {
        Context context = builder.mContext;
        this.mOtaService = new OtaService(context);
        this.mOtaService.setOtaImagePath(builder.mFilePath);
        this.netstrapService = new NetstrapService();
        this.netstrapService.setOtaService(this.mOtaService);
        this.netstrapService.setBleService(this);
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.mBleDevice = builder.mBleDevice;
        if (this.mBleDevice != null) {
            this.mBluetoothGatt = this.mBleDevice.getBluetoothGatt();
            BluetoothGattService gatt = this.mBluetoothGatt.getService(SERVICE_UUID);
            if (gatt != null) {
                this.characteristicTx = gatt.getCharacteristic(CHARACTERISTIC_TX_UUID);
                this.characteristicRx = gatt.getCharacteristic(CHARACTERISTIC_RX_UUID);
                this.mBleDevice.setNotify(SERVICE_UUID, new UUID[]{CHARACTERISTIC_RX_UUID});
                this.mVerifySupport = true;
            } else {
                Log.e((String)this.Tag, (String)"\u4e0d\u652f\u6301Dialog OTA");
                this.mVerifySupport = false;
            }
        }
        if (this.mVerifySupport && this.mBleDevice != null) {
            this.mBleDevice.setOnBleMtuListener(new OnBleMtuListener(){

                public void OnMtu(int mtu) {
                    OPLOtaManager.this.mMtu = mtu;
                }
            });
            if (Build.VERSION.SDK_INT >= 21) {
                this.mBleDevice.setConnectPriority(1);
                this.mBleDevice.setMtu(243);
            }
        }
    }

    public void startOta() {
        if (!this.mVerifySupport || this.mBleDevice == null) {
            return;
        }
        this.mBleDevice.setOnCharacteristicListener((OnCharacteristicListener)this);
        if (this.netstrapService != null) {
            this.netstrapService.start();
        }
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public void onCharacteristicReadOK(BluetoothGattCharacteristic characteristic) {
    }

    public void onCharacteristicWriteOK(BluetoothGattCharacteristic characteristic) {
        if (characteristic.getUuid().equals(CHARACTERISTIC_TX_UUID)) {
            this.writeBleCharacteristicIfRemained();
        }
    }

    public void onDescriptorWriteOK(BluetoothGattDescriptor descriptor) {
        UUID uuid = descriptor.getCharacteristic().getUuid();
        if (uuid.equals(CHARACTERISTIC_RX_UUID)) {
            this.netstrapService.addTask(new NetstrapTask(NetstrapState.OTA_START));
        }
    }

    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic) {
        if (characteristic.getUuid().equals(CHARACTERISTIC_RX_UUID)) {
            for (NetstrapPacket packet : NetstrapPacket.decodePacket(characteristic.getValue())) {
                NetstrapTask task = new NetstrapTask(NetstrapState.TO_PROCESS_RX_PACKET);
                task.setData("netstrapPacket", packet);
                this.netstrapService.addTask(task);
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    void ReqConnBle2BalPriority() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBluetoothGatt.requestConnectionPriority(0);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    void ReqConnBle2HighPriority() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBluetoothGatt.requestConnectionPriority(1);
            this.mBluetoothGatt.requestMtu(243);
        }
    }

    void send(byte[] data) {
        this.characteristicData = data;
        this.characteristicCursor = 0;
        this.mHandler.postDelayed(() -> this.writeBleCharacteristicIfRemained(), 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBleCharacteristicIfRemained() {
        if (this.characteristicTx == null) {
            return;
        }
        Class<OPLOtaManager> clazz = OPLOtaManager.class;
        synchronized (OPLOtaManager.class) {
            if (this.characteristicData != null) {
                try {
                    int availableTransmitLength = this.mMtu - 3;
                    int lastCursor = this.characteristicCursor;
                    int fragLength = this.characteristicCursor + availableTransmitLength <= this.characteristicData.length ? availableTransmitLength : this.characteristicData.length - this.characteristicCursor;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    out.write(this.characteristicData, lastCursor, fragLength);
                    byte[] bytes = out.toByteArray();
                    this.characteristicTx.setValue(bytes);
                    this.characteristicTx.setWriteType(1);
                    boolean b = this.mBluetoothGatt.writeCharacteristic(this.characteristicTx);
                    this.characteristicCursor += fragLength;
                    if (this.characteristicCursor == this.characteristicData.length) {
                        this.characteristicData = null;
                        this.characteristicCursor = 0;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.sendCompletedEvent();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isVerifySupport() {
        return this.mVerifySupport;
    }

    private void sendCompletedEvent() {
        if (this.netstrapService.isOtaStarted()) {
            this.netstrapService.addTask(new NetstrapTask(NetstrapState.OTA_SEND));
        }
    }

    void onFail() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                OPLOtaManager.this.mOnBleOTAListener.onOtaFailure(0, "");
            }
        });
    }

    void onSuccess() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                OPLOtaManager.this.mOnBleOTAListener.onOtaSuccess();
            }
        });
    }

    void onOtaProgress(final int progress) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                OPLOtaManager.this.mOnBleOTAListener.onOtaProgress(progress, 0, 0);
            }
        });
    }

    private void otaStart() {
        OtaImage otaImage = this.mOtaService.getOtaImage();
        if (otaImage != null) {
            byte[] otaHeader = otaImage.getHeader();
            this.send(otaHeader);
        }
    }

    public void otaSend() {
        OtaImage otaImage = this.mOtaService.getOtaImage();
        byte[] rawData = otaImage.getRawData();
        if (rawData != null) {
            this.cnt += rawData.length;
            NetstrapPacket pkt = NetstrapPacket.createOtaRawDataReqPacket(rawData);
            this.send(pkt.getBytes());
            this.onOtaProgress((int)(1.0f * (float)this.cnt / (float)otaImage.getSize() * 100.0f));
        }
    }

    public static final class Builder {
        private Context mContext;
        private BleDevice mBleDevice;
        private OnBleOTAListener mOnBleOTAListener;
        private Uri mFileUri;
        private String mFilePath;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setFileUri(Uri fileUri) {
            this.mFileUri = fileUri;
            return this;
        }

        public Builder setFilePath(String path) {
            this.mFilePath = path;
            return this;
        }

        public OPLOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            return new OPLOtaManager(this);
        }
    }
}

