/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.netstrap;

import java.nio.ByteBuffer;

public class OtaImage {
    public static final int OTA_IMAGE_BLOCK_LENGTH = 240;
    private long projectId;
    private long chipId;
    private long firmwareId;
    private long checksum;
    private byte[] header;
    private byte[] content;
    private int cursor;

    public OtaImage(long projectId, long chipId, long firmwareId, long checksum, byte[] header, byte[] content) {
        this.projectId = projectId;
        this.chipId = chipId;
        this.firmwareId = firmwareId;
        this.checksum = checksum;
        this.header = header;
        this.content = content;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public long getChipId() {
        return this.chipId;
    }

    public long getFirmwareId() {
        return this.firmwareId;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public int getSize() {
        return this.content.length;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getRawData() {
        if (this.cursor < this.content.length) {
            int len = 240;
            if (this.cursor + len >= this.content.length) {
                len = this.content.length - this.cursor;
            }
            byte[] buf = ByteBuffer.allocate(len).put(this.content, this.cursor, len).array();
            this.cursor += len;
            return buf;
        }
        return null;
    }

    public String toString() {
        return "OtaImage{projectId=" + String.format("0x%04X", this.projectId) + ", chipId=" + String.format("0x%04X", this.chipId) + ", firmwareId=" + String.format("0x%04X", this.firmwareId) + ", checksum=" + String.format("0x%08X", this.checksum) + ", cursor=" + this.cursor + '}';
    }
}

