/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.netstrap;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.elinkthings.bleotalibrary.netstrap.OtaImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;

public class OtaService {
    private final int BOOT_AGENT_LENGTH = 12288;
    private final int IMAGE_HEADER_LENGTH = 24;
    private final int IMAGE_HEADER_RESERVED_LENGTH = 8168;
    private Uri otaImagePath;
    private String filePath;
    private OtaImage otaImage = null;
    private Context mContext;

    public OtaService(Context context) {
        this.mContext = context;
    }

    public void setOtaImagePath(Uri otaImagePath) {
        this.otaImagePath = otaImagePath;
    }

    public void setOtaImagePath(String filePath) {
        this.filePath = filePath;
    }

    public OtaImage getOtaImage() {
        if (this.otaImage == null) {
            try {
                long checksum;
                long imageSize;
                long fwId;
                long chipId;
                long projectId;
                BufferedInputStream in;
                if (this.filePath != null) {
                    in = new BufferedInputStream(new FileInputStream(this.filePath));
                } else {
                    ParcelFileDescriptor parcelFileDescriptor = this.mContext.getContentResolver().openFileDescriptor(this.otaImagePath, "r");
                    FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                    in = new BufferedInputStream(new FileInputStream(fileDescriptor));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int len = 0;
                byte[] header = new byte[24];
                byte[] buf = new byte[1024];
                try {
                    in.skip(12288L);
                }
                catch (IOException e) {
                    throw new Exception("OTA Image broken, boot agent size is not correct.");
                }
                try {
                    int b = in.read(header, 0, 24);
                    projectId = header[4] & 0xFF | (header[5] & 0xFF) << 8;
                    chipId = header[6] & 0xFF | (header[7] & 0xFF) << 8;
                    fwId = header[8] & 0xFF | (header[9] & 0xFF) << 8;
                    imageSize = header[12] & 0xFF | (header[13] & 0xFF) << 8 | (header[14] & 0xFF) << 16 | (header[15] & 0xFF) << 24;
                    checksum = header[16] & 0xFF | (header[17] & 0xFF) << 8 | (header[18] & 0xFF) << 16 | (header[19] & 0xFF) << 24;
                }
                catch (IOException e) {
                    throw new Exception("OTA Image broken, image header size is not correct.");
                }
                try {
                    in.skip(8168L);
                }
                catch (IOException e) {
                    throw new Exception("OTA Image broken, image header reserved  size is not correct.");
                }
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                in.close();
                byte[] allImage = out.toByteArray();
                if (imageSize != (long)allImage.length) {
                    throw new Exception("OTA Image broken, imageSize: " + imageSize + ", allSize: " + allImage.length + ", projectId: " + projectId + ", chipId: " + chipId + ", fwId: " + fwId + ", checksum: " + checksum);
                }
                this.otaImage = new OtaImage(projectId, chipId, fwId, checksum, header, allImage);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.otaImage;
    }

    public void resetOtaImage() {
        this.otaImage = null;
    }
}

