/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.rtk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.realsil.sdk.core.RtkConfigure;
import com.realsil.sdk.core.RtkCore;
import com.realsil.sdk.dfu.DfuException;
import com.realsil.sdk.dfu.RtkDfu;
import com.realsil.sdk.dfu.image.BinFactory;
import com.realsil.sdk.dfu.image.LoadParams;
import com.realsil.sdk.dfu.model.BinInfo;
import com.realsil.sdk.dfu.model.DfuConfig;
import com.realsil.sdk.dfu.model.DfuProgressInfo;
import com.realsil.sdk.dfu.model.FileTypeInfo;
import com.realsil.sdk.dfu.model.OtaDeviceInfo;
import com.realsil.sdk.dfu.model.OtaModeInfo;
import com.realsil.sdk.dfu.model.Throughput;
import com.realsil.sdk.dfu.utils.BaseDfuAdapter;
import com.realsil.sdk.dfu.utils.ConnectParams;
import com.realsil.sdk.dfu.utils.DfuAdapter;
import com.realsil.sdk.dfu.utils.GattDfuAdapter;
import java.util.ArrayList;
import java.util.List;

public class RtkOtaManager {
    public static final int OTA_MODE_NORMAL_FUNCTION = 0;
    public static final int OTA_MODE_SILENT_FUNCTION = 16;
    public static final int OTA_MODE_SILENT_EXTEND_FLASH = 17;
    public static final int OTA_MODE_SILENT_NO_TEMP = 18;
    public static final int OTA_MODE_AUTOMATIC = 255;
    private String mMac = "";
    private String mFilePath = "";
    private OnBleOTAListener mOnBleOTAListener;
    private int mOtaType = 0;
    private int mFileLocation = -1;
    private Context mContext;
    private DfuConfig mDfuConfig;
    private GattDfuAdapter mDfuAdapter;
    private OtaDeviceInfo mOtaDeviceInfo = null;
    private ConnectParams mConnectParams = null;
    private BinInfo mBinInfo;
    private boolean mStartOta = false;
    private int mStepSize = 0;
    private int mStep = -1;
    private List<FileTypeInfo> mFileTypeInfos;
    private List<String> mListVersion = new ArrayList<String>();
    private BaseDfuAdapter.DfuHelperCallback mDfuHelperCallback = new BaseDfuAdapter.DfuHelperCallback(){

        public void onStateChanged(int state) {
            super.onStateChanged(state);
            if (state == 258) {
                if (!TextUtils.isEmpty((CharSequence)RtkOtaManager.this.mMac)) {
                    RtkOtaManager.this.mConnectParams = new ConnectParams.Builder().address(RtkOtaManager.this.mMac).hid(false).reconnectTimes(3).localName(RtkOtaManager.this.mDfuConfig.getLocalName()).build();
                    boolean bl = RtkOtaManager.this.mDfuAdapter.connectDevice(RtkOtaManager.this.mConnectParams);
                }
            } else if (state == 1024) {
                RtkOtaManager.this.mOtaDeviceInfo = RtkOtaManager.this.mDfuAdapter.getOtaDeviceInfo();
                List supportedModes = RtkOtaManager.this.mDfuAdapter.getSupportedModes();
                if (RtkOtaManager.this.mOnBleOTAListener != null && RtkOtaManager.this.mOnBleOTAListener instanceof OnRtkOtaInfoListener) {
                    ((OnRtkOtaInfoListener)RtkOtaManager.this.mOnBleOTAListener).OnOtaType(supportedModes);
                }
                if (!TextUtils.isEmpty((CharSequence)RtkOtaManager.this.mMac) && !TextUtils.isEmpty((CharSequence)RtkOtaManager.this.mFilePath) && RtkOtaManager.this.mFileLocation != -1 && RtkOtaManager.this.mStartOta) {
                    RtkOtaManager.this.startOta();
                }
            } else if (state == 2049 || state == 2050) {
                RtkOtaManager.this.mOtaDeviceInfo = null;
            }
        }

        public void onTargetInfoChanged(OtaDeviceInfo otaDeviceInfo) {
            super.onTargetInfoChanged(otaDeviceInfo);
        }

        public void onError(int i, int i1) {
            super.onError(i, i1);
            RtkOtaManager.this.runOnMainThread(() -> {
                RtkOtaManager.this.close();
                if (RtkOtaManager.this.mOnBleOTAListener != null) {
                    RtkOtaManager.this.mOnBleOTAListener.onOtaFailure(i, "");
                }
            });
        }

        public void onProcessStateChanged(int state, Throughput throughput) {
            super.onProcessStateChanged(state, throughput);
            RtkOtaManager.this.runOnMainThread(() -> {
                if (state == 258) {
                    if (RtkOtaManager.this.mOnBleOTAListener != null) {
                        RtkOtaManager.this.mOnBleOTAListener.onOtaSuccess();
                    }
                    RtkOtaManager.this.close();
                } else if (state == 260 || state == 259) {
                    RtkOtaManager.this.close();
                    if (RtkOtaManager.this.mOnBleOTAListener != null) {
                        RtkOtaManager.this.mOnBleOTAListener.onOtaFailure(state, "");
                    }
                } else if (state != 523 && RtkOtaManager.this.mOnBleOTAListener != null) {
                    RtkOtaManager.this.mOnBleOTAListener.onOtaStatus(state);
                }
            });
        }

        public void onProgressChanged(DfuProgressInfo dfuProgressInfo) {
            super.onProgressChanged(dfuProgressInfo);
            int progress = dfuProgressInfo.getProgress();
            RtkOtaManager.this.runOnMainThread(() -> {
                if (RtkOtaManager.this.mOnBleOTAListener != null) {
                    RtkOtaManager.this.mOnBleOTAListener.onOtaProgress(progress, Math.min(dfuProgressInfo.getCurrentFileIndex() + 1, dfuProgressInfo.getMaxFileCount()), dfuProgressInfo.getMaxFileCount());
                }
            });
        }
    };
    private Handler threadHandler = new Handler(Looper.getMainLooper());

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public RtkOtaManager(Builder builder) {
        this.mContext = builder.mContext;
        this.mMac = builder.mMac;
        this.mFileLocation = builder.mFileLocation;
        this.mFilePath = builder.mFilePath;
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.mDfuConfig = new DfuConfig();
        this.mDfuAdapter = GattDfuAdapter.getInstance((Context)this.mContext);
        this.mDfuAdapter.initialize(this.mDfuHelperCallback);
        this.mBinInfo = builder.mBinInfo;
        this.mFileTypeInfos = builder.mFileTypeInfos;
        for (FileTypeInfo fileTypeInfo : this.mFileTypeInfos) {
            this.mListVersion.add(fileTypeInfo.getName());
        }
        this.mStepSize = this.mFileTypeInfos.size();
        RtkConfigure configure = new RtkConfigure.Builder().debugEnabled(false).printLog(true).logTag("OTA").build();
        RtkCore.initialize((Context)this.mContext, (RtkConfigure)configure);
        RtkDfu.initialize((Context)this.mContext, (boolean)false);
    }

    public int getStepSize() {
        return this.mStepSize;
    }

    public void startOta() {
        this.startOta(this.mOtaType, this.mStep);
    }

    public void startOta(int otaType, int step) {
        this.mOtaType = otaType;
        this.mStep = step;
        if (this.mOtaDeviceInfo == null) {
            this.mStartOta = true;
            return;
        }
        this.mStartOta = true;
        this.mDfuConfig.setProtocolType(this.mOtaDeviceInfo.getProtocolType());
        this.mDfuConfig.setChannelType(0);
        this.mDfuConfig.setFileLocation(this.mFileLocation);
        this.mDfuConfig.setFilePath(this.mBinInfo.path);
        this.mDfuConfig.setAddress(this.mMac);
        this.mDfuConfig.setBreakpointResumeEnabled(true);
        this.mDfuConfig.setAutomaticActiveEnabled(true);
        this.mDfuConfig.setBatteryCheckEnabled(false);
        this.mDfuConfig.setLowBatteryThreshold(10);
        this.mDfuConfig.setBatteryLevelFormat(0);
        this.mDfuConfig.setVersionCheckEnabled(false);
        this.mDfuConfig.setIcCheckEnabled(true);
        this.mDfuConfig.setSectionSizeCheckEnabled(true);
        this.mDfuConfig.setThroughputEnabled(false);
        this.mDfuConfig.setMtuUpdateEnabled(true);
        this.mDfuConfig.setWaitActiveCmdAckEnabled(false);
        this.mDfuConfig.setFileSuffix("bin");
        if (step >= 0) {
            if (this.mFileTypeInfos.size() > step) {
                FileTypeInfo fileTypeInfo = this.mFileTypeInfos.get(step);
                this.mDfuConfig.setFileIndicator(1 << fileTypeInfo.getBitNumber());
            }
        } else {
            this.mDfuConfig.setFileIndicator(-1);
        }
        this.mDfuConfig.setOtaWorkMode(otaType);
        this.mDfuConfig.setBufferCheckLevel(16);
        this.mDfuConfig.setSpeedControlEnabled(false);
        this.mDfuConfig.setControlSpeed(0);
        this.mDfuConfig.setConParamUpdateLatencyEnabled(false);
        this.mDfuConfig.setLatencyTimeout(0);
        boolean ret = this.mDfuAdapter.startOtaProcedure(this.mDfuConfig, true);
        if (ret) {
            // empty if block
        }
    }

    public void close() {
        if (this.mDfuAdapter != null) {
            this.mDfuAdapter.abort();
            this.mDfuAdapter.close();
        }
    }

    private void runOnMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            this.threadHandler.post(runnable);
        }
    }

    public static interface OnRtkOtaInfoListener
    extends OnBleOTAListener {
        default public void OnOtaType(List<OtaModeInfo> otaModeInfoList) {
        }
    }

    public static final class Builder {
        private BinInfo mBinInfo;
        private String mMac = "";
        private String mFilePath = "";
        private OnBleOTAListener mOnBleOTAListener;
        private int mFileLocation = -1;
        private Context mContext;
        private List<FileTypeInfo> mFileTypeInfos;

        public Builder(Context context) {
            this.mContext = context;
        }

        public RtkOtaManager build() {
            return new RtkOtaManager(this);
        }

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setOtaPathAssets(String mac, String fileName) {
            this.mMac = mac;
            this.mFilePath = fileName;
            this.mFileLocation = 1;
            try {
                LoadParams.Builder bin = new LoadParams.Builder().with(this.mContext).fileLocation(this.mFileLocation).setFilePath(this.mFilePath).setFileSuffix("bin").setIcCheckEnabled(true);
                this.mBinInfo = BinFactory.loadImageBinInfo((LoadParams)bin.build());
                this.mFileTypeInfos = DfuAdapter.getSupportedFileContents((BinInfo)this.mBinInfo);
            }
            catch (DfuException e) {
                e.printStackTrace();
            }
            return this;
        }

        public Builder setOtaPathSdcard(String mac, String filePath) {
            this.mMac = mac;
            this.mFilePath = filePath;
            this.mFileLocation = 0;
            try {
                LoadParams.Builder bin = new LoadParams.Builder().with(this.mContext).fileLocation(this.mFileLocation).setFilePath(this.mFilePath).setFileSuffix("bin").setIcCheckEnabled(true);
                this.mBinInfo = BinFactory.loadImageBinInfo((LoadParams)bin.build());
                this.mFileTypeInfos = DfuAdapter.getSupportedFileContents((BinInfo)this.mBinInfo);
            }
            catch (DfuException e) {
                e.printStackTrace();
            }
            return this;
        }
    }
}

