/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.zhlx;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.Arrays;

class BleDeviceFinder {
    public static final int ERROR_TIMEOUT = Integer.MIN_VALUE;
    private static final int manufacturerId = 1602;
    private static final int DEFAULT_TIMEOUT = 10000;
    private final byte[] addressData;
    private final DeviceFinderCallback finderCallback;
    private final Handler timeoutHandler;
    private int timeout = 10000;
    private final ScanCallback callback = new ScanCallback(){

        public void onScanResult(int callbackType, ScanResult result) {
            byte[] data = result.getScanRecord().getManufacturerSpecificData(1602);
            if (Arrays.equals(data, BleDeviceFinder.this.addressData)) {
                BleDeviceFinder.this.stopFindDevice();
                if (BleDeviceFinder.this.finderCallback != null) {
                    BluetoothDevice device = result.getDevice();
                    BleDeviceFinder.this.finderCallback.onFound(device);
                }
            }
        }

        public void onScanFailed(int errorCode) {
            BleDeviceFinder.this.stopFindDevice();
            if (BleDeviceFinder.this.finderCallback != null) {
                BleDeviceFinder.this.finderCallback.onError(errorCode);
            }
        }
    };

    public BleDeviceFinder(byte[] addressData, DeviceFinderCallback finderCallback) {
        this.addressData = addressData;
        this.finderCallback = finderCallback;
        this.timeoutHandler = new Handler(Looper.getMainLooper());
    }

    @SuppressLint(value={"MissingPermission"})
    public void startFindDevice() {
        ScanSettings settings = new ScanSettings.Builder().setScanMode(2).setReportDelay(0L).build();
        ArrayList filters = new ArrayList();
        BluetoothLeScanner scanner = BluetoothAdapter.getDefaultAdapter().getBluetoothLeScanner();
        scanner.startScan(filters, settings, this.callback);
        this.timeoutHandler.postDelayed(this::handleTimeout, (long)this.timeout);
    }

    @SuppressLint(value={"MissingPermission"})
    public void stopFindDevice() {
        this.cancelTimeout();
        BluetoothLeScanner scanner = BluetoothAdapter.getDefaultAdapter().getBluetoothLeScanner();
        scanner.stopScan(this.callback);
    }

    private void handleTimeout() {
        this.stopFindDevice();
        if (this.finderCallback != null) {
            this.finderCallback.onError(Integer.MIN_VALUE);
        }
    }

    private void cancelTimeout() {
        this.timeoutHandler.removeCallbacksAndMessages(null);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static interface DeviceFinderCallback {
        public void onFound(BluetoothDevice var1);

        public void onError(int var1);
    }
}

