/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.zhlx;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.elinkthings.bleotalibrary.zhlx.BleDeviceFinder;
import com.elinkthings.bleotalibrary.zhlx.HexUtils;
import com.elinkthings.bleotalibrary.zhlx.OtaError;
import com.elinkthings.bleotalibrary.zhlx.OtaManager;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.util.UUID;

public final class BleOtaManager
extends OtaManager
implements BleDeviceFinder.DeviceFinderCallback {
    private static final String TAG = BleOtaManager.class.getSimpleName();
    private static final UUID OTA_SERVICE_UUID = UUID.fromString("0000ff12-0000-1000-8000-00805f9b34fb");
    private static final UUID OTA_DATA_IN_UUID = UUID.fromString("0000ff14-0000-1000-8000-00805f9b34fb");
    private static final UUID OTA_DATA_OUT_UUID = UUID.fromString("0000ff15-0000-1000-8000-00805f9b34fb");
    private static final UUID CLIENT_CHARACTERISTIC_CONFIG_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private BluetoothGatt bluetoothGatt;
    private BluetoothGattService otaService;
    private BluetoothGattCharacteristic dataInCharacteristic;
    private BluetoothGattCharacteristic dataOutCharacteristic;
    private int mMtuSize = 23;
    private boolean mAutoConnect = false;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private long mOldTime = 0L;
    private BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        @SuppressLint(value={"MissingPermission"})
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            BleLog.i((String)("onConnectionStateChange:status=" + status + "  ||  newState=" + newState));
            if (newState == 2) {
                if (System.currentTimeMillis() - BleOtaManager.this.mOldTime > 200L) {
                    BleOtaManager.this.mOldTime = System.currentTimeMillis();
                    BleOtaManager.this.bluetoothGatt.discoverServices();
                }
            } else if (newState == 0) {
                BleOtaManager.this.setDeviceReady(false);
                BleOtaManager.this.isUpdating = false;
                if (BleOtaManager.this.dataProvider == null || !BleOtaManager.this.dataProvider.isAllDataSent()) {
                    BleOtaManager.this.notifyOnStop();
                } else {
                    BleOtaManager.this.dataProvider.reset();
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            BleLog.i((String)("onServicesDiscovered:" + status));
            if (status == 0) {
                BleOtaManager.this.findCharacteristics();
            } else {
                BleOtaManager.this.setDeviceReady(false);
                BleOtaManager.this.isUpdating = false;
                BleOtaManager.this.notifyOnStop();
                BleOtaManager.this.release();
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                BleOtaManager.this.runDataSend();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] data = characteristic.getValue();
            boolean ret = BleOtaManager.this.processData(data);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (status == 0) {
                boolean ret = BleOtaManager.this.bluetoothGatt.requestMtu(517);
                BleLog.i((String)("requestMtu(517) = " + ret));
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            BleLog.i((String)("onMtuChanged: mtu = " + mtu));
            BleOtaManager.this.mMtuSize = mtu;
            if (status == 0) {
                if (BleOtaManager.this.dataProvider != null) {
                    BleOtaManager.this.dataProvider.setPacketSize(BleOtaManager.this.getPacketSizeFromMtu(mtu));
                }
                BleOtaManager.this.setDeviceReady(true);
                if (BleOtaManager.this.needIdentification()) {
                    BleLog.i((String)"\u53d1\u9001OTA\u8bc6\u522b\u4fe1\u606f");
                    BleOtaManager.this.sendOtaIdentification();
                } else {
                    BleLog.i((String)"\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f");
                    BleOtaManager.this.getAllInfo();
                }
                if (BleOtaManager.this.isTwsDevice == null) {
                    BleOtaManager.this.checkIfReadyToUpdate();
                }
            }
        }
    };
    private BleDeviceFinder deviceFinder;

    public BleOtaManager(Context context, BluetoothDevice device, OtaManager.EventListener eventListener) {
        super(context, device, eventListener);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void init() {
        BleLog.i((String)"\u521d\u59cb\u5316\u8fde\u63a5\u8bbe\u5907");
        if (this.device == null) {
            BleLog.i((String)"device==null");
            return;
        }
        this.bluetoothGatt = Build.VERSION.SDK_INT >= 23 ? (Build.MANUFACTURER.equalsIgnoreCase("HUAWEI") ? this.device.connectGatt(this.context, true, this.gattCallback, 2) : this.device.connectGatt(this.context, false, this.gattCallback, 2)) : this.device.connectGatt(this.context, false, this.gattCallback);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void release() {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
            this.bluetoothGatt = null;
        }
        this.otaService = null;
        this.dataInCharacteristic = null;
        this.dataOutCharacteristic = null;
        super.release();
    }

    @Override
    public void startOTA() {
        if (this.bluetoothGatt == null) {
            this.notifyOnError(OtaError.NOT_INIT);
            return;
        }
        if (this.dataInCharacteristic == null) {
            this.notifyOnError(OtaError.NOT_FOUND_OTA_DATA_IN);
            return;
        }
        if (this.dataOutCharacteristic == null) {
            this.notifyOnError(OtaError.NOT_FOUND_OTA_DATA_OUT);
            return;
        }
        super.startOTA();
    }

    @Override
    public int getPacketSize() {
        return this.getPacketSizeFromMtu(this.mMtuSize);
    }

    @SuppressLint(value={"MissingPermission"})
    private void findCharacteristics() {
        BleLog.i((String)"findCharacteristics:start");
        this.otaService = this.bluetoothGatt.getService(OTA_SERVICE_UUID);
        if (this.otaService == null) {
            this.notifyOnError(OtaError.NOT_FOUND_OTA_SERVICE);
            return;
        }
        this.dataInCharacteristic = this.otaService.getCharacteristic(OTA_DATA_IN_UUID);
        this.dataOutCharacteristic = this.otaService.getCharacteristic(OTA_DATA_OUT_UUID);
        if (this.dataInCharacteristic == null || this.dataOutCharacteristic == null) {
            this.notifyOnError(OtaError.NOT_FOUND_OTA_CHARACTERISTIC);
            return;
        }
        boolean enabled = this.bluetoothGatt.setCharacteristicNotification(this.dataInCharacteristic, true);
        if (!enabled) {
            this.notifyOnError(OtaError.CAN_NOT_SUBSCRIBE_DATA_IN);
            return;
        }
        BluetoothGattDescriptor descriptor = this.dataInCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID);
        if (descriptor == null) {
            this.notifyOnError(OtaError.NOT_FOUND_CLIENT_CHARACTERISTIC_CONFIG);
            return;
        }
        descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        boolean b = this.bluetoothGatt.writeDescriptor(descriptor);
        BleLog.i((String)("findCharacteristics:end=" + b));
    }

    private int getPacketSizeFromMtu(int mtu) {
        return mtu - 3;
    }

    @Override
    protected boolean canSendNow() {
        return this.allowedUpdate && !this.dataProvider.isBlockSendFinish();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    protected void btSendData(byte[] data) {
        if (this.dataOutCharacteristic != null) {
            Log.v((String)TAG, (String)("btSendData = " + HexUtils.bytesToHex(data)));
            this.dataOutCharacteristic.setValue(data);
            this.dataOutCharacteristic.setWriteType(1);
            this.bluetoothGatt.writeCharacteristic(this.dataOutCharacteristic);
        }
    }

    @Override
    protected void onOneFinish() {
        this.release();
        this.deviceFinder = new BleDeviceFinder(this.bluetoothAddress, this);
        new Handler(Looper.getMainLooper()).postDelayed(this.deviceFinder::startFindDevice, 1000L);
    }

    @Override
    public void onFound(BluetoothDevice device) {
        BleLog.i((String)("\u627e\u5230\u8bbe\u5907:" + device.getAddress()));
        this.device = device;
        this.deviceFinder = null;
        this.init();
    }

    @Override
    public void onError(int errorCode) {
        this.deviceFinder = null;
        if (errorCode == Integer.MIN_VALUE) {
            this.notifyOnError(OtaError.TIMEOUT_SCAN_NON_PRIMARY_DEVICE);
        } else {
            this.notifyOnError(OtaError.NOT_FOUND_NON_PRIMARY_DEVICE);
        }
    }
}

