/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.zhlx;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import android.util.Log;
import com.elinkthings.bleotalibrary.zhlx.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;

class BluetoothSppService {
    private static final String TAG = BluetoothSppService.class.getSimpleName();
    private static final UUID BLUETOOTH_SPP_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int STATE_NONE = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    private final Handler mHandler;
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;
    private int mState;
    private int mNewState;

    public BluetoothSppService(Handler handler) {
        this.mNewState = this.mState = 0;
        this.mHandler = handler;
    }

    private synchronized void notifyState() {
        this.mState = this.getState();
        if (this.mState != this.mNewState) {
            Log.d((String)TAG, (String)("notifyState() " + this.mNewState + " -> " + this.mState));
            this.mNewState = this.mState;
            this.mHandler.obtainMessage(1, this.mNewState, -1).sendToTarget();
        }
    }

    public synchronized int getState() {
        return this.mState;
    }

    public synchronized void connect(BluetoothDevice device) {
        Log.d((String)TAG, (String)("connect to: " + device));
        if (this.mState == 1 && this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.notifyState();
    }

    public synchronized void connected(BluetoothSocket socket, BluetoothDevice device) {
        Log.d((String)TAG, (String)"connected");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.notifyState();
    }

    public synchronized void stop() {
        Log.d((String)TAG, (String)"stop");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mState = 0;
        this.notifyState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] out) {
        ConnectedThread r;
        BluetoothSppService bluetoothSppService = this;
        synchronized (bluetoothSppService) {
            if (this.mState != 2) {
                return;
            }
            r = this.mConnectedThread;
        }
        r.write(out);
    }

    private void connectionFailed() {
        this.mState = 0;
        this.notifyState();
    }

    private void connectionLost() {
        this.mState = 0;
        this.notifyState();
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(BluetoothSocket socket) {
            Log.d((String)TAG, (String)"create ConnectedThread");
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
            BluetoothSppService.this.mState = 2;
            BluetoothSppService.this.notifyState();
        }

        @Override
        public void run() {
            Log.i((String)TAG, (String)"BEGIN mConnectedThread");
            byte[] buffer = new byte[1024];
            while (BluetoothSppService.this.mState == 2) {
                try {
                    int bytes = this.mmInStream.read(buffer);
                    byte[] data = Arrays.copyOf(buffer, bytes);
                    Log.v((String)"SPP_READ", (String)HexUtils.bytesToHex(data));
                    BluetoothSppService.this.mHandler.obtainMessage(2, (Object)data).sendToTarget();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"disconnected", (Throwable)e);
                    BluetoothSppService.this.connectionLost();
                    break;
                }
            }
        }

        public void write(byte[] buffer) {
            try {
                this.mmOutStream.write(buffer);
                BluetoothSppService.this.mHandler.obtainMessage(3, -1, -1, (Object)buffer).sendToTarget();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception during write", (Throwable)e);
            }
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private final BluetoothSocket mSocket;
        private final BluetoothDevice mDevice;

        @SuppressLint(value={"MissingPermission"})
        public ConnectThread(BluetoothDevice device) {
            this.mDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createInsecureRfcommSocketToServiceRecord(BLUETOOTH_SPP_UUID);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"create() failed", (Throwable)e);
            }
            this.mSocket = tmp;
            BluetoothSppService.this.mState = 1;
            BluetoothSppService.this.notifyState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"MissingPermission"})
        public void run() {
            Log.i((String)TAG, (String)"BEGIN mConnectThread");
            try {
                this.mSocket.connect();
            }
            catch (IOException e) {
                try {
                    this.mSocket.close();
                }
                catch (IOException e2) {
                    Log.e((String)TAG, (String)"unable to close() socket during connection failure", (Throwable)e2);
                }
                BluetoothSppService.this.connectionFailed();
                return;
            }
            BluetoothSppService bluetoothSppService = BluetoothSppService.this;
            synchronized (bluetoothSppService) {
                BluetoothSppService.this.mConnectThread = null;
            }
            BluetoothSppService.this.connected(this.mSocket, this.mDevice);
        }

        public void cancel() {
            try {
                this.mSocket.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }
}

