/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.zhlx;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.elinkthings.bleotalibrary.zhlx.HexUtils;
import com.elinkthings.bleotalibrary.zhlx.OtaCommandGenerator;
import com.elinkthings.bleotalibrary.zhlx.OtaDataProvider;
import com.elinkthings.bleotalibrary.zhlx.OtaError;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class OtaManager {
    private static final String TAG = OtaManager.class.getSimpleName();
    private boolean receivedChannelInfo = false;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int UNDEFINED_FIRMWARE_VERSION = -1;
    protected final Context context;
    private final EventListener eventListener;
    private final Handler notifyHandler;
    private final Handler timeoutHandler;
    protected BluetoothDevice device;
    protected OtaDataProvider dataProvider;
    protected OtaCommandGenerator commandGenerator;
    protected int otaFirmwareVersion = -1;
    protected int deviceFirmwareVersion = -1;
    protected boolean allowedUpdate;
    private int mBlockSize = 4096;
    private int mPacketSize = 240;
    protected boolean isUpdating = false;
    protected boolean isUpdatePause = false;
    protected boolean isPrimaryUpdated = false;
    protected Boolean isTwsDevice = null;
    protected Boolean isTwsConnected = null;
    protected byte[] bluetoothAddress;
    private boolean isDeviceReady;
    public boolean disconnectedDueToDeviceError = false;
    private boolean _needIdentification = true;
    protected boolean sentIdentification = false;
    protected static final int DELAY_AFTER_SEND_IDENTIFICATION = 200;

    public OtaManager(Context context, BluetoothDevice device, EventListener eventListener) {
        this.context = context;
        this.device = device;
        this.eventListener = eventListener;
        this.notifyHandler = new Handler(Looper.getMainLooper());
        this.timeoutHandler = new Handler(Looper.getMainLooper());
        this.commandGenerator = new OtaCommandGenerator();
    }

    public abstract void init();

    public void release() {
        this.otaFirmwareVersion = -1;
        this.deviceFirmwareVersion = -1;
        this.allowedUpdate = false;
        this.isUpdating = false;
        this.isUpdatePause = false;
        this.sentIdentification = false;
        this.receivedChannelInfo = false;
        this.cancelTimeout();
        if (this.commandGenerator != null) {
            this.commandGenerator.reset();
        }
    }

    protected int getPacketSize() {
        return this.mPacketSize;
    }

    protected int getBlockSize() {
        return this.mBlockSize;
    }

    public void startOTA() {
        this.isUpdating = true;
        this.notifyOnStart();
        this.getOtaInfoVersion();
    }

    public boolean isReadyToUpdate() {
        Log.d((String)TAG, (String)("isReady: " + this.isTwsDevice + ", " + this.isTwsConnected + ", " + (this.dataProvider != null) + ", " + this.isDeviceReady()));
        if (this.isTwsDevice == null) {
            return false;
        }
        if (this.isTwsDevice.booleanValue()) {
            return this.isTwsConnected() && this.dataProvider != null && this.isDeviceReady();
        }
        return this.dataProvider != null && this.isDeviceReady();
    }

    protected abstract boolean canSendNow();

    public void setOtaData(byte[] otaData) {
        this.dataProvider = new OtaDataProvider(otaData);
        this.dataProvider.setBlockSize(this.getBlockSize());
        this.dataProvider.setPacketSize(this.getPacketSize());
        if (this.commandGenerator != null) {
            this.commandGenerator.setDataProvider(this.dataProvider);
        } else {
            this.commandGenerator = new OtaCommandGenerator(this.dataProvider);
        }
        this.checkIfReadyToUpdate();
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public boolean isTwsDevice() {
        return this.isTwsDevice != null && this.isTwsDevice != false;
    }

    public boolean isTwsConnected() {
        return this.isTwsConnected != null && this.isTwsConnected != false;
    }

    protected void checkIfReadyToUpdate() {
        boolean isReadyToUpdate = this.isReadyToUpdate();
        BleLog.i((String)("checkIfReadyToUpdate: " + isReadyToUpdate));
        if (isReadyToUpdate) {
            this.notifyOnReady();
        }
    }

    protected void notifyOnReady() {
        this.notifyHandler.post(this.eventListener::onOtaReady);
    }

    protected void notifyOnStart() {
        this.notifyHandler.post(this.eventListener::onOtaStart);
    }

    protected void notifyOnProgress(int progress) {
        this.notifyHandler.post(() -> this.eventListener.onOtaProgress(progress));
    }

    protected void notifyOnStop() {
        if (!this.disconnectedDueToDeviceError) {
            this.notifyHandler.post(this.eventListener::onOtaStop);
        }
        this.disconnectedDueToDeviceError = false;
    }

    protected void notifyOnOneFinish() {
        this.notifyHandler.post(this.eventListener::onOtaOneFinish);
    }

    protected void notifyOnAllFinish() {
        this.notifyHandler.post(this.eventListener::onOtaAllFinish);
    }

    protected void notifyOnPause() {
        this.notifyHandler.post(this.eventListener::onOtaPause);
    }

    protected void notifyOnContinue() {
        this.notifyHandler.post(this.eventListener::onOtaContinue);
    }

    protected void notifyOnError(OtaError error) {
        this.disconnectedDueToDeviceError = true;
        this.notifyHandler.post(() -> this.eventListener.onOtaError(error));
        this.release();
    }

    protected void notifyTWSDisconnected() {
        this.notifyHandler.post(this.eventListener::onTWSDisconnected);
    }

    protected void notifyOnReceiveVersion(int version) {
        this.notifyHandler.post(() -> this.eventListener.onReceiveVersion(version));
    }

    protected void notifyOnReceiveIsTWS(boolean isTwsDevice) {
        this.notifyHandler.post(() -> this.eventListener.onReceiveIsTWS(isTwsDevice));
    }

    protected void notifyOnReceiveTWSConnected(boolean connected) {
        this.notifyHandler.post(() -> this.eventListener.onReceiveTWSConnected(connected));
    }

    protected void notifyOnReceiveChannel(boolean isLeftChannel) {
        this.notifyHandler.post(() -> this.eventListener.onReceiveChannel(isLeftChannel));
    }

    protected void getOtaInfoVersion() {
        byte[] cmd = this.commandGenerator.cmdGetInfoVersion();
        this.btSendData(cmd);
    }

    protected void getOtaInfoUpdate(int version) {
        if (this.dataProvider != null) {
            byte[] hashData = this.dataProvider.getHash();
            byte[] cmd = this.commandGenerator.cmdGetInfoUpdate(version, hashData);
            this.btSendData(cmd);
        }
    }

    protected void sendOtaIdentification() {
        byte[] cmd = this.commandGenerator.cmdOtaIdentification();
        this.btSendData(cmd);
    }

    protected void getAllInfo() {
        byte[] cmd = this.commandGenerator.cmdGetAllInfo();
        this.btSendData(cmd);
    }

    protected void sendOtaStart() {
        byte[] cmd = this.commandGenerator.cmdStartSend();
        this.btSendData(cmd);
        int progress = this.dataProvider.getProgress();
        this.notifyOnProgress(progress);
    }

    protected void sendOtaData() {
        byte[] cmd = this.commandGenerator.cmdSendData();
        this.btSendData(cmd);
        int progress = this.dataProvider.getProgress();
        this.notifyOnProgress(progress);
    }

    protected void sendOtaDataOnce() {
        this.sendOtaData();
    }

    protected void runDataSend() {
        if (!this.needIdentification() || this.sentIdentification) {
            if (this.canSendNow()) {
                this.sendOtaDataOnce();
            } else if (this.dataProvider != null && this.dataProvider.isBlockSendFinish()) {
                this.timeoutHandler.postDelayed(this::handleTimeout, 10000L);
            }
        } else {
            HandlerThread thread = new HandlerThread("Get All Info");
            thread.start();
            new Handler(thread.getLooper()).postDelayed(() -> {
                this.sentIdentification = true;
                this.getAllInfo();
            }, 200L);
        }
    }

    private void handleTimeout() {
        this.notifyOnError(OtaError.TIMEOUT_RECEIVE_RESPONSE);
    }

    private void cancelTimeout() {
        this.timeoutHandler.removeCallbacksAndMessages(null);
    }

    protected boolean processData(byte[] data) {
        if (data.length < 3) {
            Log.w((String)TAG, (String)"\u63a5\u6536\u5230\u6570\u636e\u957f\u5ea6\u5c0f\u4e8e3");
            return false;
        }
        ByteBuffer bb = ByteBuffer.wrap(data);
        byte cmdType = bb.get();
        byte seqNum = bb.get();
        switch (cmdType) {
            case -112: {
                byte status = bb.get();
                this.processNotifyStatus(status);
                return true;
            }
            case -111: {
                byte cmdSubType = bb.get();
                byte[] extraData = new byte[bb.remaining()];
                bb.get(extraData, 0, bb.remaining());
                this.processGetInfo(cmdSubType, extraData);
                return true;
            }
            case -110: {
                byte[] infoData = new byte[bb.remaining()];
                bb.get(infoData, 0, bb.remaining());
                this.processGetInfoTLV(infoData);
                return true;
            }
        }
        return false;
    }

    protected void processNotifyStatus(byte status) {
        switch (status) {
            case 0: {
                this.cancelTimeout();
                if (this.isUpdatePause || this.dataProvider.isAllDataSent()) break;
                this.sendOtaStart();
                break;
            }
            case -1: {
                this.cancelTimeout();
                if (this.isTwsDevice() && this.receivedChannelInfo && !this.isPrimaryUpdated) {
                    this.isPrimaryUpdated = true;
                    this.notifyOnOneFinish();
                    this.onOneFinish();
                    break;
                }
                this.notifyOnAllFinish();
                this.release();
                break;
            }
            case -3: {
                this.cancelTimeout();
                this.allowedUpdate = false;
                this.isUpdating = false;
                this.isUpdatePause = true;
                this.notifyOnPause();
                break;
            }
            case -2: {
                this.notifyOnContinue();
                this.isUpdating = true;
                this.isUpdatePause = false;
                this.getOtaInfoVersion();
                break;
            }
            case -128: {
                this.cancelTimeout();
                this.isUpdating = false;
                this.isTwsConnected = false;
                this.notifyTWSDisconnected();
                this.notifyOnReceiveTWSConnected(this.isTwsConnected);
                break;
            }
            default: {
                OtaError.REPORT_FROM_DEVICE.setDeviceErrorCode(status);
                this.cancelTimeout();
                this.notifyOnError(OtaError.REPORT_FROM_DEVICE);
            }
        }
    }

    protected void processGetInfo(byte cmdSubType, byte[] extraData) {
        this.processInfo(cmdSubType, extraData);
        switch (cmdSubType) {
            case 1: {
                this.getOtaInfoUpdate(this.otaFirmwareVersion);
                break;
            }
            case 2: {
                if (this.allowedUpdate) {
                    this.sendOtaStart();
                    break;
                }
                this.cancelTimeout();
                this.notifyOnError(OtaError.REFUSED_BY_DEVICE);
            }
        }
    }

    private void processGetInfoTLV(byte[] extraData) {
        while (extraData.length > 2) {
            ByteBuffer bb = ByteBuffer.wrap(extraData);
            byte infoType = bb.get();
            byte infoLength = bb.get();
            byte[] infoData = new byte[infoLength];
            bb.get(infoData);
            this.processInfo(infoType, infoData);
            if (!bb.hasRemaining()) break;
            byte[] remainingData = new byte[bb.remaining()];
            bb.get(remainingData);
            extraData = remainingData;
        }
        if (this.isReadyToUpdate() && this.isTwsDevice() && this.receivedChannelInfo && this.isPrimaryUpdated) {
            this.startOTA();
        } else {
            this.checkIfReadyToUpdate();
        }
    }

    private void processInfo(byte infoType, byte[] infoData) {
        Log.d((String)TAG, (String)("processInfo: " + infoType + " -> " + HexUtils.bytesToHex(infoData)));
        switch (infoType) {
            case 1: {
                if (infoData.length != 2) break;
                ByteBuffer bb = ByteBuffer.wrap(infoData).order(ByteOrder.LITTLE_ENDIAN);
                short version = bb.getShort();
                this.notifyOnReceiveVersion(version);
                this.deviceFirmwareVersion = version;
                break;
            }
            case 2: {
                int blockSize;
                if (infoData.length != 11) break;
                ByteBuffer bb = ByteBuffer.wrap(infoData).order(ByteOrder.LITTLE_ENDIAN);
                int startAddress = bb.getInt();
                this.dataProvider.setStartAddress(startAddress);
                this.mBlockSize = blockSize = bb.getInt();
                this.dataProvider.setBlockSize(blockSize);
                short packetSize = bb.getShort();
                this.mPacketSize = packetSize;
                this.dataProvider.setPacketSize(packetSize);
                this.allowedUpdate = bb.get() == 1;
                break;
            }
            case 3: {
                if (infoData.length != 2) break;
                ByteBuffer bb = ByteBuffer.wrap(infoData).order(ByteOrder.LITTLE_ENDIAN);
                short dev_info_capabilities = bb.getShort();
                this.isTwsDevice = (dev_info_capabilities & 1) != 0;
                this.notifyOnReceiveIsTWS(this.isTwsDevice);
                break;
            }
            case 4: {
                if (infoData.length != 2) break;
                ByteBuffer bb = ByteBuffer.wrap(infoData).order(ByteOrder.LITTLE_ENDIAN);
                short device_status = bb.getShort();
                this.isTwsConnected = (device_status & 1) != 0;
                this.notifyOnReceiveTWSConnected(this.isTwsConnected);
                break;
            }
            case 5: {
                if (infoData.length != 6) break;
                this.bluetoothAddress = infoData;
                break;
            }
            case 6: {
                if (infoData.length != 1) break;
                byte channel = infoData[0];
                if (channel == 1) {
                    this.notifyOnReceiveChannel(true);
                } else if (channel == 0) {
                    this.notifyOnReceiveChannel(false);
                }
                this.receivedChannelInfo = true;
                break;
            }
        }
    }

    protected abstract void btSendData(byte[] var1);

    protected abstract void onOneFinish();

    public boolean needIdentification() {
        return this._needIdentification;
    }

    public void setNeedIdentification(boolean needIdentification) {
        this._needIdentification = needIdentification;
    }

    public void setOtaFirmwareVersion(int otaFirmwareVersion) {
        this.otaFirmwareVersion = otaFirmwareVersion;
    }

    protected boolean isDeviceReady() {
        return this.isDeviceReady;
    }

    protected void setDeviceReady(boolean deviceReady) {
        this.isDeviceReady = deviceReady;
    }

    public static interface EventListener {
        public void onOtaReady();

        public void onOtaStart();

        public void onOtaProgress(int var1);

        public void onOtaStop();

        public void onOtaOneFinish();

        public void onOtaAllFinish();

        public void onOtaPause();

        public void onOtaContinue();

        public void onOtaError(OtaError var1);

        public void onTWSDisconnected();

        public void onReceiveVersion(int var1);

        public void onReceiveIsTWS(boolean var1);

        public void onReceiveTWSConnected(boolean var1);

        public void onReceiveChannel(boolean var1);
    }
}

