/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.zhlx;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.elinkthings.bleotalibrary.zhlx.BluetoothSppService;
import com.elinkthings.bleotalibrary.zhlx.HexUtils;
import com.elinkthings.bleotalibrary.zhlx.OtaError;
import com.elinkthings.bleotalibrary.zhlx.OtaManager;
import com.pingwang.bluetoothlib.utils.BleLog;

public final class SppOtaManager
extends OtaManager {
    private static final String TAG = SppOtaManager.class.getSimpleName();
    private static final int DELAY_SEND = 15;
    private BluetoothSppService sppService;
    private final Handler.Callback sppCallback = msg -> {
        switch (msg.what) {
            case 1: {
                switch (msg.arg1) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.setDeviceReady(true);
                        if (this.needIdentification()) {
                            this.sendOtaIdentification();
                        } else {
                            this.getAllInfo();
                        }
                        if (this.isTwsDevice != null) break;
                        this.checkIfReadyToUpdate();
                        break;
                    }
                    case 0: {
                        BleLog.i((String)"\u76f8\u5f53\u4e8e\u65ad\u5f00\u540e");
                        this.setDeviceReady(false);
                        this.isUpdating = false;
                        if (this.dataProvider == null || !this.dataProvider.isAllDataSent()) {
                            this.notifyOnStop();
                            break;
                        }
                        this.dataProvider.reset();
                    }
                }
                break;
            }
            case 2: {
                byte[] readData = (byte[])msg.obj;
                boolean ret = this.processData(readData);
                Log.d((String)TAG, (String)("\u6d88\u606f" + (ret ? "\u5df2" : "\u672a") + "\u5904\u7406"));
                break;
            }
            case 3: {
                this.runDataSend();
            }
        }
        return true;
    };

    public SppOtaManager(Context context, BluetoothDevice device, OtaManager.EventListener eventListener) {
        super(context, device, eventListener);
    }

    @Override
    public void init() {
        this.sppService = new BluetoothSppService(new Handler(this.sppCallback));
        this.sppService.connect(this.device);
    }

    @Override
    public void release() {
        if (this.sppService != null) {
            this.sppService.stop();
            this.sppService = null;
        }
        super.release();
    }

    @Override
    public void startOTA() {
        if (this.sppService.getState() != 2) {
            this.notifyOnError(OtaError.NOT_CONNECTED);
            return;
        }
        super.startOTA();
    }

    @Override
    protected void sendOtaDataOnce() {
        try {
            Thread.sleep(15L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.sendOtaDataOnce();
    }

    @Override
    protected boolean canSendNow() {
        return this.allowedUpdate && !this.isUpdatePause && !this.dataProvider.isBlockSendFinish();
    }

    @Override
    protected void btSendData(byte[] data) {
        if (this.sppService != null) {
            Log.v((String)TAG, (String)("btSendData: " + HexUtils.bytesToHex(data)));
            this.sppService.write(data);
        }
    }

    @Override
    protected void onOneFinish() {
        this.release();
        long delayTime = 3000L;
        new Handler().postDelayed(this::init, delayTime);
    }
}

