/*
 * Decompiled with CFR 0.152.
 */
package com.elinkthings.bleotalibrary.zhlx;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.elinkthings.bleotalibrary.base.BaseOtaManager;
import com.elinkthings.bleotalibrary.listener.OnBleOTAListener;
import com.elinkthings.bleotalibrary.zhlx.BleOtaManager;
import com.elinkthings.bleotalibrary.zhlx.OtaError;
import com.elinkthings.bleotalibrary.zhlx.OtaManager;
import com.pingwang.bluetoothlib.device.BleDevice;
import com.pingwang.bluetoothlib.utils.BleLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ZKLXOtaManager
extends BaseOtaManager
implements OtaManager.EventListener {
    private static final int OTA_TIME_OUT = 1;
    private static final int TIME_OUT_TIME = 10000;
    private static final String TAG = "ZKLXOtaManager";
    private OnBleOTAListener mOnBleOTAListener;
    private String mFilePath;
    private BleOtaManager mBleOtaManager;
    private Context mContext;
    private boolean mStartOta = false;
    private boolean mOtaStatus = false;
    private boolean mInitOk = false;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ZKLXOtaManager.this.mHandler.removeMessages(1);
                    ZKLXOtaManager.this.otaFailure("ota time out");
                }
            }
        }
    };

    public ZKLXOtaManager(Builder builder) {
        this.mContext = builder.mContext;
        this.mOnBleOTAListener = builder.mOnBleOTAListener;
        this.mFilePath = builder.mFilePath;
        BleDevice bleDevice = builder.mBleDevice;
        if (bleDevice == null || bleDevice.getBluetoothGatt() == null) {
            this.otaFailure("bleDevice == null || bleDevice.getBluetoothGatt() == null");
            return;
        }
        BluetoothDevice bluetoothDevice = bleDevice.getBluetoothGatt().getDevice();
        if (bluetoothDevice != null) {
            bleDevice.disconnect(false);
            this.mBleOtaManager = new BleOtaManager(this.mContext, bluetoothDevice, this);
            this.mBleOtaManager.init();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] otaData = ZKLXOtaManager.this.readFile(ZKLXOtaManager.this.mFilePath);
                        ZKLXOtaManager.this.mBleOtaManager.setOtaData(otaData);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public byte[] readFile(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream fis = new FileInputStream(file);
        int length = fis.available();
        byte[] buffer = new byte[length];
        fis.read(buffer);
        fis.close();
        return buffer;
    }

    @Override
    public void startOta() {
        this.mStartOta = true;
        if (this.mInitOk) {
            if (this.mBleOtaManager != null && !this.mOtaStatus) {
                new Thread(() -> {
                    BleLog.iw((String)"\u5f00\u59cbOTA");
                    while (!this.mBleOtaManager.isReadyToUpdate()) {
                        SystemClock.sleep((long)100L);
                    }
                    this.mBleOtaManager.startOTA();
                    this.mHandler.removeMessages(1);
                    this.mHandler.sendEmptyMessageDelayed(1, 10000L);
                }).start();
            }
        } else {
            this.mHandler.sendEmptyMessageDelayed(1, 60000L);
        }
    }

    private void otaFailure(String msg) {
        this.mOtaStatus = false;
        this.mHandler.removeMessages(1);
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaFailure(6, msg);
        }
        this.clear();
    }

    @Override
    public void onOtaReady() {
        BleLog.i((String)"onOtaReady");
        this.mInitOk = true;
        if (this.mStartOta && this.mHandler != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ZKLXOtaManager.this.startOta();
                }
            }, 1000L);
        }
    }

    @Override
    public void onOtaStart() {
        BleLog.i((String)"onOtaStart");
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        }
    }

    @Override
    public void onOtaProgress(int progress) {
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaProgress(progress, 1, 1);
        }
    }

    @Override
    public void onOtaStop() {
        BleLog.i((String)"onOtaStop");
        this.otaFailure("onOtaStop");
    }

    @Override
    public void onOtaOneFinish() {
        BleLog.i((String)"onOtaOneFinish:\u4e3b\u673a\u5347\u7ea7\u5b8c\u6210\uff0c\u7b49\u5f85\u8fde\u63a5\u526f\u673a");
    }

    @Override
    public void onOtaAllFinish() {
        BleLog.i((String)"onOtaAllFinish");
        if (this.mOnBleOTAListener != null) {
            this.mOnBleOTAListener.onOtaSuccess();
        }
        this.clear();
    }

    @Override
    public void onOtaPause() {
        BleLog.i((String)"onOtaPause");
    }

    @Override
    public void onOtaContinue() {
        BleLog.i((String)"onOtaContinue");
    }

    @Override
    public void onOtaError(OtaError error) {
        BleLog.i((String)("onOtaError:" + error.getDescription()));
        this.otaFailure(error.getDescription());
    }

    @Override
    public void onTWSDisconnected() {
        BleLog.i((String)"onTWSDisconnected");
        this.otaFailure("onTWSDisconnected");
    }

    @Override
    public void onReceiveVersion(int version) {
        BleLog.i((String)("onReceiveVersion:" + version));
    }

    @Override
    public void onReceiveIsTWS(boolean isTWS) {
        BleLog.i((String)("onReceiveIsTWS:" + isTWS));
    }

    @Override
    public void onReceiveTWSConnected(boolean connected) {
        BleLog.i((String)("onReceiveTWSConnected:" + connected));
    }

    @Override
    public void onReceiveChannel(boolean isLeftChannel) {
        BleLog.i((String)("onReceiveChannel:" + isLeftChannel));
    }

    @Override
    public void clear() {
        this.mHandler.removeMessages(1);
        if (this.mBleOtaManager != null) {
            this.mBleOtaManager.release();
            this.mBleOtaManager = null;
        }
        this.mInitOk = false;
        this.mStartOta = false;
        this.mOtaStatus = false;
        BleLog.i((String)"clear");
    }

    public static final class Builder {
        private BleDevice mBleDevice;
        private Context mContext;
        private OnBleOTAListener mOnBleOTAListener;
        private String mFilePath = "";

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setOnBleOTAListener(OnBleOTAListener onBleOTAListener) {
            this.mOnBleOTAListener = onBleOTAListener;
            return this;
        }

        public Builder setFilePath(String filePath) {
            this.mFilePath = filePath;
            return this;
        }

        public ZKLXOtaManager build(BleDevice bleDevice) {
            this.mBleDevice = bleDevice;
            if (this.mBleDevice == null) {
                return null;
            }
            return new ZKLXOtaManager(this);
        }
    }
}

