/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.bmp_convert;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.jieli.bmp_convert.OnConvertListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BmpConvert {
    private static final String TAG = BmpConvert.class.getSimpleName();
    public static final int TYPE_BR_23 = 0;
    public static final int TYPE_BR_28 = 1;
    public static final int TYPE_BR_28_ALPHA = 2;
    public static final int TYPE_BR_28_RAW = 3;
    public static final int TYPE_BR_28_ALPHA_RAW = 4;
    public static final int ERR_PARAM = -3584;
    public static final int ERR_NOT_FOUND_FILE = -3585;
    public static final int ERR_IO_EXCEPTION = -3586;
    private final ExecutorService mThreadPool = Executors.newSingleThreadExecutor();
    private final Handler mHandler = new Handler(Looper.getMainLooper());

    public void release() {
        this.mThreadPool.shutdownNow();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public void bitmapConvert(String inFilePath, String outFilePath, OnConvertListener listener) {
        this.bitmapConvert(0, inFilePath, outFilePath, listener);
    }

    public void bitmapConvert(int type, String inFilePath, String outFilePath, OnConvertListener listener) {
        if (type != 0 && type != 1 && type != 2 && type != 3 && type != 4) {
            throw new RuntimeException("illegal type");
        }
        if (this.mThreadPool.isShutdown()) {
            Log.e((String)TAG, (String)"bitmapConvert : thread is exited.");
            if (null != listener) {
                listener.onStop(false, null);
            }
            return;
        }
        this.mThreadPool.submit(() -> {
            if (listener != null) {
                this.mHandler.post(() -> listener.onStart(inFilePath));
            }
            int ret = this.bitmapConvertBlock(type, inFilePath, outFilePath);
            if (listener != null) {
                this.mHandler.post(() -> {
                    boolean isOk;
                    boolean bl = isOk = ret > 0;
                    if (isOk) {
                        listener.onStop(true, outFilePath);
                    } else {
                        listener.onStop(false, null);
                    }
                });
            }
        });
    }

    public int bitmapConvertBlock(int type, String inFilePath, String outFilePath) {
        File file = new File(inFilePath);
        if (!file.exists() || !file.isFile()) {
            Log.e((String)TAG, (String)("bitmapConvertBlock : file not found." + inFilePath));
            return -3585;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeFile((String)inFilePath, (BitmapFactory.Options)options);
        int[] pixels = new int[bitmap.getHeight() * bitmap.getWidth()];
        bitmap.getPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        byte[] data = new byte[pixels.length * 4];
        for (int i = 0; i < pixels.length; ++i) {
            int offset = i << 2;
            data[offset] = (byte)(pixels[i] & 0xFF);
            data[offset + 1] = (byte)(pixels[i] >> 8 & 0xFF);
            data[offset + 2] = (byte)(pixels[i] >> 16 & 0xFF);
            data[offset + 3] = (byte)(pixels[i] >> 24 & 0xFF);
        }
        String cachePath = inFilePath.substring(0, inFilePath.lastIndexOf(".")) + ".bin";
        File cacheFile = new File(cachePath);
        try {
            boolean isExist = cacheFile.exists();
            if (isExist && !cacheFile.delete()) {
                Log.e((String)TAG, (String)("bitmapConvertBlock : IO exception : delete." + cachePath));
            }
            if (!(isExist = cacheFile.createNewFile())) {
                Log.e((String)TAG, (String)("bitmapConvertBlock : IO exception : createNewFile." + cachePath));
                return -3586;
            }
            FileOutputStream fos = new FileOutputStream(cachePath);
            fos.write(data);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -3586;
        }
        int ret = this.bmpConvert_native(type, cachePath, bitmap.getWidth(), bitmap.getHeight(), outFilePath);
        return ret;
    }

    protected native int bmpConvert_native(int var1, String var2, int var3, int var4, String var5);

    static {
        try {
            System.loadLibrary("jl_bmp_convert");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

