/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.impl;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.ParcelUuid;
import android.text.TextUtils;
import com.jieli.jl_bt_ota.constant.BluetoothConstant;
import com.jieli.jl_bt_ota.impl.BluetoothDiscovery;
import com.jieli.jl_bt_ota.util.BluetoothUtil;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class BluetoothBreProfiles
extends BluetoothDiscovery {
    private BluetoothHeadset r;
    private BluetoothA2dp s;
    private BluetoothHandFreeReceiver t;
    private final BluetoothProfile.ServiceListener u;

    public BluetoothBreProfiles(Context context) {
        BluetoothProfile.ServiceListener serviceListener;
        BluetoothBreProfiles bluetoothBreProfiles = this;
        super(context);
        BluetoothProfile.ServiceListener serviceListener2 = serviceListener;
        serviceListener = new BluetoothProfile.ServiceListener(){

            public void onServiceConnected(int n, BluetoothProfile bluetoothProfile) {
                JL_Log.i(BluetoothBreProfiles.this.TAG, "------------onServiceConnected--------profile=" + n);
                if (2 == n) {
                    BluetoothBreProfiles.a(BluetoothBreProfiles.this, (BluetoothA2dp)bluetoothProfile);
                } else if (1 == n) {
                    BluetoothBreProfiles.a(BluetoothBreProfiles.this, (BluetoothHeadset)bluetoothProfile);
                }
            }

            public void onServiceDisconnected(int n) {
                JL_Log.i(BluetoothBreProfiles.this.TAG, "------------onServiceDisconnected--------");
                if (2 == n) {
                    BluetoothBreProfiles.a(BluetoothBreProfiles.this, null);
                } else if (1 == n) {
                    BluetoothBreProfiles.a(BluetoothBreProfiles.this, null);
                }
            }
        };
        bluetoothBreProfiles.u = serviceListener2;
        bluetoothBreProfiles.a(context);
        bluetoothBreProfiles.a();
    }

    private boolean a(Context context) {
        boolean bl;
        block12: {
            bl = false;
            if (context != null) {
                block11: {
                    BluetoothAdapter bluetoothAdapter = this.mBluetoothAdapter;
                    if (bluetoothAdapter == null) {
                        JL_Log.e(this.TAG, "get bluetooth adapter is null.");
                        return false;
                    }
                    if (this.s == null) {
                        bl = bluetoothAdapter.getProfileProxy(context, this.u, 2);
                        if (bl) break block11;
                        try {
                            JL_Log.e(this.TAG, "BluetoothBreProfiles: a2dp error.");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (this.r == null) {
                    bl = this.mBluetoothAdapter.getProfileProxy(context, this.u, 1);
                    if (bl) break block12;
                    try {
                        JL_Log.e(this.TAG, "BluetoothBreProfiles: hfp error");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void a() {
        if (this.t == null && this.context != null) {
            IntentFilter intentFilter;
            this.t = new BluetoothHandFreeReceiver();
            IntentFilter intentFilter2 = intentFilter;
            new IntentFilter().addAction("android.bluetooth.device.action.UUID");
            intentFilter2.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
            intentFilter2.addAction("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED");
            intentFilter2.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            this.context.registerReceiver((BroadcastReceiver)this.t, intentFilter2);
        }
    }

    private void b() {
        Context context;
        BluetoothHandFreeReceiver bluetoothHandFreeReceiver = this.t;
        if (bluetoothHandFreeReceiver != null && (context = this.context) != null) {
            context.unregisterReceiver((BroadcastReceiver)bluetoothHandFreeReceiver);
            this.t = null;
        }
    }

    static /* synthetic */ BluetoothA2dp a(BluetoothBreProfiles bluetoothBreProfiles, BluetoothA2dp bluetoothA2dp) {
        bluetoothBreProfiles.s = bluetoothA2dp;
        return bluetoothA2dp;
    }

    static /* synthetic */ BluetoothHeadset a(BluetoothBreProfiles bluetoothBreProfiles, BluetoothHeadset bluetoothHeadset) {
        bluetoothBreProfiles.r = bluetoothHeadset;
        return bluetoothHeadset;
    }

    protected BluetoothHeadset getBluetoothHfp() {
        return this.r;
    }

    protected BluetoothA2dp getmBluetoothA2dp() {
        return this.s;
    }

    @SuppressLint(value={"MissingPermission"})
    public List<BluetoothDevice> getDevicesConnectedByProfile() {
        if (!CommonUtil.checkHasConnectPermission(this.context)) {
            return null;
        }
        ArrayList arrayList = null;
        List list = null;
        BluetoothHeadset bluetoothHeadset = this.r;
        if (bluetoothHeadset != null) {
            list = bluetoothHeadset.getConnectedDevices();
        }
        if (list != null) {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList(list);
        }
        if ((this = this.s) != null) {
            list = this.getConnectedDevices();
        }
        if (list != null) {
            if (arrayList == null) {
                ArrayList arrayList3;
                arrayList = arrayList3;
                arrayList3 = new ArrayList();
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public boolean deviceHasHfp(BluetoothDevice bluetoothDevice) {
        return BluetoothUtil.deviceHasProfile(this.context, bluetoothDevice, BluetoothConstant.UUID_HFP);
    }

    public boolean deviceHasA2dp(BluetoothDevice bluetoothDevice) {
        return BluetoothUtil.deviceHasProfile(this.context, bluetoothDevice, BluetoothConstant.UUID_A2DP);
    }

    @SuppressLint(value={"MissingPermission"})
    public int isConnectedByProfile(BluetoothDevice bluetoothDevice) {
        if (!CommonUtil.checkHasConnectPermission(this.context)) {
            JL_Log.w(this.TAG, "-isConnectedByProfile- no connect permission.");
            return 0;
        }
        if (bluetoothDevice == null) {
            JL_Log.e(this.TAG, "-isConnectedByProfile- device is null.");
            return 0;
        }
        if (this.r != null && this.s != null) {
            if (bluetoothDevice.getType() == 2) {
                JL_Log.e(this.TAG, "device is Invalid.");
                return 0;
            }
            Object object = this.r.getConnectedDevices();
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    if (!((BluetoothDevice)object.next()).getAddress().equals(bluetoothDevice.getAddress())) continue;
                    JL_Log.w(this.TAG, "device connect hfp.");
                    return 2;
                }
            }
            if ((object = this.s.getConnectedDevices()) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    if (!((BluetoothDevice)object.next()).getAddress().equals(bluetoothDevice.getAddress())) continue;
                    JL_Log.w(this.TAG, "device connect a2dp.");
                    return 2;
                }
            }
            return 0;
        }
        BluetoothBreProfiles bluetoothBreProfiles = this;
        JL_Log.e(bluetoothBreProfiles.TAG, "mBluetoothHfp or mBluetoothA2dp is null.");
        bluetoothBreProfiles.a(bluetoothBreProfiles.context);
        return 4100;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean disconnectByProfiles(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null && CommonUtil.checkHasConnectPermission(this.context)) {
            JL_Log.i(this.TAG, "-disconnectByProfiles- device : " + this.printBtDeviceInfo(bluetoothDevice));
            boolean bl = false;
            if (bluetoothDevice.getType() != 2) {
                int n;
                int n2 = this.isConnectedByA2dp(bluetoothDevice);
                if (n2 == 2) {
                    BluetoothBreProfiles bluetoothBreProfiles = this;
                    bl = bluetoothBreProfiles.disconnectFromA2dp(bluetoothDevice);
                    JL_Log.i(bluetoothBreProfiles.TAG, "-disconnectByProfiles- disconnectFromA2dp ret : " + bl);
                }
                if ((n = this.isConnectedByHfp(bluetoothDevice)) == 2) {
                    BluetoothBreProfiles bluetoothBreProfiles = this;
                    bl = bluetoothBreProfiles.disconnectFromHfp(bluetoothDevice);
                    JL_Log.i(bluetoothBreProfiles.TAG, "-disconnectByProfiles- disconnectFromHfp ret : " + bl);
                }
                if (n2 == 0 && n == 0) {
                    bl = true;
                }
            }
            return bl;
        }
        JL_Log.i(this.TAG, "-disconnectByProfiles- device is null ");
        return false;
    }

    public boolean disconnectFromA2dp(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            JL_Log.e(this.TAG, "-disconnectFromA2dp- device is null");
            return false;
        }
        if (this.s == null) {
            JL_Log.e(this.TAG, "-disconnectFromA2dp- mBluetoothA2dp is null");
            return false;
        }
        boolean bl = false;
        int n = this.isConnectedByA2dp(bluetoothDevice);
        if (n == 0) {
            JL_Log.i(this.TAG, "-disconnectFromA2dp- A2dp is disconnected");
            return true;
        }
        if (n == 2) {
            bl = BluetoothUtil.disconnectDeviceA2dp(this.context, this.s, bluetoothDevice);
        }
        JL_Log.i(this.TAG, "-disconnectFromA2dp- ret : " + bl);
        return bl;
    }

    protected boolean disconnectFromA2dp(String string) {
        return (string = BluetoothUtil.getRemoteDevice(string)) != null && this.disconnectFromA2dp((BluetoothDevice)string);
    }

    @SuppressLint(value={"MissingPermission"})
    public int isConnectedByA2dp(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null && CommonUtil.checkHasConnectPermission(this.context)) {
            Object object = this.s;
            if (object == null) {
                JL_Log.e(this.TAG, "-isConnectedByA2dp- mBluetoothA2dp is null");
                return 4100;
            }
            if ((object = object.getConnectedDevices()) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    if (!((BluetoothDevice)object.next()).getAddress().equals(bluetoothDevice.getAddress())) continue;
                    JL_Log.i(this.TAG, "-isConnectedByA2dp- ret : true");
                    return 2;
                }
            } else {
                JL_Log.i(this.TAG, "-isConnectedByA2dp- connect list is null");
            }
            BluetoothBreProfiles bluetoothBreProfiles = this;
            JL_Log.i(bluetoothBreProfiles.TAG, "-isConnectedByA2dp- ret : false");
            return bluetoothBreProfiles.s.getConnectionState(bluetoothDevice);
        }
        JL_Log.e(this.TAG, "-isConnectedByA2dp- device is null");
        return 0;
    }

    public boolean disconnectFromHfp(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            JL_Log.e(this.TAG, "-disconnectFromHfp- device is null");
            return false;
        }
        if (this.r == null) {
            JL_Log.e(this.TAG, "-disconnectFromHfp- mBluetoothHfp is null");
            return false;
        }
        boolean bl = false;
        int n = this.isConnectedByHfp(bluetoothDevice);
        if (n == 0) {
            JL_Log.i(this.TAG, "-disconnectFromHfp- hfp is disconnected");
            return true;
        }
        if (n == 2) {
            bl = BluetoothUtil.disconnectDeviceHfp(this.context, this.r, bluetoothDevice);
        }
        JL_Log.i(this.TAG, "-disconnectFromHfp- ret : " + bl);
        return bl;
    }

    public boolean disconnectFromHfp(String string) {
        return (string = BluetoothUtil.getRemoteDevice(string)) != null && this.disconnectFromHfp((BluetoothDevice)string);
    }

    @SuppressLint(value={"MissingPermission"})
    public int isConnectedByHfp(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice != null && CommonUtil.checkHasConnectPermission(this.context)) {
            Object object = this.r;
            if (object == null) {
                JL_Log.e(this.TAG, "-isConnectedByHfp- mBluetoothHfp is null");
                return 4100;
            }
            if ((object = object.getConnectedDevices()) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    if (!((BluetoothDevice)object.next()).getAddress().equals(bluetoothDevice.getAddress())) continue;
                    JL_Log.i(this.TAG, "-isConnectedByHfp- ret : true.");
                    return 2;
                }
            } else {
                JL_Log.i(this.TAG, "-isConnectedByHfp- no connect list");
            }
            int n = this.r.getConnectionState(bluetoothDevice);
            JL_Log.i(this.TAG, "-isConnectedByHfp- ret : " + n);
            return n;
        }
        JL_Log.e(this.TAG, "-isConnectedByHfp- device is null");
        return 0;
    }

    @Override
    public void release() {
        BluetoothAdapter bluetoothAdapter;
        BluetoothBreProfiles bluetoothBreProfiles = this;
        super.release();
        bluetoothBreProfiles.b();
        BluetoothA2dp bluetoothA2dp = bluetoothBreProfiles.s;
        if (bluetoothA2dp != null && (bluetoothAdapter = this.mBluetoothAdapter) != null) {
            bluetoothAdapter.closeProfileProxy(2, (BluetoothProfile)bluetoothA2dp);
            this.s = null;
        }
        if ((bluetoothA2dp = this.r) != null && (bluetoothAdapter = this.mBluetoothAdapter) != null) {
            bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)bluetoothA2dp);
            this.r = null;
        }
    }

    private class BluetoothHandFreeReceiver
    extends BroadcastReceiver {
        private BluetoothHandFreeReceiver() {
        }

        public void onReceive(Context object, Intent parcelUuidArray) {
            if (parcelUuidArray != null) {
                object = parcelUuidArray.getAction();
                BluetoothDevice bluetoothDevice = (BluetoothDevice)parcelUuidArray.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (!TextUtils.isEmpty((CharSequence)object) && bluetoothDevice != null) {
                    object = (String)Objects.requireNonNull(object);
                    ((String)object).hashCode();
                    int n = -1;
                    switch (((String)object).hashCode()) {
                        default: {
                            break;
                        }
                        case 1244161670: {
                            if (!((String)object).equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) break;
                            n = 2;
                            break;
                        }
                        case 545516589: {
                            if (!((String)object).equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) break;
                            n = 1;
                            break;
                        }
                        case -377527494: {
                            if (!((String)object).equals("android.bluetooth.device.action.UUID")) break;
                            n = 0;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            BluetoothHandFreeReceiver bluetoothHandFreeReceiver = this;
                            BluetoothHandFreeReceiver bluetoothHandFreeReceiver2 = bluetoothHandFreeReceiver;
                            BluetoothHandFreeReceiver bluetoothHandFreeReceiver3 = bluetoothHandFreeReceiver;
                            int n2 = parcelUuidArray.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                            try {
                                JL_Log.i(bluetoothHandFreeReceiver2.BluetoothBreProfiles.this.TAG, "onReceive: a2dp ACTION_CONNECTION_STATE_CHANGED device : " + BluetoothBreProfiles.this.printBtDeviceInfo(bluetoothDevice) + ", state : " + n2);
                                bluetoothHandFreeReceiver3.BluetoothBreProfiles.this.onA2dpStatus(bluetoothDevice, n2);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        case 1: {
                            BluetoothHandFreeReceiver bluetoothHandFreeReceiver = this;
                            BluetoothHandFreeReceiver bluetoothHandFreeReceiver4 = bluetoothHandFreeReceiver;
                            BluetoothHandFreeReceiver bluetoothHandFreeReceiver5 = bluetoothHandFreeReceiver;
                            int n3 = parcelUuidArray.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                            try {
                                JL_Log.i(bluetoothHandFreeReceiver4.BluetoothBreProfiles.this.TAG, "onReceive: hfp ACTION_CONNECTION_STATE_CHANGED device : " + BluetoothBreProfiles.this.printBtDeviceInfo(bluetoothDevice) + ", state : " + n3);
                                bluetoothHandFreeReceiver5.BluetoothBreProfiles.this.onHfpStatus(bluetoothDevice, n3);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            break;
                        }
                        case 0: {
                            object = parcelUuidArray.getParcelableArrayExtra("android.bluetooth.device.extra.UUID");
                            if (object == null) {
                                JL_Log.i(BluetoothBreProfiles.this.TAG, "onReceive: ACTION_UUID no uuids");
                                return;
                            }
                            parcelUuidArray = new ParcelUuid[((Object)object).length];
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                parcelUuidArray[i] = ParcelUuid.fromString((String)object[i].toString());
                                JL_Log.i(BluetoothBreProfiles.this.TAG, "onReceive: ACTION_UUID " + parcelUuidArray[i].toString());
                            }
                        }
                    }
                }
            }
        }
    }
}

