/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.impl;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.jieli.jl_bt_ota.impl.BluetoothBase;
import com.jieli.jl_bt_ota.impl.BluetoothBreProfiles;
import com.jieli.jl_bt_ota.impl.RcspAuth;
import com.jieli.jl_bt_ota.interfaces.IActionCallback;
import com.jieli.jl_bt_ota.interfaces.IUpgradeCallback;
import com.jieli.jl_bt_ota.model.DataInfo;
import com.jieli.jl_bt_ota.model.FileOffset;
import com.jieli.jl_bt_ota.model.OTAError;
import com.jieli.jl_bt_ota.model.ReConnectDevMsg;
import com.jieli.jl_bt_ota.model.ReconnectParam;
import com.jieli.jl_bt_ota.model.base.BaseError;
import com.jieli.jl_bt_ota.model.base.BasePacket;
import com.jieli.jl_bt_ota.model.base.CommandBase;
import com.jieli.jl_bt_ota.model.command.EnterUpdateModeCmd;
import com.jieli.jl_bt_ota.model.command.FirmwareUpdateBlockCmd;
import com.jieli.jl_bt_ota.model.command.NotifyUpdateContentSizeCmd;
import com.jieli.jl_bt_ota.model.command.SettingsMtuCmd;
import com.jieli.jl_bt_ota.model.parameter.FirmwareUpdateBlockParam;
import com.jieli.jl_bt_ota.model.parameter.FirmwareUpdateBlockResponseParam;
import com.jieli.jl_bt_ota.model.parameter.NotifyUpdateContentSizeParam;
import com.jieli.jl_bt_ota.model.parameter.SettingsMtuParam;
import com.jieli.jl_bt_ota.model.response.EnterUpdateModeResponse;
import com.jieli.jl_bt_ota.model.response.SettingsMtuResponse;
import com.jieli.jl_bt_ota.model.response.TargetInfoResponse;
import com.jieli.jl_bt_ota.thread.ReadFileThread;
import com.jieli.jl_bt_ota.tool.DataHandler;
import com.jieli.jl_bt_ota.tool.DataHandlerModify;
import com.jieli.jl_bt_ota.tool.DeviceReConnectManager;
import com.jieli.jl_bt_ota.tool.IDataHandler;
import com.jieli.jl_bt_ota.tool.ParseHelper;
import com.jieli.jl_bt_ota.tool.RcspOTA;
import com.jieli.jl_bt_ota.tool.UpgradeCbHelper;
import com.jieli.jl_bt_ota.util.BluetoothUtil;
import com.jieli.jl_bt_ota.util.CHexConver;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.FileUtil;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class BluetoothOTAManager
extends BluetoothBreProfiles
implements RcspAuth.IRcspAuthOp {
    public static boolean IS_USE_MODIFY_DATA_HANDLER = true;
    public static boolean IS_SUPPORT_NEW_RECONNECT_WAY = true;
    public static long FILE_CACHE_DATA_LIMIT = 0x200000L;
    private static final long L = 6000L;
    private static final long M = 1000L;
    private static final long N = 5000L;
    private static final int O = 4660;
    private static final int P = 4661;
    private static final int Q = 4662;
    private static final int R = 4663;
    private static final int S = 4664;
    private static final int T = 4665;
    private static final int U = 4672;
    private static final int V = 4673;
    private final RcspOTA v;
    private final DeviceReConnectManager w;
    private final RcspAuth x;
    private final UpgradeCbHelper y;
    private final ExecutorService z = Executors.newSingleThreadExecutor();
    private volatile boolean A = false;
    private volatile byte[] B;
    private volatile RandomAccessFile C;
    private long D = 20000L;
    private long E = 0L;
    private long F = 0L;
    private int G = 0;
    private int H = 0;
    private ReconnectParam I;
    private final Handler J = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(@NonNull Message message) {
            switch (message.what) {
                default: {
                    break;
                }
                case 4673: {
                    1 v0 = this;
                    JL_Log.w(v0.BluetoothOTAManager.this.TAG, "MSG_RECONNECT_DEVICE_TIMEOUT >>>>>");
                    v0.BluetoothOTAManager.this.a("MSG_OTA_RECONNECT_DEVICE_TIMEOUT", OTAError.buildError(16401));
                    break;
                }
                case 4672: {
                    BluetoothOTAManager.this.g();
                    break;
                }
                case 4665: {
                    1 v1 = this;
                    JL_Log.w(v1.BluetoothOTAManager.this.TAG, "MSG_WAIT_DEVICE_DISCONNECT :: ");
                    BluetoothOTAManager bluetoothOTAManager = v1.BluetoothOTAManager.this;
                    bluetoothOTAManager.a(bluetoothOTAManager.getConnectedBtDevice(), BluetoothOTAManager.this.I);
                    break;
                }
                case 4664: {
                    1 v3 = this;
                    message = (BluetoothDevice)message.obj;
                    JL_Log.w(v3.BluetoothOTAManager.this.TAG, "MSG_WAIT_EDR_DISCONNECT  ===> " + BluetoothOTAManager.this.printBtDeviceInfo((BluetoothDevice)message));
                    v3.BluetoothOTAManager.this.h((BluetoothDevice)message);
                    break;
                }
                case 4662: {
                    boolean bl = BluetoothOTAManager.this.isOTA();
                    1 v4 = this;
                    BluetoothOTAManager bluetoothOTAManager = v4.BluetoothOTAManager.this;
                    boolean bl2 = bluetoothOTAManager.isConnectedDevice(bluetoothOTAManager.getConnectedBtDevice());
                    boolean bl3 = v4.BluetoothOTAManager.this.w.isWaitingForUpdate();
                    BluetoothOTAManager bluetoothOTAManager2 = v4.BluetoothOTAManager.this;
                    Object[] objectArray = new Object[5];
                    Object[] objectArray2 = objectArray;
                    BluetoothOTAManager bluetoothOTAManager3 = bluetoothOTAManager2;
                    objectArray2[0] = bluetoothOTAManager3.printBtDeviceInfo(bluetoothOTAManager3.getConnectedBtDevice());
                    objectArray2[1] = bl;
                    objectArray2[2] = bl3;
                    objectArray2[3] = bl2;
                    objectArray[4] = BluetoothOTAManager.this.I;
                    JL_Log.i(bluetoothOTAManager2.TAG, CommonUtil.formatString("-MSG_OTA_RECONNECT_DEVICE- device : %s, isOTA = %s, isWaitingForUpdate = %s, isConnectedDevice = %s ReconnectParam = %s", objectArray2));
                    if (!bl || bl2 || !bl3 || BluetoothOTAManager.this.I == null) break;
                    1 v8 = this;
                    BluetoothOTAManager bluetoothOTAManager4 = v8.BluetoothOTAManager.this;
                    String string = bluetoothOTAManager4.w.getReconnectAddress();
                    bl3 = v8.BluetoothOTAManager.this.I.getFlag() == 1;
                    bluetoothOTAManager4.a(string, bl3);
                    if (!BluetoothOTAManager.this.getBluetoothOption().isUseReconnect()) {
                        BluetoothOTAManager.this.w.startReconnectTask();
                    } else {
                        long l = DeviceReConnectManager.RECONNECT_TIMEOUT;
                        BluetoothOTAManager.this.J.sendEmptyMessageDelayed(4673, l);
                    }
                    BluetoothOTAManager.this.a(null);
                    break;
                }
                case 4661: {
                    1 v9 = this;
                    message = (BluetoothDevice)message.obj;
                    JL_Log.i(v9.BluetoothOTAManager.this.TAG, "-MSG_CHANGE_BLE_MTU_TIMEOUT- device : " + BluetoothOTAManager.this.printBtDeviceInfo((BluetoothDevice)message));
                    if (v9.BluetoothOTAManager.this.i((BluetoothDevice)message)) {
                        BluetoothOTAManager.this.b((BluetoothDevice)message, 0);
                        break;
                    }
                    BluetoothOTAManager.this.c((BluetoothDevice)message, 2);
                    break;
                }
                case 4660: {
                    1 v10 = this;
                    JL_Log.w(v10.BluetoothOTAManager.this.TAG, "-MSG_START_RECEIVE_CMD_TIMEOUT- ");
                    v10.BluetoothOTAManager.this.a("Receive cmd timeout", OTAError.buildError(12299));
                }
            }
            return true;
        }
    });
    private final RcspAuth.OnRcspAuthListener K;

    public BluetoothOTAManager(Context context) {
        super(context);
        RcspAuth.OnRcspAuthListener onRcspAuthListener;
        RcspAuth.OnRcspAuthListener onRcspAuthListener2 = onRcspAuthListener;
        this.K = new RcspAuth.OnRcspAuthListener(){

            @Override
            public void onInitResult(boolean bl) {
                JL_Log.d(BluetoothOTAManager.this.TAG, "-onInitResult- " + bl);
            }

            @Override
            public void onAuthSuccess(BluetoothDevice bluetoothDevice) {
                14 v0 = this;
                v0.BluetoothOTAManager.this.mDeviceStatusCache.updateDeviceIsAuth(bluetoothDevice, true);
                boolean bl = v0.BluetoothOTAManager.this.i(bluetoothDevice);
                BluetoothOTAManager bluetoothOTAManager = BluetoothOTAManager.this;
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = bluetoothOTAManager.printBtDeviceInfo(bluetoothDevice);
                objectArray[1] = bl;
                JL_Log.w(bluetoothOTAManager.TAG, CommonUtil.formatString("-onAuthSuccess- >>> device[%s] auth ok, isBleConnected = %s", objectArray2));
                if (bl) {
                    BluetoothOTAManager.this.l(bluetoothDevice);
                } else {
                    BluetoothOTAManager.this.b(bluetoothDevice, 1);
                }
            }

            @Override
            public void onAuthFailed(BluetoothDevice bluetoothDevice, int n, String string) {
                14 v0 = this;
                BluetoothOTAManager bluetoothOTAManager = v0.BluetoothOTAManager.this;
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = bluetoothOTAManager.printBtDeviceInfo(bluetoothDevice);
                objectArray[1] = n;
                objectArray[2] = string;
                JL_Log.w(bluetoothOTAManager.TAG, CommonUtil.formatString("-onAuthFailed- device : %s, code : %d, message : %s", objectArray2));
                v0.BluetoothOTAManager.this.mDeviceStatusCache.updateDeviceIsAuth(bluetoothDevice, false);
                if (!v0.BluetoothOTAManager.this.w.isDeviceReconnecting()) {
                    BluetoothOTAManager.this.a(bluetoothDevice, OTAError.buildError(20481, n, string));
                } else {
                    BluetoothOTAManager.this.c(bluetoothDevice, 2);
                }
            }
        };
        this.v = new RcspOTA(this);
        this.w = new DeviceReConnectManager(context, this);
        this.x = new RcspAuth(context, this, onRcspAuthListener2);
        this.y = new UpgradeCbHelper();
    }

    private boolean j() {
        return this.getConnectedBtDevice() != null;
    }

    private boolean i(BluetoothDevice bluetoothDevice) {
        return this.isConnectedDevice(bluetoothDevice) && this.mBluetoothOption.getPriority() == 0;
    }

    private void c(boolean bl) {
        this.A = bl;
    }

    private void a(ReconnectParam reconnectParam) {
        this.I = reconnectParam;
    }

    private void p() {
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.w(bluetoothOTAManager.TAG, "releaseDataHandler>>>>>>>>>>>>>>>>>");
        if (bluetoothOTAManager.dataHandler != null) {
            this.dataHandler.release();
            this.dataHandler = null;
        }
    }

    private void b(int n, int n2, IActionCallback<byte[]> objectArray) {
        if (n >= 0 && n2 >= 0) {
            if (objectArray5.B != null && objectArray5.B.length > 0) {
                int n3 = n2;
                byte[] byArray = new byte[n3];
                if (n + n3 <= objectArray5.B.length) {
                    System.arraycopy(objectArray5.B, n, byArray, 0, n2);
                    if (objectArray != null) {
                        objectArray.onSuccess(byArray);
                    }
                } else if (objectArray != null) {
                    Object[] objectArray2 = objectArray;
                    Object[] objectArray3 = new Object[3];
                    objectArray = objectArray3;
                    objectArray[0] = n;
                    objectArray[1] = n2;
                    objectArray3[2] = objectArray5.B.length;
                    objectArray2.onError(OTAError.buildError(16388, CommonUtil.formatString("readBlockData :: Can not read file data by Buffer. offset = %d, len = %d, file data length = %d.", objectArray)));
                }
                return;
            }
            if (objectArray5.C != null) {
                objectArray5.z.execute(() -> {
                    int n3;
                    byte[] byArray;
                    block7: {
                        BluetoothOTAManager bluetoothOTAManager = this;
                        BluetoothOTAManager bluetoothOTAManager2 = bluetoothOTAManager;
                        BluetoothOTAManager bluetoothOTAManager3 = bluetoothOTAManager;
                        byArray = new byte[n2];
                        RandomAccessFile randomAccessFile = bluetoothOTAManager2.C;
                        randomAccessFile.seek(n);
                        n3 = bluetoothOTAManager3.C.read(byArray);
                        if (n3 == n2) break block7;
                        BluetoothOTAManager bluetoothOTAManager4 = this;
                        BluetoothOTAManager bluetoothOTAManager5 = bluetoothOTAManager4;
                        long l = bluetoothOTAManager4.C.length();
                        bluetoothOTAManager5.J.post(() -> {
                            if (objectArray != null) {
                                Object[] objectArray2 = objectArray;
                                Object[] objectArray3 = new Object[4];
                                objectArray = objectArray3;
                                objectArray[0] = n;
                                objectArray[1] = n2;
                                objectArray[2] = n3;
                                objectArray3[3] = l;
                                objectArray2.onError(OTAError.buildError(16388, CommonUtil.formatString("readBlockData :: Can not read file data by RandomAccessFile. offset = %d, len = %d, read data size = %d, file data length = %d.", objectArray)));
                            }
                        });
                        return;
                    }
                    try {
                        this.J.post(() -> {
                            if (objectArray != null) {
                                objectArray.onSuccess(Arrays.copyOfRange(byArray, 0, n3));
                            }
                        });
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.J.post(() -> {
                            if (objectArray != null) {
                                objectArray.onError(OTAError.buildError(20486, "readBlockData :: failed. " + iOException.getMessage()));
                            }
                        });
                    }
                });
                return;
            }
        }
        if (objectArray != null) {
            Object[] objectArray4 = new Object[2];
            Object[] objectArray5 = objectArray4;
            objectArray5[0] = n;
            objectArray4[1] = n2;
            objectArray.onError(OTAError.buildError(4097, CommonUtil.formatString("readBlockData :: Can not read file data. offset = %d, len = %d.", objectArray5)));
        }
    }

    private float a(int n) {
        float f = 0.0f;
        int n2 = this.G;
        if (n2 > 0) {
            float f2;
            f = (float)n * 100.0f / (float)n2;
            if (f2 >= 100.0f) {
                f = 99.9f;
            }
        }
        return f;
    }

    private void a(final BluetoothDevice bluetoothDevice, String object) {
        File file;
        if (!this.j()) {
            this.a("startReadFileThread", OTAError.buildError(4114));
            return;
        }
        this.f();
        File file2 = file;
        if (new File((String)object).exists() && file2.isFile()) {
            if (file2.length() <= FILE_CACHE_DATA_LIMIT) {
                IActionCallback<byte[]> iActionCallback;
                String string = object;
                object = iActionCallback;
                iActionCallback = new IActionCallback<byte[]>(){

                    @Override
                    public void onSuccess(byte[] byArray) {
                        String string = BluetoothOTAManager.this.TAG;
                        StringBuilder stringBuilder = new StringBuilder().append("ReadFileThread >>> onSuccess, length = ");
                        int n = byArray == null ? 0 : byArray.length;
                        3 v0 = this;
                        JL_Log.i(string, stringBuilder.append(n).toString());
                        BluetoothOTAManager.a(v0.BluetoothOTAManager.this, byArray);
                        v0.BluetoothOTAManager.this.m(bluetoothDevice);
                    }

                    @Override
                    public void onError(BaseError baseError) {
                        BluetoothOTAManager.this.a("ReadFileThread", baseError);
                    }
                };
                this.z.execute(new ReadFileThread(string, (IActionCallback<byte[]>)object));
            } else {
                this.z.execute(() -> {
                    try {
                        this.C = new RandomAccessFile(file2, "r");
                        this.m(bluetoothDevice);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.J.post(() -> this.a("startReadFileThread", OTAError.buildError(20484)));
                    }
                });
            }
            return;
        }
        this.a("startReadFileThread", OTAError.buildError(20484));
    }

    private void t() {
        if (this.a("startReceiveCmdTimeout")) {
            return;
        }
        if (this.D > 0L) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.J.removeMessages(4660);
            long l = this.D;
            bluetoothOTAManager.J.sendEmptyMessageDelayed(4660, l);
        }
    }

    private void u() {
        this.J.removeMessages(4660);
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean d(BluetoothDevice bluetoothDevice, int n) {
        if (!CommonUtil.checkHasConnectPermission(this.context)) {
            JL_Log.e(this.TAG, "--requestBleMtu-- no connect permission");
            return false;
        }
        BluetoothGatt bluetoothGatt = this.getConnectedBluetoothGatt();
        if (bluetoothGatt != null && BluetoothUtil.deviceEquals(bluetoothGatt.getDevice(), bluetoothDevice)) {
            if (Build.VERSION.SDK_INT >= 21) {
                JL_Log.e(this.TAG, "--requestBleMtu-- requestMtu is started.");
                if (!bluetoothGatt.requestMtu(n + 3)) {
                    JL_Log.e(this.TAG, "--requestBleMtu-- requestMtu failed. callback old mtu.");
                    this.onBleDataBlockChanged(bluetoothDevice, 20, 4115);
                    return false;
                }
            } else {
                JL_Log.e(this.TAG, "--requestBleMtu-- android sdk not support requestMtu method.");
                this.onBleDataBlockChanged(bluetoothDevice, 20, 4115);
            }
            return true;
        }
        JL_Log.e(this.TAG, "--requestBleMtu-- device is disconnected.");
        return false;
    }

    private void l(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return;
        }
        if (this.J.hasMessages(4661)) {
            JL_Log.w(this.TAG, "-startChangeMtu- Adjusting the MTU for BLE");
            return;
        }
        boolean bl = false;
        if (this.mBluetoothOption.isNeedChangeMtu() && this.mBluetoothOption.getMtu() > 20) {
            bl = this.d(bluetoothDevice, this.mBluetoothOption.getMtu());
        }
        JL_Log.d(this.TAG, "-startChangeMtu- requestBleMtu : " + bl);
        if (bl) {
            Handler handler = this.J;
            handler.sendMessageDelayed(handler.obtainMessage(4661, (Object)bluetoothDevice), 5000L);
        } else {
            this.b(bluetoothDevice, 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int f(BluetoothDevice object) {
        int n = this.mBluetoothOption.getPriority();
        if ((object = this.getDeviceInfo((BluetoothDevice)object)) == null) return n;
        if (((TargetInfoResponse)object).isSupportDoubleBackup()) return n;
        int n2 = ((TargetInfoResponse)object).getSingleBackupOtaWay();
        if (n2 == 1) {
            return 0;
        }
        if (n2 == 2) {
            return 1;
        }
        if (((TargetInfoResponse)object).getSdkType() < 2) return n;
        return 0;
    }

    private String a(BluetoothDevice object, int n) {
        BluetoothOTAManager bluetoothOTAManager = string;
        String string = object.getAddress();
        if ((object = bluetoothOTAManager.getDeviceInfo((BluetoothDevice)object)) == null || ((TargetInfoResponse)object).isSupportDoubleBackup() || !BluetoothAdapter.checkBluetoothAddress((String)(object = n == 1 ? ((TargetInfoResponse)object).getEdrAddr() : ((TargetInfoResponse)object).getBleAddr())) || ((String)object).equals(string)) {
            object = string;
        }
        return object;
    }

    private void b(BluetoothDevice bluetoothDevice, int n) {
        if (bluetoothDevice == null) {
            JL_Log.e(this.TAG, "-handleConnectedEvent- device is null.");
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.printBtDeviceInfo(bluetoothDevice);
        objectArray[1] = n;
        JL_Log.d(this.TAG, CommonUtil.formatString("-handleConnectedEvent- device : %s, way = %d", objectArray2));
        if (n == 0) {
            this.J.removeMessages(4661);
        }
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.setConnectedBtDevice(bluetoothDevice);
        bluetoothOTAManager.g(bluetoothDevice);
    }

    @SuppressLint(value={"MissingPermission"})
    private void g(final @NonNull BluetoothDevice bluetoothDevice) {
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.d(bluetoothOTAManager.TAG, "-getDeviceInfoWithConnection- start....");
        bluetoothOTAManager.v.getDeviceInfo(new IActionCallback<TargetInfoResponse>(){

            @Override
            public void onSuccess(TargetInfoResponse targetInfoResponse) {
                BluetoothOTAManager.this.mDeviceStatusCache.updateDeviceTargetInfo(bluetoothDevice, targetInfoResponse);
                if (targetInfoResponse.isSupportMD5()) {
                    BluetoothOTAManager.this.v.getMD5(new IActionCallback<String>(){

                        @Override
                        public void onSuccess(String string) {
                            1 v0 = iActionCallback;
                            JL_Log.i(v0.BluetoothOTAManager.this.TAG, "getDevMD5 ok, MD5 : " + string);
                            IActionCallback<String> iActionCallback = v0.this;
                            iActionCallback.BluetoothOTAManager.this.mDeviceStatusCache.updateDeviceMD5(iActionCallback.bluetoothDevice, string);
                        }

                        @Override
                        public void onError(BaseError baseError) {
                            JL_Log.i(BluetoothOTAManager.this.TAG, "getDevMD5 failed, " + baseError);
                        }
                    });
                }
                if (targetInfoResponse.isMandatoryUpgrade()) {
                    4 v0 = this;
                    JL_Log.w(v0.BluetoothOTAManager.this.TAG, "getDeviceInfoWithConnection >>>> sdkType : " + targetInfoResponse.getSdkType());
                    v0.BluetoothOTAManager.this.d(bluetoothDevice);
                    if (targetInfoResponse.getSdkType() >= 2) {
                        4 v1 = this;
                        targetInfoResponse = v1.BluetoothOTAManager.this.getConnectedBluetoothGatt();
                        if (CommonUtil.checkHasConnectPermission(v1.BluetoothOTAManager.this.context) && Build.VERSION.SDK_INT >= 21 && targetInfoResponse != null) {
                            boolean bl = targetInfoResponse.requestConnectionPriority(1);
                            JL_Log.w(BluetoothOTAManager.this.TAG, "-getDeviceInfoWithConnection- requestConnectionPriority :: ret : " + bl);
                        }
                    }
                } else {
                    4 v2 = this;
                    v2.BluetoothOTAManager.this.q();
                    if (v2.BluetoothOTAManager.this.isOTA()) {
                        BluetoothOTAManager.this.J.sendEmptyMessage(4672);
                    }
                }
                BluetoothOTAManager.this.c(bluetoothDevice);
            }

            @Override
            public void onError(BaseError baseError) {
                BluetoothOTAManager.this.a(bluetoothDevice, baseError);
            }
        });
    }

    private void a(BluetoothDevice bluetoothDevice, ReconnectParam reconnectParam) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.printBtDeviceInfo(bluetoothDevice);
        objectArray[1] = reconnectParam;
        JL_Log.d(this.TAG, CommonUtil.formatString("-startUpgradeReConnect- device : %s, ReconnectParam = %s", objectArray2));
        if (bluetoothDevice != null && reconnectParam != null) {
            boolean bl = this.isConnectedDevice(bluetoothDevice);
            JL_Log.i(this.TAG, "-startUpgradeReConnect- isConnectedDevice = " + bl);
            if (!bl) {
                this.h();
                return;
            }
            bl = this.i(bluetoothDevice);
            JL_Log.i(this.TAG, "-startUpgradeReConnect- isBLEConnected = " + bl);
            if (bl) {
                BluetoothOTAManager bluetoothOTAManager = this;
                JL_Log.d(bluetoothOTAManager.TAG, "-startUpgradeReConnect- waiting for ble disconnect... ");
                bluetoothOTAManager.h();
                return;
            }
            bl = this.isConnectedByProfile(bluetoothDevice) == 2;
            JL_Log.d(this.TAG, "-startUpgradeReConnect- isEDRConnected : " + bl);
            if (!bl) {
                JL_Log.d(this.TAG, "-startUpgradeReConnect- disconnectBluetoothDevice >>> ");
                this.disconnectBluetoothDevice(bluetoothDevice);
            } else {
                bl = this.disconnectByProfiles(bluetoothDevice);
                JL_Log.i(this.TAG, "-startUpgradeReConnect- disconnectEdrRet : " + bl);
                if (!bl) {
                    BluetoothOTAManager bluetoothOTAManager = this;
                    JL_Log.i(this.TAG, "-startUpgradeReConnect- disconnect edr failed. disconnectSPPDevice.");
                    bluetoothOTAManager.disconnectBluetoothDevice(bluetoothDevice);
                    bluetoothOTAManager.J.postDelayed(() -> {
                        BluetoothOTAManager bluetoothOTAManager = this;
                        boolean bl = BluetoothUtil.removeBond(bluetoothOTAManager.context, bluetoothDevice);
                        JL_Log.i(bluetoothOTAManager.TAG, "-startUpgradeReConnect- removeBond >>> " + bl);
                    }, 300L);
                }
            }
            return;
        }
    }

    private void d(boolean bl) {
        if (this.E > 0L) {
            this.F = CommonUtil.getCurrentTime() - this.E;
            if (bl) {
                this.E = 0L;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void r() {
        Throwable throwable2;
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.c(false);
        bluetoothOTAManager.u();
        bluetoothOTAManager.s();
        bluetoothOTAManager.d(true);
        bluetoothOTAManager.a((ReconnectParam)null);
        if (bluetoothOTAManager.B != null) {
            this.B = null;
            System.gc();
        }
        if (this.C == null) return;
        this.C.close();
        this.C = null;
        return;
        {
            catch (Throwable throwable2) {
            }
            catch (IOException iOException) {}
            {
                iOException.printStackTrace();
                this.C = null;
                return;
            }
        }
        this.C = null;
        throw throwable2;
    }

    private void f() {
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.i(bluetoothOTAManager.TAG, "callbackStartOTA : ");
        bluetoothOTAManager.resetTotalTime();
        bluetoothOTAManager.y.onStartOTA();
    }

    private void a(String string, boolean bl) {
        if (this.a("callbackReconnectEvent")) {
            return;
        }
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.i(bluetoothOTAManager.TAG, "callbackReconnectEvent : " + string + ", " + bl);
        bluetoothOTAManager.y.onNeedReconnect(string, bl);
    }

    private void a(BluetoothDevice object, float f) {
        if (this.a("callbackProgress")) {
            return;
        }
        int n = (object = this.getDeviceInfo((BluetoothDevice)object)) != null && !((TargetInfoResponse)object).isNeedBootLoader() ? 1 : 0;
        this.a(n, f);
    }

    private void a(int n, float f) {
        if (this.a("callbackProgress")) {
            return;
        }
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.d(bluetoothOTAManager.TAG, "callbackProgress : type = " + n + ", progress = " + f);
        bluetoothOTAManager.d(false);
        bluetoothOTAManager.y.onProgress(n, f);
    }

    private void g() {
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.i(bluetoothOTAManager.TAG, "callbackStopOTA : ");
        bluetoothOTAManager.r();
        bluetoothOTAManager.y.onStopOTA();
        bluetoothOTAManager.J.postDelayed(() -> this.y.setUpgradeCallback(null), 100L);
    }

    private void e() {
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.w(bluetoothOTAManager.TAG, "callbackCancelOTA : ");
        bluetoothOTAManager.r();
        bluetoothOTAManager.y.onCancelOTA();
        bluetoothOTAManager.J.postDelayed(() -> this.y.setUpgradeCallback(null), 100L);
    }

    private void a(String string, BaseError baseError) {
        if (!this.a("callbackError") && baseError != null) {
            BluetoothOTAManager bluetoothOTAManager = this;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = baseError;
            JL_Log.e(bluetoothOTAManager.TAG, CommonUtil.formatString("callbackError : %s --> %s", objectArray2));
            bluetoothOTAManager.r();
            bluetoothOTAManager.y.onError(baseError);
            bluetoothOTAManager.J.postDelayed(() -> this.y.setUpgradeCallback(null), 100L);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void a(BluetoothDevice var1_1, int var2_2, int var3_3) {
        if (var1_1 != null && var3_3 == 0) {
            block7: {
                var3_3 = 1;
                if (var2_2 == 1) {
                    if (this.isConnectedByA2dp(var1_1) == 0) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            var2_2 = 1;
                            break block7;
                            break;
                        }
                    }
                    while (true) {
                        var2_2 = 0;
                        break block7;
                        break;
                    }
                }
                if (var2_2 == 2) {
                    if (this.isConnectedByHfp(var1_1) != 0) ** continue;
                    ** continue;
                }
                var2_2 = var3_3;
            }
            if (var2_2 != 0 && this.J.hasMessages(4664)) {
                this.h(var1_1);
            }
            return;
        }
    }

    private void h(BluetoothDevice bluetoothDevice) {
        if (this.w.isWaitingForUpdate()) {
            this.J.removeMessages(4664);
            if (this.isConnectedDevice(bluetoothDevice)) {
                Handler handler = this.J;
                handler.sendMessageDelayed(handler.obtainMessage(4664, (Object)bluetoothDevice), 5000L);
                this.disconnectBluetoothDevice(bluetoothDevice);
            } else {
                this.h();
            }
        }
    }

    private void h() {
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.J.removeMessages(4662);
        bluetoothOTAManager.J.sendEmptyMessageDelayed(4662, 1000L);
    }

    private void d(BluetoothDevice bluetoothDevice) {
        if (this.mDeviceStatusCache.getMaxCommunicationMtu(bluetoothDevice) < 530) {
            this.mDeviceStatusCache.updateDeviceMaxCommunicationMtu(bluetoothDevice, 530);
        }
    }

    private void m(final BluetoothDevice bluetoothDevice) {
        if (this.a("upgradePrepare")) {
            return;
        }
        if (this.getDeviceInfo(bluetoothDevice) == null) {
            this.v.getDeviceInfo(new IActionCallback<TargetInfoResponse>(){

                @Override
                public void onSuccess(TargetInfoResponse targetInfoResponse) {
                    5 v0 = this;
                    v0.BluetoothOTAManager.this.mDeviceStatusCache.updateDeviceTargetInfo(bluetoothDevice, targetInfoResponse);
                    v0.BluetoothOTAManager.this.n(bluetoothDevice);
                }

                @Override
                public void onError(BaseError baseError) {
                    BluetoothOTAManager.this.a("upgradePrepare", baseError);
                }
            });
        } else {
            this.n(bluetoothDevice);
        }
    }

    private void n(final BluetoothDevice bluetoothDevice) {
        if (this.a("upgradeStep01")) {
            return;
        }
        this.v.readUpgradeFileFlag(new IActionCallback<FileOffset>(){

            @Override
            public void onSuccess(FileOffset fileOffset) {
                6 v0 = this_;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = fileOffset;
                JL_Log.i(v0.BluetoothOTAManager.this.TAG, CommonUtil.formatString("Step01.\u83b7\u53d6\u5347\u7ea7\u6587\u4ef6\u4fe1\u606f\u7684\u504f\u79fb\u5730\u5740, %s", objectArray2));
                v0.BluetoothOTAManager.this.a(this_.bluetoothDevice, 0.0f);
                FileOffset fileOffset2 = fileOffset;
                6 this_ = this_.bluetoothDevice;
                int n = fileOffset2.getOffset();
                int n2 = fileOffset2.getLen();
                v0.BluetoothOTAManager.this.b((BluetoothDevice)this_, n, n2);
            }

            @Override
            public void onError(BaseError baseError) {
                BluetoothOTAManager.this.a("upgradeStep01", baseError);
            }
        });
    }

    private void b(final BluetoothDevice object, int n, int n2) {
        if (objectArray3.a("upgradeStep02")) {
            return;
        }
        if (n2 >= 0 && n >= 0) {
            if (n == 0 && n2 == 0) {
                BluetoothDevice bluetoothDevice = object;
                byte[] byArray = new byte[1];
                object = byArray;
                byArray[0] = CHexConver.intToByte(objectArray3.mBluetoothOption.getPriority());
                super.a(bluetoothDevice, (byte[])object);
            } else {
                IActionCallback<byte[]> iActionCallback;
                IActionCallback<byte[]> iActionCallback2 = iActionCallback;
                iActionCallback = new IActionCallback<byte[]>(){

                    @Override
                    public void onSuccess(byte[] byArray) {
                        BluetoothOTAManager.this.a(object, byArray);
                    }

                    @Override
                    public void onError(BaseError baseError) {
                        BluetoothOTAManager.this.a("upgradeStep02", baseError);
                    }
                };
                super.b(n, n2, iActionCallback2);
            }
        } else {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n;
            objectArray2[1] = n2;
            super.a("upgradeStep02", OTAError.buildError(4097, CommonUtil.formatString("upgradeStep02: offset = %d, len = %d", objectArray3)));
        }
    }

    private void a(final BluetoothDevice bluetoothDevice, byte[] object) {
        IActionCallback<Integer> iActionCallback;
        byte[] byArray = object;
        object = iActionCallback;
        iActionCallback = new IActionCallback<Integer>(){

            @Override
            public void onSuccess(Integer object) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                JL_Log.i(BluetoothOTAManager.this.TAG, CommonUtil.formatString("Step2.\u53d1\u9001\u5347\u7ea7\u6587\u4ef6\u6821\u9a8c\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u53ef\u4ee5\u5347\u7ea7, \u7ed3\u679c: %d", objectArray2));
                if ((Integer)object == 0) {
                    BluetoothOTAManager.this.e(bluetoothDevice);
                    return;
                }
                switch ((Integer)object) {
                    default: {
                        int n = (Integer)object;
                        object = "upgradeStep2 :: Unknown error : " + object;
                        object = OTAError.buildError(16385, n, (String)object);
                        break;
                    }
                    case 5: {
                        object = OTAError.buildError(16398);
                        break;
                    }
                    case 4: {
                        object = OTAError.buildError(16397);
                        break;
                    }
                    case 3: {
                        object = OTAError.buildError(16396);
                        break;
                    }
                    case 2: {
                        object = OTAError.buildError(16387, "Command E2, result = " + object);
                        break;
                    }
                    case 1: {
                        object = OTAError.buildError(16386);
                    }
                }
                this.onError((BaseError)object);
            }

            @Override
            public void onError(BaseError baseError) {
                BluetoothOTAManager.this.a("upgradeStep02", baseError);
            }
        };
        this.v.inquiryDeviceCanOTA(byArray, (IActionCallback<Integer>)object);
    }

    private void e(BluetoothDevice bluetoothDevice) {
        if (this.a("checkUpgradeEnvironment")) {
            return;
        }
        TargetInfoResponse targetInfoResponse = this.getDeviceInfo(bluetoothDevice);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this.printBtDeviceInfo(bluetoothDevice);
        objectArray[1] = targetInfoResponse;
        JL_Log.d(this.TAG, CommonUtil.formatString("checkUpgradeEnvironment >> device : %s, deviceInfo \uff1a%s", objectArray2));
        if (targetInfoResponse == null) {
            this.a("checkUpgradeEnvironment", OTAError.buildError(4114));
            return;
        }
        if (targetInfoResponse.isSupportDoubleBackup()) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.q();
            bluetoothOTAManager.v();
        } else if (targetInfoResponse.isNeedBootLoader()) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.d(bluetoothDevice);
            bluetoothOTAManager.t();
        } else if (targetInfoResponse.isMandatoryUpgrade()) {
            this.v();
        } else {
            this.k(bluetoothDevice);
        }
    }

    private void k(final BluetoothDevice bluetoothDevice) {
        IActionCallback<Integer> iActionCallback;
        ReConnectDevMsg reConnectDevMsg;
        if (this.a("readyToReconnectDevice")) {
            return;
        }
        BluetoothOTAManager bluetoothOTAManager = this;
        int n = this.f(bluetoothDevice);
        String string = bluetoothOTAManager.a(bluetoothDevice, n);
        int n2 = IS_SUPPORT_NEW_RECONNECT_WAY;
        ReConnectDevMsg reConnectDevMsg2 = reConnectDevMsg;
        reConnectDevMsg = new ReConnectDevMsg(n, string);
        bluetoothOTAManager.w.setReConnectDevMsg(reConnectDevMsg2);
        JL_Log.d(bluetoothOTAManager.TAG, "readyToReconnectDevice : flag = " + n2 + ", " + reConnectDevMsg2);
        bluetoothOTAManager.a(new ReconnectParam(bluetoothDevice.getAddress(), n, string));
        bluetoothOTAManager.J.removeMessages(4665);
        bluetoothOTAManager.J.sendEmptyMessageDelayed(4665, 6000L);
        IActionCallback<Integer> iActionCallback2 = iActionCallback;
        iActionCallback = new IActionCallback<Integer>(){

            @Override
            public void onSuccess(Integer n) {
                9 v0 = this_;
                v0.BluetoothOTAManager.this.J.removeMessages(4665);
                if (v0.BluetoothOTAManager.this.w.isWaitingForUpdate()) {
                    DeviceReConnectManager deviceReConnectManager = this_.BluetoothOTAManager.this.w;
                    boolean bl = n == 1;
                    deviceReConnectManager.setReconnectUseADV(bl);
                }
                if (this_.BluetoothOTAManager.this.I != null) {
                    9 v1 = this_;
                    v1.BluetoothOTAManager.this.I.setFlag(n);
                    BluetoothOTAManager bluetoothOTAManager = v1.BluetoothOTAManager.this;
                    9 this_ = this_.bluetoothDevice;
                    bluetoothOTAManager.a((BluetoothDevice)this_, bluetoothOTAManager.I);
                }
            }

            @Override
            public void onError(BaseError baseError) {
                BluetoothOTAManager.this.a("readyToReconnectDevice", baseError);
            }
        };
        bluetoothOTAManager.v.changeCommunicationWay(n, n2, iActionCallback2);
    }

    private void v() {
        if (this.a("upgradeStep03")) {
            return;
        }
        this.v.enterUpdateMode(new IActionCallback<Integer>(){

            @Override
            public void onSuccess(Integer n) {
                JL_Log.i(BluetoothOTAManager.this.TAG, "Step3.\u8bf7\u6c42\u8fdb\u5165\u5347\u7ea7\u6a21\u5f0f, \u7ed3\u679c\u7801: " + n);
                if (n == 0) {
                    BluetoothOTAManager.this.t();
                    return;
                }
                this.onError(OTAError.buildError(16385, "Device is not allowed to enter the upgrade mode : " + n));
            }

            @Override
            public void onError(BaseError baseError) {
                BluetoothOTAManager.this.a("upgradeStep03", baseError);
            }
        });
    }

    private void a(final FirmwareUpdateBlockCmd firmwareUpdateBlockCmd, final int n, final int n2) {
        if (this.a("upgradeStep04")) {
            return;
        }
        this.u();
        if (n == 0 && n2 == 0) {
            BluetoothOTAManager bluetoothOTAManager = this;
            FirmwareUpdateBlockCmd firmwareUpdateBlockCmd2 = firmwareUpdateBlockCmd;
            JL_Log.i(this.TAG, "read data over.");
            firmwareUpdateBlockCmd2.setParam(null);
            firmwareUpdateBlockCmd2.setStatus(0);
            bluetoothOTAManager.sendCommandResponse(firmwareUpdateBlockCmd2);
            bluetoothOTAManager.w();
        } else {
            IActionCallback<byte[]> iActionCallback;
            IActionCallback<byte[]> iActionCallback2 = iActionCallback;
            iActionCallback = new IActionCallback<byte[]>(){

                @Override
                public void onSuccess(byte[] byArray) {
                    JL_Log.i(BluetoothOTAManager.this.TAG, "read data, offset = " + n + ", length = " + n2 + ", data len = " + byArray.length);
                    if (byArray.length > 0) {
                        11 v0 = this;
                        v0.firmwareUpdateBlockCmd.setParam(new FirmwareUpdateBlockResponseParam(byArray));
                        v0.firmwareUpdateBlockCmd.setStatus(0);
                        v0.BluetoothOTAManager.this.sendCommandResponse(firmwareUpdateBlockCmd);
                        v0.BluetoothOTAManager.this.t();
                    } else {
                        BluetoothOTAManager.this.a("upgradeStep04", OTAError.buildError(16388, "offset = " + n + ", length = " + n2));
                    }
                }

                @Override
                public void onError(BaseError baseError) {
                    BluetoothOTAManager.this.a("upgradeStep04", baseError);
                }
            };
            this.b(n, n2, iActionCallback2);
        }
    }

    private void w() {
        if (this.a("upgradeStep05")) {
            return;
        }
        this.v.queryUpdateResult(new IActionCallback<Integer>(){

            @Override
            public void onSuccess(Integer object) {
                JL_Log.i(string.BluetoothOTAManager.this.TAG, "Step05.\u8be2\u95ee\u5347\u7ea7\u72b6\u6001, \u7ed3\u679c\u7801: " + object);
                if ((Integer)object == 0) {
                    12 v0 = string;
                    v0.BluetoothOTAManager.this.c(false);
                    v0.BluetoothOTAManager.this.J.removeMessages(4672);
                    v0.BluetoothOTAManager.this.J.sendEmptyMessageDelayed(4672, 500L);
                    v0.BluetoothOTAManager.this.v.rebootDevice(new IActionCallback<Boolean>(){

                        @Override
                        public void onSuccess(Boolean bl) {
                            BluetoothOTAManager.this.o();
                        }

                        @Override
                        public void onError(BaseError baseError) {
                        }
                    });
                    return;
                }
                if ((Integer)object == 128) {
                    12 v1 = string;
                    v1.BluetoothOTAManager.this.resetTotalTime();
                    v1.BluetoothOTAManager.this.s();
                    TargetInfoResponse targetInfoResponse = v1.BluetoothOTAManager.this.getDeviceInfo();
                    JL_Log.i(string.BluetoothOTAManager.this.TAG, "upgradeStep05 :: check device info.\n" + targetInfoResponse);
                    if (targetInfoResponse != null && targetInfoResponse.isSupportDoubleBackup()) {
                        String string = "Double ota, but get a bad code: " + object;
                        string.BluetoothOTAManager.this.a("upgradeStep05", OTAError.buildError(16385, (Integer)object, string));
                        return;
                    }
                    BluetoothOTAManager bluetoothOTAManager = string.BluetoothOTAManager.this;
                    bluetoothOTAManager.k(bluetoothOTAManager.getConnectedBtDevice());
                    return;
                }
                switch ((Integer)object) {
                    default: {
                        int n = (Integer)object;
                        object = "Device returned to an unknown code : " + object;
                        object = OTAError.buildError(16400, n, (String)object);
                        break;
                    }
                    case 9: {
                        object = OTAError.buildError(16399);
                        break;
                    }
                    case 8: {
                        object = OTAError.buildError(16395);
                        break;
                    }
                    case 7: {
                        object = OTAError.buildError(16394);
                        break;
                    }
                    case 6: {
                        object = OTAError.buildError(16393);
                        break;
                    }
                    case 5: {
                        object = OTAError.buildError(16391);
                        break;
                    }
                    case 4: {
                        object = OTAError.buildError(16387);
                        break;
                    }
                    case 3: {
                        object = OTAError.buildError(16390);
                        break;
                    }
                    case 2: {
                        object = OTAError.buildError(16385, "Device return update failed.");
                        break;
                    }
                    case 1: {
                        object = OTAError.buildError(16389);
                    }
                }
                string.onError((BaseError)object);
            }

            @Override
            public void onError(BaseError baseError) {
                BluetoothOTAManager.this.a("upgradeStep05", baseError);
            }
        });
    }

    private void i() {
        if (this.a("exitUpdateMode")) {
            return;
        }
        Object[] objectArray = this.getDeviceInfo();
        if (objectArray != null && objectArray.isSupportDoubleBackup()) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.c(false);
            bluetoothOTAManager.v.exitUpdateMode(new IActionCallback<Integer>(){

                @Override
                public void onSuccess(Integer n) {
                    JL_Log.d(string.BluetoothOTAManager.this.TAG, "exitUpdateMode : onSuccess >>>" + n);
                    if (n == 0) {
                        string.BluetoothOTAManager.this.e();
                        return;
                    }
                    13 v0 = string;
                    String string = "Device return a bad code : " + n;
                    v0.onError(OTAError.buildError(16385, n, string));
                }

                @Override
                public void onError(BaseError baseError) {
                    13 v0 = this;
                    v0.BluetoothOTAManager.this.c(true);
                    v0.BluetoothOTAManager.this.a("exitUpdateMode", baseError);
                }
            });
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.getConnectedBtDevice();
            JL_Log.i(this.TAG, CommonUtil.formatString("exitUpdateMode : device[%s] is single flash ota, so ota progress cannot be interrupted.", objectArray));
        }
    }

    private void c(BluetoothDevice bluetoothDevice, int n) {
        JL_Log.i(this.TAG, "-notifyConnectionStatus- device : " + this.printBtDeviceInfo(bluetoothDevice) + ", status : " + n);
        if (n != 3) {
            if (n != 1 && n != 4) {
                if (n == 2 || n == 0) {
                    BluetoothOTAManager bluetoothOTAManager = this;
                    JL_Log.w(bluetoothOTAManager.TAG, "-notifyConnectionStatus- handler disconnect event.");
                    bluetoothOTAManager.p();
                    bluetoothOTAManager.u();
                    bluetoothOTAManager.mDeviceStatusCache.removeDeviceStatus(bluetoothDevice);
                    bluetoothOTAManager.o();
                }
            } else {
                JL_Log.i(this.TAG, "-notifyConnectionStatus- handler connected event.");
            }
        }
        this.onConnection(bluetoothDevice, n);
    }

    private void c(BluetoothDevice bluetoothDevice) {
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.c(bluetoothDevice, 1);
        TargetInfoResponse targetInfoResponse = bluetoothOTAManager.getDeviceInfo(bluetoothDevice);
        if (targetInfoResponse != null && !this.isOTA()) {
            if (targetInfoResponse.isMandatoryUpgrade() || targetInfoResponse.getRequestOtaFlag() == 1) {
                this.mBtEventCbHelper.onMandatoryUpgrade(bluetoothDevice);
            }
            return;
        }
    }

    private void a(BluetoothDevice bluetoothDevice, BaseError baseError) {
        BluetoothOTAManager bluetoothOTAManager = this;
        JL_Log.i(this.TAG, "-callbackConnectFailed- device \uff1a" + this.printBtDeviceInfo(bluetoothDevice) + " , error : " + baseError);
        bluetoothOTAManager.c(bluetoothDevice, 2);
        bluetoothOTAManager.a("callbackConnectFailed", baseError);
    }

    private boolean a(String string) {
        if (!this.isOTA()) {
            JL_Log.w(this.TAG, string + ": OTA process has exited.");
            return true;
        }
        return false;
    }

    private void q() {
        if (this.w.isWaitingForUpdate()) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.w.setReConnectDevMsg(null);
            bluetoothOTAManager.w.stopReconnectTask();
        }
    }

    private void s() {
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.H = 0;
        bluetoothOTAManager.G = 0;
    }

    private void o() {
        if (this.J.hasMessages(4672)) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.J.removeMessages(4672);
            bluetoothOTAManager.J.sendEmptyMessage(4672);
        }
    }

    private void a(BluetoothDevice bluetoothDevice, CommandBase commandBase, boolean bl) {
        int n = commandBase.getId();
        if (n != 194) {
            if (n != 209) {
                if (n != 229) {
                    if (n == 232) {
                        commandBase = (NotifyUpdateContentSizeCmd)commandBase;
                        if (this.a("Receive E8 command ")) {
                            CommandBase commandBase2 = commandBase;
                            commandBase2.setParam(null);
                            commandBase2.setStatus(1);
                            this.sendCommandResponse(commandBase);
                        } else {
                            JL_Log.e(this.TAG, "Receive E8 command : " + commandBase);
                            NotifyUpdateContentSizeParam notifyUpdateContentSizeParam = (NotifyUpdateContentSizeParam)commandBase.getParam();
                            if (notifyUpdateContentSizeParam == null) {
                                BluetoothOTAManager bluetoothOTAManager = this;
                                CommandBase commandBase3 = commandBase;
                                JL_Log.d(this.TAG, "Receive E8 command : command is error.");
                                commandBase3.setStatus(1);
                                bluetoothOTAManager.sendCommandResponse(commandBase3);
                                bluetoothOTAManager.a("Receive E8 command", OTAError.buildError(12293, "E8 command"));
                            } else {
                                n = notifyUpdateContentSizeParam.getContentSize();
                                if (n >= 0) {
                                    int n2;
                                    CommandBase commandBase4 = commandBase;
                                    this.E = CommonUtil.getCurrentTime();
                                    this.H = n2 = notifyUpdateContentSizeParam.getCurrentProgress();
                                    this.G = n;
                                    this.a(bluetoothDevice, this.a(n2));
                                    commandBase4.setStatus(0);
                                    commandBase4.setParam(null);
                                    this.sendCommandResponse(commandBase4);
                                } else {
                                    BluetoothOTAManager bluetoothOTAManager = this;
                                    JL_Log.w(bluetoothOTAManager.TAG, "Receive E8 command : length = " + n);
                                    bluetoothOTAManager.a("Receive E8 command", OTAError.buildError(4097, "Update content size is error. " + n));
                                }
                            }
                        }
                    }
                } else {
                    this.u();
                    commandBase = (FirmwareUpdateBlockCmd)commandBase;
                    if (this.a("Receive E5 command")) {
                        CommandBase commandBase5 = commandBase;
                        commandBase5.setParam(null);
                        commandBase5.setStatus(1);
                        this.sendCommandResponse(commandBase);
                    } else {
                        FirmwareUpdateBlockParam firmwareUpdateBlockParam = (FirmwareUpdateBlockParam)commandBase.getParam();
                        if (firmwareUpdateBlockParam == null) {
                            BluetoothOTAManager bluetoothOTAManager = this;
                            CommandBase commandBase6 = commandBase;
                            JL_Log.d(this.TAG, "Receive E5 command : command is error.");
                            commandBase6.setStatus(1);
                            bluetoothOTAManager.sendCommandResponse(commandBase6);
                            bluetoothOTAManager.a("Receive E5 command", OTAError.buildError(12293, "E5 command"));
                        } else {
                            FirmwareUpdateBlockParam firmwareUpdateBlockParam2 = firmwareUpdateBlockParam;
                            int n3 = firmwareUpdateBlockParam2.getNextUpdateBlockOffsetAddr();
                            n = firmwareUpdateBlockParam2.getNextUpdateBlockLen();
                            if (this.G > 0) {
                                int n4;
                                BluetoothOTAManager bluetoothOTAManager = this;
                                bluetoothOTAManager.H = n4 = bluetoothOTAManager.H + n;
                                this.a(bluetoothDevice, bluetoothOTAManager.a(n4));
                            }
                            this.a((FirmwareUpdateBlockCmd)commandBase, n3, n);
                        }
                    }
                }
            } else {
                SettingsMtuParam settingsMtuParam = (SettingsMtuParam)(commandBase = (SettingsMtuCmd)commandBase).getParam();
                if (settingsMtuParam == null) {
                    JL_Log.d(this.TAG, "Receive D1 command : command is error.");
                    if (bl) {
                        commandBase.setStatus(1);
                        this.sendCommandResponse(commandBase);
                    }
                } else {
                    int n5 = settingsMtuParam.getMtu();
                    int n6 = this.mDeviceStatusCache.getMaxCommunicationMtu(bluetoothDevice);
                    if (n5 >= 530) {
                        this.mDeviceStatusCache.updateDeviceMaxCommunicationMtu(bluetoothDevice, n5);
                        n6 = n5;
                    }
                    if (bl) {
                        settingsMtuParam.setMtu(n6);
                        commandBase.setStatus(0);
                        this.sendCommandResponse(commandBase);
                    }
                }
            }
        } else {
            boolean bl2 = this.isOTA();
            BluetoothOTAManager bluetoothOTAManager = this;
            boolean bl3 = bluetoothOTAManager.J.hasMessages(4663);
            JL_Log.d(bluetoothOTAManager.TAG, "Receive C2 command : isOTA = " + bl2 + ", hasStopAdvNotify = " + bl3);
            if (bl2 && !bl3) {
                BluetoothOTAManager bluetoothOTAManager2 = this;
                bluetoothOTAManager2.J.sendEmptyMessageDelayed(4663, 3000L);
                bluetoothOTAManager2.v.stopADVInfo(null);
            }
        }
    }

    private void a(BluetoothDevice bluetoothDevice, CommandBase object) {
        if (((CommandBase)object).getStatus() != 0) {
            return;
        }
        int n = ((CommandBase)object).getId();
        if (n != 209) {
            if (n != 227) {
                if (n == 231) {
                    JL_Log.e(this.TAG, "handleResponseCommand :: reboot >>> ");
                    this.disconnectBluetoothDevice(bluetoothDevice);
                }
            } else if ((object = (EnterUpdateModeResponse)((EnterUpdateModeCmd)object).getResponse()) != null && ((EnterUpdateModeResponse)object).getCanUpdateFlag() == 0) {
                this.d(bluetoothDevice);
            }
        } else if ((object = (SettingsMtuResponse)((SettingsMtuCmd)object).getResponse()) != null) {
            this.mDeviceStatusCache.updateDeviceMaxCommunicationMtu(bluetoothDevice, ((SettingsMtuResponse)object).getRealMtu());
        }
    }

    static /* synthetic */ byte[] a(BluetoothOTAManager bluetoothOTAManager, byte[] byArray) {
        bluetoothOTAManager.B = byArray;
        return byArray;
    }

    @Override
    public void onAdapterStatus(boolean bl, boolean bl2) {
        super.onAdapterStatus(bl, bl2);
        if (!bl) {
            BluetoothOTAManager bluetoothOTAManager = this;
            bluetoothOTAManager.a("onAdapterStatus", OTAError.buildError(4099));
            BluetoothDevice bluetoothDevice = bluetoothOTAManager.getConnectedBtDevice();
            if (bluetoothDevice != null) {
                this.c(bluetoothDevice, 0);
            }
        }
    }

    @Override
    public void onA2dpStatus(BluetoothDevice bluetoothDevice, int n) {
        BluetoothOTAManager bluetoothOTAManager = this;
        super.onA2dpStatus(bluetoothDevice, n);
        bluetoothOTAManager.a(bluetoothDevice, 2, n);
    }

    @Override
    public void onHfpStatus(BluetoothDevice bluetoothDevice, int n) {
        BluetoothOTAManager bluetoothOTAManager = this;
        super.onHfpStatus(bluetoothDevice, n);
        bluetoothOTAManager.a(bluetoothDevice, 1, n);
    }

    @Override
    public void onMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
        if (bluetoothGatt == null) {
            return;
        }
        int n3 = 20;
        if (n2 == 0) {
            n3 = n - 3;
        }
        JL_Log.e(this.TAG, "--onMtuChanged-- bleMtu : " + n3);
        this.onBleDataBlockChanged(bluetoothGatt.getDevice(), n3, n2);
    }

    @Override
    public void onBleDataBlockChanged(BluetoothDevice bluetoothDevice, int n, int n2) {
        BluetoothOTAManager bluetoothOTAManager = this;
        super.onBleDataBlockChanged(bluetoothDevice, n, n2);
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.printBtDeviceInfo(bluetoothDevice);
        objectArray2[1] = n;
        objectArray[2] = n2;
        JL_Log.i(bluetoothOTAManager.TAG, CommonUtil.formatString("-onBleDataBlockChanged- device : %s, block : %d, status : %d", objectArray2));
        if (bluetoothOTAManager.J.hasMessages(4661)) {
            BluetoothOTAManager bluetoothOTAManager2 = this;
            bluetoothOTAManager2.J.removeMessages(4661);
            JL_Log.i(bluetoothOTAManager2.TAG, "-onBleDataBlockChanged- handleConnectedEvent >>>");
            this.b(bluetoothDevice, 0);
        }
    }

    @Override
    public void onBtDeviceConnection(BluetoothDevice bluetoothDevice, int n) {
        BluetoothOTAManager bluetoothOTAManager = this;
        super.onBtDeviceConnection(bluetoothDevice, n);
        JL_Log.i(bluetoothOTAManager.TAG, "-onBtDeviceConnection- device : " + this.printBtDeviceInfo(bluetoothDevice) + ", " + n);
        if (n != 3) {
            this.J.removeMessages(4673);
        }
        if (n != 1) {
            if (BluetoothUtil.deviceEquals(bluetoothDevice, this.getConnectedBtDevice())) {
                this.setConnectedBtDevice(null);
            }
            this.c(bluetoothDevice, n);
        } else {
            if (this.dataHandler == null) {
                IDataHandler iDataHandler;
                if (IS_USE_MODIFY_DATA_HANDLER) {
                    DataHandlerModify dataHandlerModify;
                    iDataHandler = dataHandlerModify;
                    dataHandlerModify = new DataHandlerModify(this);
                } else {
                    DataHandler dataHandler;
                    iDataHandler = dataHandler;
                    dataHandler = new DataHandler(this);
                }
                this.dataHandler = iDataHandler;
            }
            if (!this.checkDeviceIsCertify(bluetoothDevice)) {
                BluetoothOTAManager bluetoothOTAManager2 = this;
                bluetoothOTAManager2.x.stopAuth(bluetoothDevice, false);
                if (!bluetoothOTAManager2.x.startAuth(bluetoothDevice)) {
                    this.a(bluetoothDevice, OTAError.buildError(20481));
                }
            } else if (this.i(bluetoothDevice)) {
                this.l(bluetoothDevice);
            } else {
                this.b(bluetoothDevice, 1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onConnection(BluetoothDevice bluetoothDevice, int n) {
        block6: {
            boolean bl;
            boolean bl2;
            block7: {
                Object[] objectArray;
                block8: {
                    if (n == 3) break block6;
                    BluetoothOTAManager bluetoothOTAManager = this;
                    bl2 = bluetoothOTAManager.isOTA();
                    bl = bluetoothOTAManager.w.isWaitingForUpdate();
                    Object[] objectArray2 = new Object[4];
                    objectArray = objectArray2;
                    objectArray[0] = this.printBtDeviceInfo(bluetoothDevice);
                    objectArray[1] = n;
                    objectArray[2] = bl2;
                    objectArray2[3] = bl;
                    JL_Log.i(bluetoothOTAManager.TAG, CommonUtil.formatString("onConnection :: device : %s, status : %d, isOTA = %s, isWaitingForUpdate = %s", objectArray));
                    if (n == 0) break block7;
                    if (n == 1) break block8;
                    if (n == 2) break block7;
                    break block6;
                }
                boolean bl3 = bl2;
                BluetoothOTAManager bluetoothOTAManager = this;
                bl2 = bluetoothOTAManager.mDeviceStatusCache.isMandatoryUpgrade(bluetoothDevice);
                Object[] objectArray3 = new Object[2];
                objectArray = objectArray3;
                objectArray[0] = bl2;
                objectArray3[1] = bl;
                JL_Log.w(bluetoothOTAManager.TAG, CommonUtil.formatString("onConnection :: connect success, isMandatoryUpgrade = %s, isWaitingForUpdate = %s", objectArray));
                if (bl3 && bl) {
                    this.q();
                    if (bl2) {
                        BluetoothOTAManager bluetoothOTAManager2 = this;
                        JL_Log.e(this.TAG, "-wait for update- continue...");
                        bluetoothOTAManager2.a(bluetoothDevice, 0.0f);
                        bluetoothOTAManager2.v();
                    }
                }
                break block6;
            }
            this.J.removeMessages(4663);
            if (bl2) {
                if (bl) {
                    BluetoothOTAManager bluetoothOTAManager = this;
                    JL_Log.i(bluetoothOTAManager.TAG, "onConnection :: device state = " + n + ", " + this.I);
                    bluetoothOTAManager.J.removeMessages(4664);
                    bluetoothOTAManager.J.removeMessages(4665);
                    if (bluetoothOTAManager.I != null) {
                        BluetoothOTAManager bluetoothOTAManager3 = this;
                        JL_Log.i(bluetoothOTAManager3.TAG, "onConnection :: device communication channel is disconnect. ready reconnect task. ");
                        bluetoothOTAManager3.h();
                        return;
                    }
                } else {
                    BluetoothOTAManager bluetoothOTAManager = this;
                    JL_Log.i(bluetoothOTAManager.TAG, "onConnection :: ota failed.");
                    bluetoothOTAManager.a("onConnection", OTAError.buildError(4114));
                }
            }
        }
        super.onConnection(bluetoothDevice, n);
    }

    @Override
    public void onReceiveDeviceData(BluetoothDevice bluetoothDevice, byte[] byArray) {
        if (bluetoothDevice != null && byArray != null) {
            JL_Log.d(((BluetoothBase)((Object)dataInfo)).TAG, "---onReceiveDeviceData-- >>> device : " + ((BluetoothBase)((Object)dataInfo)).printBtDeviceInfo(bluetoothDevice) + ", recv data : " + CHexConver.byte2HexStr(byArray));
            if (!((BluetoothBase)((Object)dataInfo)).checkDeviceIsCertify(bluetoothDevice)) {
                BluetoothOTAManager bluetoothOTAManager = dataInfo;
                JL_Log.i(bluetoothOTAManager.TAG, "--onReceiveDeviceData-- >>> handleAuthData ");
                bluetoothOTAManager.x.handleAuthData(bluetoothDevice, byArray);
                return;
            }
            if (((BluetoothBase)((Object)dataInfo)).dataHandler == null) {
                JL_Log.i(((BluetoothBase)((Object)dataInfo)).TAG, "--onReceiveDeviceData-- >>> dataHandler is null ");
                return;
            }
            BluetoothOTAManager bluetoothOTAManager = dataInfo;
            DataInfo dataInfo = new DataInfo().setType(1).setDevice(bluetoothDevice).setRecvData(byArray);
            bluetoothOTAManager.dataHandler.addRecvData(dataInfo);
            JL_Log.d(bluetoothOTAManager.TAG, "--onReceiveDeviceData-- >> addRecvData >>>> " + dataInfo);
            return;
        }
    }

    @Override
    public void receiveDataFromDevice(BluetoothDevice bluetoothDevice, byte[] object) {
        ArrayList<BasePacket> arrayList = ParseHelper.findPacketData(bluetoothDevice, this.getReceiveMtu(bluetoothDevice), (byte[])object);
        object = arrayList;
        if (arrayList != null && !((ArrayList)object).isEmpty()) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                BasePacket basePacket = (BasePacket)object.next();
                CommandBase commandBase = ParseHelper.convert2Command(basePacket, this.getCacheCommand(bluetoothDevice, basePacket));
                if (commandBase == null) {
                    JL_Log.e(this.TAG, "receiveDataFromDevice :: command is null");
                    continue;
                }
                JL_Log.d(this.TAG, "receiveDataFromDevice :: " + commandBase);
                if (basePacket.getType() == 1) {
                    this.onReceiveCommand(bluetoothDevice, commandBase);
                    boolean bl = basePacket.getHasResponse() == 1;
                    this.a(bluetoothDevice, commandBase, bl);
                    continue;
                }
                this.a(bluetoothDevice, commandBase);
            }
            return;
        }
        JL_Log.w(this.TAG, "receiveDataFromDevice :: not find OTA command.");
    }

    @Override
    public void errorEventCallback(BaseError baseError) {
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.mBtEventCbHelper.onError(baseError);
        bluetoothOTAManager.a("errorEventCallback", baseError);
    }

    public boolean isOTA() {
        return this.A;
    }

    public long getTimeout_ms() {
        return this.D;
    }

    public void setTimeout_ms(long l) {
        this.D = l;
    }

    public void resetTotalTime() {
        this.F = 0L;
    }

    public long getTotalTime() {
        return this.F;
    }

    public int getUpdateContentSize() {
        return this.G;
    }

    public void setReconnectAddress(String string) {
        if (this.w.isWaitingForUpdate() && BluetoothAdapter.checkBluetoothAddress((String)string)) {
            this.w.setReconnectAddress(string);
        }
    }

    public TargetInfoResponse getDeviceInfo(BluetoothDevice bluetoothDevice) {
        return this.mDeviceStatusCache.getDeviceInfo(bluetoothDevice);
    }

    public int getCommunicationMtu(BluetoothDevice bluetoothDevice) {
        return this.mDeviceStatusCache.getMaxCommunicationMtu(bluetoothDevice);
    }

    public int getReceiveMtu(BluetoothDevice bluetoothDevice) {
        return this.mDeviceStatusCache.getMaxReceiveMtu(bluetoothDevice);
    }

    @Override
    public TargetInfoResponse getDeviceInfo() {
        BluetoothOTAManager bluetoothOTAManager = this;
        return bluetoothOTAManager.getDeviceInfo(bluetoothOTAManager.getConnectedBtDevice());
    }

    @Override
    public void queryMandatoryUpdate(final IActionCallback<TargetInfoResponse> iActionCallback) {
        final BluetoothDevice bluetoothDevice = this.getConnectedBtDevice();
        if (bluetoothDevice == null) {
            JL_Log.w(this.TAG, "-queryMandatoryUpdate- Bluetooth device is disconnected.");
            if (iActionCallback != null) {
                iActionCallback.onError(OTAError.buildError(4114));
            }
            return;
        }
        TargetInfoResponse targetInfoResponse = this.getDeviceInfo(bluetoothDevice);
        JL_Log.i(this.TAG, "-queryMandatoryUpdate- cache deviceInfo : " + targetInfoResponse);
        if (targetInfoResponse != null) {
            if (!targetInfoResponse.isMandatoryUpgrade() && targetInfoResponse.getRequestOtaFlag() != 1) {
                if (iActionCallback != null) {
                    iActionCallback.onError(OTAError.buildError(0, "Device is connected."));
                }
            } else {
                if (iActionCallback != null) {
                    iActionCallback.onSuccess(targetInfoResponse);
                }
                this.mBtEventCbHelper.onMandatoryUpgrade(bluetoothDevice);
            }
        } else {
            this.v.getDeviceInfo(new IActionCallback<TargetInfoResponse>(){

                @Override
                public void onSuccess(TargetInfoResponse targetInfoResponse) {
                    2 v0 = this;
                    v0.BluetoothOTAManager.this.mDeviceStatusCache.updateDeviceTargetInfo(bluetoothDevice, targetInfoResponse);
                    v0.BluetoothOTAManager.this.queryMandatoryUpdate(iActionCallback);
                }

                @Override
                public void onError(BaseError baseError) {
                    IActionCallback<TargetInfoResponse> iActionCallback2 = iActionCallback2.iActionCallback;
                    if (iActionCallback2 != null) {
                        iActionCallback2.onError(baseError);
                    }
                }
            });
        }
    }

    @Override
    public boolean sendAuthDataToDevice(BluetoothDevice bluetoothDevice, byte[] byArray) {
        return this.sendDataToDevice(bluetoothDevice, byArray);
    }

    @Override
    public void startOTA(IUpgradeCallback object) {
        BluetoothDevice bluetoothDevice = this.getConnectedBtDevice();
        if (bluetoothDevice == null) {
            JL_Log.w(this.TAG, "startOTA : Bluetooth device is disconnected.");
            if (object != null) {
                object.onError(OTAError.buildError(4114));
            }
            return;
        }
        if (this.isOTA()) {
            JL_Log.w(this.TAG, "startOTA : OTA is in progress.");
            if (object != null) {
                object.onError(OTAError.buildError(16392));
            }
            return;
        }
        if (!this.getBluetoothOption().isUseAuthDevice()) {
            this.mDeviceStatusCache.updateDeviceIsAuth(bluetoothDevice, true);
        }
        BluetoothOTAManager bluetoothOTAManager = this;
        bluetoothOTAManager.c(true);
        bluetoothOTAManager.y.setUpgradeCallback((IUpgradeCallback)object);
        if (FileUtil.checkFileExist(bluetoothOTAManager.getBluetoothOption().getFirmwareFilePath())) {
            this.a(bluetoothDevice, this.getBluetoothOption().getFirmwareFilePath());
        } else if (this.getBluetoothOption().getFirmwareFileData() != null && this.getBluetoothOption().getFirmwareFileData().length > 0) {
            BluetoothOTAManager bluetoothOTAManager2 = this;
            bluetoothOTAManager2.B = bluetoothOTAManager2.getBluetoothOption().getFirmwareFileData();
            object = bluetoothOTAManager2.TAG;
            StringBuilder stringBuilder = new StringBuilder().append("startOTA : data size = ");
            int n = bluetoothOTAManager2.B == null ? 0 : this.B.length;
            JL_Log.d((String)object, stringBuilder.append(n).toString());
            this.f();
            this.m(bluetoothDevice);
        } else {
            this.a("startOTA", OTAError.buildError(20485));
        }
    }

    @Override
    public void cancelOTA() {
        this.i();
    }

    @Override
    public void release() {
        BluetoothOTAManager bluetoothOTAManager = this;
        super.release();
        bluetoothOTAManager.cancelOTA();
        bluetoothOTAManager.r();
        bluetoothOTAManager.w.release();
        if (!bluetoothOTAManager.z.isShutdown()) {
            this.z.shutdownNow();
        }
        BluetoothOTAManager bluetoothOTAManager2 = this;
        bluetoothOTAManager2.x.removeListener(this.K);
        bluetoothOTAManager2.x.destroy();
        bluetoothOTAManager2.y.release();
        bluetoothOTAManager2.J.removeCallbacksAndMessages(null);
        bluetoothOTAManager2.p();
        JL_Log.e(bluetoothOTAManager2.TAG, "release..........>>>>>>>>>>>>>>>>>");
    }
}

