/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.model;

import androidx.annotation.NonNull;
import com.jieli.jl_bt_ota.interfaces.rcsp.ICmdSnGenerator;

public class BluetoothOTAConfigure {
    public static final int PREFER_SPP = 1;
    public static final int PREFER_BLE = 0;
    private int priority = 0;
    private boolean isUseReconnect = false;
    private boolean isUseAuthDevice;
    private int bleIntervalMs = 500;
    private int timeoutMs = 3000;
    private boolean isUseJLServer = false;
    private String firmwareFilePath;
    private byte[] firmwareFileData;
    private ICmdSnGenerator snGenerator;
    @Deprecated
    private String scanFilterData;
    private int mtu = 20;
    private boolean isNeedChangeMtu = false;
    private int bleScanMode = 0;

    public static BluetoothOTAConfigure createDefault() {
        return new BluetoothOTAConfigure().setPriority(0).setBleIntervalMs(500).setTimeoutMs(3000).setUseAuthDevice(false).setUseReconnect(false).setMtu(20).setUseJLServer(false).setNeedChangeMtu(false);
    }

    public int getPriority() {
        return this.priority;
    }

    public BluetoothOTAConfigure setPriority(int n) {
        this.priority = n;
        return this;
    }

    public boolean isUseReconnect() {
        return this.isUseReconnect;
    }

    public BluetoothOTAConfigure setUseReconnect(boolean bl) {
        this.isUseReconnect = bl;
        return this;
    }

    public boolean isUseAuthDevice() {
        return this.isUseAuthDevice;
    }

    public BluetoothOTAConfigure setUseAuthDevice(boolean bl) {
        this.isUseAuthDevice = bl;
        return this;
    }

    public int getBleIntervalMs() {
        return this.bleIntervalMs;
    }

    public BluetoothOTAConfigure setBleIntervalMs(int n) {
        this.bleIntervalMs = n;
        return this;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public BluetoothOTAConfigure setTimeoutMs(int n) {
        if (n < 500) {
            n = 500;
        }
        this.timeoutMs = n;
        return this;
    }

    @Deprecated
    public String getScanFilterData() {
        return this.scanFilterData;
    }

    @Deprecated
    public BluetoothOTAConfigure setScanFilterData(String string) {
        this.scanFilterData = string;
        return this;
    }

    public int getMtu() {
        return this.mtu;
    }

    public BluetoothOTAConfigure setMtu(int n) {
        this.mtu = n;
        return this;
    }

    public boolean isUseJLServer() {
        return this.isUseJLServer;
    }

    public BluetoothOTAConfigure setUseJLServer(boolean bl) {
        this.isUseJLServer = bl;
        return this;
    }

    public String getFirmwareFilePath() {
        return this.firmwareFilePath;
    }

    public BluetoothOTAConfigure setFirmwareFilePath(String string) {
        this.firmwareFilePath = string;
        return this;
    }

    public int getBleScanMode() {
        return this.bleScanMode;
    }

    public BluetoothOTAConfigure setBleScanMode(int n) {
        this.bleScanMode = n;
        return this;
    }

    public boolean isNeedChangeMtu() {
        return this.isNeedChangeMtu;
    }

    public BluetoothOTAConfigure setNeedChangeMtu(boolean bl) {
        this.isNeedChangeMtu = bl;
        return this;
    }

    public byte[] getFirmwareFileData() {
        return this.firmwareFileData;
    }

    public BluetoothOTAConfigure setFirmwareFileData(byte[] byArray) {
        this.firmwareFileData = byArray;
        return this;
    }

    public ICmdSnGenerator getSnGenerator() {
        return this.snGenerator;
    }

    public void setSnGenerator(ICmdSnGenerator iCmdSnGenerator) {
        this.snGenerator = iCmdSnGenerator;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("BluetoothOTAConfigure{priority=").append(this.priority).append(", isUseReconnect=").append(this.isUseReconnect).append(", isUseAuthDevice=").append(this.isUseAuthDevice).append(", bleIntervalMs=").append(this.bleIntervalMs).append(", timeoutMs=").append(this.timeoutMs).append(", isUseJLServer=").append(this.isUseJLServer).append(", firmwareFilePath='").append(this.firmwareFilePath).append('\'').append(", scanFilterData='").append(this.scanFilterData).append('\'').append(", mtu=").append(this.mtu).append(", bleScanMode=").append(this.bleScanMode).append(", firmwareFileData= ");
        byte[] byArray = this.firmwareFileData;
        int n = this.firmwareFileData == null ? 0 : byArray.length;
        return stringBuilder.append(n).append(", snGenerator=").append(this.snGenerator).append('}').toString();
    }
}

