/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.tool;

import android.os.Handler;
import android.os.Looper;
import com.jieli.jl_bt_ota.tool.CallbackRunnable;
import com.jieli.jl_bt_ota.tool.ICallbackHandler;
import java.util.ArrayList;

public abstract class BaseCallbackHelper<T> {
    protected final ArrayList<T> callbacks = new ArrayList();
    private final Handler a = new Handler(Looper.getMainLooper());

    public boolean addCallback(T t) {
        if (t == null) {
            return false;
        }
        boolean bl = this.callbacks.contains(t);
        if (!bl) {
            bl = this.callbacks.add(t);
        }
        return bl;
    }

    public boolean removeCallback(T t) {
        if (t != null && !this.callbacks.isEmpty()) {
            return this.callbacks.remove(t);
        }
        return false;
    }

    public void release() {
        BaseCallbackHelper baseCallbackHelper = this;
        baseCallbackHelper.callbacks.clear();
        baseCallbackHelper.a.removeCallbacksAndMessages(null);
    }

    protected void callbackEvent(ICallbackHandler<T> iCallbackHandler) {
        CallbackRunnable<T> callbackRunnable;
        if (iCallbackHandler == null) {
            return;
        }
        CallbackRunnable<T> callbackRunnable2 = callbackRunnable;
        callbackRunnable = new CallbackRunnable<T>(this.callbacks, iCallbackHandler);
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            callbackRunnable2.run();
        } else {
            this.a.post(callbackRunnable2);
        }
    }
}

