/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.tool;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.jieli.jl_bt_ota.impl.BluetoothOTAManager;
import com.jieli.jl_bt_ota.model.DataInfo;
import com.jieli.jl_bt_ota.model.OTAError;
import com.jieli.jl_bt_ota.model.base.BaseError;
import com.jieli.jl_bt_ota.model.base.BasePacket;
import com.jieli.jl_bt_ota.model.base.CommandBase;
import com.jieli.jl_bt_ota.tool.DataInfoCache;
import com.jieli.jl_bt_ota.tool.IDataHandler;
import com.jieli.jl_bt_ota.tool.ParseHelper;
import com.jieli.jl_bt_ota.tool.RcspParser;
import com.jieli.jl_bt_ota.util.CHexConver;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.util.ArrayList;

public class DataHandlerModify
implements IDataHandler {
    private final String a = DataHandlerModify.class.getSimpleName();
    private final BluetoothOTAManager b;
    private final RcspParser c;
    private final DataInfoCache d = new DataInfoCache();
    private final HandlerThread e;
    private final Handler f;
    private final Handler g;

    public DataHandlerModify(@NonNull BluetoothOTAManager bluetoothOTAManager) {
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        DataHandlerModify dataHandlerModify = this;
        DataHandlerModify dataHandlerModify2 = this;
        HandlerThread handlerThread3 = handlerThread2;
        handlerThread3("DataHandlerModify");
        dataHandlerModify2.e = handlerThread3;
        dataHandlerModify2.g = new Handler(Looper.getMainLooper());
        dataHandlerModify.b = bluetoothOTAManager;
        dataHandlerModify.c = new RcspParser();
        handlerThread.start();
        this.f = new Handler(handlerThread2.getLooper(), object -> {
            object = object.obj;
            if (object instanceof Runnable) {
                ((Runnable)object).run();
            }
            return true;
        });
    }

    private long a() {
        return System.currentTimeMillis();
    }

    private int a(BluetoothDevice bluetoothDevice) {
        return this.b.getCommunicationMtu(bluetoothDevice);
    }

    private int b(BluetoothDevice bluetoothDevice) {
        return this.b.getReceiveMtu(bluetoothDevice);
    }

    private boolean c(DataInfo dataInfo) {
        byte[] byArray = ParseHelper.packSendBasePacket(dataInfo.getBasePacket());
        if (byArray == null) {
            JL_Log.i(this.a, "send data :: pack data error.");
            return false;
        }
        int n = this.a(dataInfo.getDevice());
        if (byArray.length > n) {
            JL_Log.e(this.a, "send data over communication mtu [" + n + "] limit.");
            return false;
        }
        n = 0;
        for (int i = 0; i < 3; ++i) {
            boolean bl = this.b.sendDataToDevice(dataInfo.getDevice(), byArray);
            n = bl ? 1 : 0;
            if (bl) break;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        JL_Log.i(this.a, "send ret : " + (n != 0));
        return n != 0;
    }

    private void a(DataInfo dataInfo, BaseError baseError) {
        if (dataInfo == null) {
            JL_Log.d(this.a, "callError : param is null");
            return;
        }
        if (dataInfo.getBasePacket() != null) {
            baseError.setOpCode(dataInfo.getBasePacket().getOpCode());
        }
        DataHandlerModify dataHandlerModify = this;
        JL_Log.w(dataHandlerModify.a, "callError : " + baseError);
        dataHandlerModify.g.post(() -> {
            if (dataInfo.getCallback() != null) {
                dataInfo.getCallback().onErrCode(baseError);
            }
            this.b.errorEventCallback(baseError);
        });
    }

    private void a(DataInfo dataInfo, CommandBase commandBase) {
        if (dataInfo != null && dataInfo.getCallback() != null && commandBase != null) {
            this.g.post(() -> dataInfo.getCallback().onCommandResponse(commandBase));
            return;
        }
        JL_Log.d(this.a, " callbackCmd : param is null. " + dataInfo);
    }

    private int d(DataInfo dataInfo) {
        if (dataInfo == null) {
            return Integer.MAX_VALUE;
        }
        return dataInfo.getBasePacket().getOpCodeSn() << 16 | dataInfo.getBasePacket().getOpCode();
    }

    @Override
    public void addSendData(DataInfo dataInfo) {
        dataInfo.setSendTime(this.a());
        this.f.post(() -> {
            if (!this.c(dataInfo)) {
                this.a(dataInfo, OTAError.buildError(12290));
                return;
            }
            if (dataInfo.getBasePacket().getHasResponse() == 1) {
                DataHandlerModify dataHandlerModify = this;
                dataHandlerModify.d.add(dataInfo);
                Handler handler = dataHandlerModify.f;
                handler.sendMessageDelayed(handler.obtainMessage(this.d(dataInfo), (Object)new TimeOutCheck(dataInfo)), (long)dataInfo.getTimeoutMs());
            } else {
                Object object = dataInfo.getBasePacket();
                BasePacket basePacket = object;
                int n = basePacket.getOpCodeSn();
                basePacket.setOpCodeSn(256);
                object = ParseHelper.convert2Command((BasePacket)object, this.b.getCacheCommand(dataInfo.getDevice(), (BasePacket)object));
                if (object != null) {
                    ((CommandBase)object).setOpCodeSn(n);
                }
                this.a(dataInfo, (CommandBase)object);
            }
        });
    }

    @Override
    public void addRecvData(DataInfo dataInfo) {
        this.f.post(() -> {
            int n = this.b(dataInfo.getDevice());
            ArrayList<BasePacket> arrayList = this.c.findPacketData(n, dataInfo.getRecvData());
            if (arrayList != null && !arrayList.isEmpty()) {
                for (BasePacket basePacket : arrayList) {
                    Object object = ParseHelper.packSendBasePacket(basePacket);
                    if (basePacket.getType() == 1) {
                        this.b.receiveDataFromDevice(dataInfo.getDevice(), (byte[])object);
                        continue;
                    }
                    DataInfo dataInfo2 = this.d.getDataInfo(basePacket);
                    if (dataInfo2 == null) {
                        JL_Log.w(this.a, "addRecvData : not found cache data info. " + basePacket);
                        continue;
                    }
                    CommandBase commandBase = ParseHelper.convert2Command(basePacket, this.b.getCacheCommand(dataInfo.getDevice(), basePacket));
                    if (commandBase == null) {
                        BaseError baseError = OTAError.buildError(12293);
                        object = baseError;
                        baseError.setOpCode(basePacket.getOpCode());
                        this.a(dataInfo2, (BaseError)object);
                    } else {
                        this.b.receiveDataFromDevice(dataInfo.getDevice(), (byte[])object);
                    }
                    DataHandlerModify dataHandlerModify = this;
                    DataHandlerModify dataHandlerModify2 = this;
                    dataHandlerModify2.d.remove(dataInfo2);
                    dataHandlerModify2.f.removeMessages(this.d(dataInfo2));
                    dataHandlerModify.a(dataInfo2, commandBase);
                    dataHandlerModify.b.removeCacheCommand(dataInfo.getDevice(), basePacket);
                }
                return;
            }
            JL_Log.w(this.a, "addRecvData : not found cmd. " + CHexConver.byte2HexStr(dataInfo.getRecvData()));
        });
    }

    @Override
    public void release() {
        DataHandlerModify dataHandlerModify = this;
        dataHandlerModify.f.removeCallbacksAndMessages(null);
        dataHandlerModify.c.release();
        dataHandlerModify.d.clear();
        if (!dataHandlerModify.e.isInterrupted()) {
            this.e.quitSafely();
        }
    }

    private class TimeOutCheck
    implements Runnable {
        private final DataInfo a;

        public TimeOutCheck(DataInfo dataInfo) {
            this.a = dataInfo;
            dataInfo.setSendTime(System.currentTimeMillis());
        }

        @Override
        public void run() {
            TimeOutCheck timeOutCheck = this;
            JL_Log.w(timeOutCheck.DataHandlerModify.this.a, "send data timeout  --> " + this.a);
            if (timeOutCheck.a.getReSendCount() < 3) {
                TimeOutCheck timeOutCheck2 = this;
                DataInfo dataInfo = timeOutCheck2.a;
                dataInfo.setReSendCount(dataInfo.getReSendCount() + 1);
                timeOutCheck2.DataHandlerModify.this.d.remove(this.a);
                timeOutCheck2.DataHandlerModify.this.addSendData(this.a);
            } else {
                TimeOutCheck timeOutCheck3 = this;
                timeOutCheck3.DataHandlerModify.this.d.remove(this.a);
                timeOutCheck3.DataHandlerModify.this.b.removeCacheCommand(this.a.getDevice(), this.a.getBasePacket());
                BaseError baseError = OTAError.buildError(12295);
                timeOutCheck3.DataHandlerModify.this.a(this.a, baseError);
            }
        }
    }
}

