/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.tool;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.jieli.jl_bt_ota.constant.JL_Constant;
import com.jieli.jl_bt_ota.impl.BluetoothOTAManager;
import com.jieli.jl_bt_ota.interfaces.BtEventCallback;
import com.jieli.jl_bt_ota.interfaces.IBluetoothCallback;
import com.jieli.jl_bt_ota.model.BleScanMessage;
import com.jieli.jl_bt_ota.model.OTAError;
import com.jieli.jl_bt_ota.model.ReConnectDevMsg;
import com.jieli.jl_bt_ota.model.base.BaseError;
import com.jieli.jl_bt_ota.util.BluetoothUtil;
import com.jieli.jl_bt_ota.util.CHexConver;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.JL_Log;
import com.jieli.jl_bt_ota.util.ParseDataUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class DeviceReConnectManager {
    private static final String h = "DeviceReConnectManager";
    private static final int i = 3000;
    private static final int j = 20000;
    private static final int k = 2;
    private static final int l = 30000;
    public static long RECONNECT_TIMEOUT = 65000L;
    private static final int m = 2000;
    private static final int n = 37973;
    private static final int o = 37974;
    private static final int p = 37975;
    private final Context a;
    private final BluetoothOTAManager b;
    private volatile ReConnectDevMsg c;
    private long d = 0L;
    private final Map<String, BleScanMessage> e;
    private final Handler f;
    private final BtEventCallback g;

    public DeviceReConnectManager(@NonNull Context context, @NonNull BluetoothOTAManager bluetoothOTAManager) {
        BtEventCallback btEventCallback;
        Handler.Callback callback;
        Handler handler;
        Handler handler2;
        Object object = handler2;
        handler2 = new HashMap();
        this.e = object;
        object = handler;
        Looper looper = Looper.getMainLooper();
        Handler.Callback callback2 = callback;
        callback = new Handler.Callback(){

            public boolean handleMessage(@NonNull Message message) {
                switch (message.what) {
                    default: {
                        break;
                    }
                    case 37975: {
                        JL_Log.w(h, "MSG_CONNECT_DEVICE_TIMEOUT >>>>> " + DeviceReConnectManager.this.c);
                        if (DeviceReConnectManager.this.c == null) break;
                        1 v0 = this;
                        v0.DeviceReConnectManager.this.c.setState(0);
                        DeviceReConnectManager deviceReConnectManager = v0.DeviceReConnectManager.this;
                        deviceReConnectManager.a(deviceReConnectManager.c.getAddress());
                        break;
                    }
                    case 37974: {
                        JL_Log.w(h, "MSG_RECONNECT_DEVICE_TIMEOUT >>>>> " + DeviceReConnectManager.this.c);
                        if (DeviceReConnectManager.this.c == null) break;
                        1 v2 = this;
                        v2.DeviceReConnectManager.this.c.setState(0);
                        DeviceReConnectManager deviceReConnectManager = v2.DeviceReConnectManager.this;
                        deviceReConnectManager.a(OTAError.buildError(16401, deviceReConnectManager.c.toString()));
                        break;
                    }
                    case 37973: {
                        DeviceReConnectManager.this.b();
                    }
                }
                return true;
            }
        };
        handler = new Handler(looper, callback2);
        this.f = object;
        object = btEventCallback;
        btEventCallback = new BtEventCallback(){

            @Override
            public void onAdapterStatus(boolean bl, boolean bl2) {
                if (!bl && DeviceReConnectManager.this.isDeviceReconnecting()) {
                    JL_Log.d(h, "onAdapterStatus : bluetooth close.");
                }
            }

            @Override
            public void onDiscoveryStatus(boolean bl, boolean bl2) {
                JL_Log.d(h, "onDiscoveryStatus : " + bl2);
                if (DeviceReConnectManager.this.isDeviceReconnecting() && !DeviceReConnectManager.this.f()) {
                    if (bl2) {
                        if (DeviceReConnectManager.this.c != null && DeviceReConnectManager.this.c.getState() == 0) {
                            DeviceReConnectManager.this.c.setState(1);
                        }
                    } else {
                        2 v0 = this;
                        JL_Log.d(h, "onDiscoveryStatus : ready start scan");
                        v0.DeviceReConnectManager.this.f.removeMessages(37973);
                        v0.DeviceReConnectManager.this.f.sendEmptyMessageDelayed(37973, 1000L);
                    }
                }
            }

            @Override
            public void onDiscovery(BluetoothDevice bluetoothDevice, BleScanMessage bleScanMessage) {
                if (bluetoothDevice != null && DeviceReConnectManager.this.isDeviceReconnecting()) {
                    Object[] objectArray = null;
                    if (bleScanMessage != null) {
                        DeviceReConnectManager.this.e.put(bluetoothDevice.getAddress(), bleScanMessage);
                        objectArray = bleScanMessage.getRawData();
                    }
                    boolean bl = DeviceReConnectManager.this.a(bluetoothDevice, objectArray);
                    Object[] objectArray2 = new Object[2];
                    objectArray = objectArray2;
                    objectArray[0] = (byte)(bl ? 1 : 0);
                    objectArray2[1] = DeviceReConnectManager.this.b(bluetoothDevice);
                    JL_Log.i(h, CommonUtil.formatString("-onDiscovery- isReConnectDevice : %s, device : %s", objectArray));
                    if (bl) {
                        2 v1 = this;
                        v1.DeviceReConnectManager.this.a(bluetoothDevice);
                        v1.DeviceReConnectManager.this.h();
                    }
                    return;
                }
            }

            @Override
            public void onConnection(BluetoothDevice bluetoothDevice, int n) {
                if (bluetoothDevice != null && DeviceReConnectManager.this.isDeviceReconnecting() && n != 3) {
                    boolean bl = DeviceReConnectManager.this.f.hasMessages(37975) || DeviceReConnectManager.this.f();
                    JL_Log.d(h, "-onConnection- isConnecting: " + bl + ", status = " + n);
                    if (!bl) {
                        return;
                    }
                    BleScanMessage bleScanMessage = (BleScanMessage)DeviceReConnectManager.this.e.get(bluetoothDevice.getAddress());
                    Object[] objectArray = null;
                    if (bleScanMessage != null) {
                        JL_Log.d(h, "-onConnection- bleScanMessage: " + bleScanMessage);
                        objectArray = bleScanMessage.getRawData();
                    }
                    boolean bl2 = DeviceReConnectManager.this.a(bluetoothDevice, objectArray);
                    Object[] objectArray2 = new Object[3];
                    objectArray = objectArray2;
                    objectArray[0] = DeviceReConnectManager.this.b(bluetoothDevice);
                    objectArray[1] = n;
                    objectArray2[2] = bl2;
                    JL_Log.w(h, CommonUtil.formatString("-onConnection- device : %s, status : %d, isReConnectDevice : %s", objectArray));
                    if (!bl2) {
                        return;
                    }
                    if (DeviceReConnectManager.this.c != null) {
                        DeviceReConnectManager.this.c.setState(0);
                    }
                    DeviceReConnectManager.this.f.removeMessages(37975);
                    if (n != 1 && n != 4) {
                        if (n == 2 || n == 0) {
                            JL_Log.i(h, "-onConnection- connect device failed.");
                            DeviceReConnectManager.this.a(bluetoothDevice.getAddress());
                        }
                    } else {
                        JL_Log.d(h, "-onConnection- reconnect device success.");
                        DeviceReConnectManager.this.stopReconnectTask();
                    }
                    return;
                }
            }
        };
        this.g = object;
        this.a = context;
        this.b = bluetoothOTAManager;
        bluetoothOTAManager.registerBluetoothCallback((IBluetoothCallback)object);
    }

    private boolean a(BluetoothDevice bluetoothDevice, byte[] byArray) {
        if (bluetoothDevice == null) {
            return false;
        }
        ReConnectDevMsg reConnectDevMsg = ((DeviceReConnectManager)((Object)bleScanMessage)).e();
        if (reConnectDevMsg == null) {
            return false;
        }
        String string = reConnectDevMsg.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress((String)string)) {
            return false;
        }
        boolean bl = false;
        String string2 = h;
        JL_Log.i(string2, "-checkIsReconnectDevice- device : " + ((DeviceReConnectManager)((Object)bleScanMessage)).b(bluetoothDevice));
        if (!reConnectDevMsg.isUseADV()) {
            bl = string.equals(bluetoothDevice.getAddress());
        } else {
            JL_Log.d(string2, "-checkIsReconnectDevice- advertiseRawData : " + CHexConver.byte2HexStr(byArray));
            BleScanMessage bleScanMessage = ParseDataUtil.parseOTAFlagFilterWithBroad(byArray, JL_Constant.OTA_IDENTIFY);
            if (bleScanMessage != null) {
                JL_Log.i(string2, "-checkIsReconnectDevice- " + bleScanMessage);
                bl = string.equalsIgnoreCase(bleScanMessage.getOldBleAddress());
            }
        }
        return bl;
    }

    private boolean g() {
        BluetoothOTAManager bluetoothOTAManager = ((DeviceReConnectManager)((Object)bluetoothOTAManager)).b;
        return bluetoothOTAManager != null && bluetoothOTAManager.getConnectedDevice() != null;
    }

    private boolean f() {
        return this.e() != null && this.e().getState() == 2;
    }

    private ReConnectDevMsg e() {
        if (this.c == null) {
            return null;
        }
        return this.c.cloneObject();
    }

    private long c() {
        return Calendar.getInstance().getTimeInMillis();
    }

    private long d() {
        long l = RECONNECT_TIMEOUT - (this.c() - this.d);
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    private void a(long l) {
        this.d = l;
    }

    private void a(BluetoothDevice bluetoothDevice) {
        String string = h;
        JL_Log.d(string, "connectBtDevice :: " + this.c + ", " + bluetoothDevice);
        if (this.c != null && this.c.getState() != 2) {
            DeviceReConnectManager deviceReConnectManager = this;
            deviceReConnectManager.c.setState(2);
            long l = deviceReConnectManager.d();
            JL_Log.i(string, "connectBtDevice :: left time = " + l);
            if (l <= 2000L) {
                DeviceReConnectManager deviceReConnectManager2 = this;
                deviceReConnectManager2.f.removeMessages(37974);
                deviceReConnectManager2.f.sendEmptyMessageDelayed(37974, 31000L);
                JL_Log.i(string, "connectBtDevice :: reset time >>> ");
            }
            DeviceReConnectManager deviceReConnectManager3 = this;
            deviceReConnectManager3.f.removeMessages(37975);
            deviceReConnectManager3.f.sendEmptyMessageDelayed(37975, 30000L);
            deviceReConnectManager3.b.connectBluetoothDevice(bluetoothDevice);
        }
    }

    private void h() {
        DeviceReConnectManager deviceReConnectManager = this;
        JL_Log.d(h, "-stopScan- >>>>>>stopBLEScan ");
        deviceReConnectManager.b.stopBLEScan();
        deviceReConnectManager.b.stopDeviceScan();
    }

    private void b() {
        ReConnectDevMsg reConnectDevMsg = this.e();
        if (reConnectDevMsg == null) {
            JL_Log.w(h, "doReconnectTask >>> reConnectDevMsg is null.");
            this.stopReconnectTask();
            return;
        }
        if (!BluetoothUtil.isBluetoothEnable()) {
            DeviceReConnectManager deviceReConnectManager = this;
            JL_Log.w(h, "doReconnectTask >>> Bluetooth is close.");
            deviceReConnectManager.f.removeMessages(37973);
            deviceReConnectManager.f.sendEmptyMessageDelayed(37973, 3000L);
            return;
        }
        if (reConnectDevMsg.getState() == 2) {
            JL_Log.w(h, "doReconnectTask >>> Task is connecting. " + reConnectDevMsg);
            if (!this.f.hasMessages(37975)) {
                this.f.sendEmptyMessageDelayed(37975, 30000L);
            }
            return;
        }
        if (this.g()) {
            JL_Log.i(h, "doReconnectTask >>> device is connected. " + reConnectDevMsg + ", device = " + this.b.getConnectedDevice());
            return;
        }
        String string = h;
        JL_Log.i(string, "doReconnectTask >>> " + reConnectDevMsg + ", isDevConnected : " + this.g());
        BluetoothDevice bluetoothDevice = this.b(reConnectDevMsg.getAddress());
        JL_Log.w(string, "doReconnectTask >>> connectedDevice : " + this.b(bluetoothDevice));
        if (bluetoothDevice != null) {
            this.a(bluetoothDevice);
        } else {
            int n;
            if (reConnectDevMsg.isUseADV() && reConnectDevMsg.getWay() != 0) {
                reConnectDevMsg.setWay(0);
            }
            if (this.b.isScanning()) {
                int n2 = this.b.getScanType();
                boolean bl = n2 == 2;
                if (!bl) {
                    bl = reConnectDevMsg.getWay() == 1 && n2 == 1 || reConnectDevMsg.getWay() == 0 && n2 == 0;
                }
                JL_Log.i(string, "doReconnectTask >>> isScanOk : " + bl + ", scanType = " + n2);
                if (bl) {
                    return;
                }
                this.h();
                SystemClock.sleep((long)100L);
            }
            long l = this.d();
            JL_Log.d(string, "doReconnectTask >>> leftTime \uff1a " + l + ", beginTaskTime : " + this.d);
            if (l < RECONNECT_TIMEOUT - 40000L && !reConnectDevMsg.isUseADV()) {
                long l2;
                n = 2;
                if (reConnectDevMsg.getWay() == 1) {
                    n = 0;
                }
                if ((l2 = l - 3000L) <= 0L) {
                    l2 = l;
                }
                int n3 = this.b.startDeviceScan(l2, n);
                JL_Log.i(string, "doReconnectTask >>> startDeviceScan : " + n3 + ", way = " + n + ", timeout = " + l2);
                n = n3;
            } else {
                l = Math.min(l, 20000L);
                if (reConnectDevMsg.getWay() == 1) {
                    n = this.b.startDeviceScan(l, 1);
                    JL_Log.i(string, "doReconnectTask >>> startDeviceScan : " + n + ", scanTime = " + l);
                } else {
                    n = this.b.startBLEScan(l);
                    JL_Log.i(string, "doReconnectTask >>> startBLEScan : " + n + ", scanTime = " + l);
                }
            }
            if (n != 0) {
                DeviceReConnectManager deviceReConnectManager = this;
                deviceReConnectManager.f.removeMessages(37973);
                deviceReConnectManager.f.sendEmptyMessageDelayed(37973, 3000L);
            }
        }
    }

    private BluetoothDevice b(String string) {
        if (!BluetoothAdapter.checkBluetoothAddress((String)string)) {
            return null;
        }
        Object object = BluetoothUtil.getSystemConnectedBtDeviceList(((DeviceReConnectManager)object).a);
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                BluetoothDevice bluetoothDevice = (BluetoothDevice)object.next();
                if (!string.equals(bluetoothDevice.getAddress())) continue;
                return bluetoothDevice;
            }
            return null;
        }
        return null;
    }

    private void a(BaseError baseError) {
        if (baseError == null) {
            return;
        }
        if (this.b.isOTA()) {
            this.b.errorEventCallback(baseError);
        }
        this.stopReconnectTask();
    }

    private void a(String string) {
        long l = this.d();
        String string2 = h;
        JL_Log.d(string2, "dealWithConnectFailed >> " + string + ", Left Time = " + l);
        if (l <= 2000L) {
            JL_Log.i(string2, "-dealWithConnectFailed- time not enough.");
            this.a(OTAError.buildError(16402, string));
        } else {
            DeviceReConnectManager deviceReConnectManager = this;
            JL_Log.i(string2, "-dealWithConnectFailed- resume reconnect task.");
            deviceReConnectManager.f.removeMessages(37973);
            deviceReConnectManager.f.sendEmptyMessage(37973);
        }
    }

    private String b(BluetoothDevice bluetoothDevice) {
        return BluetoothUtil.printBtDeviceInfo(this.a, bluetoothDevice);
    }

    public void release() {
        DeviceReConnectManager deviceReConnectManager = this;
        deviceReConnectManager.setReConnectDevMsg(null);
        deviceReConnectManager.stopReconnectTask();
        deviceReConnectManager.b.unregisterBluetoothCallback(this.g);
        deviceReConnectManager.f.removeCallbacksAndMessages(null);
    }

    public boolean isWaitingForUpdate() {
        return this.e() != null;
    }

    public boolean isDeviceReconnecting() {
        return this.f.hasMessages(37974);
    }

    public void setReconnectAddress(String string) {
        if (!BluetoothAdapter.checkBluetoothAddress((String)string)) {
            this.setReConnectDevMsg(null);
        } else if (this.c == null) {
            this.setReConnectDevMsg(new ReConnectDevMsg(this.b.getBluetoothOption().getPriority(), string));
        } else {
            this.c.setAddress(string);
            JL_Log.d(h, "setReconnectAddress : " + this.c);
        }
    }

    public void setReConnectDevMsg(ReConnectDevMsg reConnectDevMsg) {
        if (this.c != reConnectDevMsg) {
            this.c = reConnectDevMsg;
            this.e.clear();
            JL_Log.d(h, "setReConnectDevMsg : " + reConnectDevMsg);
        }
    }

    public void setReconnectUseADV(boolean bl) {
        if (this.c != null) {
            this.c.setUseADV(bl);
        }
    }

    public String getReconnectAddress() {
        if ((this = ((DeviceReConnectManager)this).e()) == null) {
            return null;
        }
        return ((ReConnectDevMsg)this).getAddress();
    }

    public void startReconnectTask() {
        if (!this.isDeviceReconnecting()) {
            DeviceReConnectManager deviceReConnectManager = this;
            String string = h;
            DeviceReConnectManager deviceReConnectManager2 = this;
            JL_Log.i(string, "-startReconnectTask- start....");
            deviceReConnectManager2.a(deviceReConnectManager2.c());
            JL_Log.i(string, "-startReconnectTask- timeout = " + RECONNECT_TIMEOUT);
            long l = RECONNECT_TIMEOUT;
            deviceReConnectManager.f.sendEmptyMessageDelayed(37974, l);
            deviceReConnectManager.f.sendEmptyMessage(37973);
        }
    }

    public void stopReconnectTask() {
        DeviceReConnectManager deviceReConnectManager = this;
        boolean bl = deviceReConnectManager.isDeviceReconnecting();
        boolean bl2 = deviceReConnectManager.isWaitingForUpdate();
        JL_Log.i(h, "--> stopReconnectTask ---------> " + bl + ", isWaitingForUpdate = " + bl2);
        deviceReConnectManager.a(0L);
        deviceReConnectManager.setReConnectDevMsg(null);
        deviceReConnectManager.h();
        deviceReConnectManager.f.removeCallbacksAndMessages(null);
    }
}

