/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.tool;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.jieli.jl_bt_ota.model.DeviceStatus;
import com.jieli.jl_bt_ota.model.response.TargetInfoResponse;
import java.util.HashMap;

public final class DeviceStatusCache {
    private final HashMap<String, DeviceStatus> a;

    public DeviceStatusCache() {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        v1.a = hashMap2;
    }

    public String getDevMD5(BluetoothDevice object) {
        DeviceStatusCache deviceStatusCache = object2;
        Object object2 = null;
        if ((object = deviceStatusCache.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getDevMD5();
        }
        return object2;
    }

    public int getMaxCommunicationMtu(BluetoothDevice object) {
        int n = 530;
        if ((object = this.getDeviceInfo((BluetoothDevice)object)) != null && ((TargetInfoResponse)object).getCommunicationMtu() > 0) {
            n = ((TargetInfoResponse)object).getCommunicationMtu();
        }
        return n;
    }

    public int getMaxReceiveMtu(BluetoothDevice object) {
        int n = 530;
        if ((object = this.getDeviceInfo((BluetoothDevice)object)) != null && ((TargetInfoResponse)object).getReceiveMtu() > 0) {
            n = ((TargetInfoResponse)object).getReceiveMtu();
        }
        return n;
    }

    public int getDeviceConnectStatus(BluetoothDevice object) {
        int n = 0;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null) {
            n = ((DeviceStatus)object).getStatus();
        }
        return n;
    }

    public boolean isAuthBtDevice(BluetoothDevice object) {
        boolean bl = false;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null) {
            bl = ((DeviceStatus)object).isAuthDevice();
        }
        return bl;
    }

    public boolean isMandatoryUpgrade(BluetoothDevice object) {
        boolean bl = false;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null) {
            bl = ((DeviceStatus)object).isMandatoryUpgrade();
        }
        return bl;
    }

    public boolean isEnterLowPowerMode(BluetoothDevice object) {
        boolean bl = false;
        if ((object = this.getDeviceStatus((BluetoothDevice)object)) != null) {
            bl = ((DeviceStatus)object).isEnterLowPowerMode();
        }
        return bl;
    }

    public boolean isDoubleBackupUpgrade(BluetoothDevice bluetoothDevice) {
        return (this = ((DeviceStatusCache)this).getDeviceInfo(bluetoothDevice)) != null && ((TargetInfoResponse)this).isSupportDoubleBackup();
    }

    public TargetInfoResponse getDeviceInfo(BluetoothDevice object) {
        DeviceStatusCache deviceStatusCache = object2;
        Object object2 = null;
        if ((object = deviceStatusCache.getDeviceStatus((BluetoothDevice)object)) != null) {
            object2 = ((DeviceStatus)object).getTargetInfo();
        }
        return object2;
    }

    public void updateDeviceMD5(BluetoothDevice bluetoothDevice, String string) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setDevMD5(string);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceMaxCommunicationMtu(BluetoothDevice bluetoothDevice, int n) {
        if (n <= 0) {
            return;
        }
        TargetInfoResponse targetInfoResponse = this.getDeviceInfo(bluetoothDevice);
        if (targetInfoResponse == null) {
            return;
        }
        targetInfoResponse.setCommunicationMtu(n);
        this.updateDeviceTargetInfo(bluetoothDevice, targetInfoResponse);
    }

    public void updateDeviceMaxReceiveMtu(BluetoothDevice bluetoothDevice, int n) {
        if (n <= 0) {
            return;
        }
        TargetInfoResponse targetInfoResponse = this.getDeviceInfo(bluetoothDevice);
        if (targetInfoResponse == null) {
            return;
        }
        targetInfoResponse.setReceiveMtu(n);
        this.updateDeviceTargetInfo(bluetoothDevice, targetInfoResponse);
    }

    public void updateDeviceConnectStatus(BluetoothDevice bluetoothDevice, int n) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setStatus(n);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceIsAuth(BluetoothDevice bluetoothDevice, boolean bl) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setAuthDevice(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceIsEnterLowPowerMode(BluetoothDevice bluetoothDevice, boolean bl) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        deviceStatus.setEnterLowPowerMode(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceTargetInfo(BluetoothDevice bluetoothDevice, TargetInfoResponse targetInfoResponse) {
        DeviceStatus deviceStatus = this.getDeviceStatus(bluetoothDevice);
        boolean bl = targetInfoResponse != null && targetInfoResponse.isMandatoryUpgrade();
        if (deviceStatus == null) {
            DeviceStatus deviceStatus2;
            deviceStatus = deviceStatus2;
            deviceStatus2 = new DeviceStatus();
        }
        DeviceStatus deviceStatus3 = deviceStatus;
        deviceStatus3.setTargetInfo(targetInfoResponse);
        deviceStatus3.setMandatoryUpgrade(bl);
        this.updateDeviceStatus(bluetoothDevice, deviceStatus);
    }

    public void updateDeviceStatus(BluetoothDevice bluetoothDevice, DeviceStatus deviceStatus) {
        if (bluetoothDevice != null) {
            this.updateDeviceStatus(bluetoothDevice.getAddress(), deviceStatus);
        }
    }

    public void updateDeviceStatus(String string, DeviceStatus deviceStatus) {
        if (BluetoothAdapter.checkBluetoothAddress((String)string) && deviceStatus != null) {
            this.a.put(string, deviceStatus);
        }
    }

    public DeviceStatus removeDeviceStatus(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return null;
        }
        return this.removeDeviceStatus(bluetoothDevice.getAddress());
    }

    public DeviceStatus removeDeviceStatus(String string) {
        DeviceStatus deviceStatus = null;
        if (BluetoothAdapter.checkBluetoothAddress((String)string)) {
            deviceStatus = this.a.remove(string);
        }
        return deviceStatus;
    }

    public DeviceStatus getDeviceStatus(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null) {
            return null;
        }
        return this.getDeviceStatus(bluetoothDevice.getAddress());
    }

    public DeviceStatus getDeviceStatus(String string) {
        DeviceStatus deviceStatus = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            deviceStatus = this.a.get(string);
        }
        return deviceStatus;
    }

    public void clear() {
        this.a.clear();
    }
}

