/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.tool;

import com.jieli.jl_bt_ota.impl.BluetoothOTAManager;
import com.jieli.jl_bt_ota.interfaces.CommandCallback;
import com.jieli.jl_bt_ota.interfaces.IActionCallback;
import com.jieli.jl_bt_ota.interfaces.rcsp.IHandleResult;
import com.jieli.jl_bt_ota.interfaces.rcsp.IRcspOTA;
import com.jieli.jl_bt_ota.model.FileOffset;
import com.jieli.jl_bt_ota.model.base.CommandBase;
import com.jieli.jl_bt_ota.model.command.EnterUpdateModeCmd;
import com.jieli.jl_bt_ota.model.command.ExitUpdateModeCmd;
import com.jieli.jl_bt_ota.model.command.FirmwareUpdateStatusCmd;
import com.jieli.jl_bt_ota.model.command.GetDevMD5Cmd;
import com.jieli.jl_bt_ota.model.command.GetTargetInfoCmd;
import com.jieli.jl_bt_ota.model.command.GetUpdateFileOffsetCmd;
import com.jieli.jl_bt_ota.model.command.InquireUpdateCmd;
import com.jieli.jl_bt_ota.model.command.NotifyCommunicationWayCmd;
import com.jieli.jl_bt_ota.model.command.RebootDeviceCmd;
import com.jieli.jl_bt_ota.model.parameter.InquireUpdateParam;
import com.jieli.jl_bt_ota.model.parameter.NotifyCommunicationWayParam;
import com.jieli.jl_bt_ota.model.parameter.RebootDeviceParam;
import com.jieli.jl_bt_ota.model.response.EnterUpdateModeResponse;
import com.jieli.jl_bt_ota.model.response.ExitUpdateModeResponse;
import com.jieli.jl_bt_ota.model.response.FirmwareUpdateStatusResponse;
import com.jieli.jl_bt_ota.model.response.GetDevMD5Response;
import com.jieli.jl_bt_ota.model.response.InquireUpdateResponse;
import com.jieli.jl_bt_ota.model.response.NotifyCommunicationWayResponse;
import com.jieli.jl_bt_ota.model.response.TargetInfoResponse;
import com.jieli.jl_bt_ota.model.response.UpdateFileOffsetResponse;
import com.jieli.jl_bt_ota.tool.CmdBooleanCallback;
import com.jieli.jl_bt_ota.tool.CmdResultCallback;
import com.jieli.jl_bt_ota.util.CommandBuilder;

public class RcspOTA
implements IRcspOTA {
    private final BluetoothOTAManager a;

    public RcspOTA(BluetoothOTAManager bluetoothOTAManager) {
        if (bluetoothOTAManager != null) {
            this.a = bluetoothOTAManager;
            return;
        }
        throw new NullPointerException("BluetoothOTAManager can not be null.");
    }

    @Override
    public void getDeviceInfo(IActionCallback<TargetInfoResponse> iActionCallback) {
        IHandleResult<TargetInfoResponse> iHandleResult;
        IHandleResult<TargetInfoResponse> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<TargetInfoResponse>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public TargetInfoResponse handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof GetTargetInfoCmd)) {
                    return null;
                }
                return (TargetInfoResponse)((GetTargetInfoCmd)commandBase).getResponse();
            }
        };
        this.a.sendCommandAsync(CommandBuilder.buildGetTargetInfoCmdForAll(), new CmdResultCallback<TargetInfoResponse>("getDeviceInfo", iActionCallback, iHandleResult2));
    }

    @Override
    public void getMD5(IActionCallback<String> iActionCallback) {
        IHandleResult<String> iHandleResult;
        CmdResultCallback<String> cmdResultCallback;
        CmdResultCallback<String> cmdResultCallback2 = cmdResultCallback;
        IHandleResult<String> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<String>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public String handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof GetDevMD5Cmd)) {
                    return "";
                }
                return ((GetDevMD5Response)((GetDevMD5Cmd)commandBase).getResponse()).getMd5();
            }
        };
        cmdResultCallback = new CmdResultCallback<String>("getMD5", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(new GetDevMD5Cmd(), cmdResultCallback2);
    }

    @Override
    public void stopADVInfo(IActionCallback<Boolean> iActionCallback) {
        this.a.sendCommandAsync(CommandBuilder.buildStopDeviceNotifyADVInfoCmd(), new CmdBooleanCallback("stopADVInfo", iActionCallback));
    }

    @Override
    public void changeCommunicationWay(int n, int n2, IActionCallback<Integer> iActionCallback) {
        IHandleResult<Integer> iHandleResult;
        CmdResultCallback<Integer> cmdResultCallback;
        NotifyCommunicationWayCmd notifyCommunicationWayCmd;
        NotifyCommunicationWayCmd notifyCommunicationWayCmd2 = notifyCommunicationWayCmd;
        notifyCommunicationWayCmd = new NotifyCommunicationWayCmd(new NotifyCommunicationWayParam(n, n2));
        CmdResultCallback<Integer> cmdResultCallback2 = cmdResultCallback;
        IHandleResult<Integer> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<Integer>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public Integer handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof NotifyCommunicationWayCmd)) {
                    return 7;
                }
                return ((NotifyCommunicationWayResponse)((NotifyCommunicationWayCmd)commandBase).getResponse()).getFlag();
            }
        };
        cmdResultCallback = new CmdResultCallback<Integer>("changeCommunicationWay", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(notifyCommunicationWayCmd2, cmdResultCallback2);
    }

    @Override
    public void readUpgradeFileFlag(IActionCallback<FileOffset> iActionCallback) {
        IHandleResult<FileOffset> iHandleResult;
        CmdResultCallback<FileOffset> cmdResultCallback;
        CmdResultCallback<FileOffset> cmdResultCallback2 = cmdResultCallback;
        IHandleResult<FileOffset> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<FileOffset>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public FileOffset handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof GetUpdateFileOffsetCmd)) {
                    return new FileOffset(0, 0);
                }
                Object object = this = (UpdateFileOffsetResponse)((GetUpdateFileOffsetCmd)commandBase).getResponse();
                int n = ((UpdateFileOffsetResponse)object).getUpdateFileFlagOffset();
                return new FileOffset(n, ((UpdateFileOffsetResponse)object).getUpdateFileFlagLen());
            }
        };
        cmdResultCallback = new CmdResultCallback<FileOffset>("readUpgradeFileFlag", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(new GetUpdateFileOffsetCmd(), cmdResultCallback2);
    }

    @Override
    public void inquiryDeviceCanOTA(byte[] object, IActionCallback<Integer> iActionCallback) {
        IHandleResult<Integer> iHandleResult;
        CmdResultCallback<Integer> cmdResultCallback;
        InquireUpdateCmd inquireUpdateCmd = new InquireUpdateCmd(new InquireUpdateParam((byte[])object));
        object = cmdResultCallback;
        IHandleResult<Integer> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<Integer>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public Integer handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof InquireUpdateCmd)) {
                    return 1;
                }
                return ((InquireUpdateResponse)((InquireUpdateCmd)commandBase).getResponse()).getCanUpdateFlag();
            }
        };
        cmdResultCallback = new CmdResultCallback<Integer>("inquiryDeviceCanOTA", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(inquireUpdateCmd, (CommandCallback)object);
    }

    @Override
    public void enterUpdateMode(IActionCallback<Integer> iActionCallback) {
        IHandleResult<Integer> iHandleResult;
        CmdResultCallback<Integer> cmdResultCallback;
        CmdResultCallback<Integer> cmdResultCallback2 = cmdResultCallback;
        IHandleResult<Integer> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<Integer>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public Integer handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof EnterUpdateModeCmd)) {
                    return 7;
                }
                return ((EnterUpdateModeResponse)((EnterUpdateModeCmd)commandBase).getResponse()).getCanUpdateFlag();
            }
        };
        cmdResultCallback = new CmdResultCallback<Integer>("enterUpdateMode", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(new EnterUpdateModeCmd(), cmdResultCallback2);
    }

    @Override
    public void exitUpdateMode(IActionCallback<Integer> iActionCallback) {
        IHandleResult<Integer> iHandleResult;
        CmdResultCallback<Integer> cmdResultCallback;
        CmdResultCallback<Integer> cmdResultCallback2 = cmdResultCallback;
        IHandleResult<Integer> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<Integer>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public Integer handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof ExitUpdateModeCmd)) {
                    return 1;
                }
                return ((ExitUpdateModeResponse)((ExitUpdateModeCmd)commandBase).getResponse()).getResult();
            }
        };
        cmdResultCallback = new CmdResultCallback<Integer>("exitUpdateMode", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(new ExitUpdateModeCmd(), cmdResultCallback2);
    }

    @Override
    public void queryUpdateResult(IActionCallback<Integer> iActionCallback) {
        IHandleResult<Integer> iHandleResult;
        CmdResultCallback<Integer> cmdResultCallback;
        CmdResultCallback<Integer> cmdResultCallback2 = cmdResultCallback;
        IHandleResult<Integer> iHandleResult2 = iHandleResult;
        iHandleResult = new IHandleResult<Integer>(){

            @Override
            public int hasResult(CommandBase commandBase) {
                return 0;
            }

            @Override
            public Integer handleResult(CommandBase commandBase) {
                if (!(commandBase instanceof FirmwareUpdateStatusCmd)) {
                    return 1;
                }
                return ((FirmwareUpdateStatusResponse)((FirmwareUpdateStatusCmd)commandBase).getResponse()).getResult();
            }
        };
        cmdResultCallback = new CmdResultCallback<Integer>("queryUpdateResult", iActionCallback, iHandleResult2);
        this.a.sendCommandAsync(new FirmwareUpdateStatusCmd(), cmdResultCallback2);
    }

    @Override
    public void rebootDevice(IActionCallback<Boolean> iActionCallback) {
        CmdBooleanCallback cmdBooleanCallback;
        CmdBooleanCallback cmdBooleanCallback2 = cmdBooleanCallback;
        cmdBooleanCallback = new CmdBooleanCallback("rebootDevice", iActionCallback);
        ((RcspOTA)((Object)cmdBooleanCallback2)).a.sendCommandAsync(new RebootDeviceCmd(new RebootDeviceParam(0)), cmdBooleanCallback2);
    }
}

