/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Locale;

public class CommonUtil {
    @SuppressLint(value={"StaticFieldLeak"})
    private static WeakReference<Context> a;
    public static final boolean isSupportAndroid12 = true;

    public static Context getMainContext() {
        WeakReference<Context> weakReference = a;
        if (weakReference == null) {
            return null;
        }
        return (Context)weakReference.get();
    }

    public static void setMainContext(Context context) {
        a = new WeakReference<Context>(CommonUtil.checkNotNull(context));
    }

    public static <T> T checkNotNull(T t) {
        T t2 = t;
        t2.getClass();
        return t2;
    }

    public static <T> T checkNotNull(T t, String string) {
        if (t != null) {
            return t;
        }
        throw new NullPointerException(string);
    }

    public static void checkAllNotNull(Object ... objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i].getClass();
        }
    }

    public static long getCurrentTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static boolean checkHasScanPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 31) {
            return CommonUtil.checkHasPermission(context, "android.permission.BLUETOOTH_SCAN");
        }
        return true;
    }

    public static boolean checkHasConnectPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 31) {
            return CommonUtil.checkHasPermission(context, "android.permission.BLUETOOTH_CONNECT");
        }
        return true;
    }

    public static boolean checkHasLocationPermission(Context context) {
        return CommonUtil.checkHasPermission(context, "android.permission.ACCESS_FINE_LOCATION") || CommonUtil.checkHasPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
    }

    public static boolean checkHasPermission(Context context, String string) {
        if (context == null) {
            return false;
        }
        return ActivityCompat.checkSelfPermission((Context)context, (String)string) == 0;
    }

    public static String formatString(String string, Object ... objectArray) {
        return String.format(Locale.ENGLISH, string, objectArray);
    }

    private static void a() {
        WeakReference<Context> weakReference = a;
        if (weakReference != null) {
            weakReference.clear();
            System.gc();
        }
    }
}

