/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_bt_ota.util;

import com.jieli.jl_bt_ota.model.BleScanMessage;
import com.jieli.jl_bt_ota.util.CHexConver;
import com.jieli.jl_bt_ota.util.CommonUtil;
import com.jieli.jl_bt_ota.util.JL_Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ParseDataUtil {
    private static final String a = "ParseDataUtil";
    private static final char[] b = "0123456789ABCDEF".toCharArray();

    private static native int nativeFilterFile(byte[] var0, int var1, int var2, int var3);

    public static int filterFile(byte[] byArray, int n, int n2) {
        return ParseDataUtil.nativeFilterFile(byArray, n, n2, 0);
    }

    public static String hexDataCovetToAddress(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (byArray != null && byArray.length == 6) {
            for (int i = 0; i < byArray.length; ++i) {
                char[] cArray = b;
                stringBuilder2.append(cArray[(byArray[i] & 0xFF) >> 4]);
                stringBuilder2.append(b[byArray[i] & 0xF]);
                if (i == byArray.length - 1) continue;
                stringBuilder2.append(":");
            }
        }
        return stringBuilder2.toString();
    }

    public static BleScanMessage parseOTAFlagFilterWithBroad(byte[] byArray, String string) {
        if (byArray != null && byArray.length > 2) {
            int n;
            BleScanMessage bleScanMessage = null;
            int n2 = 0;
            while ((n = n2 + 2) <= byArray.length) {
                int n3;
                int n4 = CHexConver.byteToInt(byArray[n2]);
                if (n4 == 0) {
                    ++n2;
                    continue;
                }
                if (n4 < 1 || (n3 = n2 + 1) + n4 >= byArray.length) break;
                if (CHexConver.byteToInt(byArray[n3]) == 255) {
                    int n5 = n4 - 1;
                    byte[] byArray2 = new byte[n5];
                    System.arraycopy(byArray, n, byArray2, 0, n5);
                    bleScanMessage = ParseDataUtil.parseWithOTAFlagFilter(byArray2, string);
                    if (bleScanMessage != null) break;
                }
                n2 += n4 + 1;
            }
            return bleScanMessage;
        }
        return null;
    }

    public static BleScanMessage parseWithOTAFlagFilter(byte[] object, String string) {
        if (object != null && string != null && string.length() != 0 && ((byte[])object).length > string.getBytes().length + 2) {
            BleScanMessage bleScanMessage;
            ByteBuffer byteBuffer = ByteBuffer.wrap(object);
            object = byteBuffer;
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            short s = byteBuffer.getShort();
            byte[] byArray = new byte[string.getBytes().length];
            object = object.get(byArray);
            byte[] byArray2 = ParseDataUtil.a(byArray);
            if (!Arrays.equals(byArray2, string.getBytes())) {
                Object[] objectArray = new Object[2];
                object = objectArray;
                object[0] = CHexConver.byte2HexStr(byArray2);
                objectArray[1] = CHexConver.byte2HexStr(string.getBytes());
                JL_Log.i(a, CommonUtil.formatString("parseWithOTAFlagFilter :: flag not match. adv flag : %s, flag : %s", object));
                return null;
            }
            int n = CHexConver.byteToInt(object.get());
            if (n != 1) {
                byte[] byArray3 = object;
                byte[] byArray4 = new byte[6];
                object = byArray4;
                ByteBuffer byteBuffer2 = byArray3.get(byArray4);
                object = ParseDataUtil.hexDataCovetToAddress(ParseDataUtil.a(object));
                byteBuffer2.get(new byte[byteBuffer2.remaining()]);
                bleScanMessage = new BleScanMessage().setVid(s).setOTA(true).setIdentify(string).setVersion(n).setOldBleAddress((String)object);
            } else {
                byte[] byArray5 = object;
                object = new byte[6];
                ByteBuffer byteBuffer3 = byArray5.get((byte[])object);
                object = ParseDataUtil.hexDataCovetToAddress(ParseDataUtil.a(object));
                short s2 = byteBuffer3.getShort();
                short s3 = byteBuffer3.getShort();
                byte by = byteBuffer3.get();
                int n2 = by >> 4 & 0xFF;
                int n3 = by & 0xF;
                int n4 = CHexConver.byteToInt(byteBuffer3.get());
                byteBuffer3.get(new byte[byteBuffer3.remaining()]);
                bleScanMessage = new BleScanMessage().setOTA(true).setIdentify(string).setVersion(n).setOldBleAddress((String)object).setVid(s).setUid(s2).setPid(s3).setDeviceType(n2).setDeviceVersion(n3).setBattery(n4);
            }
            return bleScanMessage;
        }
        return null;
    }

    private static byte[] a(byte[] byArray) {
        if (byArray != null && byArray.length > 1) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[byArray.length - i - 1];
            }
            return byArray2;
        }
        return byArray;
    }

    static {
        System.loadLibrary("jl_ota_auth");
    }
}

