/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.constant;

import com.jieli.jl_rcsp.model.base.BaseError;
import com.jieli.jl_rcsp.model.base.CmdError;

public class RcspErrorCode {
    public static final int ERR_NONE = 0;
    public static final int ERR_INVALID_PARAMETER = 4097;
    public static final int ERR_CANCEL_OP = 4098;
    public static final int ERR_REMOTE_NOT_CONNECT = 8192;
    public static final int ERR_DEVICE_NOT_MATCH = 8193;
    public static final int ERR_USE_SYSTEM_API = 8194;
    public static final int ERR_AUTH_DEVICE = 8195;
    public static final int ERR_CMD_SEND = 12288;
    public static final int ERR_PARSE_DATA = 12289;
    public static final int ERR_RESPONSE_TIMEOUT = 12290;
    public static final int ERR_SYSTEM_BUSY = 12291;
    public static final int ERR_RESPONSE_BAD_STATUS = 12292;
    public static final int ERR_RESPONSE_BAD_RESULT = 12293;
    public static final int ERR_STORAGE_OFFLINE = 16384;
    public static final int ERR_FILE_BROWSING = 16385;
    public static final int ERR_DATA_LOAD_COMPLETE = 16386;
    public static final int ERR_MISSING_FILE_DATA = 16387;
    public static final int ERR_DIR_TOO_DEEP = 16388;
    public static final int ERR_IO_EXCEPTION = 16389;

    public static String getErrorDesc(int n) {
        if (n != 0) {
            if (n != 4097) {
                if (n != 4098) {
                    switch (n) {
                        default: {
                            switch (n) {
                                default: {
                                    switch (n) {
                                        default: {
                                            return "Unknown Code : " + n;
                                        }
                                        case 16389: {
                                            return "IO Exception.";
                                        }
                                        case 16388: {
                                            return "Directory hierarchy is too deep.";
                                        }
                                        case 16387: {
                                            return "Missing file data.";
                                        }
                                        case 16386: {
                                            return "File data is loaded.";
                                        }
                                        case 16385: {
                                            return "File browsing.";
                                        }
                                        case 16384: 
                                    }
                                    return "Storage offline.";
                                }
                                case 12293: {
                                    return "Device returns a failure result.";
                                }
                                case 12292: {
                                    return "Device returns a failed state.";
                                }
                                case 12291: {
                                    return "System is busy.";
                                }
                                case 12290: {
                                    return "Waiting for a reply packet timed out.";
                                }
                                case 12289: {
                                    return "Failed to parse RCSP data.";
                                }
                                case 12288: 
                            }
                            return "Command sending failed.";
                        }
                        case 8195: {
                            return "Failed to auth device.";
                        }
                        case 8194: {
                            return "Failed to use system reflection function.";
                        }
                        case 8193: {
                            return "The device is not the same as the device in use.";
                        }
                        case 8192: 
                    }
                    return "The remote device is not connected.";
                }
                return "Cancel Operation.";
            }
            return "Invalid Parameter.";
        }
        return "Success";
    }

    public static BaseError buildJsonError(int n, int n2, int n3, String string) {
        CmdError cmdError;
        CmdError cmdError2 = cmdError;
        cmdError2(n, n2, n3);
        cmdError2.setDesc(RcspErrorCode.getErrorDesc(n2));
        cmdError.setSubDesc(string);
        return new BaseError(n2, cmdError2.toString());
    }
}

