/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.cmdHandler;

import android.bluetooth.BluetoothDevice;
import com.jieli.jl_rcsp.interfaces.cmd.ICmdHandler;
import com.jieli.jl_rcsp.model.base.BasePacket;
import com.jieli.jl_rcsp.model.base.BaseResponse;
import com.jieli.jl_rcsp.model.base.CommandBase;
import com.jieli.jl_rcsp.model.command.watch.HealthSettingCmd;
import com.jieli.jl_rcsp.tool.CommandHelper;
import com.jieli.jl_rcsp.tool.datahandles.ParseHelper;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class HealthSettingCmdHandler
implements ICmdHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommandBase parseDataToCmd(BluetoothDevice object, BasePacket basePacket) {
        if (basePacket == null) {
            return null;
        }
        if (basePacket.getOpCode() != 165) {
            return null;
        }
        int n = basePacket.getHasResponse() == 1 ? 2 : 1;
        BasePacket basePacket2 = basePacket;
        byte[] byArray = basePacket2.getParamData();
        if (basePacket2.getType() == 1) {
            Object object2;
            byte by = byArray[0];
            if (by != 0) {
                if (by != 1) {
                    HealthSettingCmd.UpdateParam updateParam;
                    if (by != 2) throw new RuntimeException("invalid health setting cmd op");
                    object2 = new byte[byArray.length - 1];
                    HealthSettingCmd.UpdateParam updateParam2 = updateParam;
                    updateParam = new HealthSettingCmd.UpdateParam(ParseHelper.coverParamDataToAttrBeans((byte[])object2));
                    object2 = updateParam2;
                } else {
                    HealthSettingCmd.SetParam setParam;
                    object2 = new byte[byArray.length - 1];
                    HealthSettingCmd.SetParam setParam2 = setParam;
                    setParam = new HealthSettingCmd.SetParam(ParseHelper.coverParamDataToAttrBeans((byte[])object2));
                    object2 = setParam2;
                }
            } else {
                HealthSettingCmd.GetParam getParam;
                object2 = getParam;
                getParam = new HealthSettingCmd.GetParam(CHexConver.bytesToInt(byArray, 1, 4));
            }
            HealthSettingCmd healthSettingCmd = new HealthSettingCmd(n, (HealthSettingCmd.Param)object2);
            healthSettingCmd.setOpCodeSn(basePacket.getOpCodeSn());
            return healthSettingCmd;
        }
        BasePacket basePacket3 = basePacket;
        n = basePacket3.getOpCode();
        CommandBase commandBase = CommandHelper.getInstance().getCommand((BluetoothDevice)object, n, basePacket3.getOpCodeSn());
        if (commandBase == null) {
            JL_Log.e("jl_rcsp", "invalid health setting cmd response");
            return null;
        }
        commandBase = (HealthSettingCmd)commandBase;
        commandBase.setOpCodeSn(basePacket.getOpCodeSn());
        commandBase.setStatus(basePacket.getStatus());
        if (basePacket.getStatus() != 0) {
            CommandBase commandBase2 = commandBase;
            JL_Log.w("jl_rcsp", "health setting cmd send fail ,status = " + basePacket.getStatus());
            commandBase2.setResponse(new HealthSettingCmd.Response());
            return commandBase2;
        }
        if (commandBase.getParam() instanceof HealthSettingCmd.GetParam) {
            HealthSettingCmd.GetResponse getResponse;
            object = getResponse;
            getResponse = new HealthSettingCmd.GetResponse(ParseHelper.coverParamDataToAttrBeans(byArray));
        } else {
            HealthSettingCmd.Response response;
            object = response;
            response = new HealthSettingCmd.Response();
        }
        CommandBase commandBase3 = commandBase;
        ((BaseResponse)object).setRawData(byArray);
        commandBase3.setResponse(object);
        return commandBase3;
    }
}

