/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.file_op;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import java.nio.ByteBuffer;

public class DeviceExtendParamCmd
extends CommandWithParamAndResponse<Param, Response> {
    public static final byte OP_FILE_TRANSFER = 0;
    public static final byte OP_DELETE_FILE = 1;
    public static final byte OP_READ_FILE = 2;

    public DeviceExtendParamCmd(Param param) {
        super(39, DeviceExtendParamCmd.class.getSimpleName(), param);
    }

    public static class FileTransferResponse
    extends Response {
        public boolean hasCrc16;

        public FileTransferResponse(boolean bl) {
            super((byte)0);
            this.hasCrc16 = bl;
        }
    }

    public static class Response
    extends CommonResponse {
        public byte op;

        public Response(byte by) {
            this.op = by;
        }
    }

    public static class ReadFileParam
    extends DevParam {
        public ReadFileParam(int n) {
            super((byte)2, n);
        }
    }

    public static class DeleteFileParam
    extends DevParam {
        public DeleteFileParam(int n) {
            super((byte)1, n);
        }
    }

    public static class FileTransferParam
    extends DevParam {
        public boolean hasCrc16;

        public FileTransferParam(int n, boolean bl) {
            super((byte)0, n);
            this.hasCrc16 = bl;
        }

        @Override
        public byte[] toData() {
            return ByteBuffer.allocate(6).put(super.toData()).put((byte)(this.hasCrc16 ? 1 : 0)).array();
        }
    }

    public static class DevParam
    extends Param {
        public int dev;

        public DevParam(byte by, int n) {
            super(by);
            this.dev = n;
        }

        @Override
        public byte[] toData() {
            return ByteBuffer.allocate(5).put(super.toData()).put(CHexConver.intToBigBytes(this.dev)).array();
        }
    }

    public static class Param
    extends BaseParameter {
        public byte op;

        public Param(byte by) {
            this.op = by;
        }

        public byte[] toData() {
            return ByteBuffer.allocate(1).put(this.op).array();
        }

        @Override
        public byte[] getParamData() {
            return this.toData();
        }
    }
}

