/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.command.watch;

import com.jieli.jl_rcsp.model.base.BaseParameter;
import com.jieli.jl_rcsp.model.base.CommandWithParamAndResponse;
import com.jieli.jl_rcsp.model.base.CommonResponse;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.RcspUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PushInfoDataToDeviceCmd
extends CommandWithParamAndResponse<Param, Response> {
    public PushInfoDataToDeviceCmd(Param param) {
        super(161, PushInfoDataToDeviceCmd.class.getSimpleName(), param);
    }

    public static class RemoveMsg
    extends BaseInfo {
        private final byte[] appPackageName;
        private final byte[] timestamp;

        public RemoveMsg(String string, long l) {
            super((byte)3, (byte)0);
            this.appPackageName = RcspUtil.getData(string, 31);
            this.timestamp = CHexConver.intToBigBytes(RcspUtil.time2Int(l));
        }

        public byte[] getAppPackageName() {
            return this.appPackageName;
        }

        public byte[] getTimestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] beanToData() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            new ByteArrayOutputStream().write(RcspUtil.packLTVPacket2(0, this.timestamp));
            try {
                byteArrayOutputStream2.write(RcspUtil.packLTVPacket2(1, this.appPackageName));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return byteArrayOutputStream2.toByteArray();
        }
    }

    public static class MessageData
    extends BaseInfo {
        private final int seq;
        private final byte[] data;

        public MessageData(int n, byte[] byArray) {
            super((byte)2, (byte)0);
            this.seq = n;
            this.data = byArray;
        }

        public int getSeq() {
            return this.seq;
        }

        public byte[] getData() {
            return this.data;
        }

        @Override
        public byte[] beanToData() {
            byte[] byArray = this.data;
            int n = this.data == null ? 0 : byArray.length;
            int n2 = n;
            byte[] byArray2 = new byte[n2 + 1];
            byte[] byArray3 = byArray2;
            byArray2[0] = (byte)this.seq;
            if (n2 > 0) {
                System.arraycopy(byArray, 0, byArray3, 1, n);
            }
            return byArray3;
        }
    }

    public static class Weather
    extends BaseInfo {
        private final String province;
        private final String city;
        private final byte weather;
        private final byte temperature;
        private final byte humidity;
        private final byte windDirection;
        private final byte windPower;
        private final long time;

        public Weather(String string, String string2, byte by, byte by2, byte by3, byte by4, byte by5, long l) {
            super((byte)1, (byte)0);
            this.province = string;
            this.city = string2;
            this.weather = by;
            this.temperature = by2;
            this.humidity = by3;
            this.windDirection = by4;
            this.windPower = by5;
            this.time = l;
        }

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public byte getWeather() {
            return this.weather;
        }

        public byte getTemperature() {
            return this.temperature;
        }

        public byte getHumidity() {
            return this.humidity;
        }

        public byte getWindDirection() {
            return this.windDirection;
        }

        public byte getWindPower() {
            return this.windPower;
        }

        public long getTime() {
            return this.time;
        }

        @Override
        public byte[] beanToData() {
            byte[] byArray = this.city.getBytes();
            byte[] byArray2 = this.province.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + byArray2.length + 20);
            byteBuffer.put((byte)byArray2.length);
            byteBuffer.put(byArray2);
            byteBuffer.put((byte)byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.put(this.weather);
            byteBuffer.put(this.temperature);
            byteBuffer.put(this.humidity);
            byteBuffer.put(this.windDirection);
            byteBuffer.put(this.windPower);
            byteBuffer.put(CHexConver.intToBigBytes(RcspUtil.time2Int(this.time)));
            byte[] byArray3 = new byte[byteBuffer.position()];
            byteBuffer.flip();
            byteBuffer.get(byArray3);
            return byArray3;
        }

        public String toString() {
            return "Weather{province=" + this.province + ", city=" + this.city + ", weather=" + this.weather + ", temperature=" + this.temperature + ", humidity=" + this.humidity + ", windDirection=" + this.windDirection + ", windPower=" + this.windPower + ", time=" + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.ENGLISH).format(new Date(this.time)) + '}';
        }
    }

    public static abstract class BaseInfo {
        private final byte type;
        private final byte version;

        public BaseInfo(byte by, byte by2) {
            this.type = by;
            this.version = by2;
        }

        private byte[] toParamData() {
            byte[] byArray = this.beanToData();
            byte[] byArray2 = new byte[byArray.length + 2];
            byArray2[0] = this.type;
            byArray2[1] = this.version;
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 2, n);
            return byArray2;
        }

        public byte getType() {
            return this.type;
        }

        public byte getVersion() {
            return this.version;
        }

        public abstract byte[] beanToData();
    }

    public static class Param<T extends BaseInfo>
    extends BaseParameter {
        private final BaseInfo baseInfo;

        public Param(BaseInfo baseInfo) {
            this.baseInfo = baseInfo;
        }

        @Override
        public byte[] getParamData() {
            BaseInfo baseInfo = ((Param)((Object)baseInfo)).baseInfo;
            return baseInfo == null ? new byte[]{} : baseInfo.toParamData();
        }
    }

    public static class Response
    extends CommonResponse {
        public final int reason;
        public final byte type;

        public Response(byte by, int n) {
            this.reason = n;
            this.type = by;
        }

        public byte getType() {
            return this.type;
        }

        public int getReason() {
            return this.reason;
        }
    }
}

