/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device;

import com.jieli.jl_rcsp.util.CHexConver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ReverberationParam {
    public static final int MASK = 1;
    private boolean isOn;
    private int depthValue;
    private int strengthValue;

    public static ReverberationParam parseData(byte[] byArray) {
        if (byArray != null && byArray.length >= 5) {
            boolean bl = byArray[0] == 1;
            int n = CHexConver.bytesToInt(byArray, 1, 2);
            int n2 = CHexConver.bytesToInt(byArray, 3, 2);
            return new ReverberationParam(bl, n, n2);
        }
        return null;
    }

    public ReverberationParam() {
    }

    public ReverberationParam(boolean bl, int n, int n2) {
        ReverberationParam reverberationParam = this;
        reverberationParam.setOn(bl);
        reverberationParam.setDepthValue(n);
        reverberationParam.setStrengthValue(n2);
    }

    public boolean isOn() {
        return this.isOn;
    }

    public void setOn(boolean bl) {
        this.isOn = bl;
    }

    public int getDepthValue() {
        return this.depthValue;
    }

    public void setDepthValue(int n) {
        this.depthValue = n;
    }

    public int getStrengthValue() {
        return this.strengthValue;
    }

    public void setStrengthValue(int n) {
        this.strengthValue = n;
    }

    public byte[] toData() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream2();
        byteArrayOutputStream2.write(CHexConver.intToByte(this.isOn ? 1 : 0));
        try {
            byteArrayOutputStream2.write(CHexConver.int2byte2(this.depthValue));
            byteArrayOutputStream.write(CHexConver.int2byte2(this.strengthValue));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public String toString() {
        return "ReverberationParam{isOn=" + this.isOn + ", depthValue=" + this.depthValue + ", strengthValue=" + this.strengthValue + '}';
    }
}

