/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device;

import android.os.Parcel;
import android.os.Parcelable;
import com.jieli.jl_rcsp.util.CHexConver;

public class VoiceMode
implements Parcelable {
    public static final int VOICE_MODE_CLOSE = 0;
    public static final int VOICE_MODE_DENOISE = 1;
    public static final int VOICE_MODE_TRANSPARENT = 2;
    public static final Parcelable.Creator<VoiceMode> CREATOR = new Parcelable.Creator<VoiceMode>(){

        public VoiceMode createFromParcel(Parcel parcel) {
            return new VoiceMode(parcel);
        }

        public VoiceMode[] newArray(int n) {
            return new VoiceMode[n];
        }
    };
    private int mode = -1;
    private int leftMax;
    private int leftCurVal;
    private int rightMax;
    private int rightCurVal;

    public VoiceMode() {
    }

    public VoiceMode(Parcel parcel) {
        this.mode = parcel.readInt();
        this.leftMax = parcel.readInt();
        this.rightMax = parcel.readInt();
        this.leftCurVal = parcel.readInt();
        this.rightCurVal = parcel.readInt();
    }

    public static VoiceMode parse(byte[] byArray) {
        if (byArray != null && byArray.length == 9) {
            int n = CHexConver.byteToInt(byArray[0]);
            int n2 = CHexConver.bytesToInt(byArray, 1, 2);
            int n3 = CHexConver.bytesToInt(byArray, 3, 2);
            int n4 = CHexConver.bytesToInt(byArray, 5, 2);
            return new VoiceMode().setMode(n).setLeftMax(n2).setLeftCurVal(n4).setRightMax(n3).setRightCurVal(CHexConver.bytesToInt(byArray, 7, 2));
        }
        return null;
    }

    public static boolean isValidMode(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    public int getMode() {
        return this.mode;
    }

    public VoiceMode setMode(int n) {
        this.mode = n;
        return this;
    }

    public int getLeftMax() {
        return this.leftMax;
    }

    public VoiceMode setLeftMax(int n) {
        this.leftMax = n;
        return this;
    }

    public int getLeftCurVal() {
        return this.leftCurVal;
    }

    public VoiceMode setLeftCurVal(int n) {
        this.leftCurVal = n;
        return this;
    }

    public int getRightMax() {
        return this.rightMax;
    }

    public VoiceMode setRightMax(int n) {
        this.rightMax = n;
        return this;
    }

    public int getRightCurVal() {
        return this.rightCurVal;
    }

    public VoiceMode setRightCurVal(int n) {
        this.rightCurVal = n;
        return this;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[9];
        VoiceMode voiceMode = this;
        byArray[0] = CHexConver.intToByte(this.mode);
        byte[] byArray2 = CHexConver.int2byte2(voiceMode.leftMax);
        int n = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, 1, n);
        n = 1 + byArray2.length;
        byte[] byArray3 = CHexConver.int2byte2(this.rightMax);
        int n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray, n, n2);
        byte[] byArray4 = CHexConver.int2byte2(this.leftCurVal);
        int n3 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray, n += byArray3.length, n3);
        n3 = n + byArray4.length;
        byte[] byArray5 = CHexConver.int2byte2(voiceMode.rightCurVal);
        n = byArray5.length;
        System.arraycopy(byArray5, 0, byArray, n3, n);
        return byArray;
    }

    public String toString() {
        return "VoiceMode{mode=" + this.mode + ", leftMax=" + this.leftMax + ", rightMax=" + this.rightMax + ", leftCurVal=" + this.leftCurVal + ", rightCurVal=" + this.rightCurVal + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mode);
        parcel.writeInt(this.leftMax);
        parcel.writeInt(this.rightMax);
        parcel.writeInt(this.leftCurVal);
        parcel.writeInt(this.rightCurVal);
    }
}

