/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class AirPressure
extends HealthData {
    private static final int DATA_INTERVAL = 2;
    private int realTimeValue;
    private int minValue;
    private int maxValue;

    public AirPressure(int n, byte by, byte[] byArray) {
        AirPressure airPressure = this;
        super(1, by, byArray, n);
        airPressure.parseAirPressureData(n, by, byArray);
    }

    private void parseAirPressureData(int n, byte by, byte[] byArray) {
        if (n == 0) {
            byte[] byArray2 = CHexConver.getBooleanArrayBig(by);
            by = 0;
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 1) continue;
                if (i != 0) {
                    if (i != 1) {
                        if (i != 2) continue;
                        this.maxValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 2);
                        continue;
                    }
                    this.minValue = this.getValueFromData(by, byArray);
                    by = (byte)(by + 2);
                    continue;
                }
                this.realTimeValue = this.getValueFromData(by, byArray);
                by = (byte)(by + 2);
            }
        } else {
            JL_Log.e("AirPressure", "no support version : " + n);
        }
    }

    private int getValueFromData(int n, byte[] byArray) {
        if (byArray != null && n + 2 <= byArray.length) {
            return CHexConver.bytesToInt(byArray, n, 2);
        }
        return 0;
    }

    public int getRealTimeValue() {
        return this.realTimeValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public String toString() {
        return "AirPressure{realTimeValue=" + this.realTimeValue + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + "} " + super.toString();
    }
}

