/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.util.CHexConver;

public class BloodOxygenMeasurementAlert
implements IHealthSettingToAttr {
    public static final int STATE_CLOSE = 0;
    public static final int STATE_OPEN = 1;
    public static final int MODE_SMART = 0;
    public static final int MODE_TIMING = 1;
    private int state;
    private int mode;
    private int limitingValue;

    public BloodOxygenMeasurementAlert(byte[] byArray) {
        BloodOxygenMeasurementAlert bloodOxygenMeasurementAlert = this;
        bloodOxygenMeasurementAlert.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.state = CHexConver.byteToInt(byArray[0]);
            int n = 1;
            if (byArray.length > 1) {
                this.mode = CHexConver.byteToInt(byArray[n]);
                n = 2;
            }
            if (byArray.length > 2) {
                this.limitingValue = CHexConver.byteToInt(byArray[n]);
            }
            return;
        }
    }

    private byte[] toData() {
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray2[0] = CHexConver.intToByte(this.state);
        byArray2[1] = CHexConver.intToByte(this.mode);
        byArray[2] = CHexConver.intToByte(this.limitingValue);
        return byArray;
    }

    public BloodOxygenMeasurementAlert setState(int n) {
        this.state = n;
        return this;
    }

    public BloodOxygenMeasurementAlert setMode(int n) {
        this.mode = n;
        return this;
    }

    public BloodOxygenMeasurementAlert setLimitingValue(int n) {
        this.limitingValue = n;
        return this;
    }

    public int getState() {
        return this.state;
    }

    public int getMode() {
        return this.mode;
    }

    public int getLimitingValue() {
        return this.limitingValue;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public AttrBean toAttr() {
        AttrBean attrBean;
        AttrBean attrBean2 = attrBean;
        attrBean2();
        attrBean2.setType((byte)this.getType());
        attrBean.setAttrData(this.toData());
        return attrBean;
    }

    public String toString() {
        return "BloodOxygenMeasurementAlert{state=" + this.state + ", mode=" + this.mode + ", limitingValue=" + this.limitingValue + '}';
    }
}

