/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.health.HealthData;
import com.jieli.jl_rcsp.util.CHexConver;
import com.jieli.jl_rcsp.util.JL_Log;

public class HeartRate
extends HealthData {
    private static final int DATA_INTERVAL = 1;
    private int realTimeValue;
    private int restingValue;
    private int maxValue;
    private int singleTestValue;

    public HeartRate(int n, byte by, byte[] byArray) {
        HeartRate heartRate = this;
        super(0, by, byArray, n);
        heartRate.parseHeartRateData(n, by, byArray);
    }

    private void parseHeartRateData(int n, byte by, byte[] byArray) {
        if (n == 0) {
            byte[] byArray2 = CHexConver.getBooleanArrayBig(by);
            by = 0;
            block6: for (int i = 0; i < byArray2.length; ++i) {
                if (byArray2[i] != 1) continue;
                switch (i) {
                    default: {
                        continue block6;
                    }
                    case 3: {
                        this.singleTestValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                        continue block6;
                    }
                    case 2: {
                        this.maxValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                        continue block6;
                    }
                    case 1: {
                        this.restingValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                        continue block6;
                    }
                    case 0: {
                        this.realTimeValue = this.getValueFromData(by, byArray);
                        by = (byte)(by + 1);
                    }
                }
            }
        } else {
            JL_Log.e("HeartRate", "no support version : " + n);
        }
    }

    private int getValueFromData(int n, byte[] byArray) {
        if (byArray != null && n + 1 <= byArray.length) {
            return CHexConver.byteToInt(byArray[n]);
        }
        return 0;
    }

    public int getRealTimeValue() {
        return this.realTimeValue;
    }

    public int getRestingValue() {
        return this.restingValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getSingleTestValue() {
        return this.singleTestValue;
    }

    @Override
    public String toString() {
        return "HeartRate{realTimeValue=" + this.realTimeValue + ", restingValue=" + this.restingValue + ", maxValue=" + this.maxValue + ", singleTestValue=" + this.singleTestValue + "} " + super.toString();
    }
}

