/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import com.jieli.jl_rcsp.util.CHexConver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class HeartRateMeasure
implements IHealthSettingToAttr {
    public static final byte MODE_BRIGHT = 0;
    public static final byte MODE_SHAKE = 1;
    private boolean enable;
    private byte mode;
    private int maxHeartRate;
    private int minHeartRate;

    public HeartRateMeasure(byte[] byArray) {
        HeartRateMeasure heartRateMeasure = this;
        heartRateMeasure.maxHeartRate = -1;
        heartRateMeasure.minHeartRate = -1;
        heartRateMeasure.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n = CHexConver.byteToInt(byArray[0]) == 1 ? 1 : 0;
            this.enable = n;
            n = 1;
            if (byArray.length > 1) {
                this.mode = byArray[n];
                n = 2;
            }
            if (byArray.length > 2) {
                this.maxHeartRate = CHexConver.byteToInt(byArray[n]);
                ++n;
            }
            if (byArray.length > 3) {
                this.minHeartRate = CHexConver.byteToInt(byArray[n]);
            }
            return;
        }
    }

    private byte[] toData() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        try {
            new ByteArrayOutputStream().write(new byte[]{(byte)(this.enable ? 1 : 0), this.mode});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = null;
        int n = this.maxHeartRate;
        if (n != -1 || this.minHeartRate != -1) {
            if (n == -1) {
                this.maxHeartRate = 0;
            }
            if (this.minHeartRate == -1) {
                this.minHeartRate = 0;
            }
            byte[] byArray2 = new byte[2];
            byArray = byArray2;
            byArray[0] = CHexConver.intToByte(this.maxHeartRate);
            byArray2[1] = CHexConver.intToByte(this.minHeartRate);
        }
        if (byArray != null) {
            try {
                byteArrayOutputStream2.write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public HeartRateMeasure setEnable(boolean bl) {
        this.enable = bl;
        return this;
    }

    public byte getMode() {
        return this.mode;
    }

    public HeartRateMeasure setMode(byte by) {
        this.mode = by;
        return this;
    }

    public int getMaxHeartRate() {
        return this.maxHeartRate;
    }

    public HeartRateMeasure setMaxHeartRate(int n) {
        this.maxHeartRate = n;
        return this;
    }

    public int getMinHeartRate() {
        return this.minHeartRate;
    }

    public HeartRateMeasure setMinHeartRate(int n) {
        this.minHeartRate = n;
        return this;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setType((byte)this.getType()).setAttrData(this.toData());
    }

    public String toString() {
        return "HeartRateMeasure{enable=" + this.enable + ", mode=" + this.mode + ", maxHeartRate=" + this.maxHeartRate + ", minHeartRate=" + this.minHeartRate + '}';
    }
}

