/*
 * Decompiled with CFR 0.152.
 */
package com.jieli.jl_rcsp.model.device.health;

import com.jieli.jl_rcsp.model.device.AttrBean;
import com.jieli.jl_rcsp.model.device.health.IHealthSettingToAttr;
import java.nio.ByteBuffer;

public class LiftWristDetection
implements IHealthSettingToAttr {
    public static final byte STATUS_CLOSE = 0;
    public static final byte STATUS_ALL_DAY = 1;
    public static final byte STATUS_CUSTOM_TIME = 2;
    public static final byte MODE_BRIGHT = 0;
    public static final byte MODE_SHAKE = 1;
    public byte status;
    public byte startHour;
    public byte startMin;
    public byte endHour;
    public byte endMin;
    public byte mode;

    public LiftWristDetection(byte[] byArray) {
        LiftWristDetection liftWristDetection = this;
        liftWristDetection.parseData(byArray);
    }

    private void parseData(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.status = byArray[0];
            int n = 1;
            int n2 = 2;
            if (byArray.length >= 2) {
                this.mode = byArray[n];
            } else {
                n2 = n;
            }
            if (byArray.length >= n2 + 2) {
                this.startHour = (byte)Math.max(Math.min(byArray[n2], 23), 0);
                n = n2 + 1;
                this.startMin = (byte)Math.max(Math.min(byArray[n], 59), 0);
                n2 = n + 1;
            }
            if (byArray.length >= n2 + 2) {
                this.endHour = (byte)Math.max(Math.min(byArray[n2], 23), 0);
                this.endMin = (byte)Math.max(Math.min(byArray[n2 + 1], 59), 0);
            }
            return;
        }
    }

    private byte[] toData() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.put(this.status).put(this.mode).put(this.startHour).put(this.startMin).put(this.endHour).put(this.endMin);
        return byteBuffer.array();
    }

    public byte getStatus() {
        return this.status;
    }

    public LiftWristDetection setStatus(byte by) {
        this.status = by;
        return this;
    }

    public byte getStartHour() {
        return this.startHour;
    }

    public LiftWristDetection setStartHour(byte by) {
        this.startHour = by;
        return this;
    }

    public byte getStartMin() {
        return this.startMin;
    }

    public LiftWristDetection setStartMin(byte by) {
        this.startMin = by;
        return this;
    }

    public byte getEndHour() {
        return this.endHour;
    }

    public LiftWristDetection setEndHour(byte by) {
        this.endHour = by;
        return this;
    }

    public byte getEndMin() {
        return this.endMin;
    }

    public LiftWristDetection setEndMin(byte by) {
        this.endMin = by;
        return this;
    }

    public byte getMode() {
        return this.mode;
    }

    public LiftWristDetection setMode(byte by) {
        this.mode = by;
        return this;
    }

    public String toString() {
        return "MultiStateWithModeSwitch{status=" + this.status + ", startHour=" + this.startHour + ", startMin=" + this.startMin + ", endHour=" + this.endHour + ", endMin=" + this.endMin + ", mode=" + this.mode + '}';
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public AttrBean toAttr() {
        return new AttrBean().setType((byte)this.getType()).setAttrData(this.toData());
    }
}

